/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.mq;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.micronaut.jam.mq.kafka.MnKafkaListener;
import com.intellij.micronaut.jam.mq.rabbitmq.MnRabbitListener;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a-\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000b2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u0010\u0012\u0002\b\u00030\u000fH\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a8\u0006\u0017"}, d2={"hasMqImplicitUsage", "", "element", "Lcom/intellij/psi/PsiElement;", "isKafkaTopicListener", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "isRabbitQueueListener", "getMqPropertyPatterns", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UElement;", "injection", "Lcom/intellij/patterns/uast/UExpressionPattern;", "Lorg/jetbrains/uast/UExpression;", "(Lcom/intellij/patterns/uast/UExpressionPattern;)[Lcom/intellij/patterns/ElementPattern;", "hasMicronautMessagingInProject", "project", "Lcom/intellij/openapi/project/Project;", "hasMnRabbitInProject", "hasMnKafkaInProject", "intellij.micronaut"})
public final class MnMqUtilsKt {
    public static final boolean hasMqImplicitUsage(@NotNull PsiElement element) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof PsiMethod)) break block5;
                PsiAnnotation[] psiAnnotationArray = ((PsiMethod)element).getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                if (!(((Object[])psiAnnotationArray).length == 0)) break block6;
            }
            return false;
        }
        PsiClass psiClass = ((PsiMethod)element).getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass2)) {
            return false;
        }
        return MnMqUtilsKt.isKafkaTopicListener((PsiMethod)element, psiClass2) || MnMqUtilsKt.isRabbitQueueListener((PsiMethod)element, psiClass2);
    }

    private static final boolean isKafkaTopicListener(PsiMethod psiMethod, PsiClass psiClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (String)"io.micronaut.configuration.kafka.annotation.Topic", (int)0) && MnKafkaListener.META.getJamElement((PsiModifierListOwner)psiClass) != null;
    }

    private static final boolean isRabbitQueueListener(PsiMethod psiMethod, PsiClass psiClass) {
        Object[] objectArray = new String[]{"io.micronaut.rabbitmq.annotation.Queue", "io.micronaut.rabbitmq.annotation.Queue"};
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0) && MnRabbitListener.META.getJamElement((PsiModifierListOwner)psiClass) != null;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getMqPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        ElementPattern[] elementPatternArray = new ElementPattern[7];
        elementPatternArray[0] = injection.annotationParam("io.micronaut.configuration.kafka.annotation.Topic", "value");
        String[] stringArray = new String[]{"value", "name"};
        StringPattern stringPattern = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"oneOf(...)");
        elementPatternArray[1] = injection.annotationParams("io.micronaut.http.annotation.Header", (ElementPattern)stringPattern);
        Object[] objectArray = new String[]{"io.micronaut.rabbitmq.annotation.RabbitClient", "io.micronaut.rabbitmq.annotation.RabbitClient"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        stringArray = new String[]{"value", "connection"};
        StringPattern stringPattern2 = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"oneOf(...)");
        elementPatternArray[2] = injection.annotationParams(list, (ElementPattern)stringPattern2);
        objectArray = new String[]{"io.micronaut.rabbitmq.annotation.Queue", "io.micronaut.rabbitmq.annotation.Queue"};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        stringArray = new String[]{"connection", "executor", "value"};
        StringPattern stringPattern3 = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern3, (String)"oneOf(...)");
        elementPatternArray[3] = injection.annotationParams(list2, (ElementPattern)stringPattern3);
        objectArray = new String[]{"io.micronaut.rabbitmq.annotation.RabbitListener", "io.micronaut.rabbitmq.annotation.RabbitListener"};
        List list3 = CollectionsKt.listOf((Object[])objectArray);
        stringArray = new String[]{"connection", "executor"};
        StringPattern stringPattern4 = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern4, (String)"oneOf(...)");
        elementPatternArray[4] = injection.annotationParams(list3, (ElementPattern)stringPattern4);
        objectArray = new String[]{"io.micronaut.rabbitmq.annotation.Binding", "io.micronaut.rabbitmq.annotation.Binding"};
        List list4 = CollectionsKt.listOf((Object[])objectArray);
        stringArray = new String[]{"value", "connection"};
        StringPattern stringPattern5 = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern5, (String)"oneOf(...)");
        elementPatternArray[5] = injection.annotationParams(list4, (ElementPattern)stringPattern5);
        elementPatternArray[6] = injection.annotationParam("io.micronaut.messaging.annotation.SendTo", "value");
        return elementPatternArray;
    }

    public static final boolean hasMicronautMessagingInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"io.micronaut.messaging.annotation.SendTo");
    }

    public static final boolean hasMnRabbitInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"io.micronaut.rabbitmq.annotation.RabbitListener") || JavaLibraryUtil.hasLibraryClass((Project)project, (String)"io.micronaut.rabbitmq.annotation.RabbitListener");
    }

    public static final boolean hasMnKafkaInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"io.micronaut.configuration.kafka.annotation.KafkaClient");
    }
}

