/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.websocket;

import com.intellij.ide.presentation.Presentation;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.websocket.MnServerWebSocket;
import com.intellij.micronaut.jam.websocket.MnWebSocket;
import com.intellij.micronaut.jam.websocket.MnWebSocketModel;
import com.intellij.micronaut.provider.websocket.MnWebSocketTargetInfo;
import com.intellij.micronaut.provider.websocket.MnWebSocketUtilsKt;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="AllIcons.Webreferences.WebSocket", typeName="Micronaut WebSocket")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/micronaut/provider/websocket/MnWebSocketUrlResolver;", "Lcom/intellij/microservices/url/UrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getAuthorityHints", "", "Lcom/intellij/microservices/url/Authority$Exact;", "schema", "", "supportedSchemes", "getSupportedSchemes", "()Ljava/util/List;", "resolve", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "getVariants", "Factory", "intellij.micronaut"})
public final class MnWebSocketUrlResolver
implements UrlResolver {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<String> supportedSchemes;

    public MnWebSocketUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.supportedSchemes = UrlConstants.WS_SCHEMES;
    }

    @NotNull
    public List<Authority.Exact> getAuthorityHints(@Nullable String schema) {
        List<Authority.Exact> list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
        return list;
    }

    @NotNull
    public List<String> getSupportedSchemes() {
        return this.supportedSchemes;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request.getPath()), arg_0 -> MnWebSocketUrlResolver.resolve$lambda$1(this, arg_0)));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        List<MnServerWebSocket> list = MnWebSocketModel.getServers(this.myProject);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getServers(...)");
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> MnWebSocketUrlResolver.getVariants$lambda$2(this, arg_0)));
    }

    private static final MnWebSocketTargetInfo resolve$lambda$1$lambda$0(MnWebSocketUrlResolver this$0, MnServerWebSocket resolved) {
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(resolved.getResourceValue());
        List<String> list = this$0.getSupportedSchemes();
        Intrinsics.checkNotNull((Object)resolved);
        return new MnWebSocketTargetInfo<MnWebSocket>(list, urlPath, resolved);
    }

    private static final Sequence resolve$lambda$1(MnWebSocketUrlResolver this$0, UrlPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Sequence<MnServerWebSocket> sequence = MnWebSocketModel.resolveUrl(this$0.myProject, path);
        Intrinsics.checkNotNullExpressionValue(sequence, (String)"resolveUrl(...)");
        return SequencesKt.map(sequence, arg_0 -> MnWebSocketUrlResolver.resolve$lambda$1$lambda$0(this$0, arg_0));
    }

    private static final MnWebSocketTargetInfo getVariants$lambda$2(MnWebSocketUrlResolver this$0, MnServerWebSocket server) {
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(server.getResourceValue());
        List<String> list = this$0.getSupportedSchemes();
        Intrinsics.checkNotNull((Object)server);
        return new MnWebSocketTargetInfo<MnWebSocket>(list, urlPath, server);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/provider/websocket/MnWebSocketUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "<init>", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.micronaut"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!MnWebSocketUtilsKt.hasWebSocketLibrary(project)) {
                return null;
            }
            return new MnWebSocketUrlResolver(project);
        }
    }
}

