/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.DynamicBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class FetchAndCascadeTypeComponent {
    private JPanel myRoot;
    private JPanel myCascadeTypePanel;
    private JPanel myFetchTypePanel;
    private JCheckBox[] myCascadeCheckBoxes;
    private JRadioButton[] myFetchRadioButtons;

    public FetchAndCascadeTypeComponent() {
        this.$$$setupUI$$$();
    }

    public void initCascadeTypes(Set<String> types, Collection<String> selected) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)buttonPanel);
        pane.setBorder(BorderFactory.createEtchedBorder());
        Color color = new JBList().getBackground();
        buttonPanel.setBackground(color);
        this.myCascadeCheckBoxes = new JCheckBox[types.size()];
        int i = 0;
        for (String type : types) {
            JCheckBox checkBox = new JCheckBox(type, selected.contains(type));
            this.myCascadeCheckBoxes[i++] = checkBox;
            buttonPanel.add(checkBox);
            checkBox.setBackground(color);
        }
        pane.setHorizontalScrollBarPolicy(31);
        pane.setPreferredSize(new Dimension((int)(pane.getPreferredSize().getWidth() + new JScrollBar().getPreferredSize().getWidth()), 4 * (int)new JCheckBox().getPreferredSize().getHeight()));
        this.myCascadeTypePanel.add((Component)pane, "Center");
    }

    public void initFetchTypes(Set<String> types, String selected) {
        this.myFetchTypePanel.setLayout(new BoxLayout(this.myFetchTypePanel, 1));
        ButtonGroup group = new ButtonGroup();
        this.myFetchRadioButtons = new JRadioButton[types.size()];
        int i = 0;
        for (String type : types) {
            JRadioButton radioButton = new JRadioButton(type, type.equals(selected));
            group.add(radioButton);
            this.myFetchRadioButtons[i++] = radioButton;
            this.myFetchTypePanel.add(radioButton);
        }
    }

    public JComponent getComponent() {
        return this.myRoot;
    }

    @Nullable
    public String getFetchType() {
        for (JRadioButton fetchRadioButton : this.myFetchRadioButtons) {
            if (!fetchRadioButton.isSelected()) continue;
            return fetchRadioButton.getText();
        }
        return null;
    }

    public Set<String> getCascadeTypes() {
        HashSet<String> result = new HashSet<String>();
        for (JCheckBox checkBox : this.myCascadeCheckBoxes) {
            if (!checkBox.isSelected()) continue;
            result.add(checkBox.getText());
        }
        return result;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myRoot = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:d:grow,left:4dlu:noGrow,fill:d:grow", "fill:d:grow"));
        this.myFetchTypePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new CellConstraints(1, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JpaBundle", FetchAndCascadeTypeComponent.class).getString("dialog.relation.fetchtype.title"), (int)0, (int)0, null, null));
        this.myCascadeTypePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JpaBundle", FetchAndCascadeTypeComponent.class).getString("dialog.relation.cascade.type.title"), (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

