/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

public final class JpaQueryReferenceProvider
extends UastInjectionHostReferenceProvider {
    private static final UExpressionPattern<UExpression, ?> CREATE_NAMED_QUERY_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("createNamedQuery")).definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(JpaAnnotationConstants.ENTITY_MANAGER_CLASS.all()))));
    private static final UExpressionPattern<UExpression, ?> GET_NAMED_QUERY_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getNamedQuery")).definedInClass("org.hibernate.Session"));
    private static final UExpressionPattern<UExpression, ?> CREATE_NAMED_QUERY_PATTERN_2 = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getNamedQuery")).definedInClass("org.hibernate.SharedSessionContract"));
    private static final UExpressionPattern<UExpression, ?> QUERY_PRODUCER = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getNamedQuery")).definedInClass("org.hibernate.query.QueryProducer"));
    private static final UExpressionPattern<UExpression, ?> JPA_OPERATIONS_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.jpa.JpaOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQuery", "findByNamedQueryAndNamedParams"})));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE_3_OPERATIONS_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate3.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQuery", "findByNamedQueryAndNamedParam", "findByNamedQueryAndValueBean"})));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE_4_OPERATIONS_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate4.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQuery", "findByNamedQueryAndNamedParam", "findByNamedQueryAndValueBean"})));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE_5_OPERATIONS_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate5.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQuery", "findByNamedQueryAndNamedParam", "findByNamedQueryAndValueBean"})));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE_REACTIVE_SESSION_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("createNamedQuery")).definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.hibernate.reactive.stage.Stage.Session", "org.hibernate.reactive.mutiny.Mutiny.Session"}))));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE_QUERY_PRODUCER_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"createNamedQuery", "createNamedMutationQuery", "createNamedSelectionQuery"}))).definedInClass("org.hibernate.query.QueryProducer"));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE_LOADER_NAMED_QUERY_PATTERN = UastPatterns.injectionHostUExpression().annotationParam("org.hibernate.annotations.Loader", "namedQuery");
    public static final ElementPattern<UElement> ALL_PATTERNS = StandardPatterns.or((ElementPattern[])new ElementPattern[]{CREATE_NAMED_QUERY_PATTERN, QUERY_PRODUCER, GET_NAMED_QUERY_PATTERN, CREATE_NAMED_QUERY_PATTERN_2, JPA_OPERATIONS_PATTERN, HIBERNATE_3_OPERATIONS_PATTERN, HIBERNATE_4_OPERATIONS_PATTERN, HIBERNATE_5_OPERATIONS_PATTERN, HIBERNATE_REACTIVE_SESSION_PATTERN, HIBERNATE_QUERY_PRODUCER_PATTERN, HIBERNATE_LOADER_NAMED_QUERY_PATTERN});

    public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
        Module module;
        if (uExpression == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(0);
        }
        if (host == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host)) != null) {
            String queryName = UastUtils.evaluateString((UExpression)uExpression);
            PsiReference[] psiReferenceArray = new PsiReference[]{new QueryReference((PsiElement)host, queryName)};
            if (psiReferenceArray == null) {
                JpaQueryReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaQueryReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaQueryReferenceProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesForInjectionHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesForInjectionHost";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static final class QueryReference
    extends QueryRelatedReference {
        private final String myQueryName;

        public QueryReference(PsiElement element, String queryName) {
            super(element);
            this.myQueryName = queryName;
        }

        @NotNull
        private List<PersistenceFacet> getFacets() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                List<PersistenceFacet> list = Collections.emptyList();
                if (list == null) {
                    QueryReference.$$$reportNull$$$0(0);
                }
                return list;
            }
            List list = PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module);
            if (list == null) {
                QueryReference.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Nullable
        public PersistenceQuery resolveQuery() {
            if (StringUtil.isEmpty((String)this.myQueryName)) {
                return null;
            }
            CommonProcessors.FindFirstProcessor<PersistenceQuery> processor = new CommonProcessors.FindFirstProcessor<PersistenceQuery>(){

                public boolean process(PersistenceQuery persistenceQuery) {
                    return !Comparing.equal((String)myQueryName, (String)((String)persistenceQuery.getName().getValue()), (boolean)true) || super.process((Object)persistenceQuery);
                }
            };
            PersistenceRoleHolder roleHolder = PersistenceRoleHolder.getInstance((Project)this.myElement.getProject());
            for (PersistenceFacet facet : this.getFacets()) {
                if (!roleHolder.processMergedQueries(facet, (Processor)processor)) break;
            }
            return processor.isFound() ? (PersistenceQuery)processor.getFoundValue() : null;
        }

        public PsiElement resolve() {
            PersistenceQuery persistenceQuery = this.resolveQuery();
            return persistenceQuery == null ? null : persistenceQuery.getIdentifyingPsiElement();
        }

        public Object @NotNull [] getVariants() {
            ArrayList result = new ArrayList();
            Processor processor = persistenceQuery -> {
                String name = (String)persistenceQuery.getName().getValue();
                if (StringUtil.isNotEmpty((String)name)) {
                    String query = (String)persistenceQuery.getQuery().getValue();
                    LookupElementBuilder lookupItem = LookupElementBuilder.create((String)name);
                    if (StringUtil.isNotEmpty((String)query)) {
                        int maxDisplayChars = 30;
                        String text = query.length() < maxDisplayChars ? query : query.substring(0, maxDisplayChars) + "...";
                        lookupItem = lookupItem.withTypeText(text);
                    }
                    result.add(lookupItem);
                }
                return true;
            };
            PersistenceRoleHolder holder = PersistenceRoleHolder.getInstance((Project)this.myElement.getProject());
            for (PersistenceFacet facet : this.getFacets()) {
                if (!holder.processMergedQueries(facet, processor)) break;
            }
            Object[] objectArray = result.toArray();
            if (objectArray == null) {
                QueryReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = JpaMessages.message("cannot.resolve.query.0", new Object[0]);
            if (string == null) {
                QueryReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/jpa/JpaQueryReferenceProvider$QueryReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFacets";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class QueryRelatedReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider,
    HighlightedReference {
        public QueryRelatedReference(PsiElement element) {
            super(element, false);
        }

        public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
            return LocalQuickFix.EMPTY_ARRAY;
        }
    }
}

