/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DbViewNavigatableResolveTarget;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.jpa.DataSourceRelatedReferenceFixProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaDataSourceORMInspection;
import com.intellij.jpa.highlighting.JpaDomFacetInspection;
import com.intellij.jpa.model.annotations.mapping.EntityMappingsImpl;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.util.OrmCompletionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistenceInheritanceType;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.model.TableInfoProvider;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.converters.QuotedValueConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

public final class ORMReferencesUtil {
    public static final TableInfo NO_TABLE_INFO = new TableInfo("", "", "");
    public static final Function<UElement, Collection<DbTable>> GENERAL_TABLE_REFERENCES_PROVIDER = uElement -> {
        Pair psiTableAnnotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)uElement);
        if (psiTableAnnotationEntry == null || psiTableAnnotationEntry.getFirst() == null) {
            return ContainerUtil.emptyList();
        }
        return ORMReferencesUtil.getTableVariants(PersistenceUtil.getDataSources((PsiClass)ORMReferencesUtil.getTargetClass(uElement)), ORMReferencesUtil.getStringParameter((PsiAnnotation)psiTableAnnotationEntry.getFirst(), "schema"));
    };
    public static final Function<UElement, Collection<DbTable>> COLUMN_ANNO_TABLE_PROVIDER = uElement -> {
        PsiClass psiClass = ORMReferencesUtil.getTargetClass(uElement);
        if (psiClass == null) {
            return Collections.emptyList();
        }
        return ORMReferencesUtil.getColumnTableVariants(PersistenceUtil.getDataSources((PsiClass)psiClass), JpaUtil.getPersistentObjectsOfClass(psiClass, PersistentEntity.class), FunctionUtil.id());
    };
    public static final Function<UElement, Collection<DbElement>> CATALOG_NAME_PROVIDER = uElement -> ORMReferencesUtil.getCatalogVariants(PersistenceUtil.getDataSources((PsiClass)ORMReferencesUtil.getTargetClass(uElement)));
    public static final Function<UElement, Collection<DbElement>> SCHEMA_NAME_PROVIDER = uElement -> {
        Pair psiTableAnnotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)uElement);
        if (psiTableAnnotationEntry == null || psiTableAnnotationEntry.getFirst() == null) {
            return ContainerUtil.emptyList();
        }
        String tableName = ORMReferencesUtil.getStringParameter((PsiAnnotation)psiTableAnnotationEntry.getFirst(), JpaAnnotationConstants.TABLE_GENERATOR_ANNO.isFqn(((PsiAnnotation)psiTableAnnotationEntry.getFirst()).getQualifiedName()) ? "table" : "name");
        Collection dataSources = PersistenceUtil.getDataSources((PsiClass)ORMReferencesUtil.getTargetClass(uElement));
        return ORMReferencesUtil.getSchemaVariants(dataSources, tableName);
    };
    public static final Function<UElement, TableInfo> COLUMN_FOR_CONSTRAINT_ANNO_REFERENCE_PROVIDER = uElement -> {
        PsiAnnotation psiTableAnnotation = ORMReferencesUtil.getTopPsiAnnotation(uElement);
        if (psiTableAnnotation == null) {
            return NO_TABLE_INFO;
        }
        TableInfo tableInfo = ORMReferencesUtil.getTableInfo(psiTableAnnotation, "name");
        return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
    };
    public static final Function<UElement, TableInfo> GENERAL_COLUMN_INFO_PROVIDER = uElement -> {
        UElement uTableAnnotation = UastUtils.getParentOfType((UElement)uElement, UAnnotation.class);
        if (uTableAnnotation == null) {
            return NO_TABLE_INFO;
        }
        PsiElement psiColumnAnnotation = uTableAnnotation.getJavaPsi();
        if (!(psiColumnAnnotation instanceof PsiAnnotation)) {
            return NO_TABLE_INFO;
        }
        String specifiedName = ORMReferencesUtil.getStringParameter((PsiAnnotation)psiColumnAnnotation, "table");
        if (StringUtil.isEmpty((String)specifiedName)) {
            UDeclaration uParentDeclaration = (UDeclaration)UastUtils.getParentOfType((UElement)uElement, UDeclaration.class, (boolean)false, (Class[])new Class[]{UClass.class});
            PsiModifierListOwner asJavaPsiElement = (PsiModifierListOwner)UElementKt.getAsJavaPsiElement((UElement)uParentDeclaration, PsiModifierListOwner.class);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)asJavaPsiElement, (String[])new String[]{JpaAnnotationConstants.COLLECTION_TABLE_ANNO.fqn(psiColumnAnnotation)});
            if (annotation != null) {
                TableInfo tableInfo = ORMReferencesUtil.getTableInfo(annotation, "name");
                return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
            }
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)asJavaPsiElement, (String[])new String[]{JpaAnnotationConstants.ELEMENT_COLLECTION_ANNO.fqn(psiColumnAnnotation)}) != null) {
                return ORMReferencesUtil.getCollectionElementDefaultTableName(uElement, specifiedName);
            }
        }
        TableInfo tableInfo = ORMReferencesUtil.getEntityTableInfo(uElement, null, specifiedName);
        return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
    };
    public static final Function<UElement, TableInfo> JOIN_COLUMN_INFO_PROVIDER = uElement -> {
        String specifiedName;
        Pair containingAnnotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)uElement);
        if (containingAnnotationEntry == null) {
            return NO_TABLE_INFO;
        }
        UAnnotation containingUAnnotation = (UAnnotation)containingAnnotationEntry.getFirst();
        Pair parentalAnnotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)containingUAnnotation);
        PsiMember targetMember = ORMReferencesUtil.getTargetMember(uElement, true, JpaAnnotationConstants.JOIN_COLUMN_ANNO);
        PsiAnnotation annotationJavaPsi = containingUAnnotation.getJavaPsi();
        String string = specifiedName = annotationJavaPsi == null ? null : ORMReferencesUtil.getStringParameter(annotationJavaPsi, "table");
        if (parentalAnnotationEntry != null) {
            TableInfo tableInfo;
            PsiAnnotation parentalAnnotation = (PsiAnnotation)parentalAnnotationEntry.getFirst();
            String parentalAnnoFqn = parentalAnnotation.getQualifiedName();
            if (JpaAnnotationConstants.JOIN_TABLE_ANNO.isFqn(parentalAnnoFqn) || JpaAnnotationConstants.COLLECTION_TABLE_ANNO.isFqn(parentalAnnoFqn)) {
                return ORMReferencesUtil.getTableInfo(parentalAnnotation, "name");
            }
            if (JpaAnnotationConstants.ASSOCIATION_OVERRIDE_ANNO.isFqn(parentalAnnoFqn) && (tableInfo = ORMReferencesUtil.getEmbeddedAttributeTableInfo((PsiAnnotation)parentalAnnotationEntry.getFirst(), targetMember, uElement.getJavaPsi(), specifiedName)) != null) {
                return tableInfo;
            }
        }
        if (targetMember == null) {
            return NO_TABLE_INFO;
        }
        TableInfo tableInfo = ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(targetMember, false), uElement.getJavaPsi(), specifiedName);
        return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
    };
    public static final Function<UElement, TableInfo> REFERENCED_COLUMN_INFO_PROVIDER = uElement -> {
        boolean isTargetEntity;
        PsiElement psiElement = uElement.getSourcePsi();
        if (psiElement == null) {
            return NO_TABLE_INFO;
        }
        PsiAnnotation topPsiAnnotation = ORMReferencesUtil.getTopPsiAnnotation(uElement);
        if (topPsiAnnotation != null && (JpaAnnotationConstants.JOIN_TABLE_ANNO.isFqn(topPsiAnnotation.getQualifiedName()) || JpaAnnotationConstants.COLLECTION_TABLE_ANNO.isFqn(topPsiAnnotation.getQualifiedName()))) {
            PsiAnnotationMemberValue joinColumns = topPsiAnnotation.findAttributeValue("joinColumns");
            PsiAnnotationMemberValue inverseColumns = topPsiAnnotation.findAttributeValue("inverseJoinColumns");
            if (UastUtils.isUastChildOf((UElement)uElement, (UElement)UastContextKt.toUElement((PsiElement)joinColumns), (boolean)true)) {
                isTargetEntity = false;
            } else {
                if (!UastUtils.isUastChildOf((UElement)uElement, (UElement)UastContextKt.toUElement((PsiElement)inverseColumns), (boolean)true)) return NO_TABLE_INFO;
                isTargetEntity = true;
            }
        } else {
            isTargetEntity = true;
        }
        if (isTargetEntity) {
            PsiMember member;
            if (topPsiAnnotation != null && JpaAnnotationConstants.ASSOCIATION_OVERRIDE_ANNO.isFqn(topPsiAnnotation.getQualifiedName())) {
                String attributeName = ORMReferencesUtil.getStringParameter(topPsiAnnotation, "name");
                PersistentAttribute base = attributeName == null ? null : (PersistentAttribute)ElementPresentationManager.findByName(ORMReferencesUtil.getPersistenceAttributes(ORMReferencesUtil.getTargetMember(uElement, true, JpaAnnotationConstants.ASSOCIATION_OVERRIDE_ANNO), true), (String)attributeName);
                member = base == null ? null : base.getPsiMember();
            } else {
                JavaeeClass searchedAnnotationFqn = topPsiAnnotation == null || topPsiAnnotation.getQualifiedName() == null ? JpaAnnotationConstants.JOIN_COLUMN_ANNO : JavaeeClass.create((String)topPsiAnnotation.getQualifiedName());
                member = ORMReferencesUtil.getTargetMember(uElement, false, searchedAnnotationFqn);
            }
            TableInfo tableInfo = ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(member, true), psiElement);
            return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
        }
        TableInfo tableInfo = ORMReferencesUtil.getEntityTableInfo(uElement, null, null);
        return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
    };
    public static final Function<UElement, TableInfo> PRIMARY_KEY_COLUMN_INFO_PROVIDER = uElement -> {
        PsiAnnotation psiParentAnnotation = ORMReferencesUtil.getTopPsiAnnotation(uElement);
        if (psiParentAnnotation != null && JpaAnnotationConstants.SECONDARY_TABLE_ANNO.isFqn(psiParentAnnotation.getQualifiedName())) {
            TableInfo tableInfo = ORMReferencesUtil.getTableInfo(psiParentAnnotation, "name");
            return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
        }
        TableInfo tableInfo = ORMReferencesUtil.getEntityTableInfo(uElement, null, null);
        return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
    };
    public static final Function<UElement, TableInfo> PRIMARY_KEY_REFERENCED_COLUMN_INFO_PROVIDER = uElement -> {
        PsiAnnotation psiParentAnnotation = ORMReferencesUtil.getTopPsiAnnotation(uElement);
        if (psiParentAnnotation != null && JpaAnnotationConstants.SECONDARY_TABLE_ANNO.isFqn(psiParentAnnotation.getQualifiedName())) {
            TableInfo tableInfo = ORMReferencesUtil.getEntityTableInfo(uElement, null, null);
            return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
        }
        PsiMember member = ORMReferencesUtil.getTargetMember(uElement, false, JpaAnnotationConstants.PRIMARY_KEY_JOIN_COLUMN_ANNO);
        if (member == null) {
            PsiClass psiClass = ORMReferencesUtil.getTargetClass(uElement);
            if (psiClass == null) {
                return null;
            }
            TableInfo tableInfo = ORMReferencesUtil.getEntityTableInfo((PsiElement)psiClass.getSuperClass(), (PsiElement)psiClass, null);
            return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
        }
        TableInfo tableInfo = ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(member, true), uElement.getJavaPsi(), null);
        return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
    };
    public static final Function<UElement, TableInfo> DISCRIMINATOR_TABLE_INFO_PROVIDER = uElement -> ORMReferencesUtil.considerEmbeddableUsages(ORMReferencesUtil.getEntityTableInfo(uElement, null, null), uElement);
    public static final Function<UElement, TableInfo> TABLE_GENERATOR_INFO_PROVIDER = uElement -> {
        Pair annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)uElement);
        if (annotationEntry == null || annotationEntry.getFirst() == null) {
            return NO_TABLE_INFO;
        }
        TableInfo tableInfo = ORMReferencesUtil.getTableInfo((PsiAnnotation)annotationEntry.getFirst(), "table");
        return ORMReferencesUtil.considerEmbeddableUsages(tableInfo, uElement);
    };
    public static final Function<DbColumn, String> COLUMN_MAPPER = s -> s.getName();
    public static final Function<DbTable, LookupElement> TABLE_LOOKUP_MAPPER = s -> {
        Dbms dbms = DbImplUtilCore.getDbms((DbElement)s);
        String kindName = DbPresentationCore.getPresentableName((ObjectKind)s.getKind(), (Dbms)dbms);
        return LookupElementBuilder.create((PsiNamedElement)s).withIcon(s.getIcon()).withTypeText(kindName).withCaseSensitivity(false);
    };
    public static final Function<DbColumn, LookupElement> COLUMN_LOOKUP_MAPPER = s -> {
        String typeName = s.getDasType().toDataType().getSpecification();
        return LookupElementBuilder.create((PsiNamedElement)s).withIcon(s.getIcon()).withTypeText(typeName).withCaseSensitivity(false);
    };
    public static final Function<DbElement, LookupElement> CATALOG_LOOKUP_MAPPER = s -> LookupElementBuilder.create((PsiNamedElement)s).withCaseSensitivity(false);
    public static final Function<DbElement, LookupElement> SCHEMA_LOOKUP_MAPPER = s -> LookupElementBuilder.create((PsiNamedElement)s).withCaseSensitivity(false);
    private static final Function<DasObject, String> DB_ELEMENT_NAME_MAPPER = DasUtil.TO_NAME;

    @Nullable
    private static UClass containingEmbeddableOrNull(UElement uElement) {
        UClass containingUClass = UastUtils.getContainingUClass((UElement)uElement);
        PsiElement sourcePsi = uElement.getSourcePsi();
        if (containingUClass == null || sourcePsi == null || containingUClass.findAnnotation(JpaAnnotationConstants.EMBEDDABLE_ANNO.fqn(sourcePsi)) == null) {
            return null;
        }
        return containingUClass;
    }

    @Nullable
    private static TableInfo getCollectionElementDefaultTableName(@NotNull UElement uElement, String specifiedName) {
        TableInfo info;
        if (uElement == null) {
            ORMReferencesUtil.$$$reportNull$$$0(0);
        }
        if ((info = ORMReferencesUtil.getEntityTableInfo(uElement, null, specifiedName)) != null) {
            String propertyName;
            PsiElement psi;
            UElement uMember = UastUtils.getParentOfType((UElement)uElement, UField.class);
            if (uMember == null) {
                uMember = UastUtils.getParentOfType((UElement)uElement, UMethod.class);
            }
            if (uMember != null && (psi = uMember.getSourcePsi()) instanceof PsiMember && StringUtil.isNotEmpty((String)(propertyName = PropertyUtilBase.getPropertyName((PsiMember)((PsiMember)psi))))) {
                return new TableInfo(info.name + "_" + propertyName, info.schema, info.catalog);
            }
        }
        return ORMReferencesUtil.getEntityTableInfo(uElement, null, specifiedName);
    }

    private static PsiAnnotation getTopPsiAnnotation(UElement uElement) {
        Pair containingAnnotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)uElement);
        if (containingAnnotationEntry == null) {
            return null;
        }
        UAnnotation containingUAnnotation = (UAnnotation)containingAnnotationEntry.getFirst();
        Pair topAnnotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)containingUAnnotation);
        if (topAnnotationEntry == null) {
            return null;
        }
        return (PsiAnnotation)topAnnotationEntry.getFirst();
    }

    private static boolean isLocatedInMappedSuperclass(UElement uElement) {
        UClass containingUClass = UastUtils.getContainingUClass((UElement)uElement);
        return containingUClass != null && ORMReferencesUtil.hasAnno(containingUClass, JpaAnnotationConstants.MAPPED_SUPERCLASS_ANNO);
    }

    private static boolean hasAnno(@NotNull UClass containingUClass, @NotNull JavaeeClass javaeeClass) {
        if (containingUClass == null) {
            ORMReferencesUtil.$$$reportNull$$$0(1);
        }
        if (javaeeClass == null) {
            ORMReferencesUtil.$$$reportNull$$$0(2);
        }
        return containingUClass.findAnnotation(javaeeClass.javax()) != null || containingUClass.findAnnotation(javaeeClass.jakarta()) != null;
    }

    @Nullable
    private static TableInfo getEmbeddedAttributeTableInfo(@Nullable PsiAnnotation psiParentAnnotation, @Nullable PsiMember targetMember, @Nullable PsiElement element, @Nullable String specifiedName) {
        if (targetMember == null || element == null || psiParentAnnotation == null) {
            return null;
        }
        final String nameParam = AnnotationUtil.getStringAttributeValue((PsiAnnotation)psiParentAnnotation, (String)"name");
        if (StringUtil.isNotEmpty((String)nameParam)) {
            PersistenceModelBrowser browser = PersistenceHelper.getHelper().getSharedModelBrowser();
            for (PersistentAttribute attribute : browser.getPersistenceAttributes(targetMember)) {
                PsiClass psiClass;
                if (!(attribute instanceof PersistentEmbeddedAttribute) || (psiClass = (PsiClass)((PersistentEmbeddedAttribute)attribute).getTargetEmbeddableClass().getValue()) == null) continue;
                for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
                    CommonProcessors.FindFirstProcessor<PersistentAttribute> firstProcessor = new CommonProcessors.FindFirstProcessor<PersistentAttribute>(){

                        protected boolean accept(PersistentAttribute attribute) {
                            return nameParam.equals(attribute.getName().getStringValue());
                        }
                    };
                    browser.queryAttributes(role.getPersistentObject()).forEach((Processor)firstProcessor);
                    PersistentAttribute foundValue = (PersistentAttribute)firstProcessor.getFoundValue();
                    if (foundValue == null) continue;
                    return ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(foundValue.getPsiMember(), false), element, specifiedName);
                }
            }
        }
        return null;
    }

    private ORMReferencesUtil() {
    }

    @Nullable
    public static PsiClass getEntityClass(PsiMember member, boolean target) {
        for (PersistentAttribute attribute : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member)) {
            if (!(attribute instanceof PersistentRelationshipAttribute)) continue;
            PersistentRelationshipAttribute relationAttr = (PersistentRelationshipAttribute)attribute;
            if (relationAttr.getAttributeModelHelper().isInverseSide()) {
                return target ? ORMReferencesUtil.getTargetClass((PsiElement)member) : PersistenceCommonUtil.getTargetClass((PersistentRelationshipAttribute)relationAttr);
            }
            return target ? PersistenceCommonUtil.getTargetClass((PersistentRelationshipAttribute)relationAttr) : ORMReferencesUtil.getTargetClass((PsiElement)member);
        }
        return target ? null : ORMReferencesUtil.getTargetClass((PsiElement)member);
    }

    public static <T> Collection<DbTable> getColumnTableVariants(Collection<? extends DbDataSource> dataSources, List<? extends T> roles, Function<? super T, ? extends PersistentEntity> entityMapper) {
        if (dataSources.isEmpty()) {
            return Collections.emptyList();
        }
        BidirectionalMap tableMap = new BidirectionalMap();
        ORMReferencesUtil.processTables(dataSources, (PairProcessor<? super DbDataSource, ? super DasObject>)((PairProcessor)(db, table) -> {
            DbElement element = DbImplUtilCore.findElement((DbDataSource)db, (DasObject)table);
            if (element instanceof DbTable) {
                tableMap.put((Object)((DbTable)element), (Object)StringUtil.toUpperCase((String)table.getName()));
            }
            return true;
        }));
        if (roles.size() == 0) {
            return tableMap.keySet();
        }
        Function function = s -> {
            List list = s == null ? null : tableMap.getKeysByValue((Object)StringUtil.toUpperCase((String)s));
            return list == null ? Collections.emptyList() : list;
        };
        Function mapper = role -> {
            PersistentEntity entity = (PersistentEntity)entityMapper.fun(role);
            HashSet result = new HashSet((Collection)function.fun((Object)((String)entity.getObjectModelHelper().getTable().getTableName().getValue())));
            for (TableInfoProvider table : entity.getObjectModelHelper().getSecondaryTables()) {
                result.addAll((Collection)function.fun((Object)((String)table.getTableName().getValue())));
            }
            return result;
        };
        return ContainerUtil.concat(roles, (Function)mapper);
    }

    @NotNull
    public static Collection<DbTable> getTableVariants(@NotNull Collection<? extends DbDataSource> dataSources, @Nullable String schemaName) {
        if (dataSources == null) {
            ORMReferencesUtil.$$$reportNull$$$0(3);
        }
        if (dataSources.isEmpty()) {
            List<DbTable> list = Collections.emptyList();
            if (list == null) {
                ORMReferencesUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        boolean checkSchema = ORMReferencesUtil.containsIgnoreCase(ORMReferencesUtil.getAllowedSchemas(dataSources), schemaName, DB_ELEMENT_NAME_MAPPER);
        ArrayList<DbTable> result = new ArrayList<DbTable>();
        ORMReferencesUtil.processTables(dataSources, (PairProcessor<? super DbDataSource, ? super DasObject>)((PairProcessor)(db, table) -> {
            DbElement element;
            if ((!checkSchema || DasUtil.isNoName((String)DasUtil.getSchema((DasObject)table)) || schemaName.equalsIgnoreCase(DasUtil.getSchema((DasObject)table))) && (element = DbImplUtilCore.findElement((DbDataSource)db, (DasObject)table)) instanceof DbTable) {
                result.add((DbTable)element);
            }
            return true;
        }));
        ArrayList<DbTable> arrayList = result;
        if (arrayList == null) {
            ORMReferencesUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<DbElement> getSchemaVariants(@NotNull Collection<? extends DbDataSource> dataSources, @Nullable String tableName) {
        if (dataSources == null) {
            ORMReferencesUtil.$$$reportNull$$$0(6);
        }
        if (dataSources.isEmpty()) {
            List<DbElement> list = Collections.emptyList();
            if (list == null) {
                ORMReferencesUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (tableName == null || StringUtil.isEmpty((String)tableName)) {
            Collection<DbElement> collection = ORMReferencesUtil.getAllowedSchemas(dataSources);
            if (collection == null) {
                ORMReferencesUtil.$$$reportNull$$$0(8);
            }
            return collection;
        }
        Ref foundAtLeastOne = new Ref((Object)Boolean.FALSE);
        ArrayList schemas = new ArrayList();
        ORMReferencesUtil.processTables(dataSources, (PairProcessor<? super DbDataSource, ? super DasObject>)((PairProcessor)(db, table) -> {
            if (tableName.equalsIgnoreCase(table.getName())) {
                foundAtLeastOne.set((Object)Boolean.TRUE);
                ContainerUtil.addIfNotNull((Collection)schemas, (Object)DbImplUtilCore.findElement((DbDataSource)db, (DasObject)table.getDasParent()));
            }
            return true;
        }));
        Collection<Object> collection = (Boolean)foundAtLeastOne.get() != false ? schemas : ORMReferencesUtil.getAllowedSchemas(dataSources);
        if (collection == null) {
            ORMReferencesUtil.$$$reportNull$$$0(9);
        }
        return collection;
    }

    public static <T> List<T> getColumnVariants(Collection<? extends DbDataSource> dataSources, TableInfo tableInfo, Function<? super DbColumn, ? extends T> mapper) {
        if (dataSources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        ORMReferencesUtil.processTables(dataSources, (PairProcessor<? super DbDataSource, ? super DasObject>)((PairProcessor)(db, table) -> {
            if (ORMReferencesUtil.isTableAccepted(table, tableInfo)) {
                for (DasColumn column : DasUtil.getColumns((DasObject)table)) {
                    ContainerUtil.addIfNotNull((Collection)list, (Object)mapper.fun((Object)((DbColumn)DbImplUtilCore.findElement((DbDataSource)db, (DasObject)column))));
                }
            }
            return true;
        }));
        return list;
    }

    @NotNull
    public static Collection<DbElement> getCatalogVariants(@NotNull Collection<? extends DbDataSource> dataSources) {
        if (dataSources == null) {
            ORMReferencesUtil.$$$reportNull$$$0(10);
        }
        if (dataSources.isEmpty()) {
            List<DbElement> list = Collections.emptyList();
            if (list == null) {
                ORMReferencesUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<DbElement> result = new ArrayList<DbElement>();
        for (DbDataSource dbDataSource : dataSources) {
            for (DasObject o : dbDataSource.getModel().getModelRoots()) {
                ContainerUtil.addIfNotNull(result, (Object)DbImplUtilCore.findElement((DbDataSource)dbDataSource, (DasObject)o));
            }
        }
        ArrayList<DbElement> arrayList = result;
        if (arrayList == null) {
            ORMReferencesUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public static boolean processTables(Collection<? extends DbDataSource> dataSources, PairProcessor<? super DbDataSource, ? super DasObject> processor) {
        for (DbDataSource dbDataSource : dataSources) {
            for (DasTable o : DasUtil.getTables((DasDataSource)dbDataSource)) {
                if (processor.process((Object)dbDataSource, (Object)o)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> boolean containsIgnoreCase(Iterable<? extends T> collection, String string, Function<? super T, String> mapper) {
        return ORMReferencesUtil.findIgnoreCase(collection, string, mapper) != null;
    }

    @Nullable
    public static <T> T findIgnoreCase(Iterable<? extends T> collection, String string, Function<? super T, String> mapper) {
        for (T t : collection) {
            String str = (String)mapper.fun(t);
            if (str == null || !str.equalsIgnoreCase(string)) continue;
            return t;
        }
        return null;
    }

    public static Collection<? extends PersistentAttribute> getPersistenceAttributes(PsiMember psiMember, Boolean isCMR) {
        PsiClass psiClass;
        if (psiMember == null) {
            return Collections.emptyList();
        }
        if (psiMember instanceof PsiClass) {
            psiClass = (PsiClass)psiMember;
        } else {
            PsiType psiType = PersistenceCommonUtil.getTargetEntityType((PsiMember)psiMember);
            PsiClass psiClass2 = psiClass = psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
        }
        if (psiClass == null) {
            return Collections.emptyList();
        }
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)psiMember);
        ArrayList<PersistentAttribute> result = new ArrayList<PersistentAttribute>();
        for (PersistentObject object : browser.queryPersistentObjects(psiClass)) {
            for (PersistentAttribute attribute : browser.queryAttributes(object)) {
                if (attribute instanceof PersistentTransientAttribute || isCMR != null && isCMR != attribute instanceof PersistentRelationshipAttribute) continue;
                result.add(attribute);
            }
        }
        return result;
    }

    @Nullable
    public static String getStringParameter(PsiAnnotation psiAnnotation, String paramName) {
        return QuotedValueConverter.unquote((String)((String)JamCommonUtil.getObjectValue((PsiElement)psiAnnotation.findAttributeValue(paramName), String.class)));
    }

    @Nullable
    public static TableInfo getTableInfo(PsiAnnotation psiAnnotation, String tableNameAttributeName) {
        String tableName = ORMReferencesUtil.getStringParameter(psiAnnotation, tableNameAttributeName);
        if (StringUtil.isEmpty((String)tableName)) {
            if (JpaAnnotationConstants.TABLE_ANNO.isFqn(psiAnnotation.getQualifiedName())) {
                return ORMReferencesUtil.getEntityTableInfo((PsiElement)psiAnnotation, null, "");
            }
            return NO_TABLE_INFO;
        }
        return new TableInfo(tableName, ORMReferencesUtil.getStringParameter(psiAnnotation, "schema"), ORMReferencesUtil.getStringParameter(psiAnnotation, "catalog"));
    }

    public static Collection<DbElement> getAllowedSchemas(Collection<? extends DbDataSource> dataSources) {
        ArrayList<DbElement> list = new ArrayList<DbElement>();
        for (DbDataSource dbDataSource : dataSources) {
            for (DasObject o : DasUtil.getSchemas((DasDataSource)dbDataSource)) {
                list.add(DbImplUtilCore.findElement((DbDataSource)dbDataSource, (DasObject)o));
            }
        }
        return list;
    }

    @Nullable
    public static TableInfo getEntityTableInfo(PsiElement element, PsiElement sourceElement) {
        return ORMReferencesUtil.getEntityTableInfo(element, sourceElement, null);
    }

    @Nullable
    public static TableInfo getEntityTableInfo(PsiElement element, @Nullable PsiElement sourceElement, @Nullable String tableName) {
        return element == null ? null : ORMReferencesUtil.getPersistentEntityTableInfo(sourceElement, tableName, ORMReferencesUtil.getTargetClass(element));
    }

    @Nullable
    public static TableInfo getEntityTableInfo(UElement element, PsiElement sourceElement, String tableName) {
        return element == null ? null : ORMReferencesUtil.getPersistentEntityTableInfo(sourceElement, tableName, ORMReferencesUtil.getTargetClass(element));
    }

    private static TableInfo getPersistentEntityTableInfo(PsiElement sourceElement, String tableName, PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)ORMReferencesUtil.getTargetClass(sourceElement));
        for (PersistentObject object : browser.queryPersistentObjects(psiClass)) {
            if (!(object instanceof PersistentEntity)) continue;
            return ORMReferencesUtil.getEntityTableInfo((PersistentEntity)object, tableName, browser);
        }
        return NO_TABLE_INFO;
    }

    @Nullable
    private static TableInfo considerEmbeddableUsages(@Nullable TableInfo defaultInfo, @Nullable UElement uElement) {
        UClass embeddableClass = ORMReferencesUtil.containingEmbeddableOrNull(uElement);
        if (embeddableClass == null) {
            return defaultInfo;
        }
        PsiClass javaPsi = embeddableClass.getJavaPsi();
        Project project = javaPsi.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)javaPsi);
        String name = embeddableClass.getName();
        if (module == null || name == null) {
            return defaultInfo;
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        PsiSearchHelper.SearchCostResult isCheapToSearch = searchHelper.isCheapEnoughToSearch(name, GlobalSearchScope.moduleScope((Module)module), null);
        if (isCheapToSearch != PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) {
            return defaultInfo;
        }
        return ORMReferencesUtil.findEmbeddableTableCandidates(searchHelper, module, name);
    }

    private static TableInfo findEmbeddableTableCandidates(PsiSearchHelper searchHelper, Module module, String embeddableName) {
        HashSet<TableInfo> foundUsages = new HashSet<TableInfo>();
        searchHelper.processElementsWithWord((element, offsetInElement) -> {
            boolean hasEmbeddedAnnotation;
            UVariable variable = (UVariable)UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UVariable.class});
            if (variable == null) {
                return true;
            }
            boolean bl = hasEmbeddedAnnotation = variable.findAnnotation(JpaAnnotationConstants.EMBEDDED_ANNO.fqn(module)) != null || variable.findAnnotation(JpaAnnotationConstants.EMBEDDED_ID_ANNO.fqn(module)) != null;
            if (!hasEmbeddedAnnotation) {
                return true;
            }
            UClass maybeContainingEntity = (UClass)UastUtils.getParentOfType((UElement)variable, UClass.class);
            if (maybeContainingEntity == null) {
                return true;
            }
            TableInfo element1 = ORMReferencesUtil.getEntityTableInfo((PsiElement)maybeContainingEntity.getJavaPsi(), (PsiElement)maybeContainingEntity.getJavaPsi(), null);
            if (element1 != null) {
                foundUsages.add(element1);
            }
            return true;
        }, (SearchScope)GlobalSearchScope.moduleScope((Module)module), embeddableName, (short)1, true, false);
        return new MultipleTableInfo(foundUsages);
    }

    @Nullable
    public static TableInfo getEntityTableInfo(@NotNull PersistentEntity entity, @Nullable String tableName) {
        if (entity == null) {
            ORMReferencesUtil.$$$reportNull$$$0(13);
        }
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)entity.getIdentifyingPsiElement());
        return ORMReferencesUtil.getEntityTableInfo(entity, tableName, browser);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static TableInfo getEntityTableInfo(@NotNull PersistentEntity entity, @Nullable String tableName, PersistenceModelBrowser browser) {
        PersistentEntity persistentEntity;
        PsiClass firstClass;
        if (entity == null) {
            ORMReferencesUtil.$$$reportNull$$$0(14);
        }
        if ((firstClass = (PsiClass)entity.getClazz().getValue()) == null) {
            return ORMReferencesUtil.getEntityTableInfoInner(entity, tableName);
        }
        List classes = JamCommonUtil.getSuperClassList((PsiClass)firstClass.getSuperClass());
        if (classes.isEmpty()) {
            return ORMReferencesUtil.getEntityTableInfoInner(entity, tableName);
        }
        PersistentEntity curEntity = entity;
        PersistentEntity defaultEntity = null;
        block5: for (PsiClass aClass : classes) {
            if (aClass == firstClass) continue;
            PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass);
            int n = persistenceClassRoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                PersistenceClassRole role = persistenceClassRoleArray[n2];
                if (role.getType() == PersistenceClassRoleEnum.ENTITY && browser.acceptsRole(role)) {
                    PersistentEntity superEntity = (PersistentEntity)role.getPersistentObject();
                    PersistenceInheritanceType type = superEntity.getObjectModelHelper().getInheritanceType(entity);
                    if (type == null) {
                        defaultEntity = superEntity;
                    } else {
                        switch (type) {
                            case JOINED: {
                                defaultEntity = null;
                                break block5;
                            }
                            case SINGLE_TABLE: {
                                defaultEntity = null;
                                curEntity = superEntity;
                                break;
                            }
                            case TABLE_PER_CLASS: {
                                defaultEntity = null;
                                break block5;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        if (defaultEntity != null) {
            persistentEntity = defaultEntity;
            return ORMReferencesUtil.getEntityTableInfoInner(persistentEntity, tableName);
        }
        persistentEntity = curEntity;
        return ORMReferencesUtil.getEntityTableInfoInner(persistentEntity, tableName);
    }

    @Nullable
    public static TableInfo getEntityTableInfoInner(@NotNull PersistentEntity entity, @Nullable String tableName) {
        if (entity == null) {
            ORMReferencesUtil.$$$reportNull$$$0(15);
        }
        boolean noCheckTable = StringUtil.isEmpty((String)tableName);
        TableInfoProvider primaryTable = entity.getObjectModelHelper().getTable();
        String name = (String)primaryTable.getTableName().getValue();
        if (name != null && (noCheckTable || name.equalsIgnoreCase(tableName))) {
            return new TableInfo(name, (String)primaryTable.getSchema().getValue(), (String)primaryTable.getCatalog().getValue());
        }
        for (TableInfoProvider curTable : entity.getObjectModelHelper().getSecondaryTables()) {
            String curName = (String)curTable.getTableName().getValue();
            if (curName == null || !noCheckTable && !curName.equalsIgnoreCase(tableName)) continue;
            return new TableInfo(curName, (String)curTable.getSchema().getValue(), (String)curTable.getCatalog().getValue());
        }
        return null;
    }

    public static PsiReference[] getStringBasedReferences(PsiElement psiElement, final Function<? super UElement, ? extends Collection<DbElement>> stringProvider, final Function<? super DbElement, ? extends LookupElement> lookupMapper, final @Nls String unresolvedMessagePattern) {
        final UElement originalUElement = UastContextKt.toUElement((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)psiElement));
        final PsiElementInfo<PsiElement> elementInfo = ORMReferencesUtil.getElementInfo(originalUElement, psiElement);
        final boolean needSpecialSymbolsEscaping = OrmCompletionUtil.needSpecialSymbolsEscaping(psiElement);
        return new PsiReference[]{new QuotedPsiReferenceBase<PsiElement>(elementInfo){

            public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
                if (this.shouldNotResolve()) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults((Collection)stringProvider.fun((Object)originalUElement), elementInfo.myEvaluatedString);
                if (resolveResultArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }

            @Override
            public Collection<LookupElement> getVariantsCollection() {
                return OrmCompletionUtil.escapeIfNeeded(ContainerUtil.map((Collection)((Collection)stringProvider.fun((Object)originalUElement)), (Function)lookupMapper), needSpecialSymbolsEscaping);
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = this.shouldNotResolve() ? super.getUnresolvedMessagePattern() : unresolvedMessagePattern;
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/jpa/ORMReferencesUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "multiResolve";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }};
    }

    private static int calculateQuoteLength(String quotedValue) {
        char q = quotedValue.charAt(0);
        return q == '\"' ? 2 : 1;
    }

    public static PsiReference[] getTableReferences(PsiElement psiElement, final Function<? super UElement, ? extends Collection<DbTable>> tablesProvider) {
        final UElement originalUElement = UastContextKt.toUElement((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)psiElement));
        final PsiElementInfo<PsiElement> elementInfo = ORMReferencesUtil.getElementInfo(originalUElement, psiElement);
        final boolean needEscapeSpecialSymbols = OrmCompletionUtil.needSpecialSymbolsEscaping(psiElement);
        return new PsiReference[]{new QuotedPsiReferenceBase<PsiElement>(elementInfo){

            public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
                if (this.shouldNotResolve()) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults((Collection)tablesProvider.fun((Object)originalUElement), elementInfo.myEvaluatedString);
                if (resolveResultArray == null) {
                    3.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }

            @Override
            public Collection<LookupElement> getVariantsCollection() {
                return OrmCompletionUtil.escapeIfNeeded(ContainerUtil.map((Collection)((Collection)tablesProvider.fun((Object)originalUElement)), TABLE_LOOKUP_MAPPER), needEscapeSpecialSymbols);
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = this.shouldNotResolve() ? super.getUnresolvedMessagePattern() : JpaMessages.message("cannot.resolve.table.0", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/jpa/ORMReferencesUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "multiResolve";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }};
    }

    public static PsiReference[] getColumnReferences(final PsiElement psiElement, final Function<? super UElement, TableInfo> tablesProvider) {
        final UElement originalUElement = UastContextKt.toUElement((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)psiElement));
        final PsiElementInfo<PsiElement> elementInfo = ORMReferencesUtil.getElementInfo(originalUElement, psiElement);
        final PsiClass psiClass = ORMReferencesUtil.getTargetClass(originalUElement);
        final boolean needSpecialSymbolsEscaping = OrmCompletionUtil.needSpecialSymbolsEscaping(psiElement);
        return new PsiReference[]{new QuotedPsiReferenceBase<PsiElement>(elementInfo){

            public boolean isSoft() {
                if (DumbService.isDumb((Project)psiElement.getProject())) {
                    return true;
                }
                return ORMReferencesUtil.isLocatedInMappedSuperclass(originalUElement);
            }

            public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
                if (this.shouldNotResolve()) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                List<ResolveResult> result = ORMReferencesUtil.getColumnVariants(PersistenceUtil.getDataSources((PsiClass)psiClass), (TableInfo)tablesProvider.fun((Object)originalUElement), columnElement -> {
                    if (Comparing.equal((String)columnElement.getName(), (String)elementInfo2.myEvaluatedString, (boolean)false)) {
                        return new PsiElementResolveResult((PsiElement)new DbViewNavigatableResolveTarget((DbElement)columnElement));
                    }
                    return null;
                });
                ResolveResult[] resolveResultArray = result.isEmpty() ? ResolveResult.EMPTY_ARRAY : result.toArray(ResolveResult.EMPTY_ARRAY);
                if (resolveResultArray == null) {
                    4.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }

            @Override
            public Collection<LookupElement> getVariantsCollection() {
                Collection dataSources = PersistenceUtil.getDataSources((PsiClass)psiClass);
                return OrmCompletionUtil.escapeIfNeeded(ORMReferencesUtil.getColumnVariants(dataSources, (TableInfo)tablesProvider.fun((Object)originalUElement), COLUMN_LOOKUP_MAPPER), needSpecialSymbolsEscaping);
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = this.shouldNotResolve() ? super.getUnresolvedMessagePattern() : JpaMessages.message("cannot.resolve.column.0", new Object[0]);
                if (string == null) {
                    4.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/jpa/ORMReferencesUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "multiResolve";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }};
    }

    public static ResolveResult[] getDbElementResolveResults(Collection<? extends DbElement> elements, String name) {
        SmartList result = new SmartList();
        ContainerUtil.process(elements, object -> {
            if (Comparing.equal((String)object.getName(), (String)name, (boolean)false)) {
                result.add((Object)new PsiElementResolveResult((PsiElement)new DbViewNavigatableResolveTarget(object)));
            }
            return true;
        });
        return result.size() == 0 ? ResolveResult.EMPTY_ARRAY : (ResolveResult[])result.toArray((Object[])ResolveResult.EMPTY_ARRAY);
    }

    @Nullable
    public static PsiMember getTargetMember(PsiElement element, boolean allowClass) {
        PsiMember thisMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class, (boolean)false);
        if (thisMember == null) {
            UElement uElement = UastContextKt.toUElement((PsiElement)element);
            return uElement != null ? ORMReferencesUtil.getTargetMember(uElement, true, null) : null;
        }
        if (thisMember instanceof PsiClass && !allowClass) {
            return null;
        }
        return (PsiMember)CompletionUtil.getOriginalElement((PsiElement)thisMember);
    }

    public static PsiMember getTargetMember(UElement uElement, boolean allowClass, JavaeeClass searchedAnnotationFqn) {
        PsiElement sourcePsi;
        UElement parent = UastUtils.getParentOfType((UElement)uElement, UField.class);
        if (parent == null) {
            parent = UastUtils.getParentOfType((UElement)uElement, UMethod.class);
        }
        if (parent == null && allowClass) {
            parent = UastUtils.getContainingUClass((UElement)uElement);
        }
        if (searchedAnnotationFqn != null && parent != null && parent.getSourcePsi() != null && (sourcePsi = parent.getSourcePsi()) instanceof PsiNameIdentifierOwner) {
            return JpaUtil.getAccessingMethodsFor(((PsiNameIdentifierOwner)parent.getSourcePsi()).getIdentifyingElement()).stream().filter(method -> method.hasAnnotation(searchedAnnotationFqn.javax()) || method.hasAnnotation(searchedAnnotationFqn.jakarta())).findAny().orElse((PsiMember)parent.getJavaPsi());
        }
        return parent == null || parent.getJavaPsi() == null ? null : (PsiMember)parent.getJavaPsi();
    }

    @Nullable
    public static PsiClass getTargetClass(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiMember member = ORMReferencesUtil.getTargetMember(element, true);
        return member instanceof PsiClass ? (PsiClass)member : (member != null ? member.getContainingClass() : null);
    }

    @Nullable
    public static PsiClass getTargetClass(UElement uElement) {
        if (uElement == null) {
            return null;
        }
        if (uElement instanceof UClass) {
            UClass uClass = (UClass)uElement;
            return uClass.getJavaPsi();
        }
        UClass containingUClass = UastUtils.getContainingUClass((UElement)uElement);
        return containingUClass == null ? null : containingUClass.getJavaPsi();
    }

    public static boolean isTableAccepted(DasObject dbTable, TableInfo tableInfo) {
        if (tableInfo == null) {
            return true;
        }
        for (TableInfo variant : tableInfo.suitableVariants()) {
            if (variant.name != null && !variant.name.equalsIgnoreCase(dbTable.getName()) || !StringUtil.isEmpty((String)variant.schema) && !variant.schema.equalsIgnoreCase(DasUtil.getSchema((DasObject)dbTable)) || !StringUtil.isEmpty((String)variant.catalog) && !variant.catalog.equalsIgnoreCase(DasUtil.getCatalog((DasObject)dbTable))) continue;
            return true;
        }
        return false;
    }

    private static PsiElementInfo<PsiElement> getElementInfo(UElement uElement, PsiElement psiElement) {
        String stringValue;
        UStringConcatenationsFacade concatenation;
        String originalValue = null;
        if (uElement instanceof UExpression && (concatenation = UStringConcatenationsFacade.createFromTopConcatenation((UExpression)((UExpression)uElement))) != null) {
            originalValue = concatenation.asPartiallyKnownString().getValueIfKnown();
        }
        if (StringUtil.isEmpty(originalValue)) {
            originalValue = String.valueOf(JamCommonUtil.computeMemberValue((PsiElement)psiElement));
        }
        int startOffset = Strings.areSameInstance((String)originalValue, (String)(stringValue = QuotedValueConverter.unquote(originalValue))) ? 0 : ORMReferencesUtil.calculateQuoteLength(originalValue);
        int endOffset = Strings.areSameInstance((String)originalValue, (String)stringValue) || QuotedValueConverter.quotationIsNotClosed((String)originalValue) ? 0 : startOffset;
        return new PsiElementInfo<PsiElement>(psiElement, startOffset, endOffset, stringValue);
    }

    public static Collection<LookupElement> setTailType(Collection<LookupElement> variantsCollection, String quoteSign) {
        if (StringUtil.isEmpty((String)quoteSign)) {
            return variantsCollection;
        }
        MyTailType tailType = new MyTailType(quoteSign);
        return ContainerUtil.map(variantsCollection, element -> TailTypeDecorator.withTail((LookupElement)element, (TailType)tailType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 9, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingUClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeClass";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/ORMReferencesUtil";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/ORMReferencesUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableVariants";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaVariants";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatalogVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionElementDefaultTableName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAnno";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTableVariants";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCatalogVariants";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEntityTableInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEntityTableInfoInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 9, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static class TableInfo {
        String name;
        String schema;
        String catalog;

        public TableInfo(String name, String schema, String catalog) {
            this.name = name;
            this.schema = schema;
            this.catalog = catalog;
        }

        Collection<TableInfo> suitableVariants() {
            return new SmartList((Object)this);
        }
    }

    public static class MultipleTableInfo
    extends TableInfo {
        private final Collection<TableInfo> myTables;

        public MultipleTableInfo(Collection<TableInfo> tables) {
            super("", "", "");
            this.myTables = tables;
        }

        @Override
        Collection<TableInfo> suitableVariants() {
            return this.myTables;
        }
    }

    public static final class PsiElementInfo<T extends PsiElement> {
        private final T myElement;
        private final int myStartOffset;
        private final int myEndOffset;
        public final String myEvaluatedString;

        public PsiElementInfo(T element, int startOffset, int endOffset, String evaluatedString) {
            this.myElement = element;
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myEvaluatedString = evaluatedString;
        }
    }

    private static class MyTailType
    extends TailType {
        private final String myText;

        MyTailType(String text) {
            this.myText = text;
        }

        public int processTail(Editor editor, int tailOffset) {
            if (StringUtil.isEmpty((String)this.myText)) {
                return tailOffset;
            }
            editor.getDocument().insertString(tailOffset, (CharSequence)this.myText);
            return MyTailType.moveCaret((Editor)editor, (int)tailOffset, (int)this.myText.length());
        }
    }

    public static abstract class QuotedPsiReferenceBase<T extends PsiElement>
    extends DataSourceRelatedReference<T>
    implements HighlightedReference {
        private final int myStartOffset;
        private final int myEndOffset;

        public QuotedPsiReferenceBase(T element, int startOffset, int endOffset) {
            super(element);
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        protected QuotedPsiReferenceBase(PsiElementInfo<? extends T> elementMeta) {
            super(elementMeta.myElement);
            this.myStartOffset = elementMeta.myStartOffset;
            this.myEndOffset = elementMeta.myEndOffset;
        }

        protected TextRange calculateDefaultRangeInElement() {
            TextRange textRange = super.calculateDefaultRangeInElement();
            return this.myStartOffset == 0 && this.myEndOffset == 0 ? textRange : new TextRange(textRange.getStartOffset() + this.myStartOffset, textRange.getEndOffset() - this.myEndOffset);
        }

        protected boolean shouldNotResolve() {
            return this.myStartOffset != this.myEndOffset;
        }

        @NotNull
        @InspectionMessage
        public String getUnresolvedMessagePattern() {
            String string = XmlDomBundle.message((String)"dom.inspections.invalid.value.quotation", (Object[])new Object[0]);
            if (string == null) {
                QuotedPsiReferenceBase.$$$reportNull$$$0(0);
            }
            return string;
        }

        public abstract Collection<LookupElement> getVariantsCollection();

        public Object @NotNull [] getVariants() {
            Object[] objectArray = this.setTailType(this.getVariantsCollection()).toArray();
            if (objectArray == null) {
                QuotedPsiReferenceBase.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        protected Collection<LookupElement> setTailType(Collection<LookupElement> variantsCollection) {
            if (this.myStartOffset == 0) {
                return variantsCollection;
            }
            int start = super.calculateDefaultRangeInElement().getStartOffset();
            String quote = this.getElement().getText().substring(start, start + this.myStartOffset);
            return ORMReferencesUtil.setTailType(variantsCollection, quote);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/jpa/ORMReferencesUtil$QuotedPsiReferenceBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class DataSourceRelatedReference<T extends PsiElement>
    extends PsiPolyVariantReferenceBase<T>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        protected DataSourceRelatedReference(T element) {
            super(element);
        }

        public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            List facets = PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module);
            Stream extQuickFixes = DataSourceRelatedReferenceFixProvider.EP_NAME.getExtensionList().stream().flatMap(e -> Arrays.stream(Objects.requireNonNull(e.getQuickFixes(this))));
            LocalQuickFix[] quickFixes = facets.isEmpty() ? JpaDomFacetInspection.createAddFacetQuickFix(JamCommonUtil.getAllDependentModules((Module)module)) : JpaDataSourceORMInspection.createUnitDataSourceQuickFixes(new EntityMappingsImpl(module));
            return Stream.concat(Arrays.stream(quickFixes), extQuickFixes).toList().toArray(LocalQuickFix.EMPTY_ARRAY);
        }
    }
}

