/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DataBus;
import com.intellij.database.console.client.ScriptingSessionClient;
import com.intellij.database.console.session.ToolWindowSessionViewController;
import com.intellij.database.datagrid.ConsoleLogger;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.run.session.BaseLogView;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.LogViewController;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.SessionToolWindowHelper;
import com.intellij.database.run.session.StateWatcher;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.run.ui.ParametersPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.DataManager;
import com.intellij.jpa.engine.SessionVisibilityController;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.EdtNoGetDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class JpaConsoleAdapter<T>
extends AbstractQueryLanguageConsole<T, JpaConsoleAdapter<T>>
implements VisibleSession<T> {
    protected static final String ID_CONSOLE = "Input";
    protected final ScriptingClientDataConsumer myDataConsumer;
    protected final ScriptModel.PStorage myPStorage;
    protected final ParametersPanel myParamPanel;
    private final AdaptingView<T> myView;
    private final StateWatcher myWatcher;
    private final ScriptModel<?> myScriptModel;
    private final ParametersHolder myHolder;

    public JpaConsoleAdapter(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull T target, @NotNull String title, @NotNull Language language) {
        if (project == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(1);
        }
        if (target == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(2);
        }
        if (title == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(3);
        }
        if (language == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(4);
        }
        super(project, target, messageBus);
        LanguageConsoleImpl console = new LanguageConsoleImpl(project, title, language);
        this.myScriptModel = this.createScriptModel((LanguageConsoleView)console);
        this.myView = this.createSessionView((LanguageConsoleView)console, this.myScriptModel);
        Disposer.register((Disposable)this, this.myScriptModel);
        Disposer.register((Disposable)this, this.myView);
        this.myWatcher = new StateWatcher.SessionWatcher((VisibleSession)this);
        this.myDataConsumer = this.getView().getDataConsumer();
        this.myHolder = this.getView().getParametersHolder();
        this.myPStorage = this.myHolder.getPStorage();
        this.myParamPanel = this.myHolder.getParamPanel();
        this.getView().getUi().getContentManager().addDataProvider((DataProvider)((EdtNoGetDataProvider)sink -> DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)this)));
    }

    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> scriptModel) {
        if (scriptModel == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(5);
        }
        return this.myHolder.beforeExecuteQueries(scriptModel);
    }

    public boolean isIdle() {
        return this.myWatcher.isIdle();
    }

    @NotNull
    public AdaptingView<T> getView() {
        AdaptingView<T> adaptingView = this.myView;
        if (adaptingView == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(6);
        }
        return adaptingView;
    }

    @NotNull
    private AdaptingView<T> createSessionView(@NotNull LanguageConsoleView languageConsole, @NotNull ScriptModel<?> scriptModel) {
        if (languageConsole == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(7);
        }
        if (scriptModel == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(8);
        }
        return new AdaptingView(languageConsole.getProject(), this, languageConsole, scriptModel);
    }

    @NotNull
    public ScriptModel<?> getScriptModel() {
        ScriptModel<?> scriptModel = this.myScriptModel;
        if (scriptModel == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(9);
        }
        return scriptModel;
    }

    @NotNull
    public abstract GridDataHookUp<GridRow, GridColumn> createGridDataHookUp(@NotNull Disposable var1);

    @NotNull
    public abstract String getToolWindowId();

    @NotNull
    public abstract Icon getToolWindowIcon();

    protected abstract void buildConsoleUi();

    @NotNull
    protected abstract ScriptModel<?> createScriptModel(@NotNull LanguageConsoleView var1);

    @NotNull
    protected abstract ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView var1);

    @NotNull
    protected AnAction initParameterView() {
        AnAction anAction = this.getView().getParametersHolder().initParameterView();
        if (anAction == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(10);
        }
        return anAction;
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.getView().getUi();
        if (runnerLayoutUi == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(11);
        }
        return runnerLayoutUi;
    }

    @NotNull
    public static <T extends JpaConsoleAdapter<?>> List<T> getActiveSessions(Project project, String toolwindowId) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            List list = Collections.emptyList();
            if (list == null) {
                JpaConsoleAdapter.$$$reportNull$$$0(12);
            }
            return list;
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(toolwindowId);
        if (window == null) {
            List list = Collections.emptyList();
            if (list == null) {
                JpaConsoleAdapter.$$$reportNull$$$0(13);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (Content content : window.getContentManager().getContents()) {
            ContainerUtil.addIfNotNull((Collection)result, JpaConsoleAdapter.getSession(content));
        }
        SmartList smartList = result;
        if (smartList == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    @NotNull
    private static JpaConsoleAdapter<?> getSession(@NotNull Content content) {
        if (content == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(15);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)content.getComponent());
        JpaConsoleAdapter jpaConsoleAdapter = (JpaConsoleAdapter)Objects.requireNonNull((Session)dataContext.getData(Session.SESSION_KEY));
        if (jpaConsoleAdapter == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(16);
        }
        return jpaConsoleAdapter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10, 11, 12, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleAdapter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleAdapter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "initParameterView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSessions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteQueries";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSessionView";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 10, 11, 12, 13, 14, 16 -> new IllegalStateException(string);
        };
    }

    static class AdaptingView<T>
    extends BaseLogView<JpaConsoleAdapter<T>>
    implements ScriptingSessionClient {
        private final ScriptingClientDataConsumer myDataConsumer;
        private final ParametersHolder myParametersHolder;

        AdaptingView(@NotNull Project project, @NotNull JpaConsoleAdapter<T> console, @NotNull LanguageConsoleView consoleView, @NotNull ScriptModel<?> scriptModel) {
            if (project == null) {
                AdaptingView.$$$reportNull$$$0(0);
            }
            if (console == null) {
                AdaptingView.$$$reportNull$$$0(1);
            }
            if (consoleView == null) {
                AdaptingView.$$$reportNull$$$0(2);
            }
            if (scriptModel == null) {
                AdaptingView.$$$reportNull$$$0(3);
            }
            super(project, consoleView, (LogViewController)new MyController(project, console), console, console.getMessageBus());
            this.myDataConsumer = ScriptingClientDataConsumer.install((Project)this.getProject(), (ScriptingSessionClient)this, (LogView)this);
            SessionVisibilityController<JpaConsoleAdapter<T>> controller = new SessionVisibilityController<JpaConsoleAdapter<T>>(console);
            this.myParametersHolder = new ParametersHolder(this.getProject(), ScriptModel.PStorage.newStorage(), scriptModel, (ParametersHolder.Helper)new MyHelper(consoleView), controller);
            Disposer.register(console, (Disposable)this);
            Disposer.register((Disposable)this, (Disposable)this.myParametersHolder);
        }

        @NotNull
        ParametersHolder getParametersHolder() {
            ParametersHolder parametersHolder = this.myParametersHolder;
            if (parametersHolder == null) {
                AdaptingView.$$$reportNull$$$0(4);
            }
            return parametersHolder;
        }

        @NotNull
        public GridDataHookUp<GridRow, GridColumn> createGridDataHookUp(@NotNull Disposable parent) {
            if (parent == null) {
                AdaptingView.$$$reportNull$$$0(5);
            }
            GridDataHookUp<GridRow, GridColumn> gridDataHookUp = ((JpaConsoleAdapter)this.getTarget()).createGridDataHookUp(parent);
            if (gridDataHookUp == null) {
                AdaptingView.$$$reportNull$$$0(6);
            }
            return gridDataHookUp;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                AdaptingView.$$$reportNull$$$0(7);
            }
            super.uiDataSnapshot(sink);
            LanguageConsoleView console = this.getConsoleView();
            sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)(console.isConsoleEditorEnabled() ? console.getVirtualFile() : null));
        }

        @NotNull
        public ScriptingClientDataConsumer getDataConsumer() {
            ScriptingClientDataConsumer scriptingClientDataConsumer = this.myDataConsumer;
            if (scriptingClientDataConsumer == null) {
                AdaptingView.$$$reportNull$$$0(8);
            }
            return scriptingClientDataConsumer;
        }

        protected void buildConsoleUi() {
            ((JpaConsoleAdapter)this.getTarget()).buildConsoleUi();
        }

        @NotNull
        protected ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView consoleView) {
            if (consoleView == null) {
                AdaptingView.$$$reportNull$$$0(9);
            }
            ConsoleLogger consoleLogger = ((JpaConsoleAdapter)this.getTarget()).createHistoryLogger(consoleView);
            if (consoleLogger == null) {
                AdaptingView.$$$reportNull$$$0(10);
            }
            return consoleLogger;
        }

        public void addRequestToHistory(@NotNull DataRequest.Context context) {
            Object params;
            if (context == null) {
                AdaptingView.$$$reportNull$$$0(11);
            }
            super.addRequestToHistory(context);
            Object object = params = context.request instanceof DataRequest.QueryRequest ? ((DataRequest.QueryRequest)context.request).params : null;
            if (!(params instanceof Map) || ((Map)params).isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder("(");
            boolean first = true;
            for (Map.Entry e : ((Map)params).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(e.getKey()).append("=").append(e.getValue());
            }
            sb.append(")\n");
            this.getConsoleView().print(sb.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
        }

        public void setConsoleTitle(@NlsContexts.TabTitle @NotNull String title) {
            if (title == null) {
                AdaptingView.$$$reportNull$$$0(12);
            }
            this.getConsoleView().setTitle(title);
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.getConsoleView().getVirtualFile();
            if (virtualFile == null) {
                AdaptingView.$$$reportNull$$$0(13);
            }
            return virtualFile;
        }

        @NotNull
        public PlaceInGrid getResultsPlaceInView() {
            PlaceInGrid placeInGrid = PlaceInGrid.bottom;
            if (placeInGrid == null) {
                AdaptingView.$$$reportNull$$$0(14);
            }
            return placeInGrid;
        }

        @NotNull
        public DataBus.Consuming getMessageBus() {
            DataBus.Consuming consuming = ((JpaConsoleAdapter)this.getTarget()).getMessageBus();
            if (consuming == null) {
                AdaptingView.$$$reportNull$$$0(15);
            }
            return consuming;
        }

        @NotNull
        public Session<?> getSession() {
            Session session = (Session)this.getTarget();
            if (session == null) {
                AdaptingView.$$$reportNull$$$0(16);
            }
            return session;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6, 8, 10, 13, 14, 15, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptModel";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleAdapter$AdaptingView";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleAdapter$AdaptingView";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersHolder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGridDataHookUp";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataConsumer";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHistoryLogger";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultsPlaceInView";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageBus";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createGridDataHookUp";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createHistoryLogger";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addRequestToHistory";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setConsoleTitle";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6, 8, 10, 13, 14, 15, 16 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyHelper
    implements ParametersHolder.Helper {
        private final LanguageConsoleView myView;

        MyHelper(@NotNull LanguageConsoleView view) {
            if (view == null) {
                MyHelper.$$$reportNull$$$0(0);
            }
            this.myView = view;
        }

        @NotNull
        public Document getDocument() {
            Document document = this.myView.getEditorDocument();
            if (document == null) {
                MyHelper.$$$reportNull$$$0(1);
            }
            return document;
        }

        @NotNull
        public Editor getEditor() {
            EditorEx editorEx = this.myView.getCurrentEditor();
            if (editorEx == null) {
                MyHelper.$$$reportNull$$$0(2);
            }
            return editorEx;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myView.getVirtualFile();
            if (virtualFile == null) {
                MyHelper.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        public boolean shouldOpenFileOnEditParameters() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleAdapter$MyHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleAdapter$MyHelper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyController
    extends ToolWindowSessionViewController {
        MyController(@NotNull Project project, @NotNull JpaConsoleAdapter<?> adapter) {
            if (project == null) {
                MyController.$$$reportNull$$$0(0);
            }
            if (adapter == null) {
                MyController.$$$reportNull$$$0(1);
            }
            super(project, new SessionToolWindowHelper(adapter.getToolWindowId(), adapter.getToolWindowIcon()));
        }

        @NotNull
        protected ContentManager retrieveContentManager(@NotNull BaseLogView<?> view, @NotNull Content content, @NotNull ToolWindow window) {
            if (view == null) {
                MyController.$$$reportNull$$$0(2);
            }
            if (content == null) {
                MyController.$$$reportNull$$$0(3);
            }
            if (window == null) {
                MyController.$$$reportNull$$$0(4);
            }
            for (JpaConsoleAdapter session : JpaConsoleAdapter.getActiveSessions(this.myProject, this.myHelper.getToolWindowId())) {
                PsiFile consoleView = view.getConsoleView().getFile();
                if (session.getView().getConsoleView().getFile() != consoleView) continue;
                LOG.error("Console already created for " + consoleView.getName());
            }
            ContentManager contentManager = super.retrieveContentManager(view, content, window);
            if (contentManager == null) {
                MyController.$$$reportNull$$$0(5);
            }
            return contentManager;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "adapter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleAdapter$MyController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleAdapter$MyController";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "retrieveContentManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveContentManager";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

