/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DataBus;
import com.intellij.database.console.JdbcConsoleUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.ConsoleLogger;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DbGridDataHookUpUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.JpaGridDataHookUp;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.session.Session;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.facet.Facet;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.AbstractQlModel;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.engine.JpaConsole;
import com.intellij.jpa.engine.JpaConsoleAdapter;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.model.VirtualPersistenceUnit;
import com.intellij.jpa.model.implicit.VirtualPersistenceUnitModelHelper;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaConsoleBase
extends JpaConsoleAdapter<PersistencePackagePointer> {
    private final PersistencePackagePointer myUnitFile;
    private final ConsoleRunConfiguration myConfiguration;
    private SyntaxHighlighter myHighlighter;

    protected JpaConsoleBase(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration, @NotNull DataBus.Consuming messageBus, @NotNull String historyId, @NotNull Language language, @Nullable String query) {
        if (unitFile == null) {
            JpaConsoleBase.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            JpaConsoleBase.$$$reportNull$$$0(1);
        }
        if (messageBus == null) {
            JpaConsoleBase.$$$reportNull$$$0(2);
        }
        if (historyId == null) {
            JpaConsoleBase.$$$reportNull$$$0(3);
        }
        if (language == null) {
            JpaConsoleBase.$$$reportNull$$$0(4);
        }
        super(unitFile.getProject(), messageBus, unitFile, unitFile.getElementName(), language);
        this.myUnitFile = unitFile;
        this.myConfiguration = configuration;
        ConsoleHistoryController controller = new ConsoleHistoryController(historyId, unitFile.getPresentableUrl(), this.getLanguageConsole());
        this.getLanguageConsole().setInputText(StringUtil.notNullize((String)query));
        controller.install();
    }

    public abstract boolean isStarted();

    public abstract void terminate();

    @NotNull
    public ConsoleRunConfiguration getConfiguration() {
        ConsoleRunConfiguration consoleRunConfiguration = this.myConfiguration;
        if (consoleRunConfiguration == null) {
            JpaConsoleBase.$$$reportNull$$$0(5);
        }
        return consoleRunConfiguration;
    }

    @NotNull
    private ConsoleLogger getHistoryLogger() {
        ConsoleLogger consoleLogger = this.getView().getHistoryLogger();
        if (consoleLogger == null) {
            JpaConsoleBase.$$$reportNull$$$0(6);
        }
        return consoleLogger;
    }

    @Override
    @NotNull
    protected ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            JpaConsoleBase.$$$reportNull$$$0(7);
        }
        return new ConsoleLogger((ConsoleView)consoleView){

            public void print(@NotNull DataRequest.Context context, @NlsContexts.NotificationContent @Nullable String message) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context.request instanceof GenerateSql) {
                    JpaConsoleBase.this.printSql(message);
                } else {
                    super.print(context, message);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jpa/engine/JpaConsoleBase$1", "print"));
            }
        };
    }

    @Override
    @NotNull
    protected ScriptModel<?> createScriptModel(@NotNull LanguageConsoleView languageConsole) {
        if (languageConsole == null) {
            JpaConsoleBase.$$$reportNull$$$0(8);
        }
        return new QlScriptModel(languageConsole.getFile());
    }

    @Override
    protected void buildConsoleUi() {
        boolean isHibernate = this.getLanguageConsole().getFile().getLanguage() == JpqlLanguage.HQL;
        this.getLanguageConsole().getFile().putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)new MyAbstractQlModel(this.getProject(), this.myUnitFile, isHibernate));
        AnAction toggleAction = this.initParameterView();
        this.myDataConsumer.resetOutputTabCounter();
        this.getUi().getDefaults().initTabDefaults(0, null, null);
        this.getUi().getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getLanguageConsole().getComponent(), (Object)"Center");
        Content output = this.getUi().createContent("Input", (JComponent)loadingPanel, this.getTitle(), AllIcons.Debugger.Console, this.getLanguageConsole().getPreferredFocusableComponent());
        DefaultActionGroup outputActions = new DefaultActionGroup();
        JdbcConsoleUtil.addLeftToolbarConsoleActions((DefaultActionGroup)outputActions, (ConsoleView)this.getLanguageConsole());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getLanguageConsole().getComponent());
        this.getUi().getOptions().setLeftToolbar((ActionGroup)this.createActionGroup(toggleAction), "toolbar");
        output.setCloseable(false);
        this.getUi().addContent(output, 0, PlaceInGrid.center, false);
    }

    private String collectQueryTextAndParams(ScriptModel.StatementIt<?> it, Map<Object, String> params) {
        boolean isHibernate = !(this instanceof JpaConsole);
        try {
            String text = it.consoleQuery(this.myPStorage, o -> {
                String s = o.name();
                String value = String.valueOf(this.myPStorage.getValue((Object)s));
                if (s.startsWith("?")) {
                    String key;
                    String name = s.substring(1);
                    try {
                        key = name.isEmpty() ? Integer.valueOf(params.size() + (isHibernate ? 0 : 1)) : (isHibernate ? name : Integer.valueOf(Integer.parseInt(name)));
                    }
                    catch (NumberFormatException e) {
                        key = name;
                    }
                    params.put(key, value);
                    return true;
                }
                if (s.startsWith(":")) {
                    String name = s.substring(1);
                    if (StringUtil.isJavaIdentifier((String)name)) {
                        params.put(name, value);
                        return true;
                    }
                } else {
                    int num = StringUtil.parseInt((String)s, (int)0);
                    if (num > 0) {
                        params.put(isHibernate ? num - 1 : num, value);
                        return true;
                    }
                }
                return false;
            });
            return text;
        }
        catch (TranslateException e) {
            return "";
        }
    }

    @Override
    @NotNull
    public GridDataHookUp<GridRow, GridColumn> createGridDataHookUp(@NotNull Disposable parent) {
        if (parent == null) {
            JpaConsoleBase.$$$reportNull$$$0(9);
        }
        JpaGridDataHookUp jpaGridDataHookUp = DbGridDataHookUpUtil.createJpaHookUp((Project)this.getProject(), (Session)this, (Disposable)parent);
        if (jpaGridDataHookUp == null) {
            JpaConsoleBase.$$$reportNull$$$0(10);
        }
        return jpaGridDataHookUp;
    }

    public void executeQueries(@NotNull ScriptModel<?> model) {
        if (model == null) {
            JpaConsoleBase.$$$reportNull$$$0(11);
        }
        for (ScriptModel.StatementIt it : model.statements()) {
            this.executeQueryInner(it);
        }
    }

    private void executeQueryInner(ScriptModel.StatementIt<?> it) {
        HashMap<Object, String> params = new HashMap<Object, String>();
        String query = this.collectQueryTextAndParams(it, params);
        if (StringUtil.isEmpty((String)query)) {
            return;
        }
        ConsoleHistoryController.addToHistory((LanguageConsoleView)this.getLanguageConsole(), (String)query);
        List<String> columnNames = QlScriptModel.statementType(it);
        LoadRequest request = new LoadRequest((DataRequest.Owner)this, query, params, columnNames);
        this.getMessageBus().getDataProducer().processRequest((GridDataRequest)request);
    }

    public void generateSQL() {
        this.myParamPanel.commit();
        ScriptModel.StatementIt it = (ScriptModel.StatementIt)this.getScriptModel().statements().first();
        if (it == null) {
            return;
        }
        String query = this.collectQueryTextAndParams(it, new HashMap<Object, String>());
        this.getLanguageConsole().print("> " + query + "\n", ConsoleViewContentType.USER_INPUT);
        if (query.isEmpty()) {
            return;
        }
        this.getMessageBus().getDataProducer().processRequest((GridDataRequest)new GenerateSql((DataRequest.Owner)this, query, Command.QUERY));
    }

    public void generateDDL() {
        this.getMessageBus().getDataProducer().processRequest((GridDataRequest)new GenerateSql((DataRequest.Owner)this, "", Command.DDL));
    }

    public void showConsole(boolean focused) {
        this.getView().show(focused, focused);
    }

    @NotNull
    @Nls
    public String getTitle() {
        String string = this.getView().getTitle();
        if (string == null) {
            JpaConsoleBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public LanguageConsoleView getLanguageConsole() {
        LanguageConsoleView languageConsoleView = this.getView().getConsoleView();
        if (languageConsoleView == null) {
            JpaConsoleBase.$$$reportNull$$$0(13);
        }
        return languageConsoleView;
    }

    private DefaultActionGroup createActionGroup(AnAction toggleAction) {
        DefaultActionGroup group = new DefaultActionGroup();
        RunAction runAction = new RunAction();
        DumbAwareAction sqlAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                JpaConsoleBase.this.generateSQL();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(JpaConsoleBase.this.getLanguageConsole().getEditorDocument().getText().trim().length() > 0);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DumbAwareAction ddlAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                JpaConsoleBase.this.generateDDL();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabledAndVisible(!JpaUtil.isHibernateProvider(JpaConsoleBase.this.myUnitFile.getPersistenceFacet(), JpaConsoleBase.this.myUnitFile.findElement()));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DefaultActionGroup generateGroup = new DefaultActionGroup(new AnAction[]{sqlAction, ddlAction});
        generateGroup.setPopup(true);
        generateGroup.getTemplatePresentation().setIcon(AllIcons.ToolbarDecorator.Export);
        generateGroup.getTemplatePresentation().setText(JpaMessages.message("JpaConsoleBase.generate.script", new Object[0]));
        DumbAwareAction closeAction = new DumbAwareAction(AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ContentManager contentManager;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((contentManager = JpaConsoleBase.this.getView().getContent().getManager()) == null) {
                    return;
                }
                contentManager.removeContent(JpaConsoleBase.this.getView().getContent(), true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(true);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DumbAwareAction terminateAction = new DumbAwareAction(Presentation.NULL_STRING, Presentation.NULL_STRING, AllIcons.Actions.Suspend){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                JpaConsoleBase.this.terminate();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(JpaConsoleBase.this.isStarted());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DefaultActionGroup selectUnitPropertiesGroup = this.addPropertiesSelectAction();
        group.add((AnAction)runAction);
        group.add((AnAction)generateGroup);
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("QueryExecution.Settings"));
        group.add(toggleAction);
        group.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getLanguageConsole()).getBrowseHistory());
        group.add(this.getUi().getOptions().getLayoutActions());
        group.addSeparator();
        if (selectUnitPropertiesGroup != null) {
            group.add((AnAction)selectUnitPropertiesGroup);
        }
        group.addSeparator();
        group.add((AnAction)terminateAction);
        group.add((AnAction)closeAction);
        ActionUtil.mergeFrom((AnAction)runAction, (String)"Console.Jpa.Execute");
        ActionUtil.mergeFrom((AnAction)closeAction, (String)"Console.Jpa.Close");
        ActionUtil.mergeFrom((AnAction)terminateAction, (String)"Console.Jpa.Terminate");
        ActionUtil.mergeFrom((AnAction)sqlAction, (String)"Console.Jpa.GenerateSql");
        ActionUtil.mergeFrom((AnAction)ddlAction, (String)"Console.Jpa.GenerateDDL");
        for (AnAction action : group.getChildActionsOrStubs()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        return group;
    }

    private DefaultActionGroup addPropertiesSelectAction() {
        List persistenceUnits = this.myUnitFile.getPersistenceFacet().getPersistenceUnits();
        if (persistenceUnits.size() != 1) {
            return null;
        }
        PersistencePackage unit = (PersistencePackage)ContainerUtil.getFirstItem((List)persistenceUnits);
        if (!(unit instanceof VirtualPersistenceUnit)) {
            return null;
        }
        VirtualPersistenceUnitModelHelper modelHelper = ((VirtualPersistenceUnit)unit).getModelHelper();
        List actions = ContainerUtil.map(modelHelper.getPropertiesSources(), sourceName -> JpaConsoleBase.wrapToAction(sourceName, modelHelper));
        DefaultActionGroup selectUnitProperties = new DefaultActionGroup(actions);
        selectUnitProperties.setPopup(true);
        selectUnitProperties.getTemplatePresentation().setIcon(AllIcons.Actions.Preview);
        selectUnitProperties.getTemplatePresentation().setText(JpaMessages.message("action.text.select.unit.properties.source", new Object[0]));
        return selectUnitProperties;
    }

    private static ToggleAction wrapToAction(final @NlsSafe String sourceName, final VirtualPersistenceUnitModelHelper modelHelper) {
        return new ToggleAction(sourceName){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                return modelHelper.getActivePropertyProfile().equals(sourceName);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                modelHelper.setActivePropertyProfile(sourceName);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$6";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public void printSql(@NlsSafe @Nullable String sql) {
        if (this.myHighlighter == null) {
            this.getHistoryLogger().print(sql);
        } else if (!StringUtil.isEmptyOrSpaces((String)sql)) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)this.getLanguageConsole(), (String)sql.trim(), (SyntaxHighlighter)this.myHighlighter);
            this.getHistoryLogger().newLine();
        }
        this.getHistoryLogger().newLine();
    }

    public void initHighlighter(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JpaConsoleBase.$$$reportNull$$$0(14);
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect((LocalDataSource)dataSource);
        this.myHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryLogger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGridDataHookUp";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createHistoryLogger";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createScriptModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGridDataHookUp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initHighlighter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 10, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static class MyAbstractQlModel
    extends AbstractQlModel {
        private final PersistenceFacet myFacet;
        private final PersistencePackagePointer myUnitFile;
        private final boolean myHibernate;

        public MyAbstractQlModel(Project project, PersistencePackagePointer unitFile, boolean isHibernate) {
            super(project);
            this.myHibernate = isHibernate;
            this.myFacet = unitFile.getPersistenceFacet();
            this.myUnitFile = unitFile;
        }

        @Override
        protected void processPersistenceMappings(PairProcessor<PersistenceMappings, PersistenceModelBrowser> processor) {
            PersistencePackage unit;
            if (this.isRegisteredFacet() && (unit = this.myUnitFile.findElement()) != null && unit.isValid()) {
                PersistenceMappings entityMappings = this.myFacet.getEntityMappings(unit);
                PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)this.myFacet, (PersistencePackage)unit, null);
                processor.process((Object)entityMappings, (Object)browser);
            }
        }

        private boolean isRegisteredFacet() {
            return !(this.myFacet instanceof Facet) || FacetUtil.isRegistered((Facet)((Facet)this.myFacet));
        }

        @Override
        protected boolean isHibernate() {
            return this.myHibernate;
        }

        @Override
        @NotNull
        protected List<? extends PersistenceFacet> getPersistenceFacets() {
            List<PersistenceFacet> list = Collections.singletonList(this.myFacet);
            if (list == null) {
                MyAbstractQlModel.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaConsoleBase$MyAbstractQlModel", "getPersistenceFacets"));
        }
    }

    public static class LoadRequest
    extends DataRequest.QueryRequest {
        public final List<String> expectedColumns;

        public LoadRequest(DataRequest.Owner owner, String query, Map<Object, String> params, List<String> names) {
            super(owner, query, LoadRequest.newConstraints((int)0, (int)GridUtilCore.getPageSize((DataGridSettings)DatabaseSettings.getSettings()), (int)0, (int)-1, (int)-1), params);
            this.expectedColumns = names;
        }
    }

    public static class GenerateSql
    extends DataRequest {
        public final Command command;
        public final String query;

        GenerateSql(DataRequest.Owner owner, String query, Command command) {
            super(owner, NONE);
            this.command = command;
            this.query = query;
        }
    }

    public static enum Command {
        QUERY,
        DDL;

    }

    private class RunAction
    extends DumbAwareAction
    implements Toggleable {
        RunAction() {
            super(Presentation.NULL_STRING, Presentation.NULL_STRING, AllIcons.Actions.Execute);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean ranged;
            if (e == null) {
                RunAction.$$$reportNull$$$0(0);
            }
            ScriptModel scriptModel = JpaConsoleBase.this.getScriptModel();
            TextRange selectionRange = EditorUtil.getSelectionInAnyMode((Editor)JpaConsoleBase.this.getLanguageConsole().getCurrentEditor());
            boolean bl = ranged = selectionRange.getLength() > 0;
            if (ranged) {
                scriptModel = scriptModel.subModel((TextRange)new ScriptModel.StrictRange(selectionRange));
            }
            if (JpaConsoleBase.this.beforeExecuteQueries(scriptModel)) {
                JpaConsoleBase.this.executeQueries(scriptModel);
                if (!ranged) {
                    JpaConsoleBase.this.getLanguageConsole().setInputText("");
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RunAction.$$$reportNull$$$0(1);
            }
            boolean enabled = !StringUtil.isEmptyOrSpaces((String)JpaConsoleBase.this.getLanguageConsole().getEditorDocument().getText());
            e.getPresentation().setEnabled(enabled);
            Toggleable.setSelected((Presentation)e.getPresentation(), (!JpaConsoleBase.this.isIdle() ? 1 : 0) != 0);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RunAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase$RunAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$RunAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class Builder<T> {
        protected final PersistencePackagePointer myUnitFile;
        protected ConsoleRunConfiguration myConfiguration;
        protected String myQuery;

        protected Builder(@NotNull PersistencePackagePointer unitFile) {
            if (unitFile == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myUnitFile = unitFile;
        }

        public Builder<T> withQuery(@Nullable CharSequence query) {
            this.myQuery = query == null ? null : query.toString();
            return this;
        }

        public Builder<T> withRunConfiguration(@Nullable ConsoleRunConfiguration configuration) {
            this.myConfiguration = configuration;
            return this;
        }

        @NotNull
        protected Project getProject() {
            Project project = this.myUnitFile.getProject();
            if (project == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return project;
        }

        public abstract T build();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unitFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

