/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.jpa.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.facet.JpaFacetImpl;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.jpa.facet.JpaFacetUtil;
import com.intellij.jpa.facet.JpaImplicitFacetModificationTracker;
import com.intellij.jpa.facet.JpaModuleConfiguration;
import com.intellij.jpa.model.annotations.mapping.EntityMappingsImpl;
import com.intellij.jpa.model.xml.persistence.Persistence;
import com.intellij.jpa.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.model.xml.persistence.mapping.EntityMappings;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JpaImplicitFacetImpl
extends UserDataHolderBase
implements JpaModuleConfiguration {
    @NotNull
    private final Module myModule;
    @Nullable
    private final ConfigFile myPersistenceConfig;
    @Nullable
    private final String myProviderName;
    private EntityMappingsImpl myAnnotationsPersistenceRoot;

    JpaImplicitFacetImpl(@NotNull Module module, @Nullable ConfigFileInfo persistenceXmlConfig, @Nullable String name) {
        if (module == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myPersistenceConfig = persistenceXmlConfig != null ? new SimpleConfigFile(module.getProject(), persistenceXmlConfig) : null;
        this.myProviderName = name;
    }

    public Icon getIcon() {
        return JpaFacetType.getInstance().getIcon();
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(1);
        }
        return module;
    }

    public ModificationTracker getModificationTracker() {
        return JpaImplicitFacetModificationTracker.getInstance(this.myModule.getProject());
    }

    public List<ConfigFile> getDescriptors() {
        if (this.myPersistenceConfig != null) {
            return List.of(this.myPersistenceConfig);
        }
        return Collections.emptyList();
    }

    @NotNull
    public List<PersistencePackage> getPersistenceUnits() {
        List<PersistencePackage> list = JpaFacetUtil.getPersistenceUnits(this);
        if (list == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public List<XmlFile> getPersistenceXmls() {
        SmartList persistenceXmls = new SmartList();
        ContainerUtil.addIfNotNull((Collection)persistenceXmls, (Object)this.getPersistenceXmlInModule());
        ContainerUtil.addAllNotNull((Collection)persistenceXmls, JpaFacetUtil.getPersistenceXmlsInLibraries(this.getModule()));
        SmartList smartList = persistenceXmls;
        if (smartList == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @Nullable
    public XmlFile getPersistenceXmlInModule() {
        XmlFile xmlFile;
        ConfigFile persistenceDescriptor = this.getMainDeploymentDescriptor();
        if (persistenceDescriptor != null && (xmlFile = persistenceDescriptor.getXmlFile()) != null) {
            return xmlFile;
        }
        return null;
    }

    @Nullable
    private ConfigFile getMainDeploymentDescriptor() {
        return this.myPersistenceConfig;
    }

    @Override
    @Nullable
    public Persistence getMergedPersistenceRoot() {
        return JpaFacetUtil.getMergedPersistenceRoot(this);
    }

    public List<PersistencePackage> getExplicitPersistenceUnits() {
        ArrayList<PersistencePackage> packages = new ArrayList<PersistencePackage>();
        Persistence persistenceRoot = this.getMergedPersistenceRoot();
        if (persistenceRoot != null) {
            packages.addAll(persistenceRoot.getPersistenceUnits());
        }
        return packages;
    }

    @Nullable
    public com.intellij.jpa.model.common.persistence.mapping.EntityMappings getAnnotationEntityMappings() {
        this.refreshModel();
        return this.myAnnotationsPersistenceRoot;
    }

    @NotNull
    public PersistenceMappings getEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(4);
        }
        this.refreshModel();
        PersistenceMappings persistenceMappings = JpaFacetUtil.getEntityMappings(this, unit);
        if (persistenceMappings == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(5);
        }
        return persistenceMappings;
    }

    @Override
    @Nullable
    public com.intellij.jpa.model.common.persistence.mapping.EntityMappings getAnnotationEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(6);
        }
        return this.myAnnotationsPersistenceRoot != null ? this.myAnnotationsPersistenceRoot.createCustomMappings((Condition<PsiClass>)((Condition)JpaFacetImpl.getAnnoMappingsCondition(this, unit).getValue())) : null;
    }

    @Override
    public ConfigFile getDefaultORMDescriptor() {
        return null;
    }

    @NotNull
    public List<? extends PersistenceMappings> getDefaultEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(7);
        }
        List<EntityMappings> list = JpaFacetUtil.getDefaultEntityMappings(this, unit);
        if (list == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public Class<? extends PersistencePackage> getPersistenceUnitClass() {
        return PersistenceUnit.class;
    }

    @NotNull
    public Map<ConfigFileMetaData, Class<? extends PersistenceMappings>> getSupportedDomMappingFormats() {
        Map<ConfigFileMetaData, Class<? extends PersistenceMappings>> map = Collections.singletonMap(JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA, EntityMappings.class);
        if (map == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(9);
        }
        return map;
    }

    public String getDataSourceId(@NotNull PersistencePackagePointer unit) {
        if (unit == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(10);
        }
        return null;
    }

    public String getDataSourceId(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(11);
        }
        return null;
    }

    public Language getQlLanguage() {
        for (PersistencePackage unit : this.getPersistenceUnits()) {
            if (JpaUtil.isHibernateProvider(this, unit)) {
                return JpqlLanguage.HQL;
            }
            if (!JpaUtil.isEclipseLinkProvider(this, unit)) continue;
            return JpqlLanguage.EQL;
        }
        return JpqlLanguage.JPQL;
    }

    @NotNull
    public ModelValidator getModelValidator(@Nullable PersistencePackage unit) {
        ModelValidator modelValidator = JpaFacetUtil.getModelValidator(this, unit);
        if (modelValidator == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(12);
        }
        return modelValidator;
    }

    public Class<?> @NotNull [] getInspectionToolClasses() {
        Class<? extends LocalInspectionTool>[] classArray = JpaFacetUtil.getInspectionClasses();
        if (classArray == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(13);
        }
        return classArray;
    }

    @NotNull
    public PersistencePackageDefaults getPersistenceUnitDefaults(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(14);
        }
        PersistencePackageDefaults persistencePackageDefaults = JpaFacetUtil.getPersistencePackageDefaults(this, unit);
        if (persistencePackageDefaults == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(15);
        }
        return persistencePackageDefaults;
    }

    public String getNamingStrategy(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaImplicitFacetImpl.$$$reportNull$$$0(16);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpaImplicitFacetImpl facet = (JpaImplicitFacetImpl)o;
        return this.myModule.equals(facet.myModule) && Objects.equals(this.myPersistenceConfig, facet.myPersistenceConfig) && Objects.equals(this.myProviderName, facet.myProviderName);
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myPersistenceConfig, this.myProviderName);
    }

    @Override
    public String getDefaultJPAProviderName() {
        return this.myProviderName;
    }

    private void refreshModel() {
        List<PersistencePackage> allPersistenceUnits = this.getPersistenceUnits();
        if (!allPersistenceUnits.isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myAnnotationsPersistenceRoot == null) {
                this.myAnnotationsPersistenceRoot = new EntityMappingsImpl(this.getModule());
            }
        } else if (this.myAnnotationsPersistenceRoot != null) {
            this.myAnnotationsPersistenceRoot = null;
        }
    }

    public String toString() {
        return "JpaImplicitFacetImpl (" + this.getModule().getName() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 8, 9, 12, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/facet/JpaImplicitFacetImpl";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/facet/JpaImplicitFacetImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnits";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceXmls";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityMappings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultEntityMappings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDomMappingFormats";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelValidator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnitDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEntityMappings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationEntityMappings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEntityMappings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceUnitDefaults";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNamingStrategy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 8, 9, 12, 13, 15 -> new IllegalStateException(string);
        };
    }

    private static class SimpleConfigFile
    implements ConfigFile {
        private final Project myProject;
        private final ConfigFileInfo myInfo;
        private volatile Reference<PsiFile> myPsiFile;

        private SimpleConfigFile(@NotNull Project project, @NotNull ConfigFileInfo info) {
            if (project == null) {
                SimpleConfigFile.$$$reportNull$$$0(0);
            }
            if (info == null) {
                SimpleConfigFile.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myInfo = info;
        }

        public String getUrl() {
            return this.myInfo.getUrl();
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return VirtualFileManager.getInstance().findFileByUrl(this.getUrl());
        }

        @Nullable
        public PsiFile getPsiFile() {
            PsiFile psiFile = (PsiFile)SoftReference.dereference(this.myPsiFile);
            if (psiFile != null && psiFile.isValid()) {
                return psiFile;
            }
            VirtualFile virtualFile = this.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            this.myPsiFile = new java.lang.ref.SoftReference<PsiFile>(psiFile);
            return psiFile;
        }

        @Nullable
        public XmlFile getXmlFile() {
            PsiFile file = this.getPsiFile();
            return file instanceof XmlFile ? (XmlFile)file : null;
        }

        @NotNull
        public ConfigFileMetaData getMetaData() {
            ConfigFileMetaData configFileMetaData = this.myInfo.getMetaData();
            if (configFileMetaData == null) {
                SimpleConfigFile.$$$reportNull$$$0(2);
            }
            return configFileMetaData;
        }

        @NotNull
        public ConfigFileInfo getInfo() {
            ConfigFileInfo configFileInfo = this.myInfo;
            if (configFileInfo == null) {
                SimpleConfigFile.$$$reportNull$$$0(3);
            }
            return configFileInfo;
        }

        public boolean isValid() {
            return true;
        }

        public void dispose() {
        }

        public long getModificationCount() {
            return 0L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleConfigFile file = (SimpleConfigFile)o;
            return this.myProject.equals(file.myProject) && this.myInfo.equals((Object)file.myInfo);
        }

        public int hashCode() {
            return Objects.hash(this.myProject, this.myInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/facet/JpaImplicitFacetImpl$SimpleConfigFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/facet/JpaImplicitFacetImpl$SimpleConfigFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

