/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.frameworks.data.util.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.utils.persistence.data.parser.Part;
import com.intellij.javaee.utils.persistence.data.parser.PartTree;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserContext;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserUtil;
import com.intellij.javaee.utils.persistence.data.parser.PartType;
import com.intellij.javaee.utils.persistence.data.parser.domain.PropertyPath;
import com.intellij.javaee.utils.persistence.data.parser.domain.Sort;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnchorOwner;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public abstract class PartTreeCompletionContributor
extends CompletionContributor {
    public static final Key<Boolean> PART_TREE_COMPLETION_KEY = Key.create((String)"partTree.completion.key");

    public PartTreeCompletionContributor() {
        PsiJavaElementPattern.Capture javaFieldCapture = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).andOr(new ElementPattern[]{PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent(PsiField.class), PsiJavaPatterns.psiElement(PsiIdentifier.class).withSuperParent(3, PsiClass.class)})).with((PatternCondition)new PatternCondition<PsiElement>("PartTreeCompletionContributor"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiClass psiClass;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class)) != null && PartTreeCompletionContributor.this.isDataRepository(psiClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$1", "accepts"));
            }
        });
        PsiElementPattern.Capture<PsiElement> uastMethodCapture = new PsiElementPattern.Capture<PsiElement>(PsiElement.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                UTypeReferenceExpression returnTypeReference;
                if (!(o instanceof PsiElement)) {
                    return false;
                }
                PsiElement element = (PsiElement)o;
                if (!PartTreeCompletionContributor.this.hasDataSupported(element)) {
                    return false;
                }
                UIdentifier uIdentifier = (UIdentifier)UastContextKt.toUElement((PsiElement)element, UIdentifier.class);
                if (uIdentifier == null) {
                    return false;
                }
                UElement intermediateParent = UastUtils.skipParentOfType((UElement)uIdentifier, (boolean)true, (Class[])new Class[]{UReferenceExpression.class, UTypeReferenceExpression.class});
                if (intermediateParent == null && element.getParent() instanceof PsiErrorElement) {
                    UElement uParent = UastContextKt.toUElement((PsiElement)element.getParent().getParent(), UElement.class);
                    if (uParent == null) {
                        return false;
                    }
                    intermediateParent = UastUtils.skipParentOfType((UElement)uParent, (boolean)true, (Class[])new Class[]{UReferenceExpression.class, UTypeReferenceExpression.class});
                }
                if (intermediateParent == null) {
                    return false;
                }
                if (intermediateParent instanceof UMethod && (returnTypeReference = ((UMethod)intermediateParent).getReturnTypeReference()) != null && UastUtils.isPsiAncestor((UElement)returnTypeReference, (UElement)uIdentifier)) {
                    return false;
                }
                if (!(intermediateParent instanceof UClass) && !(intermediateParent instanceof UMethod)) {
                    return false;
                }
                PsiFile file = element.getContainingFile();
                if (file != null && file.getLanguage().is((Language)JavaLanguage.INSTANCE)) {
                    return false;
                }
                UClass uClass = (UClass)UastUtils.getParentOfType((UElement)intermediateParent, UClass.class, (boolean)false);
                return uClass != null && PartTreeCompletionContributor.this.isDataRepository(uClass.getJavaPsi());
            }
        };
        ElementPattern psiIdentifierCapture = StandardPatterns.or((ElementPattern[])new ElementPattern[]{javaFieldCapture, uastMethodCapture});
        this.extend(CompletionType.BASIC, psiIdentifierCapture, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                PartTreeCompletionContributor.this.addCompletions(parameters, result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Pair<PsiClass, ? extends PsiType> repositoryTypes;
        if (parameters == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((repositoryTypes = this.getRepositoryTypes(parameters)) != null) {
            result.addAllElements(this.getCompletionVariants(repositoryTypes, this.getPsiMemberName(parameters), result.getPrefixMatcher()));
            result.addAllElements(this.getAdditionalCompletionVariants(repositoryTypes));
            result.stopHere();
        }
    }

    @NotNull
    protected Set<? extends LookupElement> getAdditionalCompletionVariants(@NotNull Pair<PsiClass, ? extends PsiType> types) {
        if (types == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(2);
        }
        Set set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(3);
        }
        return set;
    }

    protected abstract boolean hasDataSupported(@NotNull PsiElement var1);

    protected abstract boolean isDataRepository(@NotNull PsiClass var1);

    protected abstract Set<String> getDomainClassProperties(PsiClass var1);

    protected abstract Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(PsiClass var1);

    protected abstract Icon getLookupElementIcon();

    protected abstract PartTreeParserContext getPartTreeParserContext();

    @NotNull
    protected Set<LookupElement> getCompletionVariants(@NotNull Pair<PsiClass, ? extends PsiType> typesPair, @Nullable String methodName, @NotNull PrefixMatcher matcher) {
        if (typesPair == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(5);
        }
        if (methodName == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(6);
            }
            return set;
        }
        String prefix = matcher.getPrefix();
        PsiClass domainClass = (PsiClass)typesPair.getFirst();
        if (domainClass == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(7);
            }
            return set;
        }
        PartTree partTree = new PartTree(methodName, domainClass, this.getPartTreeParserContext());
        int offset = prefix.length();
        Position[] ranges = PartTreeCompletionContributor.getPartTreeTextRanges(partTree).toArray(new Position[1]);
        if (ranges.length == 1 && ranges[0] instanceof PartPosition) {
            return this.getSubjectVariants(domainClass, "");
        }
        for (int i = 0; i < ranges.length; ++i) {
            Position nextPosition;
            Position currentPosition = ranges[i];
            Position position = nextPosition = i + 1 < ranges.length ? ranges[i + 1] : null;
            if (currentPosition.getRange().contains(offset)) {
                return this.getPositionVariants(methodName, domainClass, currentPosition);
            }
            if (currentPosition.getRange().getEndOffset() == offset) {
                return this.getPositionEndOffsetVariants(methodName, domainClass, currentPosition, nextPosition, offset);
            }
            if (PartTreeCompletionContributor.isOffsetBetweenKnownPositions(offset, currentPosition, nextPosition)) {
                if (!(nextPosition instanceof PartPosition)) continue;
                return this.getBetweenPartCompletionVariantsElements(domainClass, PartTreeCompletionContributor.getPrefix(methodName, currentPosition.getRange().getEndOffset()), PartTreeCompletionContributor.getSuffix(methodName, nextPosition.getRange()));
            }
            if (nextPosition != null || !PartTreeCompletionContributor.isIncompleteOrderByKeyword(partTree)) continue;
            Set<LookupElement> set = this.getEmptyOrderByVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, methodName.indexOf("OrderBy")), "");
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(8);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static boolean isIncompleteOrderByKeyword(PartTree partTree) {
        return partTree.getOrderBySource() != null && partTree.getOrderBySource().getOrders().isEmpty();
    }

    private static boolean isOffsetBetweenKnownPositions(int offset, @NotNull Position currentPosition, @Nullable Position nextPosition) {
        if (currentPosition == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(10);
        }
        return nextPosition != null && currentPosition.getRange().getEndOffset() < offset && nextPosition.getRange().getStartOffset() > offset;
    }

    @NotNull
    private Set<LookupElement> getPositionEndOffsetVariants(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull Position currentPosition, @Nullable Position nextPosition, int offset) {
        if (methodName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(11);
        }
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(12);
        }
        if (currentPosition == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(13);
        }
        TextRange textRange = currentPosition.getRange();
        if (currentPosition instanceof SubjectPosition) {
            if (nextPosition == null) {
                Set<LookupElement> set = this.getPropertyWithKeywordVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), "");
                if (set == null) {
                    PartTreeCompletionContributor.$$$reportNull$$$0(14);
                }
                return set;
            }
            return this.getPositionVariants(methodName, domainClass, nextPosition);
        }
        if (currentPosition instanceof PartPosition) {
            PartPosition partPosition = (PartPosition)currentPosition;
            HashSet<LookupElement> variants = new HashSet<LookupElement>();
            Set<String> propertiesWithKeywords = this.getLastPartPositionVariantsStrings(methodName, domainClass, partPosition, offset);
            variants.addAll(this.getCompletionVariants(domainClass, propertiesWithKeywords, PartTreeCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), PartTreeCompletionContributor.getSuffix(methodName, textRange), true));
            PropertyPath property = partPosition.getPart().getProperty();
            if (property.getSegment().isEmpty() || partPosition.getPart().isValid()) {
                variants.addAll(this.getOperationVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), PartTreeCompletionContributor.getSuffix(methodName, textRange)));
            }
            if (nextPosition == null && partPosition.getPart().isValid()) {
                variants.addAll(this.getEmptyOrderByVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), PartTreeCompletionContributor.getSuffix(methodName, textRange)));
            }
            variants.addAll(this.getPropertyChainVariants(domainClass, partPosition, PartTreeCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), PartTreeCompletionContributor.getSuffix(methodName, textRange)));
            HashSet<LookupElement> hashSet = variants;
            if (hashSet == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(15);
            }
            return hashSet;
        }
        if (currentPosition instanceof SortPosition && nextPosition == null) {
            HashSet<LookupElement> variants = new HashSet<LookupElement>();
            Sort.Order order = ((SortPosition)currentPosition).getOrder();
            if (PartTreeCompletionContributor.isSortPropertyResolved(order)) {
                variants.addAll(this.getSortVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), ""));
            }
            variants.addAll(this.getSortVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), ""));
            HashSet<LookupElement> hashSet = variants;
            if (hashSet == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(16);
            }
            return hashSet;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    private Set<String> getLastPartPositionVariantsStrings(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull PartPosition currentPosition, int offset) {
        if (methodName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(18);
        }
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(19);
        }
        if (currentPosition == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(20);
        }
        Set<String> propertiesWithKeywords = this.getAllPropertiesWithKeywords(this.getDomainClassProperties(domainClass));
        propertiesWithKeywords.remove(currentPosition.getPart().getSource());
        if (methodName.length() == offset) {
            if (methodName.endsWith("And")) {
                propertiesWithKeywords.remove("And");
            }
            if (methodName.endsWith("Or")) {
                propertiesWithKeywords.remove("Or");
            }
        }
        Set<String> set = propertiesWithKeywords;
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(21);
        }
        return set;
    }

    private static boolean isSortPropertyResolved(Sort.Order order) {
        return order.getPropertyPath().getLeafProperty().getType() != null;
    }

    @NotNull
    private Set<LookupElement> getBetweenPartCompletionVariantsElements(@NotNull PsiClass domainClass, String prefix, String suffix) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(22);
        }
        Set<LookupElement> set = this.getCompletionVariants(domainClass, PartTreeCompletionContributor.mergeTails(PartTreeCompletionContributor.getOperations(), this.getAllPropertiesWithKeywords(this.getDomainClassProperties(domainClass))), prefix, suffix, true);
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(23);
        }
        return set;
    }

    private Set<LookupElement> getEmptyOrderByVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return this.getCompletionVariants(domainClass, PartTreeCompletionContributor.mergeTails(Collections.singleton("OrderBy"), this.getCapitalizedProperties(domainClass)), prefixExpression, suffixExpression, true);
    }

    @NotNull
    protected Set<LookupElement> getCompletionVariants(@NotNull PsiClass domainClass, @NotNull Set<String> strings, @NotNull String prefixExpression, @Nullable String suffixExpression, @NotNull Boolean isPropertyRelated) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(24);
        }
        if (strings == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(25);
        }
        if (prefixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(26);
        }
        if (isPropertyRelated == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(27);
        }
        @NotNull HashSet<LookupElement> set = new HashSet<LookupElement>();
        for (String s : strings) {
            if (StringUtil.isEmptyOrSpaces((String)s)) continue;
            set.add((LookupElement)this.createLookupElement(prefixExpression, s, suffixExpression != null ? suffixExpression : ""));
        }
        HashSet<LookupElement> hashSet = set;
        if (hashSet == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    private Set<LookupElement> getSortVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return this.getCompletionVariants(domainClass, PartTreeCompletionContributor.mergeTails(this.getCapitalizedProperties(domainClass), "Asc", "Desc"), prefixExpression, suffixExpression, true);
    }

    @NotNull
    private Set<LookupElement> getPositionVariants(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull Position position) {
        if (methodName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(29);
        }
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(30);
        }
        if (position == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(31);
        }
        TextRange textRange = position.getRange();
        String prefixExpression = PartTreeCompletionContributor.getPrefix(methodName, textRange.getStartOffset());
        String suffixExpression = PartTreeCompletionContributor.getSuffix(methodName, textRange);
        if (position instanceof SubjectPosition) {
            return this.getSubjectVariants(domainClass, suffixExpression);
        }
        if (position instanceof PartPosition) {
            HashSet<LookupElement> variants = new HashSet<LookupElement>();
            variants.addAll(this.getPropertyChainVariants(domainClass, (PartPosition)position, prefixExpression, suffixExpression));
            variants.addAll(this.getPropertyWithKeywordVariants(domainClass, prefixExpression, suffixExpression));
            HashSet<LookupElement> hashSet = variants;
            if (hashSet == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(32);
            }
            return hashSet;
        }
        if (position instanceof SortPosition) {
            Set<LookupElement> set = this.getSortVariants(domainClass, prefixExpression, suffixExpression);
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(33);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(34);
        }
        return set;
    }

    @NotNull
    private Set<LookupElement> getPropertyChainVariants(@NotNull PsiClass domainClass, @NotNull PartPosition position, @NotNull String prefixExpression, @NotNull String suffixExpression) {
        PsiClass psiClass;
        Part part;
        PropertyPath leafProperty;
        PsiType propertyType;
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(35);
        }
        if (position == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(36);
        }
        if (prefixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(37);
        }
        if (suffixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(38);
        }
        if ((propertyType = (leafProperty = (part = position.getPart()).getProperty().getLeafProperty()).getType()) instanceof PsiClassType && (psiClass = ((PsiClassType)propertyType).resolve()) != null) {
            HashSet<String> propertyChains = new HashSet<String>();
            Set<String> capitalizedProperties = this.getCapitalizedProperties(psiClass);
            String segment = StringUtil.capitalize((String)leafProperty.getSegment());
            String propertyPrefix = StringUtil.substringBefore((String)position.getPart().getSource(), (String)segment);
            String propertySuffix = StringUtil.substringAfter((String)position.getPart().getSource(), (String)segment);
            if (propertyPrefix == null || propertySuffix == null) {
                Set<LookupElement> set = Collections.emptySet();
                if (set == null) {
                    PartTreeCompletionContributor.$$$reportNull$$$0(39);
                }
                return set;
            }
            if (propertySuffix.startsWith("_")) {
                propertySuffix = StringUtil.substringAfter((String)propertySuffix, (String)"_");
            }
            for (String s : capitalizedProperties) {
                propertyChains.add(segment + s);
                propertyChains.add(segment + "_" + s);
            }
            Set<LookupElement> set = this.getCompletionVariants(domainClass, propertyChains, prefixExpression + propertyPrefix, propertySuffix + suffixExpression, true);
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(40);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(41);
        }
        return set;
    }

    private Set<LookupElement> getPropertyWithKeywordVariants(@NotNull PsiClass domainClass, String prefixExpression, String suffixExpression) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(42);
        }
        return this.getCompletionVariants(domainClass, this.getAllPropertiesWithKeywords(this.getDomainClassProperties(domainClass)), prefixExpression, suffixExpression, true);
    }

    private Set<LookupElement> getOperationVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        boolean endsWitOperations = ContainerUtil.exists(PartTreeCompletionContributor.getOperations(), o -> prefixExpression.endsWith((String)o));
        if (endsWitOperations) {
            return Collections.emptySet();
        }
        return this.getCompletionVariants(domainClass, PartTreeCompletionContributor.mergeTails(PartTreeCompletionContributor.getOperations(), this.getCapitalizedProperties(domainClass)), prefixExpression, suffixExpression, true);
    }

    private static String getSuffix(@NotNull String methodName, TextRange textRange) {
        if (methodName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(43);
        }
        return methodName.substring(textRange.getEndOffset());
    }

    @NotNull
    private Set<LookupElement> getSubjectVariants(@NotNull PsiClass domainClass, @NotNull String suffixExpression) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(44);
        }
        if (suffixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(45);
        }
        Set<LookupElement> set = this.getCompletionVariants(domainClass, this.getSubjectVariants(domainClass), "", suffixExpression, false);
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(46);
        }
        return set;
    }

    @Nullable
    protected Pair<PsiClass, ? extends PsiType> getRepositoryTypes(@NotNull CompletionParameters parameters) {
        UClass aClass;
        if (parameters == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(47);
        }
        if ((aClass = (UClass)UastUtils.findContaining((PsiElement)parameters.getPosition(), UClass.class)) == null) {
            return null;
        }
        return this.substituteRepositoryTypes(aClass.getJavaPsi());
    }

    @Nullable
    protected String getPsiMemberName(@NotNull CompletionParameters parameters) {
        UDeclaration declaration;
        if (parameters == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(48);
        }
        if ((declaration = (UDeclaration)UastUtils.findContaining((PsiElement)parameters.getPosition(), UDeclaration.class)) != null && "org.jetbrains.uast.kotlin.KotlinReceiverUParameter".equals(declaration.getClass().getCanonicalName())) {
            declaration = (UDeclaration)ObjectUtils.tryCast((Object)declaration.getUastParent(), UDeclaration.class);
        }
        if (declaration == null) {
            return null;
        }
        PsiElement sourceElement = declaration.getSourcePsi();
        if (sourceElement == null) {
            return null;
        }
        UIdentifier uIdentifier = (UIdentifier)UastContextKt.toUElement((PsiElement)parameters.getOriginalPosition(), UIdentifier.class);
        if (uIdentifier != null) {
            return uIdentifier.getName();
        }
        PsiElement originalElement = PsiUtilCore.getOriginalElement((PsiElement)sourceElement, PsiElement.class);
        if (originalElement == null) {
            return null;
        }
        UDeclaration originalUDeclaration = (UDeclaration)UastUtils.findContaining((PsiElement)originalElement, UDeclaration.class);
        if (!(originalUDeclaration instanceof UAnchorOwner)) {
            return null;
        }
        UIdentifier identifier = ((UAnchorOwner)originalUDeclaration).getUastAnchor();
        if (identifier == null) {
            return null;
        }
        return identifier.getName();
    }

    @NotNull
    protected Set<String> getAllPropertiesWithKeywords(@NotNull Set<String> properties) {
        if (properties == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(49);
        }
        HashSet<String> all = new HashSet<String>();
        for (String property : properties) {
            PartTreeCompletionContributor.addTails(all, StringUtil.capitalize((String)property), this.getAllKeywordsWithIgnoreCase());
        }
        HashSet<String> hashSet = all;
        if (hashSet == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(50);
        }
        return hashSet;
    }

    @NotNull
    protected List<String> getAllKeywordsWithIgnoreCase() {
        ArrayList<String> allKeywords = new ArrayList<String>();
        PartTreeParserContext context = this.getPartTreeParserContext();
        for (PartType type : context.types().getPartTypes()) {
            boolean ignoreCase = type.isUseIgnoreCase();
            for (String keyword : type.getKeywords()) {
                allKeywords.add(keyword);
                if (!ignoreCase) continue;
                allKeywords.add(keyword + context.ignoreCase());
            }
        }
        allKeywords.add(context.ignoreCase());
        ArrayList<String> arrayList = allKeywords;
        if (arrayList == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    protected LookupElementBuilder createLookupElement(@NotNull String prefixExpression, @NotNull String property, @NotNull String suffixExpression) {
        if (prefixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(52);
        }
        if (property == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(53);
        }
        if (suffixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(54);
        }
        String lookupText = prefixExpression + property + suffixExpression;
        return LookupElementBuilder.create((Object)property, (String)lookupText).withPresentableText(property).bold().withTailText(StringUtil.isEmptyOrSpaces((String)suffixExpression) ? "" : suffixExpression, true).withIcon(this.getLookupElementIcon()).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    4.$$$reportNull$$$0(1);
                }
                context.getEditor().putUserData(PART_TREE_COMPLETION_KEY, (Object)true);
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$4";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected Set<String> getSubjectVariants(@NotNull PsiClass domainClassName) {
        if (domainClassName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(55);
        }
        HashSet<String> strings = new HashSet<String>();
        this.getPartTreeParserContext().queryPattern();
        String[] selectQuery = this.getSelectQueryPredicates();
        String[] query = this.getQueryPredicates();
        for (String s2 : selectQuery) {
            this.addSubjectSimpleTails(strings, s2, domainClassName);
            this.addSimpleTails(strings, s2);
        }
        for (String s2 : query) {
            this.addSubjectSimpleTails(strings, s2, domainClassName);
        }
        return strings.stream().map(s -> s + "By").collect(Collectors.toSet());
    }

    protected abstract String[] getSelectQueryPredicates();

    protected abstract String[] getQueryPredicates();

    protected abstract void addSubjectSimpleTails(Set<String> var1, String var2, @NotNull PsiClass var3);

    protected void addSimpleTails(Set<String> strings, String s) {
    }

    protected static void addTails(@NotNull Collection<String> strings, @NotNull String base, String ... tails) {
        if (strings == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(56);
        }
        if (base == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(57);
        }
        strings.add(base);
        for (String tail : tails) {
            strings.add(base + tail);
        }
    }

    private static void addTails(@NotNull Collection<String> strings, @NotNull String base, Collection<String> tails) {
        if (strings == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(58);
        }
        if (base == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(59);
        }
        strings.add(base);
        for (String tail : tails) {
            strings.add(base + tail);
        }
    }

    private Set<String> getCapitalizedProperties(@NotNull PsiClass domainClass) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(60);
        }
        return this.getDomainClassProperties(domainClass).stream().map(s -> StringUtil.capitalize((String)s)).collect(Collectors.toSet());
    }

    protected static List<String> getOperations() {
        return Arrays.asList("And", "Or");
    }

    @NotNull
    public static List<Position> getPartTreeTextRanges(@NotNull PartTree partTree) {
        if (partTree == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(61);
        }
        LinkedList<Position> textRanges = new LinkedList<Position>();
        Pair<PartTree.Subject, TextRange> subject = PartTreeCompletionContributor.getSubject(partTree);
        if (subject != null) {
            textRanges.add(new SubjectPosition((TextRange)subject.getSecond()));
        }
        for (Map.Entry entry : PartTreeParserUtil.getPartTextRanges((PartTree)partTree).entrySet()) {
            textRanges.add(new PartPosition((TextRange)entry.getValue(), (Part)entry.getKey()));
        }
        for (Map.Entry entry : PartTreeParserUtil.getSortTextRanges((PartTree)partTree).entrySet()) {
            textRanges.add(new SortPosition((TextRange)entry.getValue(), (Sort.Order)entry.getKey()));
        }
        List<Position> list = textRanges.stream().sorted((o1, o2) -> Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(o1.getRange(), o2.getRange())).collect(Collectors.toList());
        if (list == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(62);
        }
        return list;
    }

    @Nullable
    private static Pair<PartTree.Subject, TextRange> getSubject(PartTree partTree) {
        PartTree.Subject subject = partTree.getSubject();
        if (subject == null || StringUtil.isEmptyOrSpaces((String)subject.getExpression())) {
            return null;
        }
        return Pair.create((Object)subject, (Object)TextRange.create((int)0, (int)subject.getExpression().length()));
    }

    private static String getPrefix(String methodName, int offset) {
        return methodName.substring(0, offset);
    }

    @NotNull
    private static Set<String> mergeTails(Collection<String> base, Collection<String> tails) {
        return PartTreeCompletionContributor.mergeTails(base, ArrayUtilRt.toStringArray(tails));
    }

    @NotNull
    private static Set<String> mergeTails(Collection<String> base, String ... tails) {
        HashSet<String> strings = new HashSet<String>();
        for (String property : base) {
            PartTreeCompletionContributor.addTails(strings, property, tails);
        }
        HashSet<String> hashSet = strings;
        if (hashSet == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(63);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 8, 9, 14, 15, 16, 17, 21, 23, 28, 32, 33, 34, 39, 40, 41, 46, 50, 51, 62, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesPair";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPosition";
                break;
            }
            case 11: 
            case 18: 
            case 29: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 12: 
            case 19: 
            case 22: 
            case 24: 
            case 30: 
            case 35: 
            case 42: 
            case 44: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 25: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 26: 
            case 37: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isPropertyRelated";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 38: 
            case 45: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixExpression";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClassName";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalCompletionVariants";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionEndOffsetVariants";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastPartPositionVariantsStrings";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBetweenPartCompletionVariantsElements";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionVariants";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyChainVariants";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubjectVariants";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertiesWithKeywords";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeywordsWithIgnoreCase";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartTreeTextRanges";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeTails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalCompletionVariants";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 62: 
            case 63: {
                break;
            }
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetBetweenKnownPositions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPositionEndOffsetVariants";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLastPartPositionVariantsStrings";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getBetweenPartCompletionVariantsElements";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPositionVariants";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyChainVariants";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyWithKeywordVariants";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSuffix";
                break;
            }
            case 44: 
            case 45: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getSubjectVariants";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryTypes";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPsiMemberName";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertiesWithKeywords";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addTails";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getCapitalizedProperties";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getPartTreeTextRanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7, 8, 9, 14, 15, 16, 17, 21, 23, 28, 32, 33, 34, 39, 40, 41, 46, 50, 51, 62, 63 -> new IllegalStateException(string);
        };
    }

    private static class Position {
        private final TextRange myRange;

        private Position(@NotNull TextRange range) {
            if (range == null) {
                Position.$$$reportNull$$$0(0);
            }
            this.myRange = range;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$Position", "<init>"));
        }
    }

    private static final class PartPosition
    extends Position {
        private final Part myPart;

        private PartPosition(@NotNull TextRange range, @NotNull Part part) {
            if (range == null) {
                PartPosition.$$$reportNull$$$0(0);
            }
            if (part == null) {
                PartPosition.$$$reportNull$$$0(1);
            }
            super(range);
            this.myPart = part;
        }

        public Part getPart() {
            return this.myPart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "part";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$PartPosition";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SubjectPosition
    extends Position {
        private SubjectPosition(@NotNull TextRange range) {
            if (range == null) {
                SubjectPosition.$$$reportNull$$$0(0);
            }
            super(range);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$SubjectPosition", "<init>"));
        }
    }

    private static final class SortPosition
    extends Position {
        private final Sort.Order myOrder;

        public Sort.Order getOrder() {
            return this.myOrder;
        }

        private SortPosition(@NotNull TextRange range, Sort.Order key) {
            if (range == null) {
                SortPosition.$$$reportNull$$$0(0);
            }
            super(range);
            this.myOrder = key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$SortPosition", "<init>"));
        }
    }
}

