/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaLineMarkerActionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.uast.UastSmartPointer;
import com.intellij.ui.awt.RelativePoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jpa/highlighting/FindUsagesOfAttributeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "memberPointer", "Lcom/intellij/uast/UastSmartPointer;", "Lorg/jetbrains/uast/UDeclaration;", "anchorPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/uast/UastSmartPointer;Lcom/intellij/psi/SmartPsiElementPointer;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nJpaLineMarkerActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaLineMarkerActions.kt\ncom/intellij/jpa/highlighting/FindUsagesOfAttributeAction\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,267:1\n19#2:268\n*S KotlinDebug\n*F\n+ 1 JpaLineMarkerActions.kt\ncom/intellij/jpa/highlighting/FindUsagesOfAttributeAction\n*L\n231#1:268\n*E\n"})
public final class FindUsagesOfAttributeAction
extends AnAction {
    @NotNull
    private final UastSmartPointer<UDeclaration> memberPointer;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> anchorPointer;

    public FindUsagesOfAttributeAction(@NotNull UastSmartPointer<UDeclaration> memberPointer, @NotNull SmartPsiElementPointer<PsiElement> anchorPointer) {
        Intrinsics.checkNotNullParameter(memberPointer, (String)"memberPointer");
        Intrinsics.checkNotNullParameter(anchorPointer, (String)"anchorPointer");
        super(AllIcons.Actions.Find);
        this.memberPointer = memberPointer;
        this.anchorPointer = anchorPointer;
    }

    public void update(@NotNull AnActionEvent e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement $this$asSafely$iv = JpaLineMarkerActionsKt.substituteUsagesTarget(this.memberPointer);
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiNamedElement)) {
            psiElement = null;
        }
        PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
        String actionName = psiNamedElement != null ? psiNamedElement.getName() : null;
        Presentation presentation = e.getPresentation();
        if (actionName != null) {
            Object[] objectArray = new Object[]{actionName};
            string = JpaMessages.message("action.Jpa.FindUsagesOf0", objectArray);
        } else {
            string = JpaMessages.message("action.Jpa.FindUsages", new Object[0]);
        }
        presentation.setText(string);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        RelativePoint relativePoint;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiElement anchor = this.anchorPointer.getElement();
        if (editor != null && anchor != null) {
            editor.getCaretModel().moveToOffset(anchor.getTextOffset());
            relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        } else {
            relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        }
        RelativePoint relativePoint2 = relativePoint;
        Intrinsics.checkNotNull((Object)relativePoint2);
        RelativePoint bestPositionForPopup = relativePoint2;
        PsiElement psiElement = JpaLineMarkerActionsKt.substituteUsagesTarget(this.memberPointer);
        if (psiElement == null) {
            return;
        }
        PsiElement substituteUsagesTarget = psiElement;
        ShowUsagesAction.startFindUsages((PsiElement)substituteUsagesTarget, (RelativePoint)bestPositionForPopup, (Editor)editor);
    }
}

