/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.jpa.JpaEventsCollector;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.SetupDatasourceResult;
import com.intellij.jpa.actions.AssignDataSourcesAction;
import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaImportDatasourceService;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceInheritanceType;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;

public final class JpaDataSourceORMInspection
extends AbstractUastJpaInspection {
    @Override
    protected void checkClassAllRoles(UClass aClass, PersistenceClassRole[] roles, ProblemsHolder holder, boolean isOnTheFly) {
        if (ContainerUtil.find((Object[])roles, role -> role.getType() != PersistenceClassRoleEnum.ENTITY_LISTENER) == null) {
            return;
        }
        PersistenceClassRole entityRole = (PersistenceClassRole)ContainerUtil.find((Object[])roles, role -> role.getType() == PersistenceClassRoleEnum.ENTITY);
        if (entityRole != null && ((PersistentEntity)entityRole.getPersistentObject()).getObjectModelHelper().getInheritanceType(null) == PersistenceInheritanceType.TABLE_PER_CLASS) {
            return;
        }
        ProblemHighlightType highlightType = JpaDataSourceORMInspection.suggestHighlightingType(aClass, roles);
        Processor processor = t -> {
            JpaInspectionUtil.checkMemberAnnotations(t, holder, ORMReferencesUtil.DataSourceRelatedReference.class, highlightType);
            return true;
        };
        JpaInspectionUtil.checkMemberAnnotations((UAnnotated)aClass, holder, ORMReferencesUtil.DataSourceRelatedReference.class, highlightType);
        ContainerUtil.process(Arrays.asList(aClass.getFields()), (Processor)processor);
        ContainerUtil.process(Arrays.asList(aClass.getMethods()), (Processor)processor);
    }

    public static LocalQuickFix[] createUnitDataSourceQuickFixes(@Nullable PersistenceMappings entityMappings) {
        SmartList quickFixes = new SmartList();
        Collection<Object> dataSources = entityMappings == null ? Collections.emptyList() : PersistenceUtil.getDataSources((PersistenceMappings)entityMappings);
        List allConnections = entityMappings != null ? DbPsiFacade.getInstance((Project)entityMappings.getPsiManager().getProject()).getDataSources() : Collections.emptyList();
        quickFixes.add((Object)new SetupDataSourcesQuickFix(allConnections));
        for (DbDataSource dbDataSource : dataSources) {
            LocalDataSource localDataSource = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dbDataSource);
            if (localDataSource == null || !DbImplUtilCore.canConnectTo((LocalDataSource)localDataSource)) continue;
            quickFixes.add((Object)new RefreshDataSourceQuickFix(localDataSource));
        }
        return (LocalQuickFix[])quickFixes.toArray((Object[])LocalQuickFix.EMPTY_ARRAY);
    }

    private static ProblemHighlightType suggestHighlightingType(UClass uClass, PersistenceClassRole[] roles) {
        return JpaUtil.isDataSourceSetUp(uClass, roles) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WARNING;
    }

    private static class SetupDataSourcesQuickFix
    implements LocalQuickFix {
        private final boolean hasDatasource;

        private SetupDataSourcesQuickFix(Collection<DbDataSource> dataSources) {
            this.hasDatasource = !dataSources.isEmpty();
        }

        @NotNull
        public String getName() {
            if (!this.hasDatasource) {
                String string = JpaHighlightingMessages.message("fix.create.datasource.name", new Object[0]);
                if (string == null) {
                    SetupDataSourcesQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = JpaHighlightingMessages.message("fix.edit.unit.datasource.name", new Object[0]);
            if (string == null) {
                SetupDataSourcesQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                SetupDataSourcesQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SetupDataSourcesQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                SetupDataSourcesQuickFix.$$$reportNull$$$0(4);
            }
            if (!this.hasDatasource) {
                ((JpaImportDatasourceService)project.getService(JpaImportDatasourceService.class)).createOrImportDatasource(descriptor.getPsiElement());
                return;
            }
            PersistenceFacet facet = (PersistenceFacet)PersistenceHelper.getHelper().getSharedModelBrowser().queryPersistenceFacets(descriptor.getPsiElement()).findFirst();
            if (facet == null) {
                return;
            }
            boolean assigned = AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet = JpaConfigurationModel.createModifiablePersistenceFacet(facet));
            JpaEventsCollector.setupFixFinished(project, assigned ? SetupDatasourceResult.ASSIGN_DATASOURCE : SetupDatasourceResult.CANCEL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$SetupDataSourcesQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$SetupDataSourcesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RefreshDataSourceQuickFix
    implements LocalQuickFix {
        private final LocalDataSource myDataSource;

        public RefreshDataSourceQuickFix(LocalDataSource dataSource) {
            this.myDataSource = dataSource;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(0);
            }
            if (previewDescriptor == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(1);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(2);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        public String getName() {
            String string = JpaHighlightingMessages.message("fix.refresh.datasource.name", this.myDataSource.getName());
            if (string == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("fix.refresh.datasource.family.name", new Object[0]);
            if (string == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(6);
            }
            DataSourceUtil.performManualSyncTask((LoaderContext)LoaderContext.selectGeneralTask((Project)project, (LocalDataSource)this.myDataSource));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

