/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.llm.domains.persistence;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jpa.llm.domains.persistence.EntityItemPresentation;
import com.intellij.jpa.llm.domains.persistence.EntityProviderKt;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.common.persistence.mapping.Entity;
import com.intellij.jpa.model.common.persistence.mapping.Id;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.ml.llm.domains.DomainContext;
import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.ml.llm.domains.context.DomainItemContext;
import com.intellij.ml.llm.domains.ide.presentation.DomainItemPresentation;
import com.intellij.ml.llm.domains.ide.presentation.PresentableProvider;
import com.intellij.ml.llm.domains.ide.utils.DomainProviderUtils;
import com.intellij.ml.llm.domains.mapper.DomainProviderContextMapper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.helpers.PersistentEntityModelHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0016R\u000e\u0010\u0011\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jpa/llm/domains/persistence/EntityProvider;", "Lcom/intellij/ml/llm/domains/mapper/DomainProviderContextMapper;", "Lcom/intellij/jpa/model/common/persistence/mapping/Entity;", "Lcom/intellij/ml/llm/domains/ide/presentation/PresentableProvider;", "<init>", "()V", "getItemPresentation", "Lcom/intellij/ml/llm/domains/ide/presentation/DomainItemPresentation;", "item", "getId", "", "isAvailable", "", "searchScope", "Lcom/intellij/ml/llm/domains/DomainSearchScope;", "getItems", "", "TYPE_ID", "asContext", "Lcom/intellij/ml/llm/domains/context/DomainItemContext;", "t", "scope", "findItem", "domainContext", "Lcom/intellij/ml/llm/domains/DomainContext;", "getIcon", "Ljavax/swing/Icon;", "unused", "Attr", "Companion", "intellij.javaee.jpa.llm"})
@SourceDebugExtension(value={"SMAP\nEntityProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityProvider.kt\ncom/intellij/jpa/llm/domains/persistence/EntityProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1755#2,3:98\n1557#2:101\n1628#2,3:102\n808#2,11:105\n1557#2:116\n1628#2,3:117\n*S KotlinDebug\n*F\n+ 1 EntityProvider.kt\ncom/intellij/jpa/llm/domains/persistence/EntityProvider\n*L\n40#1:98,3\n65#1:101\n65#1:102,3\n73#1:105,11\n74#1:116\n74#1:117,3\n*E\n"})
public final class EntityProvider
implements DomainProviderContextMapper<Entity>,
PresentableProvider<Entity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String TYPE_ID;
    @NotNull
    public static final String ID = "Entities";

    public EntityProvider() {
        this.TYPE_ID = "persistence-entity";
    }

    @NotNull
    public DomainItemPresentation getItemPresentation(@NotNull Entity item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object object = ReadAction.compute(() -> EntityProvider.getItemPresentation$lambda$0(item));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (DomainItemPresentation)object;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public boolean isAvailable(@NotNull DomainSearchScope searchScope) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
            List list = searchScope.getModules();
            if (list == null) {
                return false;
            }
            List modules = list;
            Iterable $this$any$iv = modules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Module it = (Module)element$iv;
                    boolean bl2 = false;
                    if (DomainProviderUtils.isSourceModule((Module)it)) {
                        return JpaUtil.isJpaAvailable(it);
                    }
                    if (!false) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public Set<Entity> getItems(@NotNull DomainSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        List modules = searchScope.getModules();
        SearchScope scope = searchScope.getScope();
        if (modules != null && scope instanceof GlobalSearchScope) {
            HashSet items = new HashSet();
            for (Module module : modules) {
                for (String entityAnnotation : EntityProviderKt.access$getENTITY_ANNOTATIONS$p()) {
                    items.addAll(JamService.getJamService((Project)module.getProject()).getJamClassElements((JamMemberMeta)EntityImpl.ENTITY_META, entityAnnotation, (GlobalSearchScope)scope));
                }
            }
            return items;
        }
        return SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DomainItemContext asContext(@NotNull Entity t, @NotNull DomainSearchScope scope) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        List list = ((PersistentEntityModelHelper)t.getObjectModelHelper()).getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
        List attributes = list;
        Iterable $this$map$iv2 = attributes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void attr;
            PersistentAttribute persistentAttribute = (PersistentAttribute)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = attr.getName().getStringValue();
            if (string == null) {
                string = "";
            }
            void v2 = attr;
            Intrinsics.checkNotNull((Object)v2);
            PsiType psiType = v2.getPsiType();
            Intrinsics.checkNotNull((Object)psiType);
            String string2 = psiType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
            collection.add(new Attr(string, string2));
        }
        Set attrs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object object = t.getClazz().getValue();
        Intrinsics.checkNotNull((Object)object);
        String className = ((PsiClass)object).getName();
        if (className == null) {
            return DomainItemContext.EMPTY;
        }
        Object object2 = t.getClazz().getValue();
        Intrinsics.checkNotNull((Object)object2);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)object2));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        DomainItemContext domainItemContext = DomainItemContext.Companion.create(this.TYPE_ID, className, smartPsiElementPointer);
        Object object3 = t.getClazz().getValue();
        Intrinsics.checkNotNull((Object)object3);
        DomainItemContext domainItemContext2 = domainItemContext.with("class", ((PsiClass)object3).getQualifiedName());
        Object object4 = t.getClazz().getValue();
        Intrinsics.checkNotNull((Object)object4);
        $this$mapTo$iv$iv2 = attributes;
        String string = "idType";
        collection = domainItemContext2.with("path", ((PsiClass)object4).getContainingFile().getVirtualFile().getPath());
        boolean $i$f$filterIsInstance = false;
        void $i$f$mapTo22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Id)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Collection<String> collection2 = (List)destination$iv$iv2;
        $this$filterIsInstance$iv = collection2;
        boolean $i$f$map2 = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersistentAttribute persistentAttribute = (PersistentAttribute)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl = false;
            void v12 = it;
            Intrinsics.checkNotNull((Object)v12);
            PsiType psiType = v12.getPsiType();
            Intrinsics.checkNotNull((Object)psiType);
            collection2.add(psiType.getCanonicalText());
        }
        collection2 = (List)destination$iv$iv2;
        String string3 = (String)CollectionsKt.firstOrNull((List)collection2);
        if (string3 == null) {
            string3 = "Long";
        }
        return collection.with(string, string3).with("attributes", attrs);
    }

    @Nullable
    public Entity findItem(@NotNull DomainContext domainContext) {
        Intrinsics.checkNotNullParameter((Object)domainContext, (String)"domainContext");
        PsiClass psiClass = DomainProviderUtils.getContainingClass((DomainContext)domainContext);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        return (Entity)EntityImpl.ENTITY_META.getJamElement((PsiModifierListOwner)psiClass2);
    }

    @NotNull
    public Icon getIcon(boolean unused) {
        Icon icon = JavaUltimateIcons.Javaee.Gutter.PersistenceEntity;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PersistenceEntity");
        return icon;
    }

    private static final EntityItemPresentation getItemPresentation$lambda$0(Entity $item) {
        return new EntityItemPresentation($item);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jpa/llm/domains/persistence/EntityProvider$Attr;", "", "name", "", "type", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javaee.jpa.llm"})
    public static final class Attr {
        @NotNull
        private final String name;
        @NotNull
        private final String type;

        public Attr(@NotNull String name, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name;
            this.type = type;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final Attr copy(@NotNull String name, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Attr(name, type);
        }

        public static /* synthetic */ Attr copy$default(Attr attr, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = attr.name;
            }
            if ((n & 2) != 0) {
                string2 = attr.type;
            }
            return attr.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Attr(name=" + this.name + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Attr)) {
                return false;
            }
            Attr attr = (Attr)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)attr.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)attr.type);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jpa/llm/domains/persistence/EntityProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.javaee.jpa.llm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

