/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.implicit;

import com.intellij.jpa.model.implicit.UnitPropertiesUtilsKt;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/jpa/model/implicit/CallExpressionVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "foundProperties", "Ljava/util/Properties;", "<init>", "(Ljava/util/Properties;)V", "getFoundProperties", "()Ljava/util/Properties;", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "intellij.javaee.jpa.impl"})
final class CallExpressionVisitor
extends AbstractUastVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Properties foundProperties;
    @NotNull
    private static final String JAVA_UTIL_PROPERTIES = "java.util.Properties";
    @NotNull
    private static final String PUT_METHOD = "put";
    @NotNull
    private static final UCallExpressionPattern putMethodCallPattern;

    public CallExpressionVisitor(@NotNull Properties foundProperties) {
        Intrinsics.checkNotNullParameter((Object)foundProperties, (String)"foundProperties");
        this.foundProperties = foundProperties;
    }

    @NotNull
    public final Properties getFoundProperties() {
        return this.foundProperties;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (putMethodCallPattern.accepts((Object)node)) {
            Object object = node.getArgumentForParameter(0);
            if (object == null || (object = UastUtils.evaluateString((UExpression)object)) == null || (object = UnitPropertiesUtilsKt.toJpaNotation((String)object)) == null) {
                return false;
            }
            Object key = object;
            Object object2 = node.getArgumentForParameter(1);
            if (object2 == null || (object2 = UastUtils.evaluateString((UExpression)object2)) == null || (object2 = UnitPropertiesUtilsKt.substituteDefaultUrlValues$default((String)object2, null, 1, null)) == null) {
                return false;
            }
            Object value = object2;
            ((Map)this.foundProperties).put(key, value);
            return true;
        }
        return false;
    }

    static {
        UCallExpressionPattern uCallExpressionPattern = UastPatterns.callExpression().withMethodName(PUT_METHOD);
        PsiClassPattern psiClassPattern = PsiJavaPatterns.psiClass().inheritorOf(false, JAVA_UTIL_PROPERTIES);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassPattern, (String)"inheritorOf(...)");
        putMethodCallPattern = uCallExpressionPattern.withReceiver((ElementPattern)psiClassPattern);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/jpa/model/implicit/CallExpressionVisitor$Companion;", "", "<init>", "()V", "JAVA_UTIL_PROPERTIES", "", "PUT_METHOD", "putMethodCallPattern", "Lcom/intellij/patterns/uast/UCallExpressionPattern;", "intellij.javaee.jpa.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

