/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.util.AnnotationManipulator;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.jpa.model.annotations.mapping.PersistentObjectImpl;
import com.intellij.jpa.model.common.persistence.JavaeePersistenceConstants;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.model.common.persistence.JpaConstants;
import com.intellij.jpa.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.model.common.persistence.mapping.CascadeTypeMode;
import com.intellij.jpa.model.common.persistence.mapping.EntityBase;
import com.intellij.jpa.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.jpa.model.manipulators.JpaObjectManipulatorBase;
import com.intellij.jpa.model.xml.persistence.mapping.FetchType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JdbcTypesUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JpaAnnoObjectManipulator
extends JpaObjectManipulatorBase<PersistentObjectImpl> {
    private final SmartPsiElementPointer<PsiClass> myLazyPointer;
    private final JamClassMeta<? extends PersistentObjectImpl> myMeta;

    public JpaAnnoObjectManipulator(PersistentObjectImpl target) {
        super(target);
        PsiClass psiClass = (PsiClass)target.getClazz().getValue();
        assert (psiClass != null);
        this.myLazyPointer = SmartPointerManager.getInstance((Project)psiClass.getProject()).createSmartPsiElementPointer((PsiElement)psiClass);
        this.myMeta = target.getJamMeta();
    }

    @Override
    protected JpaObjectManipulatorBase.MyJpaAttributeAction<JpaAnnoObjectManipulator> createNewAttributeAction(AttributeType type) {
        return new MyAnnoAttributeAction(this, type);
    }

    public PersistentObjectImpl getManipulatorTarget() {
        PersistentObjectImpl target = (PersistentObjectImpl)super.getManipulatorTarget();
        if (target.isValid()) {
            return target;
        }
        PsiClass psiClass = (PsiClass)this.myLazyPointer.getElement();
        assert (psiClass != null);
        return (PersistentObjectImpl)JpaAnnoObjectManipulator.getClassJamElement(this.myMeta, psiClass);
    }

    @Override
    public PsiClass getManipulatorTargetClass() {
        return (PsiClass)this.myLazyPointer.getElement();
    }

    public void setTable(DasTable tableInfo) throws IncorrectOperationException {
        PersistentObjectImpl target = this.getManipulatorTarget();
        assert (target instanceof EntityImpl);
        EntityImpl entity = (EntityImpl)target;
        PsiClass psiClass = target.getPsiClass();
        if (!Comparing.strEqual((String)tableInfo.getName(), (String)((String)entity.getName().getValue()), (boolean)false)) {
            PsiAnnotation annotation = (PsiAnnotation)JpaAnnoObjectManipulator.createJpaAnnoChildLink((PsiMember)psiClass, JavaeePersistenceConstants.TABLE_ANNO.fqn((PsiElement)psiClass)).ensurePsiElementExists();
            JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "name", AnnotationTextUtil.quote((String)tableInfo.getName()), null);
            JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "schema", AnnotationTextUtil.quote((String)DasUtil.getSchema((DasObject)tableInfo)), null);
            JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "catalog", AnnotationTextUtil.quote((String)DasUtil.getCatalog((DasObject)tableInfo)), null);
        }
    }

    public static void setAnnotationParameter(PsiAnnotation annotation, String nameParam, String value, String defValue) {
        if (Objects.equals(value, defValue)) {
            return;
        }
        PsiAnnotationMemberValue psiValue = JavaPsiFacade.getElementFactory((Project)annotation.getProject()).createAnnotationFromText("@A(" + value + ")", (PsiElement)annotation).getParameterList().getAttributes()[0].getValue();
        annotation.setDeclaredAttributeValue(nameParam, psiValue);
    }

    public PersistentEmbeddedAttribute addEmbeddedAttribute(PersistentEmbeddable embeddable, String attributeName, PropertyMemberType accessMode) throws IncorrectOperationException {
        PsiClass embeddableClass;
        PsiClass curClass = this.getManipulatorTarget().getPsiClass();
        assert (curClass != null);
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)embeddable, PersistentObjectManipulator.class);
        if (manipulator == null || (embeddableClass = manipulator.ensureClassExists()) == null) {
            throw new AssertionError();
        }
        String annotationText = AnnotationTextUtil.createAnnotationText((PsiElement)curClass, (String)JpaAttributeType.EMBEDDED.getAttributeAnnotation().fqn((PsiElement)curClass), (boolean)true, null, (String[])new String[0]);
        assert (annotationText != null);
        return (PersistentEmbeddedAttribute)this.createAttributeInternal(curClass.getManager(), JpaAttributeType.EMBEDDED, attributeName, accessMode, (PsiType)JavaPsiFacade.getInstance((Project)curClass.getProject()).getElementFactory().createType(embeddableClass), annotationText);
    }

    public PersistentRelationshipAttribute addRelationshipAttribute(PersistentEntityBase entity, RelationshipType relationshipType, JavaContainerType containerType, String attributeName, String targetAttributeName, boolean inverse, boolean optional, String fetchType, Collection<String> cascadeVariants, PropertyMemberType accessMode) throws IncorrectOperationException {
        AttributeType attributeType;
        PersistentObjectImpl thisEntity = this.getManipulatorTarget();
        boolean sameAttr = thisEntity == entity && attributeName.equals(targetAttributeName);
        PsiClass curClass = this.getManipulatorTarget().getPsiClass();
        assert (curClass != null);
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)entity, PersistentObjectManipulator.class);
        assert (manipulator != null) : "target entity manipulator null";
        PsiClass entityClass = manipulator.ensureClassExists();
        assert (entityClass != null) : "target entity class null";
        PsiClassType entityClassType = JavaPsiFacade.getInstance((Project)curClass.getProject()).getElementFactory().createType(entityClass);
        PsiClassType propertyType = relationshipType.isMany(false) ? containerType.createCollectionType((PsiElement)curClass, (PsiType)entityClassType, null) : entityClassType;
        HashSet<String> cascades = new HashSet<String>();
        for (CascadeTypeMode mode : CascadeTypeMode.values()) {
            if (!cascadeVariants.contains(mode.getDisplayName())) continue;
            cascades.add(mode.name());
        }
        FetchType fetch = null;
        if (fetchType != null) {
            for (FetchType type : FetchType.values()) {
                if (!type.getDisplayName().equals(fetchType)) continue;
                fetch = type;
                break;
            }
        }
        String mappedBy = sameAttr || inverse ? targetAttributeName : null;
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)curClass, (JavaeeClass)JavaeePersistenceConstants.ENTITY_ANNO);
        String cascadesString = AnnotationTextUtil.createStringArrayInitializer(cascades, (String[])new String[]{JpaConstants.CASCADE_TYPE_PREFIX.fqn(javaeeType), ""});
        String fetchString = fetch == null ? null : JpaConstants.FETCH_TYPE_PREFIX.fqn(javaeeType) + fetch.name();
        String entityClassName = entityClass.getQualifiedName();
        String targetEntityString = entityClassName + ".class";
        String targetEntityDefString = propertyType.getCanonicalText().contains(entityClassName) ? targetEntityString : null;
        String annotationText = AnnotationTextUtil.createAnnotationText((PsiElement)curClass, (String)attributeType.getAttributeAnnotation().fqn((PsiElement)curClass), (boolean)true, null, (String[])(switch (relationshipType) {
            case RelationshipType.MANY_TO_MANY -> {
                attributeType = JpaAttributeType.MANY_TO_MANY;
                yield new String[]{"cascade", cascadesString, null, "fetch", fetchString, null, "mappedBy", AnnotationTextUtil.quote((String)mappedBy), null, "targetEntity", targetEntityString, targetEntityDefString};
            }
            case RelationshipType.MANY_TO_ONE -> {
                attributeType = JpaAttributeType.MANY_TO_ONE;
                yield new String[]{"cascade", cascadesString, null, "fetch", fetchString, null, "optional", String.valueOf(optional), String.valueOf(true), "targetEntity", targetEntityString, targetEntityDefString};
            }
            case RelationshipType.ONE_TO_MANY -> {
                attributeType = JpaAttributeType.ONE_TO_MANY;
                yield new String[]{"cascade", cascadesString, null, "fetch", fetchString, null, "mappedBy", AnnotationTextUtil.quote((String)mappedBy), null, "targetEntity", targetEntityString, targetEntityDefString};
            }
            case RelationshipType.ONE_TO_ONE -> {
                attributeType = JpaAttributeType.ONE_TO_ONE;
                yield new String[]{"cascade", cascadesString, null, "fetch", fetchString, null, "mappedBy", AnnotationTextUtil.quote((String)mappedBy), null, "optional", String.valueOf(optional), String.valueOf(true), "targetEntity", targetEntityString, targetEntityDefString};
            }
            default -> throw new AssertionError();
        }));
        assert (annotationText != null);
        return (PersistentRelationshipAttribute)this.createAttributeInternal(curClass.getManager(), attributeType, attributeName, accessMode, (PsiType)propertyType, annotationText);
    }

    public PersistentAttribute addAttribute(String attributeName, PsiType attributeType, PropertyMemberType accessType, Collection<? extends DasColumn> columns2) throws IncorrectOperationException {
        String[] stringArray;
        PsiClass curClass = this.getManipulatorTarget().getPsiClass();
        assert (curClass != null);
        String annotationText = AnnotationTextUtil.createAnnotationText((PsiElement)curClass, (String)JpaAttributeType.BASIC.getAttributeAnnotation().fqn((PsiElement)curClass), (boolean)true, null, (String[])new String[0]);
        assert (annotationText != null);
        String typeText = attributeType.getCanonicalText();
        if ("java.sql.Blob".equals(typeText) || "java.sql.Clob".equals(typeText)) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = annotationText;
            stringArray = stringArray2;
            stringArray2[1] = "@" + JavaeePersistenceConstants.LOB_ANNO;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = annotationText;
        }
        String[] annotationTexts = stringArray;
        PersistentAttribute attribute = this.createAttributeInternal(curClass.getManager(), JpaAttributeType.BASIC, attributeName, accessType, attributeType, annotationTexts);
        if (!columns2.isEmpty()) {
            this.setColumn(attribute, columns2.iterator().next());
        }
        return attribute;
    }

    public PersistentAttribute addIdAttribute(boolean compositeId, String attributeName, PsiType attributeType, PropertyMemberType accessType, Collection<? extends DasColumn> columns2) throws IncorrectOperationException {
        assert (this.getManipulatorTarget() instanceof EntityBase);
        PsiClass curClass = this.getManipulatorTarget().getPsiClass();
        assert (curClass != null);
        String idAnnotationText = AnnotationTextUtil.createAnnotationText((PsiElement)curClass, (String)JpaAttributeType.ID.getAttributeAnnotation().fqn((PsiElement)curClass), (boolean)true, null, (String[])new String[0]);
        assert (idAnnotationText != null);
        String strategyArgument = JavaeePersistenceConstants.GENERATION_TYPE_ANNO_PARAMETER.fqn((PsiElement)curClass) + ".IDENTITY";
        String generatedValueAnnotationText = AnnotationTextUtil.createAnnotationText((PsiElement)curClass, (String)JpaAnnotationConstants.GENERATED_VALUE_ANNO.fqn((PsiElement)curClass), (boolean)true, null, (String[])new String[]{"strategy", strategyArgument, null});
        PersistentAttribute attribute = this.createAttributeInternal(curClass.getManager(), JpaAttributeType.ID, attributeName, accessType, attributeType, idAnnotationText, generatedValueAnnotationText);
        if (!columns2.isEmpty()) {
            this.setColumn(attribute, columns2.iterator().next());
        }
        return attribute;
    }

    private void setColumn(PersistentAttribute attribute, DasColumn columnInfo) throws IncorrectOperationException {
        String defaultTableName = this.getManipulatorTarget() instanceof EntityImpl ? (String)((EntityImpl)this.getManipulatorTarget()).getTable().getTableName().getValue() : null;
        PsiMember psiMember = attribute.getPsiMember();
        assert (psiMember != null);
        PsiAnnotation annotation = (PsiAnnotation)JpaAnnoObjectManipulator.createJpaAnnoChildLink(psiMember, JavaeePersistenceConstants.COLUMN_ANNO.fqn((PsiElement)psiMember)).ensurePsiElementExists();
        JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "name", AnnotationTextUtil.quote((String)columnInfo.getName()), null);
        String tableName = columnInfo.getTable().getName();
        if (!Comparing.strEqual((String)tableName, (String)defaultTableName, (boolean)false)) {
            JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "table", AnnotationTextUtil.quote((String)tableName), AnnotationTextUtil.quote((String)defaultTableName));
        }
        if (this.isGenerateColumnProperties()) {
            JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "nullable", String.valueOf(!columnInfo.isNotNull()), null);
            int jdbcType = JdbcTypesUtil.getJdbcType((DasTypedObject)columnInfo, null);
            DataType dataType = columnInfo.getDasType().toDataType();
            if (JdbcUtil.hasLength((int)jdbcType)) {
                JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "length", String.valueOf(dataType.getLength()), null);
            } else if (JdbcUtil.hasScaleAndPrecision((int)jdbcType)) {
                JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "precision", String.valueOf(dataType.getPrecision()), null);
                JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "precision", String.valueOf(dataType.getScale()), null);
            }
        }
        if (annotation.getParameterList().getAttributes().length == 0) {
            annotation.delete();
        }
    }

    public void setIdClass(String qualifiedName) throws IncorrectOperationException {
        PersistentObjectImpl target = this.getManipulatorTarget();
        assert (target instanceof PersistentEntity);
        EntityImpl entity = (EntityImpl)target;
        PsiClass psiClass = (PsiClass)entity.getClazz().getValue();
        assert (psiClass != null);
        PsiElementRef<PsiAnnotation> ref = JpaAnnoObjectManipulator.createJpaAnnoChildLink((PsiMember)psiClass, JavaeePersistenceConstants.ID_CLASS_ANNO.fqn((PsiElement)psiClass));
        if (qualifiedName == null) {
            PsiAnnotation anno = (PsiAnnotation)ref.getPsiElement();
            if (anno != null) {
                anno.delete();
            }
        } else {
            PsiAnnotation annotation = (PsiAnnotation)ref.ensurePsiElementExists();
            JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "value", qualifiedName + ".class", null);
        }
    }

    public void addNamedQuery(String queryName, String queryText) throws IncorrectOperationException {
        PersistentObjectImpl target = this.getManipulatorTarget();
        assert (target instanceof PersistentEntity);
        PsiElement context = target.getIdentifyingPsiElement();
        JavaeeType javaeeType = context == null ? JavaeeType.JAVAX : JavaeeType.discover((PsiElement)context, (JavaeeClass)JavaeePersistenceConstants.ENTITY_ANNO);
        String annoText = AnnotationTextUtil.createAnnotationText((PsiElement)context, (String)JavaeePersistenceConstants.NAMED_QUERY_ANNO.fqn(javaeeType), (boolean)false, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)queryName), null, "query", AnnotationTextUtil.quote((String)queryText), null});
        AnnotationTextUtil.createMultiAnnotation(Collections.singletonList(annoText), (Object)this.getManipulatorTarget().getPsiClass(), (String)JavaeePersistenceConstants.NAMED_QUERY_ANNO.fqn(javaeeType), (String)JavaeePersistenceConstants.NAMED_QUERIES_ANNO.fqn(javaeeType), (AnnotationManipulator)AnnotationManipulator.PSI_MANIPULATOR);
    }

    private PersistentAttribute createAttributeInternal(PsiManager manager, AttributeType attributeType, String attributeName, PropertyMemberType accessMode, PsiType type, String ... annotationTexts) throws IncorrectOperationException {
        ArrayList<PsiAnnotation> annos = new ArrayList<PsiAnnotation>();
        for (String annotationText : annotationTexts) {
            annos.add(JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createAnnotationFromText(annotationText, null));
        }
        PsiMember member = this.ensurePropertyExists(this.getManipulatorTargetClass(), attributeName, type, accessMode, annos.toArray(PsiAnnotation.EMPTY_ARRAY));
        String anno = attributeType.getAttributeAnnotation().fqn((PsiElement)member);
        assert (anno != null) : attributeType;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{anno});
        assert (annotation != null) : attributeType;
        return JpaAnnoObjectManipulator.getMemberJamElement(attributeType, member);
    }

    private static JamAttributeBase getMemberJamElement(AttributeType attributeType, PsiMember member) {
        JamAttributeBase result = (JamAttributeBase)attributeType.getJamMetas()[0].createJamElement(PsiElementRef.real((PsiElement)member));
        assert (result != null);
        return result;
    }

    @NotNull
    public static <T> T getClassJamElement(JamClassMeta<?> meta, PsiClass psiClass) {
        JamElement result = meta.createJamElement(PsiElementRef.real((PsiElement)psiClass));
        assert (result != null);
        JamElement jamElement = result;
        if (jamElement == null) {
            JpaAnnoObjectManipulator.$$$reportNull$$$0(0);
        }
        return (T)jamElement;
    }

    public static PsiElementRef<PsiAnnotation> createJpaAnnoChildLink(PsiMember psiMember, String anno) {
        return new AnnotationChildLink(anno){

            @NotNull
            public PsiAnnotation createChild(@NotNull PsiModifierListOwner member) throws IncorrectOperationException {
                if (member == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiAnnotation child = super.createChild(member);
                PsiElement parent = child.getParent();
                for (PsiElement e = parent.getLastChild(); e != null && e != child; e = e.getPrevSibling()) {
                    String qualifiedName;
                    String string = qualifiedName = e instanceof PsiAnnotation ? ((PsiAnnotation)e).getQualifiedName() : null;
                    if (qualifiedName == null || !qualifiedName.startsWith(JpaConstants.PERSISTENCE_PACKAGE_PREFIX.javax()) && !qualifiedName.startsWith(JpaConstants.PERSISTENCE_PACKAGE_PREFIX.jakarta())) continue;
                    PsiElement copy = child.copy();
                    child.delete();
                    child = (PsiAnnotation)parent.addAfter(copy, e);
                    break;
                }
                PsiAnnotation psiAnnotation = child;
                if (psiAnnotation == null) {
                    1.$$$reportNull$$$0(1);
                }
                return psiAnnotation;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "member";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/model/manipulators/JpaAnnoObjectManipulator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/model/manipulators/JpaAnnoObjectManipulator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createChild";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createChild";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }.createChildRef((PsiElement)psiMember);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/manipulators/JpaAnnoObjectManipulator", "getClassJamElement"));
    }

    public static class MyAnnoAttributeAction
    extends JpaObjectManipulatorBase.MyJpaAttributeAction<JpaAnnoObjectManipulator> {
        public MyAnnoAttributeAction(JpaAnnoObjectManipulator manipulator, AttributeType attributeType) {
            super(manipulator, attributeType);
        }

        @Override
        protected PsiAnnotation[] createAnnotations(PsiClass context) throws IncorrectOperationException {
            String[] annotationParameters = this.myAttributeType == JpaAttributeType.MANY_TO_MANY || this.myAttributeType == JpaAttributeType.ONE_TO_MANY || this.myAttributeType == JpaAttributeType.ONE_TO_ONE ? (this.myInfo.inverse ? new String[]{"mappedBy", AnnotationTextUtil.quote((String)this.myInfo.targetAttribute), null} : ArrayUtilRt.EMPTY_STRING_ARRAY) : ArrayUtilRt.EMPTY_STRING_ARRAY;
            String annotationText = AnnotationTextUtil.createAnnotationText((PsiElement)context, (String)this.myAttributeType.getAttributeAnnotation().fqn((PsiElement)context), (boolean)true, null, (String[])annotationParameters);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
            PsiAnnotation typeAnno = factory.createAnnotationFromText(annotationText, null);
            if (this.myAttributeType == JpaAttributeType.ID && this.myInfo.generated) {
                String generatedAnno = AnnotationTextUtil.createAnnotationText((PsiElement)context, (String)JavaeePersistenceConstants.GENERATED_VALUE_ANNO.fqn((PsiElement)context), (boolean)true, null, (String[])ArrayUtilRt.EMPTY_STRING_ARRAY);
                return new PsiAnnotation[]{typeAnno, factory.createAnnotationFromText(generatedAnno, null)};
            }
            return new PsiAnnotation[]{typeAnno};
        }
    }
}

