/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.orm.structure;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ExternalElementsProvider;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.jpa.model.AbstractJpaOrmEntity;
import com.intellij.jpa.jpb.model.orm.jpa.model.AbstractJpaOrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.orm.structure.JpaOrmEmbeddableUsagesPresentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=JpaOrmEmbeddableUsagesPresentationProvider.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jpa/orm/structure/JpaOrmEmbeddableUsagesProvider;", "Lcom/intellij/ide/structureView/logical/ExternalElementsProvider;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "<init>", "()V", "isApplicable", "", "parent", "getElements", "", "containerName", "", "getContainerName", "()Ljava/lang/String;", "intellij.javaee.jpa.impl"})
public final class JpaOrmEmbeddableUsagesProvider
implements ExternalElementsProvider<OrmEntity, OrmEntity> {
    @NotNull
    private final String containerName;

    public JpaOrmEmbeddableUsagesProvider() {
        this.containerName = "Usages";
    }

    public boolean isApplicable(@NotNull OrmEntity parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent instanceof AbstractJpaOrmEntity && ((AbstractJpaOrmEntity)parent).isEmbeddable();
    }

    @NotNull
    public List<OrmEntity> getElements(@NotNull OrmEntity parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SmartPsiElementPointer smartPsiElementPointer = parent.getClassPsiPointer();
        if (smartPsiElementPointer == null || (smartPsiElementPointer = smartPsiElementPointer.getProject()) == null) {
            return CollectionsKt.emptyList();
        }
        SmartPsiElementPointer project = smartPsiElementPointer;
        Object object = parent.getClassPsiPointer();
        if (object == null || (object = (PsiClass)object.getElement()) == null || (object = object.getQualifiedName()) == null) {
            return CollectionsKt.emptyList();
        }
        Object classFqn = object;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> JpaOrmEmbeddableUsagesProvider.getElements$lambda$1(JpaOrmEmbeddableUsagesProvider::getElements$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        TreeSet result = SetsKt.sortedSetOf(comparator, (Object[])new OrmEntity[0]);
        OrmUnitsProvider ormUnitsProvider = OrmUnitsProvider.Companion.getForFramework(parent.getOrmFramework());
        Intrinsics.checkNotNull((Object)ormUnitsProvider);
        for (OrmUnit unit : ormUnitsProvider.getUnits((Project)project)) {
            block1: for (OrmEntity entity : unit.getEntities()) {
                for (OrmEntityAttribute attribute : entity.getAttributes()) {
                    Intrinsics.checkNotNull((Object)attribute, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.orm.jpa.model.AbstractJpaOrmEntityAttribute");
                    AbstractJpaOrmEntityAttribute cfr_ignored_0 = (AbstractJpaOrmEntityAttribute)attribute;
                    if (!((AbstractJpaOrmEntityAttribute)attribute).isEmbedded() || !Intrinsics.areEqual((Object)attribute.getTypeFqn().getExternalFullName(), (Object)classFqn)) continue;
                    result.add(entity);
                    continue block1;
                }
            }
        }
        return CollectionsKt.toList((Iterable)result);
    }

    @NotNull
    public String getContainerName() {
        return this.containerName;
    }

    private static final String getElements$lambda$0(OrmEntity it) {
        return it.getName();
    }

    private static final String getElements$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

