/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.orm.structure;

import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.logical.model.LogicalModelPresentationProvider;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.jpa.jpb.model.JpaIcons;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.orm.model.JpaOrmEntity;
import com.intellij.jpa.util.JpaOrmUtilKt;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jpa/orm/structure/JpaOrmEntityPresentationProvider;", "Lcom/intellij/ide/structureView/logical/model/LogicalModelPresentationProvider;", "Lcom/intellij/jpa/orm/model/JpaOrmEntity;", "<init>", "()V", "getName", "", "t", "getIcon", "Ljavax/swing/Icon;", "getColoredText", "", "Lcom/intellij/ide/util/treeView/PresentableNodeDescriptor$ColoredFragment;", "handleClick", "", "fragmentIndex", "", "intellij.javaee.jpa.impl"})
public final class JpaOrmEntityPresentationProvider
extends LogicalModelPresentationProvider<JpaOrmEntity> {
    @NotNull
    public String getName(@NotNull JpaOrmEntity t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        return t.getName();
    }

    @NotNull
    public Icon getIcon(@NotNull JpaOrmEntity t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        if (t.isMappedSuperclass()) {
            Icon icon = JpaIcons.MappedSuperclass;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MappedSuperclass");
            return icon;
        }
        Icon icon = AllIcons.Javaee.PersistenceEntity;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PersistenceEntity");
        return icon;
    }

    @NotNull
    public List<PresentableNodeDescriptor.ColoredFragment> getColoredText(@NotNull JpaOrmEntity t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        List result = new ArrayList();
        result.add(new PresentableNodeDescriptor.ColoredFragment(t.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
        if (t.isMappedSuperclass()) {
            v0 = result.add(new PresentableNodeDescriptor.ColoredFragment(" @MappedSuperclass", SimpleTextAttributes.GRAYED_ATTRIBUTES));
        } else if (t.isEmbeddable()) {
            v0 = result.add(new PresentableNodeDescriptor.ColoredFragment(" @Embeddable", SimpleTextAttributes.GRAYED_ATTRIBUTES));
        } else {
            DbTable dbTable = JpaOrmUtilKt.getDbTable$default(t, null, 2, null);
            if (dbTable == null) {
                return result;
            }
            DbTable table = dbTable;
            result.add(new PresentableNodeDescriptor.ColoredFragment(" " + JpaModelBundle.message((String)"logical.orm.attribute.maps", (Object[])new Object[0]) + " ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES));
            v0 = result.add(new PresentableNodeDescriptor.ColoredFragment(table.getName(), SimpleTextAttributes.LINK_ATTRIBUTES));
        }
        return result;
    }

    public boolean handleClick(@NotNull JpaOrmEntity t, int fragmentIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        if (fragmentIndex != 2) {
            return false;
        }
        DbTable dbTable = JpaOrmUtilKt.getDbTable$default(t, null, 2, null);
        if (dbTable == null) {
            return false;
        }
        DbTable table = dbTable;
        DbNavigationUtils.navigateToDatabaseView((DbElement)((DbElement)table), (boolean)true);
        return true;
    }
}

