/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.util;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.model.common.persistence.mapping.AttributeWithColumn;
import com.intellij.jpa.model.common.persistence.mapping.Entity;
import com.intellij.jpa.orm.model.JpaOrmEntity;
import com.intellij.jpa.orm.model.JpaOrmEntityAttribute;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u001a$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"getTableName", "", "ormEntity", "Lcom/intellij/jpa/orm/model/JpaOrmEntity;", "getDbTable", "Lcom/intellij/database/psi/DbTable;", "columnTableName", "getDbColumn", "Lcom/intellij/database/psi/DbColumn;", "columnName", "ormAttribute", "Lcom/intellij/jpa/orm/model/JpaOrmEntityAttribute;", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nJpaOrmUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaOrmUtil.kt\ncom/intellij/jpa/util/JpaOrmUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n295#2,2:46\n295#2,2:48\n1#3:50\n*S KotlinDebug\n*F\n+ 1 JpaOrmUtil.kt\ncom/intellij/jpa/util/JpaOrmUtilKt\n*L\n28#1:46,2\n33#1:48,2\n*E\n"})
public final class JpaOrmUtilKt {
    @Nullable
    public static final String getTableName(@NotNull JpaOrmEntity ormEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)ormEntity), (String)"ormEntity");
        PersistentObject persistentObject = ormEntity.getPersistentEntity();
        Entity entity = persistentObject instanceof Entity ? (Entity)persistentObject : null;
        if (entity == null) {
            return null;
        }
        Entity entity2 = entity;
        Object object = entity2.getTable();
        if (object == null || (object = object.getTableName()) == null || (object = (String)object.getValue()) == null) {
            object = ormEntity.getName();
        }
        Object logicalTableName = object;
        Project project = entity2.getPsiManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PhysicalNamingStrategy physicalNamingStrategy = PhysicalNamingStrategy.Companion.getInstance(project);
        return physicalNamingStrategy.toTableName(logicalTableName);
    }

    @Nullable
    public static final DbTable getDbTable(@NotNull JpaOrmEntity ormEntity, @Nullable String columnTableName) {
        Object v6;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)ormEntity), (String)"ormEntity");
            String string = columnTableName;
            if (string == null && (string = JpaOrmUtilKt.getTableName(ormEntity)) == null) {
                return null;
            }
            String tableName = string;
            PsiClass psiClass = ormEntity.getClassPsiPointer();
            if (psiClass == null || (psiClass = (PsiClass)psiClass.getElement()) == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            Collection collection = PersistenceUtil.getDataSources((PsiClass)psiClass2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDataSources(...)");
            Collection dataSources = collection;
            PersistentObject persistentObject = ormEntity.getPersistentEntity();
            Intrinsics.checkNotNull((Object)persistentObject, (String)"null cannot be cast to non-null type com.intellij.jpa.model.common.persistence.mapping.Entity");
            GenericValue<String> genericValue = ((Entity)persistentObject).getTable().getSchema();
            String schema = genericValue != null ? (String)genericValue.getValue() : null;
            Collection<DbTable> collection2 = ORMReferencesUtil.getTableVariants(dataSources, schema);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getTableVariants(...)");
            Collection<DbTable> tableVariants = collection2;
            Iterable $this$firstOrNull$iv = tableVariants;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DbTable it = (DbTable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)tableName)) continue;
                v6 = element$iv;
                break block3;
            }
            v6 = null;
        }
        return v6;
    }

    public static /* synthetic */ DbTable getDbTable$default(JpaOrmEntity jpaOrmEntity, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return JpaOrmUtilKt.getDbTable(jpaOrmEntity, string);
    }

    @Nullable
    public static final DbColumn getDbColumn(@NotNull JpaOrmEntity ormEntity, @NotNull String columnName, @Nullable String columnTableName) {
        Object v2;
        DbTable dbTable;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)ormEntity), (String)"ormEntity");
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            DbTable dbTable2 = JpaOrmUtilKt.getDbTable(ormEntity, columnTableName);
            if (dbTable2 == null) {
                return null;
            }
            dbTable = dbTable2;
            JBIterable jBIterable = DasUtil.getColumns((DasObject)((DasObject)dbTable.getDasObject()));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getColumns(...)");
            Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DasColumn it = (DasColumn)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)columnName)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        DasColumn dasColumn = v2;
        if (dasColumn == null) {
            return null;
        }
        DasColumn dasColumn2 = dasColumn;
        DbElement dbElement = DbImplUtilCore.findElement((DbDataSource)dbTable.getDataSource(), (DasObject)((DasObject)dasColumn2));
        return dbElement instanceof DbColumn ? (DbColumn)dbElement : null;
    }

    public static /* synthetic */ DbColumn getDbColumn$default(JpaOrmEntity jpaOrmEntity, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return JpaOrmUtilKt.getDbColumn(jpaOrmEntity, string, string2);
    }

    @Nullable
    public static final DbColumn getDbColumn(@NotNull JpaOrmEntity ormEntity, @NotNull JpaOrmEntityAttribute ormAttribute) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)ormEntity), (String)"ormEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)ormAttribute), (String)"ormAttribute");
        PersistentAttribute persistentAttribute = ormAttribute.getAttribute();
        AttributeWithColumn attributeWithColumn = persistentAttribute instanceof AttributeWithColumn ? (AttributeWithColumn)persistentAttribute : null;
        if (attributeWithColumn == null) {
            return null;
        }
        AttributeWithColumn attribute = attributeWithColumn;
        Object object = attribute.getColumn();
        if (object == null || (object = object.getName()) == null || (object = (String)object.getValue()) == null) {
            object = ormAttribute.getName();
        }
        Object logicalColumnName = object;
        Project project = attribute.getPsiManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PhysicalNamingStrategy physicalNamingStrategy = PhysicalNamingStrategy.Companion.getInstance(project);
        String string2 = physicalNamingStrategy.toColumnName(logicalColumnName);
        if (string2 == null) {
            return null;
        }
        String columnName = string2;
        String string3 = (String)attribute.getColumn().getTable().getValue();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string = physicalNamingStrategy.toTableName(it);
        } else {
            string = null;
        }
        String columnTableName = string;
        return JpaOrmUtilKt.getDbColumn(ormEntity, columnName, columnTableName);
    }
}

