/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.integration;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.integration.ApplicationServerConfigurable;
import com.intellij.javaee.appServers.integration.ApplicationServersModelProvider;
import com.intellij.javaee.appServers.integration.ApplicationServersUtil;
import com.intellij.javaee.appServers.integration.impl.ApplicationServerImpl;
import com.intellij.javaee.appServers.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.appServers.serverInstances.ApplicationServersManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppServerDKsEditor
implements ApplicationServersModelProvider {
    protected static final String EMPTY_PANEL_PLACE = "empty";
    private final ApplicationServer mySelected;
    private final JBList<ApplicationServer> myServerDKs = new JBList();
    private final CardLayout myCardLayout = new CardLayout();
    private final JPanel myConfigurablePanel = new JPanel(this.myCardLayout);
    private final Map<ApplicationServer, Pair<ApplicationServerConfigurable, String>> mySKDToConfigurableMap = new HashMap<ApplicationServer, Pair<ApplicationServerConfigurable, String>>();
    private final Set<ApplicationServer> myInitialServers = new HashSet<ApplicationServer>();
    private ApplicationServersManager.ApplicationServersManagerModifiableModel myModifiableModel;
    private int myNextId = 0;
    private final List<AppServerIntegration> myIntegrations;
    private final Splitter mySplitter = new JBSplitter("AppServerDKsEditor.splitterProportion", 0.3f);
    private ApplicationServer myCurrentSelection;
    private final UserActivityWatcher myUserActivityWatcher = new UserActivityWatcher();

    public AppServerDKsEditor(List<AppServerIntegration> integrations, ApplicationServer selected) {
        this.myIntegrations = integrations;
        this.mySelected = selected;
        this.myServerDKs.setSelectionMode(0);
        this.myServerDKs.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        this.myServerDKs.getEmptyText().setText(AppServersIntegrationBundle.message((String)"not.configured", (Object[])new Object[0]));
        JPanel listPanel = this.createWestPanel();
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)listPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myConfigurablePanel);
        this.mySplitter.setPreferredSize((Dimension)JBUI.size((int)400, (int)200));
        this.trySelectElementAt(0);
        this.myUserActivityWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                AppServerDKsEditor.this.myServerDKs.repaint();
            }
        });
    }

    private JPanel createWestPanel() {
        ToolbarDecorator listDecorator = ToolbarDecorator.createDecorator(this.myServerDKs).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).disableUpDownActions().setAddActionName(AppServersIntegrationBundle.message((String)"action.description.add.application.server", (Object[])new Object[0])).setAddAction(this.createAddAction()).setRemoveActionName(AppServersIntegrationBundle.message((String)"action.description.remove.application.server", (Object[])new Object[0])).setRemoveAction((AnActionButtonRunnable)new MyRemoveAction());
        JPanel listPanel = listDecorator.createPanel();
        listPanel.setMinimumSize((Dimension)JBUI.size((int)50, (int)70));
        this.myServerDKs.setCellRenderer(BuilderKt.textListCellRenderer(o -> this.myModifiableModel.getLibrary(o).getName()));
        return listPanel;
    }

    private AnActionButtonRunnable createAddAction() {
        List<AddAction> addActions = this.createAllAddActions();
        return addActions.size() == 1 ? new ActionWrapper(addActions.get(0)) : new MultipleAddAction(addActions);
    }

    private List<AddAction> createAllAddActions() {
        ArrayList<AddAction> result = new ArrayList<AddAction>();
        for (AppServerIntegration integration : this.myIntegrations) {
            result.add(new AddAction(integration));
        }
        result.sort((o1, o2) -> o1.myIntegration.getPresentableName().compareToIgnoreCase(o2.myIntegration.getPresentableName()));
        return result;
    }

    public void reset() {
        this.mySKDToConfigurableMap.clear();
        this.myModifiableModel = this.createNewModifiableModel();
        this.refreshList();
        if (this.myServerDKs.getModel().getSize() > 0) {
            if (this.mySelected != null) {
                this.selectElementInList(((DefaultListModel)this.myServerDKs.getModel()).indexOf(this.mySelected));
            } else {
                this.selectElementInList(0);
            }
        }
    }

    private void refreshList() {
        this.myConfigurablePanel.removeAll();
        JLabel label = new JLabel(AppServersIntegrationBundle.message((String)"label.text.no.application.server.selected", (Object[])new Object[0]));
        label.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myConfigurablePanel.add((Component)panel, EMPTY_PANEL_PLACE);
        DefaultListModel<ApplicationServerImpl> model = new DefaultListModel<ApplicationServerImpl>();
        this.myServerDKs.setModel(model);
        this.myServerDKs.setCellRenderer(BuilderKt.textListCellRenderer(o -> {
            Pair<ApplicationServerConfigurable, String> pair = this.mySKDToConfigurableMap.get(o);
            return pair != null ? ((ApplicationServerConfigurable)pair.getFirst()).getCurrentServerName() : String.valueOf(o);
        }));
        ArrayList allDKs = new ArrayList(this.myModifiableModel.getCurrentList(this.myIntegrations));
        ApplicationServersUtil.sortByName(allDKs);
        for (ApplicationServer allDK : allDKs) {
            String uniqueId;
            ApplicationServerConfigurable configurable;
            ApplicationServerImpl applicationServer = (ApplicationServerImpl)allDK;
            Pair<ApplicationServerConfigurable, String> oldPair = this.mySKDToConfigurableMap.put(applicationServer, (Pair<ApplicationServerConfigurable, String>)Pair.create((Object)(configurable = applicationServer.createConfigurable(this)), (Object)(uniqueId = this.createUniqueId())));
            if (oldPair != null) {
                ((ApplicationServerConfigurable)oldPair.getFirst()).disposeUIResources();
            }
            JComponent component = configurable.createComponent();
            this.myConfigurablePanel.add((Component)component, uniqueId);
            this.myUserActivityWatcher.register((Component)component);
            configurable.reset();
            model.addElement(applicationServer);
        }
    }

    private String createUniqueId() {
        return String.valueOf(this.myNextId++);
    }

    private ApplicationServersManager.ApplicationServersManagerModifiableModel createNewModifiableModel() {
        ApplicationServersManager.ApplicationServersManagerModifiableModel modifiableModel = ApplicationServersManager.getInstance().createModifiableModel();
        this.myInitialServers.clear();
        this.myInitialServers.addAll(modifiableModel.getCurrentList(this.myIntegrations));
        return modifiableModel;
    }

    public void disposeUIResources() {
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
        }
        for (ApplicationServer applicationServer : this.mySKDToConfigurableMap.keySet()) {
            ((ApplicationServerConfigurable)this.mySKDToConfigurableMap.get(applicationServer).getFirst()).disposeUIResources();
        }
        this.mySKDToConfigurableMap.clear();
    }

    public JComponent getComponent() {
        return this.mySplitter;
    }

    @Nullable
    private ApplicationServer getCurrentSelection() {
        int selectionIndex = this.myServerDKs.getSelectionModel().getMinSelectionIndex();
        if (selectionIndex == -1) {
            return null;
        }
        return (ApplicationServer)this.myServerDKs.getModel().getElementAt(selectionIndex);
    }

    private void selectElementAt(int selectedIndex) {
        this.myCurrentSelection = (ApplicationServer)this.myServerDKs.getModel().getElementAt(selectedIndex);
        Pair<ApplicationServerConfigurable, String> pair = this.mySKDToConfigurableMap.get(this.myCurrentSelection);
        if (pair != null) {
            this.myCardLayout.show(this.myConfigurablePanel, (String)pair.getSecond());
        }
        UIUtil.setupEnclosingDialogBounds((JComponent)this.mySplitter);
    }

    private List<ApplicationServer> collectNewServerDKs() {
        ArrayList<ApplicationServer> newServerDKs = new ArrayList<ApplicationServer>();
        ListModel model = this.myServerDKs.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            newServerDKs.add((ApplicationServer)model.getElementAt(i));
        }
        return newServerDKs;
    }

    private void selectServerElement(ApplicationServerImpl newServer) {
        ListModel model = this.myServerDKs.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!newServer.equals(model.getElementAt(i))) continue;
            this.selectElementInList(i);
            return;
        }
        this.trySelectElementAt(model.getSize() - 1);
    }

    public ApplicationServer getSelectedAppliactionServer() {
        return this.myCurrentSelection;
    }

    public boolean isModified() {
        if (!this.myInitialServers.equals(this.mySKDToConfigurableMap.keySet())) {
            return true;
        }
        for (Pair<ApplicationServerConfigurable, String> pair : this.mySKDToConfigurableMap.values()) {
            if (!((ApplicationServerConfigurable)pair.getFirst()).isModified()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        this.checkServersNames();
        try {
            for (ApplicationServer applicationServer : this.mySKDToConfigurableMap.keySet()) {
                Pair<ApplicationServerConfigurable, String> pair = this.mySKDToConfigurableMap.get(applicationServer);
                ((ApplicationServerConfigurable)pair.getFirst()).apply();
            }
            ApplicationManager.getApplication().runWriteAction(() -> this.myModifiableModel.commit());
        }
        finally {
            this.myModifiableModel = this.createNewModifiableModel();
        }
    }

    private void checkServersNames() throws ConfigurationException {
        List servers = this.myModifiableModel.getCurrentList(AppServerIntegrationsManager.getInstance().getAllIntegrations());
        HashSet<String> names = new HashSet<String>();
        for (ApplicationServer server : servers) {
            String name;
            Pair<ApplicationServerConfigurable, String> pair = this.mySKDToConfigurableMap.get(server);
            if (pair != null) {
                name = ((ApplicationServerConfigurable)pair.getFirst()).getCurrentServerName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    throw new ConfigurationException(AppServersIntegrationBundle.message((String)"message.text.application.server.name.cannot.be.empty", (Object[])new Object[0]), CommonBundle.getErrorTitle());
                }
            } else {
                name = server.getName();
            }
            if (names.contains(name)) {
                throw new ConfigurationException(AppServersIntegrationBundle.message((String)"message.text.application.server.already.exists", (Object[])new Object[]{name}), CommonBundle.getErrorTitle());
            }
            names.add(name);
        }
    }

    private void trySelectElementAt(int prevSelection) {
        int size = this.myServerDKs.getModel().getSize();
        if (size == 0) {
            return;
        }
        if (prevSelection > size - 1) {
            int selectedElement = size - 1;
            this.selectElementInList(selectedElement);
        } else {
            this.selectElementInList(prevSelection);
        }
    }

    private void selectElementInList(int selectedElement) {
        this.myServerDKs.getSelectionModel().setSelectionInterval(selectedElement, selectedElement);
    }

    @Override
    public ApplicationServersManager.ApplicationServersManagerModifiableModel getApplicationServersModel() {
        return this.myModifiableModel;
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedIndex = AppServerDKsEditor.this.myServerDKs.getSelectionModel().getMinSelectionIndex();
            if (selectedIndex == -1 || AppServerDKsEditor.this.myServerDKs.getModel().getSize() <= selectedIndex) {
                return;
            }
            AppServerDKsEditor.this.selectElementAt(selectedIndex);
        }
    }

    private class MyRemoveAction
    implements AnActionButtonRunnable {
        private MyRemoveAction() {
        }

        public void run(AnActionButton button) {
            int prevSelection = AppServerDKsEditor.this.myServerDKs.getSelectionModel().getMinSelectionIndex();
            ApplicationServer currentSelection = AppServerDKsEditor.this.getCurrentSelection();
            if (currentSelection != null) {
                AppServerDKsEditor.this.myModifiableModel.deleteApplicationServer(currentSelection);
                Pair<ApplicationServerConfigurable, String> pair = AppServerDKsEditor.this.mySKDToConfigurableMap.remove(currentSelection);
                if (pair != null) {
                    ((ApplicationServerConfigurable)pair.getFirst()).disposeUIResources();
                }
                AppServerDKsEditor.this.refreshList();
                AppServerDKsEditor.this.trySelectElementAt(prevSelection);
            }
        }
    }

    private static class ActionWrapper
    implements AnActionButtonRunnable {
        private final AddAction myAction;

        ActionWrapper(AddAction action) {
            this.myAction = action;
        }

        public void run(AnActionButton button) {
            this.myAction.perform();
        }
    }

    private class AddAction
    extends AnAction
    implements DumbAware {
        private final AppServerIntegration myIntegration;

        AddAction(AppServerIntegration integration) {
            super(integration.getPresentableName(), null, integration.getIcon());
            this.myIntegration = integration;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            this.perform();
        }

        void perform() {
            ApplicationServerImpl newServer = ApplicationServersUtil.createNewApplicationServer(this.myIntegration, AppServerDKsEditor.this.myModifiableModel, AppServerDKsEditor.this.collectNewServerDKs(), (JPanel)AppServerDKsEditor.this.mySplitter);
            if (newServer != null) {
                ApplicationServerConfigurable configurable = newServer.createConfigurable(AppServerDKsEditor.this);
                Pair pair = Pair.create((Object)configurable, (Object)AppServerDKsEditor.this.createUniqueId());
                AppServerDKsEditor.this.mySKDToConfigurableMap.put(newServer, (Pair<ApplicationServerConfigurable, String>)pair);
                AppServerDKsEditor.this.myConfigurablePanel.add((Component)configurable.createComponent(), pair.getSecond());
                AppServerDKsEditor.this.refreshList();
                AppServerDKsEditor.this.selectServerElement(newServer);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/appServers/integration/AppServerDKsEditor$AddAction", "actionPerformed"));
        }
    }

    private static class MultipleAddAction
    implements AnActionButtonRunnable {
        private final List<AddAction> myActions;

        MultipleAddAction(List<AddAction> actions) {
            this.myActions = actions;
        }

        public void run(AnActionButton button) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction anAction : this.myActions) {
                group.add(anAction);
            }
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            ListPopup listPopup = popupFactory.createActionGroupPopup(AppServersIntegrationBundle.message((String)"action.description.add.application.server", (Object[])new Object[0]), (ActionGroup)group, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), false, false, false, null, -1, Conditions.alwaysTrue());
            listPopup.show(button.getPreferredPopupPoint());
        }
    }
}

