/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.configuration.view;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.deployment.DeploymentView;
import com.intellij.javaee.appServers.deployment.DeploymentViewEx;
import com.intellij.javaee.appServers.ex.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.configuration.view.JavaeeDeploymentActionConsoleContext;
import com.intellij.javaee.appServers.run.configuration.view.JavaeeDeploymentActionContext;
import com.intellij.javaee.appServers.run.execution.ConsoleViewWrapper;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.appServers.run.execution.JavaeeConsoleView;
import com.intellij.javaee.appServers.serverInstances.DefaultServerInstance;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EdtNoGetDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaeeConsoleViewImpl
extends ConsoleViewWrapper
implements ExecutionConsoleEx,
JavaeeConsoleView,
ObservableConsoleView {
    @NonNls
    private static final String DEPLOYMENT_VIEW_ID = "ConsoleViewWrapperDeployment";
    private final DeploymentViewEx myDeploymentView;
    private final AppServerIntegration myIntegration;
    private final J2EEProcess myJ2EEProcess;
    private final Executor myExecutor;

    public JavaeeConsoleViewImpl(Project project, CommonStrategy commonStrategy, J2EEProcess j2eeProcess, Executor executor, ConsoleView plainConsole) {
        super(plainConsole);
        this.myJ2EEProcess = j2eeProcess;
        this.myIntegration = commonStrategy.getIntegration();
        this.myExecutor = executor;
        this.myDeploymentView = DeploymentManagerEx.getInstanceEx(project).createDeploymentView(this.myIntegration, commonStrategy, j2eeProcess.getServerInstance());
        Disposer.register((Disposable)this, (Disposable)this.myDeploymentView);
    }

    public void buildUi(RunnerLayoutUi layoutUi) {
        boolean isDebug = this.myExecutor.getId().equals("Debug");
        int tabIndex = isDebug ? 1 : 0;
        layoutUi.getDefaults().initTabDefaults(tabIndex, AppServersIntegrationBundle.message((String)"run.tab.title.server", (Object[])new Object[0]), this.myIntegration.getIcon());
        Content output = layoutUi.createContent("ConsoleContent", this.getComponent(), AppServersIntegrationBundle.message((String)"run.tab.title.output", (Object[])new Object[0]), null, this.getPreferredFocusableComponent());
        output.setActions((ActionGroup)new DefaultActionGroup(this.createConsoleActions()), "unknown", this.getComponent());
        layoutUi.addContent(output, tabIndex, PlaceInGrid.center, false);
        output.setCloseable(false);
        Content deployment = layoutUi.createContent(DEPLOYMENT_VIEW_ID, this.myDeploymentView.getComponent(), AppServersIntegrationBundle.message((String)"run.tab.title.deployment", (Object[])new Object[0]), null, null);
        deployment.setHelpId(this.myDeploymentView.getHelpId());
        deployment.setActions((ActionGroup)this.myDeploymentView.createActionGroup(), "unknown", this.myDeploymentView.getComponent());
        deployment.setCloseable(false);
        layoutUi.addContent(deployment, tabIndex, PlaceInGrid.left, false);
        layoutUi.getOptions().setMoveToGridActionEnabled(true);
        JavaeeConsoleViewImpl.registerConsoleView(layoutUi, this);
    }

    public static void registerConsoleView(RunnerLayoutUi layoutUi, JavaeeConsoleView consoleView) {
        layoutUi.getContentManager().addDataProvider((DataProvider)((EdtNoGetDataProvider)sink -> {
            sink.set(KEY, (Object)consoleView);
            sink.set(JavaeeDeploymentActionContext.KEY, (Object)new JavaeeDeploymentActionConsoleContext(consoleView));
        }));
        J2EEServerInstance serverInstance = consoleView.getServerInstance();
        if (serverInstance instanceof DefaultServerInstance) {
            ((DefaultServerInstance)serverInstance).registerAdditionalContent(layoutUi);
        }
    }

    @NotNull
    public String getExecutionConsoleId() {
        return "JAVAEE_CONSOLE";
    }

    public JComponent getPreferredFocusableComponent() {
        return this.getComponent();
    }

    public ProcessHandler getProcessHandler() {
        return (ProcessHandler)this.myJ2EEProcess;
    }

    public DeploymentView getDeploymentView() {
        return this.myDeploymentView;
    }

    public J2EEServerInstance getServerInstance() {
        return this.myJ2EEProcess.getServerInstance();
    }

    public AppServerIntegration getIntegration() {
        return this.myIntegration;
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        ConsoleView delegate;
        if (listener == null) {
            JavaeeConsoleViewImpl.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            JavaeeConsoleViewImpl.$$$reportNull$$$0(1);
        }
        if ((delegate = this.getDelegate()) instanceof ObservableConsoleView) {
            ((ObservableConsoleView)delegate).addChangeListener(listener, parent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/appServers/run/configuration/view/JavaeeConsoleViewImpl";
        objectArray[2] = "addChangeListener";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

