/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.oss.util.FileWrapper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.lang.HashMapZipFile;
import com.intellij.util.lang.ImmutableZipEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DirectoryScanner {
    @Nullable
    private final Pattern pattern;
    @NotNull
    private static final Logger LOG = Logger.getInstance(DirectoryScanner.class);

    protected DirectoryScanner(@NonNls String pattern) {
        this.pattern = pattern == null ? null : Pattern.compile(pattern);
    }

    public void scan(@NonNls String dir, Class<?> ref) {
        try {
            Path base = PathManager.getJarForClass(ref);
            assert (base != null);
            if (Files.isDirectory(base, new LinkOption[0])) {
                this.scanDirectory(base, dir);
            } else if (Files.exists(base, new LinkOption[0])) {
                this.scanArchive(base, dir);
            }
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    private void scanDirectory(@NotNull Path base, String dir) {
        List files;
        if (base == null) {
            DirectoryScanner.$$$reportNull$$$0(0);
        }
        if ((files = NioFiles.list((Path)base.resolve(dir))).isEmpty()) {
            return;
        }
        for (final Path file : files) {
            String fileName = file.getFileName().toString();
            if (this.pattern != null && !this.pattern.matcher(fileName).matches()) continue;
            try {
                this.handle(new FileWrapper(fileName, "/" + dir + "/" + fileName){

                    @Override
                    public InputStream getStream() throws IOException {
                        return Files.newInputStream(file, new OpenOption[0]);
                    }
                });
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    private void scanArchive(@NotNull Path base, String dir) throws Exception {
        if (base == null) {
            DirectoryScanner.$$$reportNull$$$0(1);
        }
        try (final HashMapZipFile zip = HashMapZipFile.load((Path)base);){
            for (final ImmutableZipEntry entry : zip.getEntries()) {
                String name = entry.getName();
                if (!name.startsWith(dir)) continue;
                name = entry.getName().substring(name.lastIndexOf(47) + 1);
                if (this.pattern != null && !this.pattern.matcher(name).matches()) continue;
                try {
                    this.handle(new FileWrapper(entry.getName().replaceFirst("(?:.*/)?(.*)", "$1"), "/" + entry.getName()){

                        @Override
                        public InputStream getStream() throws IOException {
                            return entry.getInputStream(zip);
                        }
                    });
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
            }
        }
    }

    protected abstract void handle(@NotNull FileWrapper var1) throws Exception;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "base";
        objectArray2[1] = "com/intellij/javaee/oss/util/DirectoryScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scanDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scanArchive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

