/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.bdd;

import com.intellij.rml.dfa.impl.bdd.BitsKt;

public final class BddNodeLookupTable {
    private long[] key;
    private int[] value;
    private int mask;
    private int n;
    private int maxFill;
    private int size;
    private final float f;

    public BddNodeLookupTable(int initial, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (initial < 0) {
            throw new IllegalArgumentException("The initial number of elements must be non-negative");
        }
        this.f = f;
        this.n = BitsKt.nextPowerOfTwo(initial);
        this.mask = this.n - 1;
        this.maxFill = BddNodeLookupTable.maxFill(this.n, f);
        this.key = new long[this.n];
        this.value = new int[this.n];
    }

    public int getCapacity() {
        return this.n;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getOrPut(long k, int v) {
        if (k == 0L) {
            throw new IllegalArgumentException("Null (0) key is not allowed");
        }
        k = BitsKt.mixBits(k);
        int hash = (int)k;
        int mask = this.mask;
        long[] key = this.key;
        int pos = hash & mask;
        long curr = key[pos];
        while (curr != k) {
            if (curr == 0L) {
                return this.insert(pos, k, v);
            }
            pos = pos + 1 & mask;
            curr = key[pos];
        }
        return this.value[pos];
    }

    private int insert(int pos, long k, int v) {
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(this.n << 1);
        }
        return v;
    }

    private void rehash(int newN) {
        long[] key = this.key;
        int[] value = this.value;
        int mask = newN - 1;
        long[] newKey = new long[newN];
        int[] newValue = new int[newN];
        int i = this.n;
        int j = this.size;
        while (j-- != 0) {
            while (key[--i] == 0L) {
            }
            int hash = (int)key[i];
            int pos = hash & mask;
            if (newKey[pos] != 0L) {
                while (newKey[pos = pos + 1 & mask] != 0L) {
                }
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = BddNodeLookupTable.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    private static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }
}

