/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ir.cfg;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl;
import com.intellij.rml.dfa.impl.ir.cfg.IrCfgRegionBuilderImpl;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrCfgBuilder;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J(\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\f\u00a8\u0006\""}, d2={"Lcom/intellij/rml/dfa/impl/ir/cfg/IrCfgBuilderImpl;", "Lcom/intellij/rml/dfa/impl/ir/cfg/IrCfgRegionBuilderImpl;", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgBuilder;", "<init>", "()V", "lastAddedBlock", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "getLastAddedBlock", "()Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "startBlock", "getStartBlock", "setStartBlock", "(Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;)V", "exitBlock", "getExitBlock", "setExitBlock", "addSubgraph", "", "cfg", "Lcom/intellij/rml/dfa/ir/cfg/IrCfg;", "addBlock", "createBlock", "setJump", "from", "jump", "Lcom/intellij/rml/dfa/ir/cfg/IrJump;", "setUnconditionalJump", "to", "setConditionalJump", "trueBranch", "falseBranch", "condition", "Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "build", "intellij.rml.dfa.impl"})
public final class IrCfgBuilderImpl
extends IrCfgRegionBuilderImpl
implements IrCfgBuilder {
    @Nullable
    private IrCFGBlock startBlock;
    @Nullable
    private IrCFGBlock exitBlock;

    @NotNull
    public IrCFGBlock getLastAddedBlock() {
        return this.getLastBlock();
    }

    @Nullable
    public IrCFGBlock getStartBlock() {
        return this.startBlock;
    }

    public void setStartBlock(@Nullable IrCFGBlock irCFGBlock) {
        this.startBlock = irCFGBlock;
    }

    @Nullable
    public IrCFGBlock getExitBlock() {
        return this.exitBlock;
    }

    public void setExitBlock(@Nullable IrCFGBlock irCFGBlock) {
        this.exitBlock = irCFGBlock;
    }

    public void addSubgraph(@NotNull IrCfg cfg2) {
        Intrinsics.checkNotNullParameter((Object)cfg2, (String)"cfg");
        CollectionsKt.addAll((Collection)this.getBlocks(), (Iterable)cfg2.getBlocks());
        this.getJumps().putAll(cfg2.getJumps());
        this.setUnconditionalJump(this.getLastBlock(), cfg2.getStartBlock());
        this.createBlock();
        this.setUnconditionalJump(cfg2.getExitBlock(), this.getLastBlock());
    }

    @NotNull
    public IrCFGBlock addBlock() {
        if (this.getLastBlock().getInstructions().isEmpty()) {
            return this.getLastBlock();
        }
        IrCFGBlockImpl newExitBlock = new IrCFGBlockImpl(null, 1, null);
        this.getJumps().put(this.getLastBlock(), (IrJump)new IrUnconditionalJump((IrCFGBlock)newExitBlock));
        ((Collection)this.getBlocks()).add(newExitBlock);
        this.setLastBlock(newExitBlock);
        return newExitBlock;
    }

    @NotNull
    public IrCFGBlock createBlock() {
        IrCFGBlockImpl irCFGBlockImpl;
        IrCFGBlockImpl it = irCFGBlockImpl = new IrCFGBlockImpl(null, 1, null);
        boolean bl = false;
        ((Collection)this.getBlocks()).add(it);
        this.setLastBlock(it);
        return irCFGBlockImpl;
    }

    public void setJump(@NotNull IrCFGBlock from, @NotNull IrJump jump) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        if (this.getJumps().containsKey(from)) {
            throw new DfaInternalException("Jump from block \n" + from + "\n already exists");
        }
        this.getJumps().put(from, jump);
    }

    public void setUnconditionalJump(@NotNull IrCFGBlock from, @NotNull IrCFGBlock to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.setJump(from, (IrJump)new IrUnconditionalJump(to));
    }

    public void setConditionalJump(@NotNull IrCFGBlock from, @NotNull IrCFGBlock trueBranch, @NotNull IrCFGBlock falseBranch, @NotNull IrCondition condition) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)trueBranch, (String)"trueBranch");
        Intrinsics.checkNotNullParameter((Object)falseBranch, (String)"falseBranch");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.setJump(from, (IrJump)new IrConditionalJump(condition, trueBranch, falseBranch));
    }

    @Override
    @NotNull
    public IrCfg build() {
        IrCFGBlock irCFGBlock;
        Set set = CollectionsKt.toSet((Iterable)this.getBlocks());
        Map<IrCFGBlock, IrJump> map2 = this.getJumps();
        IrCFGBlock irCFGBlock2 = this.getStartBlock();
        if (irCFGBlock2 == null) {
            irCFGBlock2 = (IrCFGBlock)CollectionsKt.first(this.getBlocks());
        }
        if ((irCFGBlock = this.getExitBlock()) == null) {
            irCFGBlock = this.getLastBlock();
        }
        return new IrCfg(set, map2, irCFGBlock2, irCFGBlock);
    }
}

