/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.dsl.translator;

import com.intellij.rml.dfa.RmlParseException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.rml.dsl.ast.RmlDeclarationType;
import com.intellij.rml.dfa.rml.dsl.ast.RmlOption;
import com.intellij.rml.dfa.rml.dsl.ast.RmlProgram;
import com.intellij.rml.dfa.rml.dsl.ast.RmlRelationDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J*\u0010\f\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer;", "", "manager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "<init>", "(Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;)V", "initialize", "", "program", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlProgram;", "processOptions", "processDeclarations", "addDeclaration", "decl", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlRelationDeclaration;", "type", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlDeclarationType;", "domainTypes", "", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nVariableManagerInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableManagerInitializer.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n1863#2,2:47\n37#3,2:49\n*S KotlinDebug\n*F\n+ 1 VariableManagerInitializer.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/VariableManagerInitializer\n*L\n26#1:47,2\n43#1:49,2\n*E\n"})
public final class VariableManagerInitializer {
    @NotNull
    private final VariablesManager manager;

    public VariableManagerInitializer(@NotNull VariablesManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    public final void initialize(@NotNull RmlProgram program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        this.processDeclarations(program);
        this.processOptions(program);
    }

    private final void processOptions(RmlProgram program) {
        for (RmlOption option : program.getOptions()) {
            this.manager.addOption(option.getName(), option.getDefaultValue(), option.getType().ordinal());
        }
    }

    private final void processDeclarations(RmlProgram program) {
        for (RmlDeclarationType type : RmlDeclarationType.getEntries()) {
            Object v = program.getDeclarations().get(type);
            Intrinsics.checkNotNull(v);
            for (RmlRelationDeclaration decl : (List)v) {
                List domainTypes = new ArrayList();
                Iterable $this$forEach$iv = decl.getDomainTypes();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KClass klass = (KClass)element$iv;
                    boolean bl = false;
                    DomainType domainType = this.manager.getTypeManager().getDomainType(klass);
                    domainTypes.add(domainType);
                }
                this.addDeclaration(this.manager, decl, type, domainTypes);
                String subgroup = (String)program.getRelationSubgroups().get(decl.getRelationName());
                if (subgroup == null) continue;
                this.manager.setRelationSubgroup(decl.getRelationName(), subgroup);
            }
        }
    }

    private final void addDeclaration(VariablesManager $this$addDeclaration, RmlRelationDeclaration decl, RmlDeclarationType type, List<? extends DomainType> domainTypes) {
        if ($this$addDeclaration.containsRelation(decl.getRelationName())) {
            throw new RmlParseException("Redeclared " + type + " relation " + decl.getRelationName(), null, 2, null);
        }
        Collection $this$toTypedArray$iv = domainTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$addDeclaration.addRelationDeclaration(type, new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])), decl.getModifications());
    }
}

