/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rml.dfa.AnalysisPass;
import com.intellij.rml.dfa.DfaEvaluationStatus;
import com.intellij.rml.dfa.PathSensitiveMode;
import com.intellij.rml.dfa.impl.DfaEvaluationEvent;
import com.intellij.rml.dfa.impl.DfaFailedException;
import com.intellij.rml.dfa.impl.DfaFunctionEvaluationBaseEvent;
import com.intellij.rml.dfa.impl.DfaFunctionEvaluationEvent;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IImmutableRelation;
import com.intellij.rml.dfa.impl.rml.profiler.tree.IProfileNode;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryEvaluationEvent;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryEvaluationObserver;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryFunctionEvaluationBaseEvent;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryFunctionEvaluationEvent;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u000234B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J6\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J'\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000f2\b\u0010)\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020,H\u0002J\u001a\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u00102\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/SummaryLogObserver;", "Lcom/intellij/rml/dfa/impl/summaries/DfaSummaryEvaluationObserver;", "<init>", "()V", "logToCsv", "", "eventStats", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/rml/dfa/impl/summaries/SummaryLogObserver$EventStatistics;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "numOfFunctions", "", "processedFunctionsCnt", "startMillis", "", "start", "", "event", "Lcom/intellij/rml/dfa/impl/DfaEvaluationEvent;", "handleEvent", "name", "", "mode", "Lcom/intellij/rml/dfa/AnalysisPass;", "provider", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;", "summaryProviders", "", "startTime", "functionAnalysisFinished", "Lcom/intellij/rml/dfa/impl/DfaFunctionEvaluationEvent;", "functionAnalysisFailed", "Lcom/intellij/rml/dfa/impl/DfaFunctionEvaluationBaseEvent;", "exception", "Lcom/intellij/rml/dfa/impl/DfaFailedException;", "intermediateTasksCompleted", "intermediateProvider", "intermediateSummaryProvider", "afterAllPasses", "globalProvider", "storageSize", "(Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;JLjava/lang/Long;)V", "toCsvFile", "Ljava/io/File;", "finish", "status", "Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "profilerTree", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/IProfileNode;", "getReachableSizeBytes", "EventStatistics", "Companion", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nSummaryLogObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryLogObserver.kt\ncom/intellij/rml/dfa/impl/summaries/SummaryLogObserver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,141:1\n1#2:142\n11165#3:143\n11500#3,3:144\n*S KotlinDebug\n*F\n+ 1 SummaryLogObserver.kt\ncom/intellij/rml/dfa/impl/summaries/SummaryLogObserver\n*L\n133#1:143\n133#1:144,3\n*E\n"})
public final class SummaryLogObserver
implements DfaSummaryEvaluationObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean logToCsv = Registry.Companion.is("rml.dfa.log.to.csv.file", false);
    @NotNull
    private final ConcurrentList<EventStatistics> eventStats;
    private int numOfFunctions;
    private int processedFunctionsCnt;
    private long startMillis;
    @NotNull
    private static final Logger LOG;

    public SummaryLogObserver() {
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.eventStats = concurrentList;
    }

    @Override
    public void start(@NotNull DfaEvaluationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.eventStats.clear();
        this.numOfFunctions = ((DfaSummaryEvaluationEvent)event).getCallGraph().getNodesCnt();
        this.processedFunctionsCnt = 0;
        LOG.warn("First pass");
        this.startMillis = System.currentTimeMillis();
    }

    private final void handleEvent(String name, AnalysisPass mode, RMLInstancesProvider provider, List<? extends RMLInstancesProvider> summaryProviders, long startTime) {
        long l;
        long l2;
        long l3;
        long l4;
        RMLInstancesProvider it;
        long l5;
        Iterable iterable = CollectionsKt.plus((Collection)summaryProviders, (Object)provider);
        Long l6 = System.currentTimeMillis() - startTime;
        AnalysisPass analysisPass = mode;
        String string = name;
        long l7 = 0L;
        for (Object t : iterable) {
            RMLInstancesProvider rMLInstancesProvider = (RMLInstancesProvider)t;
            l5 = l7;
            boolean bl = false;
            l4 = it.getBddOperationsCnt();
            l7 = l5 + l4;
        }
        l5 = l7;
        iterable = summaryProviders;
        l4 = provider.getBddMemoryStat().getAmortizedTotalBytes();
        l7 = 0L;
        for (Object t : iterable) {
            it = (RMLInstancesProvider)t;
            l3 = l7;
            boolean bl = false;
            l2 = it.getBddMemoryStat().getAmortizedTotalBytes();
            l7 = l3 + l2;
        }
        l3 = l7;
        iterable = summaryProviders;
        l2 = this.getReachableSizeBytes(provider);
        l7 = 0L;
        for (Object t : iterable) {
            it = (RMLInstancesProvider)t;
            l = l7;
            boolean bl = false;
            long l8 = this.getReachableSizeBytes(it);
            l7 = l + l8;
        }
        long l9 = l = l7;
        long l10 = l2;
        long l11 = l3;
        long l12 = l4;
        long l13 = l5;
        Long l14 = l6;
        AnalysisPass analysisPass2 = analysisPass;
        String string2 = string;
        EventStatistics event = new EventStatistics(string2, analysisPass2, l14, l13, l12, l11, l10, l9);
        ((Collection)this.eventStats).add(event);
        int n = this.processedFunctionsCnt;
        this.processedFunctionsCnt = n + 1;
        FormatHelperKt.logProgress((int)n, (int)this.numOfFunctions, (long)this.startMillis);
    }

    @Override
    public void functionAnalysisFinished(@NotNull DfaFunctionEvaluationEvent event, long startTime) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DfaSummaryFunctionEvaluationEvent cfr_ignored_0 = (DfaSummaryFunctionEvaluationEvent)event;
        String string = event.getFunction().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Object[] objectArray = new RMLInstancesProvider[]{((DfaSummaryFunctionEvaluationEvent)event).getSummaryProvider(), ((DfaSummaryFunctionEvaluationEvent)event).getForSecondPassProvider()};
        this.handleEvent(string, ((DfaSummaryFunctionEvaluationEvent)event).getPass(), event.getProvider(), CollectionsKt.listOf((Object[])objectArray), startTime);
    }

    @Override
    public void functionAnalysisFailed(@NotNull DfaFunctionEvaluationBaseEvent event, @NotNull DfaFailedException exception) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        DfaSummaryFunctionEvaluationBaseEvent cfr_ignored_0 = (DfaSummaryFunctionEvaluationBaseEvent)event;
        Collection collection = (Collection)this.eventStats;
        String string = event.getFunction().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        collection.add(new EventStatistics(string, ((DfaSummaryFunctionEvaluationBaseEvent)event).getPass(), null, 0L, 0L, 0L, 0L, 0L));
        int n = this.processedFunctionsCnt;
        this.processedFunctionsCnt = n + 1;
        FormatHelperKt.logProgress((int)n, (int)this.numOfFunctions, (long)this.startMillis);
        if (((DfaSummaryFunctionEvaluationBaseEvent)event).getMode() == PathSensitiveMode.PathSensitive) {
            LOG.warn(event.getFunction() + ": failed to perform path-sensitive DFA, reason: " + exception);
        } else {
            LOG.warn(event.getFunction() + ": failed to perform path-insensitive DFA, reason: " + exception);
        }
    }

    @Override
    public void intermediateTasksCompleted(@NotNull DfaEvaluationEvent event, @NotNull RMLInstancesProvider intermediateProvider, @NotNull RMLInstancesProvider intermediateSummaryProvider, long startTime) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)intermediateProvider, (String)"intermediateProvider");
        Intrinsics.checkNotNullParameter((Object)intermediateSummaryProvider, (String)"intermediateSummaryProvider");
        this.handleEvent("Intermediate tasks", AnalysisPass.IntermediatePass, intermediateProvider, CollectionsKt.listOf((Object)intermediateSummaryProvider), startTime);
        LOG.warn("Second pass");
        this.startMillis = System.currentTimeMillis();
        this.processedFunctionsCnt = 0;
    }

    @Override
    public void afterAllPasses(@NotNull RMLInstancesProvider globalProvider, long startTime, @Nullable Long storageSize) {
        long l;
        long l2;
        long l3;
        long l4;
        EventStatistics it;
        long l5;
        Intrinsics.checkNotNullParameter((Object)globalProvider, (String)"globalProvider");
        Iterable iterable = (Iterable)this.eventStats;
        Long l6 = System.currentTimeMillis() - startTime;
        AnalysisPass analysisPass = null;
        String string = "Total";
        long l7 = 0L;
        for (Object t : iterable) {
            EventStatistics eventStatistics = (EventStatistics)t;
            l5 = l7;
            boolean bl = false;
            l4 = it.getOperationsCnt();
            l7 = l5 + l4;
        }
        l5 = l7;
        iterable = (Iterable)this.eventStats;
        l5 += globalProvider.getBddOperationsCnt();
        l7 = 0L;
        for (Object t : iterable) {
            it = (EventStatistics)t;
            l4 = l7;
            boolean bl = false;
            l3 = it.getLocalBddSize();
            l7 = l4 + l3;
        }
        l4 = l7;
        iterable = (Iterable)this.eventStats;
        l7 = 0L;
        for (Object t : iterable) {
            it = (EventStatistics)t;
            l3 = l7;
            boolean bl = false;
            l2 = it.getSummaryBddSize();
            l7 = l3 + l2;
        }
        l3 = l7;
        iterable = (Iterable)this.eventStats;
        l3 += globalProvider.getBddMemoryStat().getAmortizedTotalBytes();
        l7 = 0L;
        for (Object t : iterable) {
            it = (EventStatistics)t;
            l2 = l7;
            boolean bl = false;
            l = it.getLocalReachableSize();
            l7 = l2 + l;
        }
        l2 = l7;
        iterable = (Iterable)this.eventStats;
        l7 = 0L;
        for (Object t : iterable) {
            it = (EventStatistics)t;
            l = l7;
            boolean bl = false;
            long l8 = it.getSummaryReachableSize();
            l7 = l + l8;
        }
        l = l7;
        long l9 = l + this.getReachableSizeBytes(globalProvider);
        long l10 = l2;
        long l11 = l3;
        long l12 = l4;
        long l13 = l5;
        Long l14 = l6;
        AnalysisPass analysisPass2 = analysisPass;
        String string2 = string;
        EventStatistics event = new EventStatistics(string2, analysisPass2, l14, l13, l12, l11, l10, l9);
        LOG.warn(event.toString());
        ((Collection)this.eventStats).add(event);
        if (storageSize != null) {
            LOG.warn("Storage files size: " + FormatHelperKt.formatMemorySize$default((long)storageSize, (int)0, (int)2, null));
        }
        if (this.logToCsv) {
            LOG.warn("Statistics was logged to " + this.toCsvFile().getAbsolutePath());
        }
    }

    private final File toCsvFile() {
        File file = FileUtil.createTempFile((String)"dfa-profile", (String)".csv");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File file2 = file;
        StringBuilder csvBuilder = new StringBuilder();
        csvBuilder.append(EventStatistics.Companion.getCsvHeader()).append("\n");
        for (EventStatistics eventStat : this.eventStats) {
            csvBuilder.append(eventStat.toCsv()).append("\n");
        }
        FileUtil.writeToFile((File)file2, (String)csvBuilder.toString());
        return file2;
    }

    @Override
    public void finish(@NotNull DfaEvaluationStatus status, @Nullable IProfileNode profilerTree) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
    }

    /*
     * WARNING - void declaration
     */
    private final long getReachableSizeBytes(RMLInstancesProvider provider) {
        void $this$mapTo$iv$iv;
        String[] $this$map$iv = provider.getRelationsRepository().getAvailableRelations();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(provider.getRelationsRepository().getRelation((String)it));
        }
        Iterable iterable = (List)destination$iv$iv;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            IImmutableRelation iImmutableRelation = (IImmutableRelation)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getNumOfBDDNodes();
            l = l2 + l3;
        }
        return l * (long)8;
    }

    static {
        Logger logger = Logger.getInstance((String)SummaryLogObserver.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/SummaryLogObserver$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0018\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u0006\u0010\u001d\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/SummaryLogObserver$EventStatistics;", "", "name", "", "pass", "Lcom/intellij/rml/dfa/AnalysisPass;", "duration", "", "operationsCnt", "localBddSize", "summaryBddSize", "localReachableSize", "summaryReachableSize", "<init>", "(Ljava/lang/String;Lcom/intellij/rml/dfa/AnalysisPass;Ljava/lang/Long;JJJJJ)V", "getName", "()Ljava/lang/String;", "getPass", "()Lcom/intellij/rml/dfa/AnalysisPass;", "getDuration", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getOperationsCnt", "()J", "getLocalBddSize", "getSummaryBddSize", "getLocalReachableSize", "getSummaryReachableSize", "toString", "toCsv", "Companion", "intellij.rml.dfa.impl"})
    public static final class EventStatistics {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @Nullable
        private final AnalysisPass pass;
        @Nullable
        private final Long duration;
        private final long operationsCnt;
        private final long localBddSize;
        private final long summaryBddSize;
        private final long localReachableSize;
        private final long summaryReachableSize;

        public EventStatistics(@NotNull String name, @Nullable AnalysisPass pass, @Nullable Long duration, long operationsCnt, long localBddSize, long summaryBddSize, long localReachableSize, long summaryReachableSize) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.pass = pass;
            this.duration = duration;
            this.operationsCnt = operationsCnt;
            this.localBddSize = localBddSize;
            this.summaryBddSize = summaryBddSize;
            this.localReachableSize = localReachableSize;
            this.summaryReachableSize = summaryReachableSize;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final AnalysisPass getPass() {
            return this.pass;
        }

        @Nullable
        public final Long getDuration() {
            return this.duration;
        }

        public final long getOperationsCnt() {
            return this.operationsCnt;
        }

        public final long getLocalBddSize() {
            return this.localBddSize;
        }

        public final long getSummaryBddSize() {
            return this.summaryBddSize;
        }

        public final long getLocalReachableSize() {
            return this.localReachableSize;
        }

        public final long getSummaryReachableSize() {
            return this.summaryReachableSize;
        }

        @NotNull
        public String toString() {
            Object object = this.pass;
            if (object == null) {
                object = "";
            }
            return this.name + ": " + object + (String)(this.duration != null ? "finished (" + FormatHelperKt.formatDuration$default((long)this.duration, (int)0, (int)2, null) : "failed") + ": BDD size: " + FormatHelperKt.formatMemorySize$default((long)this.summaryBddSize, (int)0, (int)2, null) + "/" + FormatHelperKt.formatMemorySize$default((long)this.localBddSize, (int)0, (int)2, null) + " (" + FormatHelperKt.formatMemorySize$default((long)this.summaryReachableSize, (int)0, (int)2, null) + "/" + FormatHelperKt.formatMemorySize$default((long)this.localReachableSize, (int)0, (int)2, null) + ")";
        }

        @NotNull
        public final String toCsv() {
            Long l = this.duration;
            return this.name + ", " + this.pass + ", " + (l != null ? l : 0L) + ", " + this.operationsCnt + ", " + this.localBddSize + ", " + this.summaryBddSize + ", " + this.localReachableSize + ", " + this.summaryReachableSize;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/SummaryLogObserver$EventStatistics$Companion;", "", "<init>", "()V", "getCsvHeader", "", "intellij.rml.dfa.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getCsvHeader() {
                return "Name, Mode, Duration, OperationsCnt, LocalBddSize, SummaryBddSize, LocalReachableSize, SummaryReachableSize";
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

