/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.symtable;

import com.intellij.openapi.util.Pair;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.IntAttribute;
import com.intellij.rml.dfa.impl.WrongAttributeException;
import com.intellij.rml.dfa.impl.domains.AttributesInfo;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.providers.RmlProviderDescriptor;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import java.io.DataInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\f\b\u0016\u0018\u0000 (2\u00020\u0001:\u0001(B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b\u0012\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00070\u000b\u0012&\u0010\u0010\u001a\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00120\u0007\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\fH\u0016J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u001f\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u000fH\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010$\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0010\u001a\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00120\u0007\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lcom/intellij/rml/dfa/impl/symtable/ImmutableSymbolTable;", "Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "descriptor", "Lcom/intellij/rml/dfa/impl/providers/RmlProviderDescriptor;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "domainTypeInfos", "", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "Lcom/intellij/rml/dfa/impl/domains/AttributesInfo;", "attributes", "", "Lcom/intellij/rml/dfa/attributes/Attribute;", "backwardMap", "", "", "attributeSources", "", "Lcom/intellij/openapi/util/Pair;", "<init>", "(Lcom/intellij/rml/dfa/impl/providers/RmlProviderDescriptor;Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;Ljava/util/Map;Ljava/util/List;Ljava/util/List;[Ljava/util/Map;)V", "getTypeManager", "()Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "getAttributeSources", "()[Ljava/util/Map;", "[Ljava/util/Map;", "getAttributesInfo", "type", "containsAttribute", "", "domainTypeIndex", "attribute", "getAttributeInt", "getAttributeIntOrNull", "(Lcom/intellij/rml/dfa/impl/domains/DomainType;Ljava/lang/String;)Ljava/lang/Integer;", "getAttribute", "domainType", "value", "getAttributes", "toString", "Companion", "intellij.rml.dfa.impl"})
public class ImmutableSymbolTable
implements SymbolTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RmlProviderDescriptor descriptor;
    @NotNull
    private final DomainTypeManager typeManager;
    @NotNull
    private final Map<DomainType, AttributesInfo> domainTypeInfos;
    @NotNull
    private final List<List<Attribute>> attributes;
    @NotNull
    private final List<Map<String, Integer>> backwardMap;
    @Nullable
    private final Map<Attribute, Pair<String, String>>[] attributeSources;

    public ImmutableSymbolTable(@NotNull RmlProviderDescriptor descriptor, @NotNull DomainTypeManager typeManager, @NotNull Map<DomainType, AttributesInfo> domainTypeInfos, @NotNull List<? extends List<? extends Attribute>> attributes, @NotNull List<? extends Map<String, Integer>> backwardMap, @Nullable Map<Attribute, Pair<String, String>>[] attributeSources) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
        Intrinsics.checkNotNullParameter(domainTypeInfos, (String)"domainTypeInfos");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(backwardMap, (String)"backwardMap");
        this.descriptor = descriptor;
        this.typeManager = typeManager;
        this.domainTypeInfos = domainTypeInfos;
        this.attributes = attributes;
        this.backwardMap = backwardMap;
        this.attributeSources = attributeSources;
    }

    @Override
    @NotNull
    public DomainTypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    @Nullable
    public Map<Attribute, Pair<String, String>>[] getAttributeSources() {
        return this.attributeSources;
    }

    @Override
    @NotNull
    public AttributesInfo getAttributesInfo(@NotNull DomainType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        AttributesInfo attributesInfo = this.domainTypeInfos.get(type);
        Intrinsics.checkNotNull((Object)attributesInfo);
        return attributesInfo;
    }

    @Override
    public boolean containsAttribute(int domainTypeIndex, @NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        return this.backwardMap.get(domainTypeIndex).containsKey(attribute.getKey());
    }

    @Override
    public int getAttributeInt(@NotNull DomainType type, @NotNull String attribute) {
        int n;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (type.isIntegerType()) {
            n = Integer.parseInt(attribute);
        } else {
            Integer n2 = this.backwardMap.get(type.getIndex()).get(attribute);
            if (n2 != null) {
                n = n2;
            } else {
                throw new WrongAttributeException(this.toString(), Messages.getString(SymbolTable.class.getName() + "-1") + attribute + "\"");
            }
        }
        return n;
    }

    @Override
    @Nullable
    public Integer getAttributeIntOrNull(@NotNull DomainType type, @NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        return type.isIntegerType() ? Integer.valueOf(Integer.parseInt(attribute)) : this.backwardMap.get(type.getIndex()).get(attribute);
    }

    @Override
    @NotNull
    public Attribute getAttribute(@NotNull DomainType domainType, int value) {
        Intrinsics.checkNotNullParameter((Object)domainType, (String)"domainType");
        if (domainType.isIntegerType()) {
            return (Attribute)new IntAttribute(value);
        }
        return this.attributes.get(domainType.getIndex()).get(value);
    }

    @Override
    @NotNull
    public List<Attribute> getAttributes(@NotNull DomainType domainType) {
        Intrinsics.checkNotNullParameter((Object)domainType, (String)"domainType");
        return this.attributes.get(domainType.getIndex());
    }

    @NotNull
    public String toString() {
        return this.descriptor.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/rml/dfa/impl/symtable/ImmutableSymbolTable$Companion;", "", "<init>", "()V", "load", "Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "descriptor", "Lcom/intellij/rml/dfa/impl/providers/RmlProviderDescriptor;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "stream", "Ljava/io/DataInput;", "intellij.rml.dfa.impl"})
    @SourceDebugExtension(value={"SMAP\nImmutableSymbolTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmutableSymbolTable.kt\ncom/intellij/rml/dfa/impl/symtable/ImmutableSymbolTable$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1279#2,2:98\n1293#2,4:100\n1557#2:104\n1628#2,2:105\n1557#2:107\n1628#2,3:108\n1630#2:111\n1557#2:112\n1628#2,3:113\n*S KotlinDebug\n*F\n+ 1 ImmutableSymbolTable.kt\ncom/intellij/rml/dfa/impl/symtable/ImmutableSymbolTable$Companion\n*L\n62#1:98,2\n62#1:100,4\n63#1:104\n63#1:105,2\n68#1:107\n68#1:108,3\n63#1:111\n73#1:112\n73#1:113,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SymbolTable load(@NotNull RmlProviderDescriptor descriptor, @NotNull DomainTypeManager typeManager, @NotNull DataInput stream) {
            void $this$mapTo$iv$iv;
            Iterator $this$mapTo$iv$iv2;
            int n;
            void $this$mapTo$iv$iv3;
            AttributesInfo attributesInfo;
            int n2;
            Map[] mapArray;
            Object element$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            IntRange domainTypeIndices = RangesKt.until((int)0, (int)typeManager.getDomainTypesCount());
            Iterable $this$associateWith$iv = typeManager.getAvailableDomainTypes();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv2 : $this$associateWithTo$iv$iv) {
                DomainType domainType = (DomainType)element$iv$iv2;
                Object t = element$iv$iv2;
                mapArray = result$iv;
                n2 = 0;
                attributesInfo = AttributesInfo.Companion.load(stream);
                mapArray.put(t, attributesInfo);
            }
            Map domainTypeInfos = result$iv;
            Iterable $this$map$iv = (Iterable)domainTypeIndices;
            boolean $i$f$map = false;
            $this$associateWithTo$iv$iv = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            element$iv$iv2 = $this$mapTo$iv$iv3.iterator();
            while (element$iv$iv2.hasNext()) {
                List list;
                void it;
                int item$iv$iv;
                n2 = item$iv$iv = ((IntIterator)element$iv$iv2).nextInt();
                mapArray = destination$iv$iv;
                n = 0;
                DomainType domainType = typeManager.getDomainType((int)it);
                if (!domainType.isIntegerType()) {
                    Object v = domainTypeInfos.get(domainType);
                    Intrinsics.checkNotNull(v);
                    int attrsCnt = ((AttributesInfo)v).getNumOfAttributes();
                    Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)attrsCnt);
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    Iterator iterator = $this$mapTo$iv$iv2.iterator();
                    while (iterator.hasNext()) {
                        int item$iv$iv2;
                        int n3 = item$iv$iv2 = ((IntIterator)iterator).nextInt();
                        Collection collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(Attribute.load((DataInput)stream));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                mapArray.add(list);
            }
            List attributes = (List)destination$iv$iv;
            Iterable $this$map$iv3 = (Iterable)domainTypeIndices;
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            Iterator item$iv$iv = $this$mapTo$iv$iv.iterator();
            while (item$iv$iv.hasNext()) {
                void it;
                Map map2;
                int item$iv$iv3;
                n = item$iv$iv3 = ((IntIterator)item$iv$iv).nextInt();
                mapArray = destination$iv$iv3;
                boolean bl = false;
                Map map3 = map2 = (Map)new LinkedHashMap();
                boolean bl2 = false;
                $this$mapTo$iv$iv2 = ((Iterable)attributes.get((int)it)).iterator();
                int destination$iv$iv2 = 0;
                while ($this$mapTo$iv$iv2.hasNext()) {
                    int index = destination$iv$iv2++;
                    Attribute attr = (Attribute)$this$mapTo$iv$iv2.next();
                    Integer n4 = index;
                    map3.put(attr.getKey(), n4);
                }
                mapArray.add(map2);
            }
            List backwardMap = (List)destination$iv$iv3;
            int attributeSourcesSize = stream.readInt();
            Map[] mapArray2 = new Map[attributeSourcesSize];
            for (int i = 0; i < attributeSourcesSize; ++i) {
                Map map4;
                int n5 = i;
                int mapSize = stream.readInt();
                Map it = map4 = (Map)new LinkedHashMap();
                int n6 = n5;
                mapArray = mapArray2;
                boolean bl = false;
                int n7 = 0;
                while (n7 < mapSize) {
                    void map5;
                    int it2 = n7++;
                    boolean bl3 = false;
                    Attribute attribute = Attribute.load((DataInput)stream);
                    String first = stream.readUTF();
                    String second = stream.readUTF();
                    map5.put(attribute, new Pair((Object)first, (Object)second));
                }
                attributesInfo = Unit.INSTANCE;
                mapArray[n6] = MapsKt.toMap((Map)map4);
            }
            Map[] attributeSources = mapArray2;
            return new ImmutableSymbolTable(descriptor, typeManager, domainTypeInfos, attributes, backwardMap, attributeSources);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

