/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.microservices.jvm.config.ConfigKeyPathContext;
import com.intellij.microservices.jvm.config.ConfigKeyPathMapKeyReference;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigKeyPathEnumReference
extends ConfigKeyPathMapKeyReference {
    ConfigKeyPathEnumReference(@NotNull PsiElement element, @NotNull ConfigKeyPathContext context) {
        if (element == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(1);
        }
        super(element, context);
    }

    @Override
    @NotNull
    public ConfigKeyPathReference.PathType getPathType() {
        ConfigKeyPathReference.PathType pathType = ConfigKeyPathReference.PathType.ENUM;
        if (pathType == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(2);
        }
        return pathType;
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass keyClass = this.getEnumClass();
        if (keyClass == null) {
            return null;
        }
        return ConfigKeyPathUtils.resolveEnumReference(ConfigKeyPathUtils.getEnumReferenceVariants(this.getValue()), keyClass, true);
    }

    public Object @NotNull [] getVariants() {
        PsiClass keyClass = this.getEnumClass();
        if (keyClass == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                ConfigKeyPathEnumReference.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] enumConstants = (PsiField[])ContainerUtil.findAllAsArray((Object[])keyClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
        Object[] objectArray = ContainerUtil.map2Array((Object[])enumConstants, LookupElement.class, field -> {
            String sanitizedFieldName = ConfigKeyPathEnumReference.getSanitizedName(field);
            LookupElementBuilder builder = LookupElementBuilder.create((Object)field, (String)sanitizedFieldName).withIcon(field.getIcon(1)).withPresentableText(sanitizedFieldName);
            TailType tailType = this.getVariantTailType(this.getValueType());
            builder.putUserData(ConfigKeyPathUtils.TAIL_TYPE_KEY, (Object)tailType);
            return TailTypeDecorator.withTail((LookupElement)builder, (TailType)tailType);
        });
        if (objectArray == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @NotNull
    private static String getSanitizedName(PsiField psiField) {
        String psiFieldName = psiField.getName();
        String string = StringUtil.toLowerCase((String)psiFieldName).replace('_', '-');
        if (string == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        PsiClass keyClass = this.getEnumClass();
        String location = keyClass == null ? "" : MicroservicesConfigBundle.message("config.unresolved.key.in.class", keyClass.getQualifiedName());
        String string = MicroservicesConfigBundle.message("config.unresolved.enum.key", this.getValue(), location);
        if (string == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    private PsiClass getEnumClass() {
        ConfigKeyPathReference previous = this.getContext().getPrevious();
        return previous == null ? this.getContext().getInitialKeyClass() : previous.getKeyClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/ConfigKeyPathEnumReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/ConfigKeyPathEnumReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

