/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.microservices.jvm.config.ConfigKeyPathContext;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ConfigKeyPathReferenceBase
extends PsiReferenceBase<PsiElement>
implements ConfigKeyPathReference,
EmptyResolveMessageProvider {
    private final ConfigKeyPathContext myContext;

    protected ConfigKeyPathReferenceBase(@NotNull PsiElement element, @NotNull ConfigKeyPathContext context) {
        if (element == null) {
            ConfigKeyPathReferenceBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ConfigKeyPathReferenceBase.$$$reportNull$$$0(1);
        }
        super(element);
        this.myContext = context;
        this.setRangeInElement(context.getTextRange());
    }

    @Override
    @NotNull
    public ConfigKeyPathContext getContext() {
        ConfigKeyPathContext configKeyPathContext = this.myContext;
        if (configKeyPathContext == null) {
            ConfigKeyPathReferenceBase.$$$reportNull$$$0(2);
        }
        return configKeyPathContext;
    }

    @NotNull
    protected TailType getVariantTailType(@Nullable PsiType type) {
        if (type instanceof PsiArrayType) {
            TailType tailType = this.getContext().getIndexedTailType(() -> {
                PsiClass listElementType = ConfigKeyPathUtils.getPsiClass(((PsiArrayType)type).getComponentType());
                return listElementType != null && !ConfigKeyPathUtils.stopResolvingProperty(listElementType);
            });
            if (tailType == null) {
                ConfigKeyPathReferenceBase.$$$reportNull$$$0(3);
            }
            return tailType;
        }
        if (type instanceof PsiClassType) {
            String baseClass;
            String string = InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.List") ? "java.util.List" : (baseClass = InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Set") ? "java.util.Set" : null);
            if (baseClass != null) {
                TailType tailType = this.getContext().getIndexedTailType(() -> {
                    PsiClass listElementType = ConfigKeyPathUtils.getPsiClass(ConfigKeyPathUtils.getTypeParameter(type, baseClass, 0));
                    return listElementType != null && !ConfigKeyPathUtils.stopResolvingProperty(listElementType);
                });
                if (tailType == null) {
                    ConfigKeyPathReferenceBase.$$$reportNull$$$0(4);
                }
                return tailType;
            }
        }
        if (ConfigKeyPathReferenceBase.canHaveNext(type)) {
            TailType tailType = this.getContext().getSeparatorTailType();
            if (tailType == null) {
                ConfigKeyPathReferenceBase.$$$reportNull$$$0(5);
            }
            return tailType;
        }
        TailType tailType = this.getContext().getValueTailType();
        if (tailType == null) {
            ConfigKeyPathReferenceBase.$$$reportNull$$$0(6);
        }
        return tailType;
    }

    private static boolean canHaveNext(PsiType type) {
        PsiClass psiClass = ConfigKeyPathUtils.getPsiClass(type);
        return psiClass != null && !ConfigKeyPathUtils.stopResolvingProperty(psiClass);
    }

    public String toString() {
        String type = this.getPathType().name();
        return type + "[" + this.getValue() + "] " + this.getKeyClass() + " " + this.getValueType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/ConfigKeyPathReferenceBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/ConfigKeyPathReferenceBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantTailType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

