/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.microservices.jvm.config.ConfigKeyPathBeanPropertyResolver;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MetaConfigKey {
    public static final Condition<MetaConfigKey> MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION = configKey -> configKey.getKeyItemHint() == ItemHint.NONE && configKey.isAccessType(AccessType.ENUM_MAP, AccessType.MAP, AccessType.INDEXED);

    @NotNull
    public MetaConfigKeyManager getManager();

    @NotNull
    public String getName();

    @NotNull
    public PsiElement getDeclaration();

    @NotNull
    public DeclarationResolveResult getDeclarationResolveResult();

    @Nullable
    public PsiType getType();

    @Nullable
    public PsiType getEffectiveValueType();

    @Nullable
    default public PsiType getEffectiveValueElementType() {
        PsiType valueType = this.getEffectiveValueType();
        if (valueType == null) {
            return null;
        }
        if (this.isAccessType(AccessType.MAP_GROUP)) {
            AccessType valueAccessType = AccessType.forPsiType(valueType);
            valueType = valueAccessType.getEffectiveValueType(valueType);
        }
        return valueType;
    }

    public boolean isAccessType(AccessType ... var1);

    @Nullable
    public PsiClass getMapKeyType();

    @NotNull
    public DescriptionText getDescriptionText();

    @NotNull
    public Deprecation getDeprecation();

    @Nullable
    public String getDefaultValue();

    @NotNull
    public ItemHint getItemHint();

    @NotNull
    public ItemHint getKeyItemHint();

    @NotNull
    public MetaConfigKeyPresentation getPresentation();

    default public ConfigKeyPathBeanPropertyResolver getPropertyResolver() {
        return ConfigKeyPathBeanPropertyResolver.DEFAULT_RESOLVER;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AccessType {
        NORMAL{

            @Override
            public PsiType getEffectiveValueType(@NotNull PsiType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                return type;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/microservices/jvm/config/MetaConfigKey$AccessType$1", "getEffectiveValueType"));
            }
        }
        ,
        MAP{

            @Override
            public PsiType getEffectiveValueType(@NotNull PsiType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(0);
                }
                return AccessType.getParameter(type, 1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/microservices/jvm/config/MetaConfigKey$AccessType$2", "getEffectiveValueType"));
            }
        }
        ,
        ENUM_MAP{

            @Override
            public PsiType getEffectiveValueType(@NotNull PsiType type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                return AccessType.getParameter(type, 1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/microservices/jvm/config/MetaConfigKey$AccessType$3", "getEffectiveValueType"));
            }
        }
        ,
        INDEXED{

            @Override
            public PsiType getEffectiveValueType(@NotNull PsiType type) {
                if (type == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (type instanceof PsiArrayType) {
                    return ((PsiArrayType)type).getComponentType();
                }
                return AccessType.getParameter(type, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/microservices/jvm/config/MetaConfigKey$AccessType$4", "getEffectiveValueType"));
            }
        };

        public static final AccessType[] MAP_GROUP;

        @Nullable
        private static PsiType getParameter(PsiType type, int index) {
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiType[] parameters = ((PsiClassType)type).getParameters();
            if (parameters.length < index + 1) {
                return null;
            }
            return parameters[index];
        }

        public abstract PsiType getEffectiveValueType(@NotNull PsiType var1);

        public static AccessType forPsiType(@NotNull PsiType type) {
            if (type == null) {
                AccessType.$$$reportNull$$$0(0);
            }
            if (type instanceof PsiArrayType) {
                return INDEXED;
            }
            if (type instanceof PsiClassType && ((PsiClassType)type).getParameterCount() == 0) {
                String fqn = type.getCanonicalText();
                if ("java.util.Map".equals(fqn)) {
                    return MAP;
                }
                if ("java.util.List".equals(fqn) || "java.util.Set".equals(fqn)) {
                    return INDEXED;
                }
                return NORMAL;
            }
            PsiClass resolve = ConfigKeyPathUtils.getPsiClass(type);
            if (resolve == null) {
                return NORMAL;
            }
            String fqn = resolve.getQualifiedName();
            if ("java.util.Map".equals(fqn)) {
                return MAP;
            }
            if ("java.util.List".equals(fqn) || "java.util.Set".equals(fqn)) {
                return INDEXED;
            }
            return NORMAL;
        }

        static {
            MAP_GROUP = new AccessType[]{MAP, ENUM_MAP};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/microservices/jvm/config/MetaConfigKey$AccessType", "forPsiType"));
        }
    }

    public static class ItemHint {
        public static final ItemHint NONE = new ItemHint(Collections.emptyList(), Collections.emptyList()){

            @Override
            public String toString() {
                return "ItemHint.NONE";
            }
        };
        public static final String MAP_KEYS_NAME_SUFFIX = ".keys";
        public static final String MAP_VALUES_NAME_SUFFIX = ".values";
        private final List<ValueProvider> myValueProviders;
        private final List<ValueHint> myValueHints;

        public ItemHint(List<ValueProvider> valueProviders, List<ValueHint> valueHints) {
            this.myValueProviders = valueProviders;
            this.myValueHints = valueHints;
        }

        public List<ValueHint> getValueHints() {
            return this.myValueHints;
        }

        public List<ValueProvider> getValueProviders() {
            return this.myValueProviders;
        }

        public String toString() {
            return "ItemHint{myValueProviders=" + this.myValueProviders + ", myValueHints=" + this.myValueHints + "}";
        }
    }

    public static class ValueHint {
        private final String myValue;
        private final DescriptionText myDescriptionText;

        public ValueHint(@NotNull String value, @NotNull DescriptionText descriptionText) {
            if (value == null) {
                ValueHint.$$$reportNull$$$0(0);
            }
            if (descriptionText == null) {
                ValueHint.$$$reportNull$$$0(1);
            }
            this.myValue = value;
            this.myDescriptionText = descriptionText;
        }

        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                ValueHint.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public DescriptionText getDescriptionText() {
            DescriptionText descriptionText = this.myDescriptionText;
            if (descriptionText == null) {
                ValueHint.$$$reportNull$$$0(3);
            }
            return descriptionText;
        }

        public String toString() {
            return "ValueHint{myValue='" + this.myValue + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptionText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/microservices/jvm/config/MetaConfigKey$ValueHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/microservices/jvm/config/MetaConfigKey$ValueHint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class ValueProvider {
        private final String myName;
        private final Map<String, String> myParameters;

        public ValueProvider(String name, Map<String, String> parameters) {
            this.myName = name;
            this.myParameters = parameters;
        }

        public String getName() {
            return this.myName;
        }

        public Map<String, String> getParameters() {
            return this.myParameters;
        }

        public String toString() {
            return "ValueProvider{myName='" + this.myName + "', myParameters=" + this.myParameters.size() + "}";
        }
    }

    public static final class Deprecation {
        public static final Deprecation NOT_DEPRECATED = new Deprecation(new DescriptionText("Deprecation.NOT_DEPRECATED"), null);
        public static final Deprecation DEPRECATED_WITHOUT_REASON = new Deprecation(DescriptionText.NONE, null);
        private final DescriptionText myReason;
        private final DeprecationLevel myLevel;
        private final String myReplacement;

        public Deprecation(@NotNull DescriptionText reason, @Nullable String replacement) {
            if (reason == null) {
                Deprecation.$$$reportNull$$$0(0);
            }
            this(reason, DeprecationLevel.WARNING, replacement);
        }

        public Deprecation(@NotNull DescriptionText reason, @NotNull DeprecationLevel level, @Nullable String replacement) {
            if (reason == null) {
                Deprecation.$$$reportNull$$$0(1);
            }
            if (level == null) {
                Deprecation.$$$reportNull$$$0(2);
            }
            this.myReason = reason;
            this.myLevel = level;
            this.myReplacement = replacement;
        }

        @NotNull
        public DescriptionText getReason() {
            DescriptionText descriptionText = this.myReason;
            if (descriptionText == null) {
                Deprecation.$$$reportNull$$$0(3);
            }
            return descriptionText;
        }

        @NotNull
        public DeprecationLevel getLevel() {
            DeprecationLevel deprecationLevel = this.myLevel;
            if (deprecationLevel == null) {
                Deprecation.$$$reportNull$$$0(4);
            }
            return deprecationLevel;
        }

        @Nullable
        public String getReplacement() {
            return this.myReplacement;
        }

        public String toString() {
            return "Deprecation{myReason=" + this.myReason + ", myLevel=" + this.myLevel + ", myReplacement='" + this.myReplacement + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/microservices/jvm/config/MetaConfigKey$Deprecation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/microservices/jvm/config/MetaConfigKey$Deprecation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReason";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }

        public static enum DeprecationLevel {
            WARNING("warning"),
            ERROR("error");

            private final String myValue;

            private DeprecationLevel(String value) {
                this.myValue = value;
            }

            public String getValue() {
                return this.myValue;
            }

            @Nullable
            public static DeprecationLevel parse(@Nullable String value) {
                if (value == null) {
                    return null;
                }
                for (DeprecationLevel level : DeprecationLevel.values()) {
                    if (!level.getValue().equals(value)) continue;
                    return level;
                }
                return null;
            }
        }
    }

    public static class DescriptionText {
        public static final DescriptionText NONE = new DescriptionText("");
        private final String myText;

        public DescriptionText(@NotNull String text) {
            if (text == null) {
                DescriptionText.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @NotNull
        public String getFullText() {
            String string = this.myText;
            if (string == null) {
                DescriptionText.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getShortText() {
            String firstSentence = this.myText;
            if (StringUtil.containsChar((String)this.myText, (char)'.')) {
                BreakIterator breakIterator = BreakIterator.getSentenceInstance(Locale.US);
                breakIterator.setText(this.myText);
                firstSentence = this.myText.substring(breakIterator.first(), breakIterator.next()).trim();
            }
            if (StringUtil.isNotEmpty((String)firstSentence)) {
                String withoutDot = StringUtil.endsWithChar((CharSequence)firstSentence, (char)'.') ? firstSentence.substring(0, firstSentence.length() - 1) : firstSentence;
                String string = StringUtil.replace((String)withoutDot, (String)"\n", (String)"");
                if (string == null) {
                    DescriptionText.$$$reportNull$$$0(2);
                }
                return string;
            }
            return "";
        }

        public String toString() {
            return "DescriptionText{myText='" + this.myText + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/microservices/jvm/config/MetaConfigKey$DescriptionText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/microservices/jvm/config/MetaConfigKey$DescriptionText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface MetaConfigKeyPresentation {
        @NotNull
        public Icon getIcon();

        public LookupElementBuilder getLookupElement();

        public LookupElementBuilder getLookupElement(String var1);

        public LookupElement tuneLookupElement(LookupElement var1);
    }

    public static enum DeclarationResolveResult {
        PROPERTY,
        ADDITIONAL_JSON,
        JSON,
        JSON_UNRESOLVED_SOURCE_TYPE;

    }
}

