/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.yaml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.microservices.jvm.config.ConfigKeyPathContext;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.microservices.jvm.config.yaml.ConfigKeyPathYamlContext;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlAccessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.completion.YamlKeyCompletionInsertHandler;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public final class ConfigYamlUtils {
    private static final LookupElementRenderer<LookupElement> YAML_PLACEHOLDER_LOOKUP_RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation2) {
            Pair<String, String> presentationText = ConfigYamlUtils.getLookupElementPresentationText(element.getObject());
            presentation2.setIcon(com.intellij.util.PlatformIcons.PROPERTY_ICON);
            presentation2.setItemText((String)presentationText.first);
            TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PropertiesComponent.PROPERTY_VALUE.getTextAttributesKey());
            presentation2.setTailText("=" + (String)presentationText.second, attrs.getForegroundColor());
            PsiFile psiFile = ((PsiElement)element.getObject()).getContainingFile();
            if (psiFile != null) {
                presentation2.setTypeText(psiFile.getOriginalFile().getName(), psiFile.getOriginalFile().getIcon(0));
            }
        }
    };
    public static final InsertHandler<LookupElement> INSERT_COLON_AND_NEW_LINE_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            if (lookupElement == null) {
                2.$$$reportNull$$$0(1);
            }
            PsiElement element = context.getFile().findElementAt(context.getStartOffset());
            assert (element != null) : "no element at " + context.getStartOffset();
            int indent = YAMLUtil.getIndentToThisElement((PsiElement)element) + 2;
            String insertion = "\n" + StringUtil.repeatSymbol((char)' ', (int)indent);
            Editor editor = context.getEditor();
            if (!YamlKeyCompletionInsertHandler.isCharAtCaret((Editor)editor, (char)':')) {
                insertion = ":" + insertion;
            } else {
                editor.getCaretModel().moveCaretRelatively(1, 0, false, false, false);
            }
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)insertion);
            AutoPopupController.getInstance((Project)Objects.requireNonNull(editor.getProject())).scheduleAutoPopup(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lookupElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/microservices/jvm/config/yaml/ConfigYamlUtils$2";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final int VALUE_PRESENTATION_MAX_ITEMS = 2;
    @NonNls
    private static final String MORE_ITEMS_TEXT = ", [...]";
    private static final Function<String, String> NUMBER_VALUE_SANITIZER = value -> StringUtil.replace((String)value, (String)"_", (String)"");

    private ConfigYamlUtils() {
    }

    @NotNull
    public static String getQualifiedConfigKeyName(YAMLKeyValue yamlKeyValue) {
        return ConfigYamlUtils.getQualifiedConfigKeyName(yamlKeyValue, YAMLKeyValue::getKeyText);
    }

    @NotNull
    public static String getQualifiedConfigKeyName(YAMLKeyValue yamlKeyValue, Function<YAMLKeyValue, String> keyTextMapper) {
        StringBuilder builder = new StringBuilder();
        YAMLKeyValue element = yamlKeyValue;
        boolean addSeparator = false;
        while (element != null) {
            YAMLSequenceItem item;
            if (addSeparator) {
                builder.insert(0, '.');
            }
            builder.insert(0, keyTextMapper.apply(element));
            addSeparator = true;
            YAMLKeyValue parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class, (boolean)true, (Class[])new Class[]{YAMLSequenceItem.class});
            if (parent == null && (item = (YAMLSequenceItem)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLSequenceItem.class)) != null) {
                int index;
                YAMLSequence sequence2 = (YAMLSequence)PsiTreeUtil.getParentOfType((PsiElement)item, YAMLSequence.class);
                if (sequence2 != null && (index = sequence2.getItems().indexOf(item)) >= 0) {
                    builder.insert(0, "[" + index + "].");
                    addSeparator = false;
                }
                parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
            }
            element = parent;
        }
        String string = builder.toString();
        if (string == null) {
            ConfigYamlUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getValuePresentationText(YAMLKeyValue yamlKeyValue) {
        YAMLValue value = yamlKeyValue.getValue();
        if (value instanceof YAMLScalar) {
            String string = ((YAMLScalar)value).getTextValue();
            if (string == null) {
                ConfigYamlUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (value instanceof YAMLSequence) {
            List sequenceItems = ((YAMLSequence)value).getItems();
            String suffix = sequenceItems.size() > 2 ? MORE_ITEMS_TEXT : "";
            String string = StringUtil.join((Collection)ContainerUtil.getFirstItems((List)sequenceItems, (int)2), item -> {
                YAMLValue itemValue = item.getValue();
                if (itemValue instanceof YAMLScalar) {
                    return ((YAMLScalar)itemValue).getTextValue();
                }
                return ConfigYamlUtils.getSequenceItemText(item);
            }, (String)", ") + suffix;
            if (string == null) {
                ConfigYamlUtils.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static String getValuePresentationText(YAMLSequenceItem sequenceItem) {
        YAMLValue value = sequenceItem.getValue();
        if (value instanceof YAMLScalar) {
            String string = ((YAMLScalar)value).getTextValue();
            if (string == null) {
                ConfigYamlUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        return value != null ? value.getText() : "";
    }

    @NotNull
    private static String getSequenceItemText(YAMLSequenceItem item) {
        SmartList keysValues = new SmartList();
        int count = 0;
        String suffix = "";
        Iterator iterator = item.getKeysValues().iterator();
        while (iterator.hasNext()) {
            YAMLKeyValue next = (YAMLKeyValue)iterator.next();
            keysValues.add(next);
            if (count++ != 2) continue;
            if (!iterator.hasNext()) break;
            suffix = MORE_ITEMS_TEXT;
            break;
        }
        String string = StringUtil.join((Collection)keysValues, keyValue -> keyValue.getKeyText() + ": " + ConfigYamlUtils.getValuePresentationText(keyValue), (String)", ") + suffix;
        if (string == null) {
            ConfigYamlUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getReferenceDisplayText(YAMLKeyValue yamlKeyValue) {
        String keyText = ConfigYamlUtils.getQualifiedConfigKeyName(yamlKeyValue);
        String valueText = ConfigYamlUtils.getValuePresentationText(yamlKeyValue);
        Object object = valueText.isEmpty() ? keyText : keyText + ": " + valueText;
        if (object == null) {
            ConfigYamlUtils.$$$reportNull$$$0(5);
        }
        return object;
    }

    @NotNull
    public static LookupElementRenderer<LookupElement> getYamlPlaceholderLookupRenderer() {
        LookupElementRenderer<LookupElement> lookupElementRenderer = YAML_PLACEHOLDER_LOOKUP_RENDERER;
        if (lookupElementRenderer == null) {
            ConfigYamlUtils.$$$reportNull$$$0(6);
        }
        return lookupElementRenderer;
    }

    @Nullable
    public static YAMLKeyValue getParentKeyValue(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        YAMLKeyValue parentYamlKeyValue;
        if (element == null) {
            ConfigYamlUtils.$$$reportNull$$$0(7);
        }
        if ((parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)originalElement, YAMLKeyValue.class)) == null) {
            parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
        }
        if (element.getNode().getElementType() == YAMLTokenTypes.SCALAR_KEY) {
            parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)parentYamlKeyValue, YAMLKeyValue.class);
        }
        return parentYamlKeyValue;
    }

    @NotNull
    public static List<LookupElement> getCurrentLineKeyComponents(@NotNull PsiElement element, @NotNull MetaConfigKeyManager.ConfigKeyNameBinder binder, @NotNull String parentConfigKeyName, @NotNull List<? extends MetaConfigKey> configKeys) {
        if (element == null) {
            ConfigYamlUtils.$$$reportNull$$$0(8);
        }
        if (binder == null) {
            ConfigYamlUtils.$$$reportNull$$$0(9);
        }
        if (parentConfigKeyName == null) {
            ConfigYamlUtils.$$$reportNull$$$0(10);
        }
        if (configKeys == null) {
            ConfigYamlUtils.$$$reportNull$$$0(11);
        }
        if (element.getNode().getElementType() != YAMLTokenTypes.SCALAR_KEY && !(element.getParent() instanceof YAMLScalar)) {
            List<LookupElement> list2 = Collections.emptyList();
            if (list2 == null) {
                ConfigYamlUtils.$$$reportNull$$$0(12);
            }
            return list2;
        }
        YAMLKeyValue parentKeyValue = ConfigYamlUtils.getParentKeyValue(element, null);
        YAMLValue searchValue = parentKeyValue == null ? null : parentKeyValue.getValue();
        String currentLineKey = ConfigYamlUtils.getElementKeyText(element);
        ConfigYamlAccessor accessor = new ConfigYamlAccessor(element, binder);
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        int parentComponents = parentConfigKeyName.isEmpty() ? 0 : StringUtil.countChars((CharSequence)parentConfigKeyName, (char)'.') + 1;
        for (MetaConfigKey metaConfigKey : configKeys) {
            List components;
            if (!parentConfigKeyName.isEmpty() && !binder.matchesPrefix(metaConfigKey, parentConfigKeyName) || (components = StringUtil.split((String)metaConfigKey.getName(), (String)".")).size() <= parentComponents + 1) continue;
            String key2 = (String)components.get(parentComponents);
            if ((currentLineKey == null || !binder.matchesPart(key2, currentLineKey)) && accessor.findExistingKey(key2, searchValue) != null) continue;
            keys.add(key2);
        }
        List list3 = ContainerUtil.map(keys, key -> LookupElementBuilder.create((String)key).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Property)).withInsertHandler(INSERT_COLON_AND_NEW_LINE_INSERT_HANDLER));
        if (list3 == null) {
            ConfigYamlUtils.$$$reportNull$$$0(13);
        }
        return list3;
    }

    @Nullable
    public static String getElementKeyText(@NotNull PsiElement element) {
        IElementType elementType;
        if (element == null) {
            ConfigYamlUtils.$$$reportNull$$$0(14);
        }
        if ((elementType = element.getNode().getElementType()) == YAMLTokenTypes.SCALAR_KEY) {
            YAMLKeyValue currentKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
            if (currentKeyValue != null) {
                return currentKeyValue.getKeyText();
            }
        } else {
            String text;
            if (elementType == YAMLTokenTypes.TEXT) {
                return element.getText();
            }
            if ((elementType == YAMLTokenTypes.SCALAR_STRING || elementType == YAMLTokenTypes.SCALAR_DSTRING) && (text = element.getText()).length() > 2) {
                return text.substring(1, text.length() - 1);
            }
        }
        return null;
    }

    public static void addCompletionAddIfNeeded(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            ConfigYamlUtils.$$$reportNull$$$0(15);
        }
        if (result == null) {
            ConfigYamlUtils.$$$reportNull$$$0(16);
        }
        if (parameters.getInvocationCount() <= 1) {
            result.addLookupAdvertisement(MicroservicesConfigBundle.message("config.completion.ad", KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")));
        }
    }

    private static Pair<String, String> getLookupElementPresentationText(Object o) {
        if (o instanceof YAMLKeyValue) {
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)o;
            return Pair.create((Object)ConfigYamlUtils.getQualifiedConfigKeyName(yamlKeyValue), (Object)ConfigYamlUtils.getValuePresentationText(yamlKeyValue));
        }
        if (o instanceof YAMLSequenceItem) {
            YAMLSequenceItem sequenceItem = (YAMLSequenceItem)o;
            YAMLKeyValue parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)sequenceItem, YAMLKeyValue.class);
            String keyText = ConfigYamlUtils.getQualifiedConfigKeyName(parent) + "[" + sequenceItem.getItemIndex() + "]";
            return Pair.create((Object)keyText, (Object)ConfigYamlUtils.getValuePresentationText(sequenceItem));
        }
        return Pair.create((Object)"", (Object)"");
    }

    public static Function<String, String> getYamlNumberValueSanitizer() {
        return NUMBER_VALUE_SANITIZER;
    }

    @Nullable
    public static String sanitizeNumberValueIfNeeded(@Nullable String value, @NotNull Supplier<? extends PsiType> valueType) {
        if (valueType == null) {
            ConfigYamlUtils.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)value)) {
            return value;
        }
        char first = value.charAt(0);
        if (first == '+' || first == '-' || first >= '0' && first <= '9') {
            String typeName;
            PsiClass typeClass = PsiTypesUtil.getPsiClass((PsiType)valueType.get());
            String string = typeName = typeClass == null ? null : typeClass.getQualifiedName();
            if ("java.lang.Integer".equals(typeName) || "java.lang.Long".equals(typeName) || "java.lang.Float".equals(typeName) || "java.lang.Double".equals(typeName)) {
                return ConfigYamlUtils.getYamlNumberValueSanitizer().apply(value);
            }
        }
        return null;
    }

    public static TextRange getKeyReferenceRange(@NotNull YAMLKeyValue yamlKeyValue) {
        if (yamlKeyValue == null) {
            ConfigYamlUtils.$$$reportNull$$$0(18);
        }
        return TextRange.allOf((String)yamlKeyValue.getKeyText()).shiftRight(ElementManipulators.getOffsetInElement((PsiElement)yamlKeyValue));
    }

    public static TextRange trimIndexedAccess(@NotNull TextRange textRange, @NotNull YAMLKeyValue yamlKeyValue) {
        PsiElement keyElement;
        if (textRange == null) {
            ConfigYamlUtils.$$$reportNull$$$0(19);
        }
        if (yamlKeyValue == null) {
            ConfigYamlUtils.$$$reportNull$$$0(20);
        }
        if ((keyElement = yamlKeyValue.getKey()) == null) {
            return textRange;
        }
        String text = textRange.substring(keyElement.getText());
        return ConfigKeyPathUtils.hasIndexedAccess(text) ? TextRange.create((int)0, (int)text.indexOf("[")).shiftRight(textRange.getStartOffset()) : textRange;
    }

    @NotNull
    public static List<ConfigKeyPathReference> getConfigPathReferences(final @NotNull YAMLKeyValue yamlKeyValue, @Nullable YAMLKeyValue parent, final @NotNull MetaConfigKey configKey) {
        String parentQualifiedConfigKeyName;
        int parentSeparatorsCount;
        if (yamlKeyValue == null) {
            ConfigYamlUtils.$$$reportNull$$$0(21);
        }
        if (configKey == null) {
            ConfigYamlUtils.$$$reportNull$$$0(22);
        }
        if (configKey.isAccessType(MetaConfigKey.AccessType.NORMAL)) {
            List<ConfigKeyPathReference> list2 = Collections.emptyList();
            if (list2 == null) {
                ConfigYamlUtils.$$$reportNull$$$0(23);
            }
            return list2;
        }
        int keyNameSeparatorsCount = StringUtil.countChars((CharSequence)configKey.getName(), (char)'.');
        final int skip = keyNameSeparatorsCount - (parentSeparatorsCount = StringUtil.countChars((CharSequence)(parentQualifiedConfigKeyName = parent == null ? "" : ConfigYamlUtils.getQualifiedConfigKeyName(parent) + "."), (char)'.'));
        final ConfigKeyPathReference parentReference = skip >= 0 ? null : (parent == null ? null : ConfigYamlUtils.getLastConfigKeyPathReference(parent));
        SmartList result = new SmartList();
        String keyText = yamlKeyValue.getKeyText();
        if (StringUtil.startsWithChar((CharSequence)keyText, (char)'[')) {
            int start = 1;
            int end = keyText.length();
            if (StringUtil.endsWithChar((CharSequence)keyText, (char)']')) {
                --end;
            }
            ConfigKeyPathYamlContext context = new ConfigKeyPathYamlContext(configKey, yamlKeyValue, parentReference, TextRange.create((int)start, (int)end));
            result.add(ConfigKeyPathUtils.getNext((PsiElement)yamlKeyValue, context));
            SmartList smartList = result;
            if (smartList == null) {
                ConfigYamlUtils.$$$reportNull$$$0(24);
            }
            return smartList;
        }
        new DelimitedListProcessor(".", (List)result, parent, keyText){
            private ConfigKeyPathReference previous;
            private int index;
            private boolean stopProcessing;
            final /* synthetic */ List val$result;
            final /* synthetic */ YAMLKeyValue val$parent;
            final /* synthetic */ String val$keyText;
            {
                this.val$result = list2;
                this.val$parent = yAMLKeyValue2;
                this.val$keyText = string;
                super(arg0);
                this.previous = parentReference;
                this.index = 0;
                this.stopProcessing = false;
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                if (this.stopProcessing) {
                    return;
                }
                if (this.index <= skip) {
                    ++this.index;
                    return;
                }
                if (this.isStopProcessing(start)) {
                    this.stopProcessing = true;
                    return;
                }
                ConfigKeyPathYamlContext context = new ConfigKeyPathYamlContext(configKey, yamlKeyValue, this.previous, TextRange.create((int)start, (int)end));
                this.previous = ConfigKeyPathUtils.getNext((PsiElement)yamlKeyValue, context);
                this.val$result.add(this.previous);
            }

            private boolean isStopProcessing(int start) {
                YAMLMapping parentMapping;
                return this.previous == null && configKey.isAccessType(MetaConfigKey.AccessType.INDEXED) && (this.index == 0 ? (parentMapping = yamlKeyValue.getParentMapping()) == null || parentMapping.getParent() == this.val$parent && this.val$parent != null && !ConfigKeyPathUtils.hasIndexedAccess(this.val$parent.getKeyText()) : this.val$keyText.charAt(start - 2) != ']');
            }
        }.processText(keyText);
        SmartList smartList = result;
        if (smartList == null) {
            ConfigYamlUtils.$$$reportNull$$$0(25);
        }
        return smartList;
    }

    @Nullable
    public static ConfigKeyPathReference getLastConfigKeyPathReference(@NotNull YAMLKeyValue yamlKeyValue) {
        if (yamlKeyValue == null) {
            ConfigYamlUtils.$$$reportNull$$$0(26);
        }
        PsiReference[] references = yamlKeyValue.getReferences();
        for (int i = references.length - 1; i >= 0; --i) {
            PsiReference parentReference = references[i];
            if (!(parentReference instanceof ConfigKeyPathReference)) continue;
            ConfigKeyPathReference previous = (ConfigKeyPathReference)parentReference;
            return previous;
        }
        return null;
    }

    @Nullable
    public static String getMapKeyPrefix(@NotNull ConfigKeyPathContext context) {
        if (context == null) {
            ConfigYamlUtils.$$$reportNull$$$0(27);
        }
        ConfigKeyPathReference previous = context.getPrevious();
        StringBuilder prefixBuilder = new StringBuilder();
        while (previous != null) {
            prefixBuilder.insert(0, ConfigYamlUtils.getConfigKeyPathText(previous) + ".");
            previous = previous.getContext().getPrevious();
        }
        if (prefixBuilder.isEmpty()) {
            return null;
        }
        prefixBuilder.setLength(prefixBuilder.length() - 1);
        String prefix = prefixBuilder.toString();
        if (StringUtil.startsWithChar((CharSequence)prefix, (char)'[') || StringUtil.endsWithChar((CharSequence)prefix, (char)']')) {
            return null;
        }
        return prefix;
    }

    private static String getConfigKeyPathText(ConfigKeyPathReference reference) {
        String text = reference.getElement().getText();
        TextRange textRange = reference.getRangeInElement();
        if (textRange.getStartOffset() > 0 && text.charAt(textRange.getStartOffset() - 1) == '[') {
            textRange = textRange.shiftLeft(1).grown(1);
        }
        if (textRange.getEndOffset() < text.length() && text.charAt(textRange.getEndOffset()) == ']') {
            textRange = textRange.grown(1);
        }
        return textRange.substring(text);
    }

    public static TailType getValueTailType() {
        return ConfigKeyPathYamlContext.VALUE_TAIL_TYPE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 21, 22, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/yaml/ConfigYamlUtils";
                break;
            }
            case 7: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentConfigKeyName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeys";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlKeyValue";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedConfigKeyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePresentationText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSequenceItemText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceDisplayText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getYamlPlaceholderLookupRenderer";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/yaml/ConfigYamlUtils";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLineKeyComponents";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPathReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentKeyValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentLineKeyComponents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementKeyText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionAddIfNeeded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeNumberValueIfNeeded";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getKeyReferenceRange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "trimIndexedAccess";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConfigPathReferences";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLastConfigKeyPathReference";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMapKeyPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 21, 22, 26, 27 -> new IllegalArgumentException(string);
        };
    }
}

