/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.microservices.jvm.inject.InjectionGeneratorContext;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/microservices/jvm/inject/GeneratorAction;", "", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "target", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/codeInsight/intention/IntentionAction;Lcom/intellij/psi/PsiElement;)V", "isValid", "", "context", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;", "invoke", "", "startInWriteAction", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.microservices.jvm"})
public final class GeneratorAction {
    @NotNull
    private final IntentionAction action;
    @NotNull
    private final PsiElement target;

    public GeneratorAction(@NotNull IntentionAction action2, @NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.action = action2;
        this.target = target;
    }

    public final boolean isValid(@NotNull InjectionGeneratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.target.isValid() && this.action.isAvailable(context.getProject(), context.getEditor(), context.getContainingFile());
    }

    public final void invoke(@NotNull InjectionGeneratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.action.invoke(context.getProject(), context.getEditor(), context.getContainingFile());
    }

    public final boolean startInWriteAction() {
        return this.action.startInWriteAction();
    }

    private final IntentionAction component1() {
        return this.action;
    }

    private final PsiElement component2() {
        return this.target;
    }

    @NotNull
    public final GeneratorAction copy(@NotNull IntentionAction action2, @NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new GeneratorAction(action2, target);
    }

    public static /* synthetic */ GeneratorAction copy$default(GeneratorAction generatorAction, IntentionAction intentionAction, PsiElement psiElement, int n, Object object) {
        if ((n & 1) != 0) {
            intentionAction = generatorAction.action;
        }
        if ((n & 2) != 0) {
            psiElement = generatorAction.target;
        }
        return generatorAction.copy(intentionAction, psiElement);
    }

    @NotNull
    public String toString() {
        return "GeneratorAction(action=" + this.action + ", target=" + this.target + ")";
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = result * 31 + this.target.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeneratorAction)) {
            return false;
        }
        GeneratorAction generatorAction = (GeneratorAction)other;
        if (!Intrinsics.areEqual((Object)this.action, (Object)generatorAction.action)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.target, (Object)generatorAction.target);
    }
}

