/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.mockserver;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionContributor;
import com.intellij.lang.injection.general.SimpleInjection;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.microservices.jvm.mockserver.MockServerBodyLanguageInjectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/jvm/mockserver/MockServerBodyLanguageInjector;", "Lcom/intellij/lang/injection/general/LanguageInjectionContributor;", "<init>", "()V", "getInjection", "Lcom/intellij/lang/injection/general/Injection;", "host", "Lcom/intellij/psi/PsiElement;", "isTargetMethod", "", "uCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "getInjectedLanguage", "arg", "Lorg/jetbrains/uast/UReferenceExpression;", "isJsonBody", "bodyType", "", "isXmlBody", "intellij.microservices.jvm"})
public final class MockServerBodyLanguageInjector
implements LanguageInjectionContributor {
    @Nullable
    public Injection getInjection(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Project project = host.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (project2.isDefault()) {
            return null;
        }
        if (!JavaLibraryUtil.hasLibraryJar((Project)project2, (String)"org.mock-server:mockserver-core")) {
            return null;
        }
        UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)host, UInjectionHost.class);
        if (uInjectionHost == null) {
            return null;
        }
        UInjectionHost uInjectionHost2 = uInjectionHost;
        UExpression roomExpression = uInjectionHost2.getStringRoomExpression();
        UCallExpression uCallExpression = UastUtils.getUCallExpression((UElement)roomExpression.getUastParent(), (int)1);
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression uCallExpression2 = uCallExpression;
        if (!this.isTargetMethod(uCallExpression2)) {
            return null;
        }
        List args = uCallExpression2.getValueArguments();
        if (args.size() == 1) {
            Object v4;
            block12: {
                UElement uElement = uCallExpression2.getUastParent();
                UExpression uExpression = uElement instanceof UExpression ? (UExpression)uElement : null;
                if (uExpression == null) {
                    return null;
                }
                UExpression chainExpression = uExpression;
                Iterable iterable = UastUtils.getQualifiedChain((UExpression)chainExpression);
                for (Object t : iterable) {
                    UExpression it = (UExpression)t;
                    boolean bl = false;
                    if (!(it instanceof UCallExpression && Intrinsics.areEqual((Object)((UCallExpression)it).getMethodName(), (Object)"withContentType"))) continue;
                    v4 = t;
                    break block12;
                }
                v4 = null;
            }
            Object var10_15 = v4;
            UCallExpression uCallExpression3 = var10_15 instanceof UCallExpression ? (UCallExpression)var10_15 : null;
            if (uCallExpression3 == null) {
                return null;
            }
            UCallExpression contentTypeCall = uCallExpression3;
            Object object = CollectionsKt.firstOrNull((List)contentTypeCall.getValueArguments());
            UReferenceExpression uReferenceExpression = object instanceof UReferenceExpression ? (UReferenceExpression)object : null;
            if (uReferenceExpression == null) {
                return null;
            }
            UReferenceExpression firstArg = uReferenceExpression;
            return this.getInjectedLanguage(firstArg);
        }
        if (args.size() == 2) {
            UExpression arg = (UExpression)args.get(1);
            if (!(arg instanceof UReferenceExpression)) {
                return null;
            }
            return this.getInjectedLanguage((UReferenceExpression)arg);
        }
        return null;
    }

    private final boolean isTargetMethod(UCallExpression uCallExpression) {
        if (uCallExpression.isMethodNameOneOf((Collection)MockServerBodyLanguageInjectorKt.access$getWITH_BODY_METHOD_NAME$p())) {
            PsiMethod psiMethod = uCallExpression.resolve();
            String qualifiedClassName = psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null;
            return Intrinsics.areEqual((Object)qualifiedClassName, (Object)"org.mockserver.model.HttpResponse") || Intrinsics.areEqual((Object)qualifiedClassName, (Object)"org.mockserver.model.HttpRequest");
        }
        return false;
    }

    private final Injection getInjectedLanguage(UReferenceExpression arg) {
        Injection injection;
        String bodyType = arg.getResolvedName();
        if (this.isJsonBody(bodyType)) {
            Language language = Language.findLanguageByID((String)"JSON");
            Intrinsics.checkNotNull((Object)language);
            injection = (Injection)new SimpleInjection(language, "", "", "java");
        } else {
            injection = this.isXmlBody(bodyType) ? (Injection)new SimpleInjection((Language)XMLLanguage.INSTANCE, "", "", "java") : null;
        }
        return injection;
    }

    private final boolean isJsonBody(String bodyType) {
        return Intrinsics.areEqual((Object)bodyType, (Object)"JSON_UTF_8") || Intrinsics.areEqual((Object)bodyType, (Object)"APPLICATION_JSON") || Intrinsics.areEqual((Object)bodyType, (Object)"APPLICATION_JSON_UTF_8");
    }

    private final boolean isXmlBody(String bodyType) {
        return Intrinsics.areEqual((Object)bodyType, (Object)"XML_UTF_8") || Intrinsics.areEqual((Object)bodyType, (Object)"TEXT_XML") || Intrinsics.areEqual((Object)bodyType, (Object)"TEXT_XML_UTF_8") || Intrinsics.areEqual((Object)bodyType, (Object)"APPLICATION_XML") || Intrinsics.areEqual((Object)bodyType, (Object)"APPLICATION_XML_UTF_8");
    }
}

