/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.oas;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.jvm.oas.SwSemContributor;
import com.intellij.microservices.jvm.oas.v2.SwApiOperation;
import com.intellij.microservices.jvm.oas.v2.SwApiParameter;
import com.intellij.microservices.jvm.oas.v2.SwApiResourceDeclaration;
import com.intellij.microservices.jvm.oas.v3.SwApiResponse;
import com.intellij.microservices.jvm.oas.v3.SwApiResponses;
import com.intellij.microservices.jvm.oas.v3.SwContent;
import com.intellij.microservices.jvm.oas.v3.SwOperation;
import com.intellij.microservices.jvm.oas.v3.SwParameter;
import com.intellij.microservices.jvm.oas.v3.SwSchema;
import com.intellij.microservices.jvm.oas.v3.SwTag;
import com.intellij.microservices.jvm.oas.v3.SwTags;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/microservices/jvm/oas/SwSemContributor;", "Lcom/intellij/semantic/SemContributor;", "<init>", "()V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "registerSemProviders", "", "registrar", "Lcom/intellij/semantic/SemRegistrar;", "registerSwagger3Annotations", "intellij.microservices.jvm"})
public final class SwSemContributor
extends SemContributor {
    protected boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"io.swagger.annotations.Api") || JavaLibraryUtil.hasLibraryClass((Project)project, (String)"io.swagger.v3.oas.annotations.OpenAPIDefinition");
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SwApiResourceDeclaration.Companion.getRESOURCE_DECLARATION_META().register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("io.swagger.annotations.Api"));
        SwApiOperation.Companion.getAPI_OPERATION_META().register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("io.swagger.annotations.ApiOperation"));
        SwApiParameter.Companion.getAPI_PARAM_META().register(registrar, (ElementPattern)PsiJavaPatterns.psiParameter().withAnnotation("io.swagger.annotations.ApiParam"));
        this.registerSwagger3Annotations(registrar);
    }

    private final void registerSwagger3Annotations(SemRegistrar registrar) {
        SwTags.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("io.swagger.v3.oas.annotations.tags.Tags"));
        SwTags.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("io.swagger.v3.oas.annotations.tags.Tags"));
        SwTag.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("io.swagger.v3.oas.annotations.tags.Tag"));
        SwTag.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("io.swagger.v3.oas.annotations.tags.Tag"));
        SwParameter.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiParameter().withAnnotation("io.swagger.v3.oas.annotations.Parameter"));
        SwOperation.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("io.swagger.v3.oas.annotations.Operation"));
        SwApiResponse.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("io.swagger.v3.oas.annotations.responses.ApiResponse"));
        SwApiResponse.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("io.swagger.v3.oas.annotations.responses.ApiResponse"));
        SwApiResponses.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("io.swagger.v3.oas.annotations.responses.ApiResponses"));
        SwApiResponses.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("io.swagger.v3.oas.annotations.responses.ApiResponses"));
        registrar.registerSemElementProvider(SwContent.JAM_KEY, (ElementPattern)PsiJavaPatterns.psiAnnotation().qName("io.swagger.v3.oas.annotations.media.Content"), arg_0 -> SwSemContributor.registerSwagger3Annotations$lambda$0(registerSwagger3Annotations.1.INSTANCE, arg_0));
        registrar.registerSemElementProvider(SwSchema.JAM_KEY, (ElementPattern)PsiJavaPatterns.psiAnnotation().qName("io.swagger.v3.oas.annotations.media.Schema"), arg_0 -> SwSemContributor.registerSwagger3Annotations$lambda$1(registerSwagger3Annotations.2.INSTANCE, arg_0));
    }

    private static final SwContent registerSwagger3Annotations$lambda$0(Function1 $tmp0, Object p0) {
        return (SwContent)$tmp0.invoke(p0);
    }

    private static final SwSchema registerSwagger3Annotations$lambda$1(Function1 $tmp0, Object p0) {
        return (SwSchema)$tmp0.invoke(p0);
    }
}

