/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.okhttp;

import com.intellij.icons.AllIcons;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.jvm.cache.SourceTestLibSearcher;
import com.intellij.microservices.jvm.okhttp.OkHttp;
import com.intellij.microservices.jvm.okhttp.OkHttpHolder;
import com.intellij.microservices.jvm.okhttp.OkHttpModel;
import com.intellij.microservices.jvm.okhttp.OkHttpUrl;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uast.UastModificationTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/intellij/microservices/jvm/okhttp/OkHttpEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/microservices/jvm/okhttp/OkHttpHolder;", "Lcom/intellij/microservices/jvm/okhttp/OkHttpUrl;", "<init>", "()V", "holdersSearcher", "Lcom/intellij/microservices/jvm/cache/SourceTestLibSearcher;", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "group", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "endpoint", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getNavigationElement", "isValidEndpoint", "", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "intellij.microservices.jvm"})
public final class OkHttpEndpointsProvider
implements EndpointsProvider<OkHttpHolder, OkHttpUrl> {
    @NotNull
    private final SourceTestLibSearcher<OkHttpHolder> holdersSearcher = new SourceTestLibSearcher("OKHTTP_FILES", (Function2)new Function2<Module, GlobalSearchScope, List<? extends OkHttpHolder>>((Object)OkHttpModel.INSTANCE){

        public final List<OkHttpHolder> invoke(Module p0, GlobalSearchScope p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return ((OkHttpModel)this.receiver).findHolders(p0, p1);
        }
    });
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("OkHttp", "OkHttp", AllIcons.Javaee.WebServiceClient);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_CLIENT_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!OkHttp.isAvailable(project)) {
            return EndpointsProvider.Status.UNAVAILABLE;
        }
        if (OkHttpModel.INSTANCE.hasUsages(project)) {
            return EndpointsProvider.Status.HAS_ENDPOINTS;
        }
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public Iterable<OkHttpHolder> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!OkHttp.isAvailable(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.holdersSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<OkHttpUrl> getEndpoints(@NotNull OkHttpHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return OkHttpModel.INSTANCE.getEndpoints(group);
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull OkHttpHolder group, @NotNull OkHttpUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return (ItemPresentation)new HttpMethodPresentation(endpoint.getUriPresentation(), endpoint.getHttpMethod(), group.getName(), AllIcons.Nodes.PpWeb, null, 16, null);
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull OkHttpHolder group, @NotNull OkHttpUrl endpoint) {
        UElement parent;
        UElement uElement;
        UElement uElement2;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        UElement uElement3 = uElement2 = UastContextKt.toUElement((PsiElement)endpoint.getPsiElement());
        if (uElement3 != null) {
            Class[] classArray = new Class[]{UClass.class};
            uElement = UastUtils.getParentOfType((UElement)uElement3, (boolean)true, UMethod.class, (Class[])classArray);
        } else {
            uElement = null;
        }
        UElement uElement4 = parent = uElement;
        return uElement4 != null ? uElement4.getSourcePsi() : null;
    }

    @NotNull
    public PsiElement getNavigationElement(@NotNull OkHttpHolder group, @NotNull OkHttpUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getPsiElement();
    }

    public boolean isValidEndpoint(@NotNull OkHttpHolder group, @NotNull OkHttpUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }
}

