/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.starters.wizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.DependencyAvailable;
import com.intellij.ide.starters.shared.DependencyState;
import com.intellij.ide.starters.shared.DependencyUnavailable;
import com.intellij.ide.starters.shared.FormUiUtilKt;
import com.intellij.ide.starters.shared.LibraryInfo;
import com.intellij.ide.starters.shared.StarterWizardSettings;
import com.intellij.ide.starters.shared.ui.LibrariesSearchTextField;
import com.intellij.ide.starters.shared.ui.LibraryDescriptionPanel;
import com.intellij.ide.starters.shared.ui.SelectedLibrariesPanel;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.UIWizardUtil;
import com.intellij.microservices.jvm.starters.DownloadResult;
import com.intellij.microservices.jvm.starters.WebStarterContext;
import com.intellij.microservices.jvm.starters.WebStarterContextProvider;
import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.microservices.jvm.starters.WebStarterDependencyCategory;
import com.intellij.microservices.jvm.starters.WebStarterFrameworkVersion;
import com.intellij.microservices.jvm.starters.WebStarterModuleBuilder;
import com.intellij.microservices.jvm.starters.wizard.WebStarterLibrariesStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010E\u001a\u00020FH\u0016J\n\u0010G\u001a\u0004\u0018\u00010?H\u0016J\n\u0010H\u001a\u0004\u0018\u00010FH\u0016J\b\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020JH\u0016J\b\u0010L\u001a\u00020JH\u0016J\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020NH\u0014J\u0010\u0010P\u001a\u00020N2\u0006\u0010Q\u001a\u00020RH\u0015J\b\u0010S\u001a\u00020JH\u0002J\b\u0010T\u001a\u00020JH\u0002J\f\u0010U\u001a\u00020J*\u00020VH\u0014J\b\u0010W\u001a\u00020\u0019H\u0002J\u000e\u0010X\u001a\b\u0012\u0004\u0012\u0002040YH\u0002J\b\u0010Z\u001a\u00020\u001fH\u0002J\u0018\u0010[\u001a\u00020N2\u0006\u0010\\\u001a\u00020=2\u0006\u0010]\u001a\u00020?H\u0002J\b\u0010^\u001a\u00020$H\u0002J\b\u0010_\u001a\u00020`H\u0014J\u000e\u0010a\u001a\b\u0012\u0004\u0012\u00020c0bH\u0004J\b\u0010d\u001a\u00020.H\u0014J\n\u0010e\u001a\u0004\u0018\u00010fH\u0002J\u0010\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020jH\u0002J\b\u0010k\u001a\u00020JH\u0002J\u0010\u0010l\u001a\u00020J2\u0006\u0010m\u001a\u00020fH\u0002J\u0010\u0010n\u001a\u00020J2\u0006\u0010\\\u001a\u00020=H\u0002J\b\u0010o\u001a\u00020JH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001d\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001d\u001a\u0004\b%\u0010&R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001d\u001a\u0004\b*\u0010+R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u001d\u001a\u0004\b/\u00100R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u000206X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0016\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001040:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010@\u001a\u00020A8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u0010\u001d\u001a\u0004\bB\u0010C\u00a8\u0006p"}, d2={"Lcom/intellij/microservices/jvm/starters/wizard/WebStarterLibrariesStep;", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "contextProvider", "Lcom/intellij/microservices/jvm/starters/WebStarterContextProvider;", "<init>", "(Lcom/intellij/microservices/jvm/starters/WebStarterContextProvider;)V", "moduleBuilder", "Lcom/intellij/microservices/jvm/starters/WebStarterModuleBuilder;", "getModuleBuilder", "()Lcom/intellij/microservices/jvm/starters/WebStarterModuleBuilder;", "wizardContext", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "starterContext", "Lcom/intellij/microservices/jvm/starters/WebStarterContext;", "getStarterContext", "()Lcom/intellij/microservices/jvm/starters/WebStarterContext;", "starterSettings", "Lcom/intellij/ide/starters/shared/StarterWizardSettings;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "topLevelPanel", "Ljavax/swing/JPanel;", "contentPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getContentPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "contentPanel$delegate", "Lkotlin/Lazy;", "librariesList", "Lcom/intellij/ui/CheckboxTreeBase;", "getLibrariesList", "()Lcom/intellij/ui/CheckboxTreeBase;", "librariesList$delegate", "librariesSearchField", "Lcom/intellij/ide/starters/shared/ui/LibrariesSearchTextField;", "getLibrariesSearchField", "()Lcom/intellij/ide/starters/shared/ui/LibrariesSearchTextField;", "librariesSearchField$delegate", "libraryDescriptionPanel", "Lcom/intellij/ide/starters/shared/ui/LibraryDescriptionPanel;", "getLibraryDescriptionPanel", "()Lcom/intellij/ide/starters/shared/ui/LibraryDescriptionPanel;", "libraryDescriptionPanel$delegate", "selectedLibrariesPanel", "Lcom/intellij/ide/starters/shared/ui/SelectedLibrariesPanel;", "getSelectedLibrariesPanel", "()Lcom/intellij/ide/starters/shared/ui/SelectedLibrariesPanel;", "selectedLibrariesPanel$delegate", "frameworkVersionsModel", "Ljavax/swing/DefaultComboBoxModel;", "Lcom/intellij/microservices/jvm/starters/WebStarterFrameworkVersion;", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "getPropertyGraph", "()Lcom/intellij/openapi/observable/properties/PropertyGraph;", "frameworkVersionProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "selectedDependencies", "", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "currentSearchString", "", "searchMergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getSearchMergingUpdateQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "searchMergingUpdateQueue$delegate", "getComponent", "Ljavax/swing/JComponent;", "getHelpId", "getPreferredFocusedComponent", "updateDataModel", "", "onStepLeaving", "_init", "validate", "", "validateFields", "validateWithServer", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "requestWebService", "loadFrameworkVersions", "addFieldsAfter", "Lcom/intellij/ui/dsl/builder/Panel;", "createComponent", "getAvailableFrameworkVersions", "", "createLibrariesList", "isDependencyMatched", "item", "search", "createLibrariesFilter", "getModalityState", "Lcom/intellij/openapi/application/ModalityState;", "getDisposed", "Lcom/intellij/openapi/util/Condition;", "", "createSelectedLibrariesPanel", "getLibrariesRoot", "Lcom/intellij/ui/CheckedTreeNode;", "getDependencyState", "Lcom/intellij/ide/starters/shared/DependencyState;", "libraryInfo", "Lcom/intellij/ide/starters/shared/LibraryInfo;", "loadLibrariesList", "selectFirstDependency", "librariesRoot", "updateSelectedLibraryInfo", "updateAvailableDependencies", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nWebStarterLibrariesStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebStarterLibrariesStep.kt\ncom/intellij/microservices/jvm/starters/wizard/WebStarterLibrariesStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,488:1\n774#2:489\n865#2,2:490\n774#2:492\n865#2,2:493\n14#3:495\n*S KotlinDebug\n*F\n+ 1 WebStarterLibrariesStep.kt\ncom/intellij/microservices/jvm/starters/wizard/WebStarterLibrariesStep\n*L\n122#1:489\n122#1:490,2\n272#1:492\n272#1:493,2\n177#1:495\n*E\n"})
public class WebStarterLibrariesStep
extends ModuleWizardStep {
    @NotNull
    private final WebStarterModuleBuilder moduleBuilder;
    @NotNull
    private final WizardContext wizardContext;
    @NotNull
    private final WebStarterContext starterContext;
    @NotNull
    private final StarterWizardSettings starterSettings;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final JPanel topLevelPanel;
    @NotNull
    private final Lazy contentPanel$delegate;
    @NotNull
    private final Lazy librariesList$delegate;
    @NotNull
    private final Lazy librariesSearchField$delegate;
    @NotNull
    private final Lazy libraryDescriptionPanel$delegate;
    @NotNull
    private final Lazy selectedLibrariesPanel$delegate;
    @NotNull
    private final DefaultComboBoxModel<WebStarterFrameworkVersion> frameworkVersionsModel;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private final GraphProperty<WebStarterFrameworkVersion> frameworkVersionProperty;
    @NotNull
    private final Set<WebStarterDependency> selectedDependencies;
    @NotNull
    private String currentSearchString;
    @NotNull
    private final Lazy searchMergingUpdateQueue$delegate;

    public WebStarterLibrariesStep(@NotNull WebStarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        this.moduleBuilder = contextProvider.getModuleBuilder();
        this.wizardContext = contextProvider.getWizardContext();
        this.starterContext = contextProvider.getStarterContext();
        this.starterSettings = contextProvider.getSettings();
        this.parentDisposable = contextProvider.getParentDisposable();
        this.topLevelPanel = (JPanel)new BorderLayoutPanel();
        this.contentPanel$delegate = LazyKt.lazy(() -> WebStarterLibrariesStep.contentPanel_delegate$lambda$0(this));
        this.librariesList$delegate = LazyKt.lazy(() -> WebStarterLibrariesStep.librariesList_delegate$lambda$1(this));
        this.librariesSearchField$delegate = LazyKt.lazy(() -> WebStarterLibrariesStep.librariesSearchField_delegate$lambda$2(this));
        this.libraryDescriptionPanel$delegate = LazyKt.lazy(WebStarterLibrariesStep::libraryDescriptionPanel_delegate$lambda$3);
        this.selectedLibrariesPanel$delegate = LazyKt.lazy(() -> WebStarterLibrariesStep.selectedLibrariesPanel_delegate$lambda$4(this));
        this.frameworkVersionsModel = new DefaultComboBoxModel();
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.frameworkVersionProperty = this.propertyGraph.property(null);
        this.selectedDependencies = new LinkedHashSet();
        this.currentSearchString = "";
        this.searchMergingUpdateQueue$delegate = LazyKt.lazy(() -> WebStarterLibrariesStep.searchMergingUpdateQueue_delegate$lambda$5(this));
    }

    @NotNull
    protected final WebStarterModuleBuilder getModuleBuilder() {
        return this.moduleBuilder;
    }

    @NotNull
    protected final WebStarterContext getStarterContext() {
        return this.starterContext;
    }

    @NotNull
    protected final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    private final DialogPanel getContentPanel() {
        Lazy lazy = this.contentPanel$delegate;
        return (DialogPanel)lazy.getValue();
    }

    private final CheckboxTreeBase getLibrariesList() {
        Lazy lazy = this.librariesList$delegate;
        return (CheckboxTreeBase)lazy.getValue();
    }

    private final LibrariesSearchTextField getLibrariesSearchField() {
        Lazy lazy = this.librariesSearchField$delegate;
        return (LibrariesSearchTextField)lazy.getValue();
    }

    private final LibraryDescriptionPanel getLibraryDescriptionPanel() {
        Lazy lazy = this.libraryDescriptionPanel$delegate;
        return (LibraryDescriptionPanel)lazy.getValue();
    }

    private final SelectedLibrariesPanel getSelectedLibrariesPanel() {
        Lazy lazy = this.selectedLibrariesPanel$delegate;
        return (SelectedLibrariesPanel)lazy.getValue();
    }

    @NotNull
    protected final PropertyGraph getPropertyGraph() {
        return this.propertyGraph;
    }

    private final MergingUpdateQueue getSearchMergingUpdateQueue() {
        Lazy lazy = this.searchMergingUpdateQueue$delegate;
        return (MergingUpdateQueue)lazy.getValue();
    }

    @NotNull
    public JComponent getComponent() {
        return this.topLevelPanel;
    }

    @Nullable
    public String getHelpId() {
        return this.moduleBuilder.getHelpId();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.getLibrariesSearchField();
    }

    public void updateDataModel() {
        this.starterContext.setFrameworkVersion((WebStarterFrameworkVersion)this.frameworkVersionProperty.get());
        this.starterContext.getDependencies().clear();
        this.starterContext.getDependencies().addAll((Collection<WebStarterDependency>)this.selectedDependencies);
    }

    public void onStepLeaving() {
        super.onStepLeaving();
        this.updateDataModel();
    }

    public void _init() {
        block2: {
            super._init();
            if (this.topLevelPanel.getComponentCount() == 0) {
                this.topLevelPanel.add((Component)this.getContentPanel(), "Center");
            }
            if (this.topLevelPanel.isDisplayable() && this.topLevelPanel.isShowing()) {
                return;
            }
            this.loadLibrariesList();
            this.loadFrameworkVersions();
            this.updateAvailableDependencies();
            CheckedTreeNode checkedTreeNode = this.getLibrariesRoot();
            if (checkedTreeNode == null) break block2;
            CheckedTreeNode it = checkedTreeNode;
            boolean bl = false;
            this.selectFirstDependency(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean validate() {
        void $this$filterTo$iv$iv;
        Object[] $this$filter$iv = (Object[])this.selectedDependencies;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WebStarterDependency it = (WebStarterDependency)element$iv$iv;
            boolean bl = false;
            if (!(this.getDependencyState(it) instanceof DependencyUnavailable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unavailable = (List)destination$iv$iv;
        if (!((Collection)unavailable).isEmpty()) {
            String dependencyInfo = CollectionsKt.joinToString$default((Iterable)unavailable, null, null, null, (int)0, null, WebStarterLibrariesStep::validate$lambda$8, (int)31, null);
            Object object = (WebStarterFrameworkVersion)this.frameworkVersionProperty.get();
            if (object == null || (object = ((WebStarterFrameworkVersion)object).getTitle()) == null) {
                object = "";
            }
            Object version = object;
            objectArray = new Object[]{dependencyInfo, version};
            Messages.showErrorDialog((String)JavaStartersBundle.message((String)"message.unavailable.dependencies", (Object[])objectArray), (String)JavaStartersBundle.message((String)"message.title.error", (Object[])new Object[0]));
            return false;
        }
        if (!this.validateFields()) {
            return false;
        }
        if (this.starterContext.getResult() == null) {
            this.updateDataModel();
            this.requestWebService();
            if (this.starterContext.getResult() == null) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateFields() {
        return true;
    }

    @RequiresBackgroundThread
    protected boolean validateWithServer(@NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        return true;
    }

    private final void requestWebService() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> WebStarterLibrariesStep.requestWebService$lambda$10(this), JavaStartersBundle.message((String)"message.state.preparing.template", (Object[])new Object[0]), true, this.wizardContext.getProject());
    }

    private final void loadFrameworkVersions() {
        WebStarterFrameworkVersion defaultVersion;
        List<WebStarterFrameworkVersion> availableFrameworkVersions = this.getAvailableFrameworkVersions();
        this.frameworkVersionsModel.removeAllElements();
        this.frameworkVersionsModel.addAll((Collection<WebStarterFrameworkVersion>)availableFrameworkVersions);
        WebStarterFrameworkVersion webStarterFrameworkVersion = this.starterContext.getFrameworkVersion();
        if (webStarterFrameworkVersion == null) {
            webStarterFrameworkVersion = (WebStarterFrameworkVersion)CollectionsKt.firstOrNull(availableFrameworkVersions);
        }
        if (CollectionsKt.contains((Iterable)availableFrameworkVersions, (Object)(defaultVersion = webStarterFrameworkVersion))) {
            this.frameworkVersionProperty.set((Object)defaultVersion);
        } else {
            this.frameworkVersionProperty.set(CollectionsKt.firstOrNull(availableFrameworkVersions));
        }
    }

    protected void addFieldsAfter(@NotNull Panel $this$addFieldsAfter) {
        Intrinsics.checkNotNullParameter((Object)$this$addFieldsAfter, (String)"<this>");
    }

    private final DialogPanel createComponent() {
        CustomizedMessages messages = this.starterSettings.getCustomizedMessages();
        StatusText statusText = this.getSelectedLibrariesPanel().getEmptyText();
        Object object = messages;
        if (object == null || (object = object.getNoDependenciesSelectedLabel()) == null) {
            object = JavaStartersBundle.message((String)"hint.dependencies.not.selected", (Object[])new Object[0]);
        }
        statusText.setText((String)object);
        return UIWizardUtil.withVisualPadding$default((DialogPanel)BuilderKt.panel(arg_0 -> WebStarterLibrariesStep.createComponent$lambda$22(this, messages, arg_0)), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebStarterFrameworkVersion> getAvailableFrameworkVersions() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.starterContext.getServerOptions().getFrameworkVersions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WebStarterFrameworkVersion it = (WebStarterFrameworkVersion)element$iv$iv;
            boolean bl = false;
            if (!this.moduleBuilder.isVersionAvailableInternal$intellij_microservices_jvm(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CheckboxTreeBase createLibrariesList() {
        CheckboxTreeBase list2 = new CheckboxTreeBase((CheckboxTreeBase.CheckboxTreeCellRendererBase)new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return;
                }
                this.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
                Object item = ((DefaultMutableTreeNode)value).getUserObject();
                if (item instanceof WebStarterDependencyCategory) {
                    this.getTextRenderer().append(((WebStarterDependencyCategory)item).getTitle());
                } else if (item instanceof WebStarterDependency) {
                    boolean enabled = ((CheckedTreeNode)value).isEnabled();
                    SimpleTextAttributes attributes = enabled ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    this.getTextRenderer().append(((WebStarterDependency)item).getTitle(), attributes);
                }
            }
        }, null);
        list2.getEmptyText().setText(IdeBundle.message((String)"empty.text.nothing.found", (Object[])new Object[0]));
        FormUiUtilKt.enableEnterKeyHandling((CheckboxTreeBase)list2);
        list2.setRowHeight(0);
        list2.setRootVisible(false);
        list2.getSelectionModel().setSelectionMode(1);
        list2.addCheckboxTreeListener(new CheckboxTreeListener(this){
            final /* synthetic */ WebStarterLibrariesStep this$0;
            {
                this.this$0 = $receiver;
            }

            public void nodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object = node.getUserObject();
                WebStarterDependency webStarterDependency = object instanceof WebStarterDependency ? (WebStarterDependency)object : null;
                if (webStarterDependency == null) {
                    return;
                }
                WebStarterDependency dependency = webStarterDependency;
                boolean bl = node.isChecked() ? WebStarterLibrariesStep.access$getSelectedDependencies$p(this.this$0).add(dependency) : WebStarterLibrariesStep.access$getSelectedDependencies$p(this.this$0).remove(dependency);
                WebStarterLibrariesStep.access$getLibrariesList(this.this$0).repaint();
                WebStarterLibrariesStep.access$getSelectedLibrariesPanel(this.this$0).update((Collection)WebStarterLibrariesStep.access$getSelectedDependencies$p(this.this$0));
            }
        });
        list2.getSelectionModel().addTreeSelectionListener(arg_0 -> WebStarterLibrariesStep.createLibrariesList$lambda$24(this, arg_0));
        this.getLibrariesSearchField().setList((JComponent)list2);
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDependencyMatched(WebStarterDependency item, String search) {
        if (StringsKt.contains((CharSequence)item.getTitle(), (CharSequence)search, (boolean)true)) return true;
        String string = item.getDescription();
        if (string == null) {
            string = "";
        }
        if (StringsKt.contains((CharSequence)string, (CharSequence)search, (boolean)true)) return true;
        if (!StringsKt.contains((CharSequence)item.getId(), (CharSequence)search, (boolean)true)) return false;
        return true;
    }

    private final LibrariesSearchTextField createLibrariesFilter() {
        LibrariesSearchTextField textField = new LibrariesSearchTextField();
        textField.addDocumentListener((DocumentListener)new DocumentAdapter(this, textField){
            final /* synthetic */ WebStarterLibrariesStep this$0;
            final /* synthetic */ LibrariesSearchTextField $textField;
            {
                this.this$0 = $receiver;
                this.$textField = $textField;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                WebStarterLibrariesStep.access$getSearchMergingUpdateQueue(this.this$0).queue(Update.Companion.create((Object)"", () -> createLibrariesFilter.1.textChanged$lambda$1(this.this$0, this.$textField)));
            }

            private static final void textChanged$lambda$1$lambda$0(WebStarterLibrariesStep this$0, LibrariesSearchTextField $textField) {
                WebStarterLibrariesStep.access$setCurrentSearchString$p(this$0, $textField.getText());
                WebStarterLibrariesStep.access$loadLibrariesList(this$0);
                WebStarterLibrariesStep.access$getLibrariesList(this$0).repaint();
            }

            private static final void textChanged$lambda$1(WebStarterLibrariesStep this$0, LibrariesSearchTextField $textField) {
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)this$0.getModalityState(), () -> createLibrariesFilter.1.textChanged$lambda$1$lambda$0(this$0, $textField));
            }
        });
        return textField;
    }

    @NotNull
    protected ModalityState getModalityState() {
        Object object = this.wizardContext.getUserData(AbstractWizard.KEY);
        Intrinsics.checkNotNull((Object)object);
        ModalityState modalityState = ModalityState.stateForComponent((Component)((AbstractWizard)object).getContentComponent());
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        return modalityState;
    }

    @NotNull
    protected final Condition<Object> getDisposed() {
        return arg_0 -> WebStarterLibrariesStep.getDisposed$lambda$25(this, arg_0);
    }

    @NotNull
    protected SelectedLibrariesPanel createSelectedLibrariesPanel() {
        SelectedLibrariesPanel panel2 = new SelectedLibrariesPanel();
        CustomizedMessages messages = this.starterSettings.getCustomizedMessages();
        StatusText statusText = panel2.getEmptyText();
        Object object = messages;
        if (object == null || (object = object.getNoDependenciesSelectedLabel()) == null) {
            object = JavaStartersBundle.message((String)"hint.dependencies.not.selected", (Object[])new Object[0]);
        }
        statusText.setText((String)object);
        panel2.setLibraryRemoveListener(arg_0 -> WebStarterLibrariesStep.createSelectedLibrariesPanel$lambda$27(this, arg_0));
        if (this.starterContext.getFrameworkVersion() != null) {
            panel2.setDependencyStateFunction(arg_0 -> WebStarterLibrariesStep.createSelectedLibrariesPanel$lambda$28(this, arg_0));
        }
        return panel2;
    }

    private final CheckedTreeNode getLibrariesRoot() {
        Object object = this.getLibrariesList().getModel().getRoot();
        return object instanceof CheckedTreeNode ? (CheckedTreeNode)object : null;
    }

    private final DependencyState getDependencyState(LibraryInfo libraryInfo) {
        WebStarterFrameworkVersion webStarterFrameworkVersion = (WebStarterFrameworkVersion)this.frameworkVersionProperty.get();
        if (webStarterFrameworkVersion == null) {
            return (DependencyState)DependencyAvailable.INSTANCE;
        }
        WebStarterFrameworkVersion frameworkVersion = webStarterFrameworkVersion;
        Intrinsics.checkNotNull((Object)libraryInfo, (String)"null cannot be cast to non-null type com.intellij.microservices.jvm.starters.WebStarterDependency");
        return this.moduleBuilder.getDependencyStateInternal$intellij_microservices_jvm(frameworkVersion, (WebStarterDependency)libraryInfo);
    }

    private final void loadLibrariesList() {
        CheckedTreeNode librariesRoot = new CheckedTreeNode();
        String search = ((Object)StringsKt.trim((CharSequence)this.currentSearchString)).toString();
        List<WebStarterDependencyCategory> dependencyCategories = this.starterContext.getServerOptions().getDependencyCategories();
        for (WebStarterDependencyCategory webStarterDependencyCategory : dependencyCategories) {
            if (!webStarterDependencyCategory.isAvailable(this.starterContext)) continue;
            DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(webStarterDependencyCategory, true);
            for (WebStarterDependency dependency : webStarterDependencyCategory.getDependencies()) {
                if (!StringsKt.isBlank((CharSequence)search) && !this.isDependencyMatched(dependency, search)) continue;
                CheckedTreeNode libraryNode = new CheckedTreeNode((Object)dependency);
                if (dependency.isDefault()) {
                    this.selectedDependencies.add(dependency);
                }
                libraryNode.setChecked(this.selectedDependencies.contains(dependency));
                DependencyState state = this.getDependencyState(dependency);
                libraryNode.setEnabled(!dependency.isDefault() && state instanceof DependencyAvailable);
                if (dependencyCategories.size() > 1) {
                    categoryNode.add((MutableTreeNode)libraryNode);
                    continue;
                }
                librariesRoot.add((MutableTreeNode)libraryNode);
            }
            if (dependencyCategories.size() <= 1 || categoryNode.getChildCount() <= 0) continue;
            librariesRoot.add((MutableTreeNode)categoryNode);
        }
        this.getLibrariesList().setModel((TreeModel)new DefaultTreeModel((TreeNode)librariesRoot));
        if (!StringsKt.isBlank((CharSequence)search)) {
            Enumeration enumeration = librariesRoot.children();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
            Iterator iterator = CollectionsKt.iterator((Enumeration)enumeration);
            while (iterator.hasNext()) {
                TreeNode treeNode = (TreeNode)iterator.next();
                this.getLibrariesList().expandPath(TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)treeNode));
            }
            this.selectFirstDependency(librariesRoot);
        }
    }

    private final void selectFirstDependency(CheckedTreeNode librariesRoot) {
        if (librariesRoot.getChildCount() > 0) {
            TreeNode firstNode = librariesRoot.getChildAt(0);
            if (firstNode instanceof CheckedTreeNode) {
                this.getLibrariesList().getSelectionModel().addSelectionPath(TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)firstNode));
            } else {
                this.getLibrariesList().expandPath(TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)firstNode));
                if (firstNode.getChildCount() > 0) {
                    this.getLibrariesList().getSelectionModel().addSelectionPath(TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)firstNode.getChildAt(0)));
                }
            }
        }
    }

    private final void updateSelectedLibraryInfo(WebStarterDependency item) {
        DependencyState dependencyState = this.getDependencyState(item);
        String versionInfo = dependencyState instanceof DependencyUnavailable ? ((DependencyUnavailable)dependencyState).getHint() : null;
        this.getLibraryDescriptionPanel().update((LibraryInfo)item, versionInfo);
    }

    private final void updateAvailableDependencies() {
        Object selectedDependency;
        this.getSelectedLibrariesPanel().update((Collection)this.selectedDependencies);
        CheckedTreeNode checkedTreeNode = this.getLibrariesRoot();
        if (checkedTreeNode == null) {
            return;
        }
        CheckedTreeNode root = checkedTreeNode;
        FormUiUtilKt.walkCheckedTree((CheckedTreeNode)root, arg_0 -> WebStarterLibrariesStep.updateAvailableDependencies$lambda$29(this, arg_0));
        this.getLibrariesList().repaint();
        TreePath treePath = this.getLibrariesList().getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        CheckedTreeNode checkedTreeNode2 = object instanceof CheckedTreeNode ? (CheckedTreeNode)object : null;
        Object object2 = selectedDependency = checkedTreeNode2 != null ? checkedTreeNode2.getUserObject() : null;
        if (selectedDependency instanceof WebStarterDependency) {
            this.updateSelectedLibraryInfo((WebStarterDependency)selectedDependency);
        }
    }

    private static final DialogPanel contentPanel_delegate$lambda$0(WebStarterLibrariesStep this$0) {
        return this$0.createComponent();
    }

    private static final CheckboxTreeBase librariesList_delegate$lambda$1(WebStarterLibrariesStep this$0) {
        return this$0.createLibrariesList();
    }

    private static final LibrariesSearchTextField librariesSearchField_delegate$lambda$2(WebStarterLibrariesStep this$0) {
        return this$0.createLibrariesFilter();
    }

    private static final LibraryDescriptionPanel libraryDescriptionPanel_delegate$lambda$3() {
        return new LibraryDescriptionPanel();
    }

    private static final SelectedLibrariesPanel selectedLibrariesPanel_delegate$lambda$4(WebStarterLibrariesStep this$0) {
        return this$0.createSelectedLibrariesPanel();
    }

    private static final MergingUpdateQueue searchMergingUpdateQueue_delegate$lambda$5(WebStarterLibrariesStep this$0) {
        return new MergingUpdateQueue("SearchLibs_" + this$0.moduleBuilder.getBuilderId(), 250, true, (JComponent)this$0.topLevelPanel, this$0.parentDisposable, null, false, 96, null);
    }

    private static final CharSequence validate$lambda$8(WebStarterDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTitle();
    }

    private static final void requestWebService$lambda$10$lambda$9(Exception $e, WebStarterLibrariesStep this$0) {
        Object[] objectArray = new Object[]{$e.getMessage()};
        String string = JavaStartersBundle.message((String)"error.text.with.error.content", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        message = StringUtil.shortenTextWithEllipsis((String)message, (int)1024, (int)0);
        Messages.showErrorDialog((String)message, (String)this$0.moduleBuilder.getPresentableName());
    }

    private static final void requestWebService$lambda$10(WebStarterLibrariesStep this$0) {
        DownloadResult downloadResult;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNull((Object)progressIndicator);
        if (!this$0.validateWithServer(progressIndicator)) {
            return;
        }
        progressIndicator.checkCanceled();
        Object[] objectArray = new Object[]{this$0.moduleBuilder.getPresentableName()};
        progressIndicator.setText(JavaStartersBundle.message((String)"message.state.downloading.template", (Object[])objectArray));
        try {
            downloadResult = this$0.moduleBuilder.downloadResultInternal$intellij_microservices_jvm(progressIndicator);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(WebStarterLibrariesStep.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info((Throwable)e);
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> WebStarterLibrariesStep.requestWebService$lambda$10$lambda$9(e, this$0), 3L, TimeUnit.SECONDS);
            downloadResult = null;
        }
        DownloadResult downloadResult2 = downloadResult;
        this$0.starterContext.setResult(downloadResult2);
    }

    private static final String createComponent$lambda$22$lambda$13$lambda$11(WebStarterFrameworkVersion it) {
        Object object = it;
        if (object == null || (object = ((WebStarterFrameworkVersion)object).getTitle()) == null) {
            object = "";
        }
        return object;
    }

    private static final String createComponent$lambda$22$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit createComponent$lambda$22$lambda$13(List $frameworkVersions, WebStarterLibrariesStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if ($frameworkVersions.size() == 1) {
            v0 = $this$row.label(((WebStarterFrameworkVersion)$frameworkVersions.get(0)).getTitle());
        } else {
            this$0.frameworkVersionsModel.addListDataListener(new ListDataListener(this$0){
                final /* synthetic */ WebStarterLibrariesStep this$0;
                {
                    this.this$0 = $receiver;
                }

                public void intervalAdded(ListDataEvent e) {
                    WebStarterLibrariesStep.access$updateAvailableDependencies(this.this$0);
                }

                public void intervalRemoved(ListDataEvent e) {
                    WebStarterLibrariesStep.access$updateAvailableDependencies(this.this$0);
                }

                public void contentsChanged(ListDataEvent e) {
                    WebStarterLibrariesStep.access$updateAvailableDependencies(this.this$0);
                }
            });
            v0 = ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)this$0.frameworkVersionsModel, (ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> WebStarterLibrariesStep.createComponent$lambda$22$lambda$13$lambda$12(WebStarterLibrariesStep::createComponent$lambda$22$lambda$13$lambda$11, arg_0))), (ObservableMutableProperty)((ObservableMutableProperty)this$0.frameworkVersionProperty));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$22$lambda$14(CustomizedMessages $messages, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object object = $messages;
        if (object == null || (object = object.getDependenciesLabel()) == null) {
            String string = JavaStartersBundle.message((String)"title.project.dependencies.label", (Object[])new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        $this$row.label((String)object);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createComponent$lambda$22$lambda$21(WebStarterLibrariesStep this$0, CustomizedMessages $messages, Row $this$row) {
        void $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417;
        JBLabel jBLabel;
        void $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418;
        LibraryDescriptionPanel $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2416;
        LibraryDescriptionPanel libraryDescriptionPanel;
        void $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
        Object $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2415;
        void $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420;
        Object object;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JPanel jPanel2 = jPanel = new JPanel(new GridBagLayout());
        Row row = $this$row;
        boolean bl = false;
        BorderLayoutPanel borderLayoutPanel = object = new BorderLayoutPanel();
        void var8_9 = $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420;
        boolean bl2 = false;
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2415.setPreferredSize(new Dimension(0, 0));
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2415.addToTop((Component)this$0.getLibrariesSearchField());
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2415.addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this$0.getLibrariesList())));
        var8_9.add((Component)object, FormUiUtilKt.gridConstraint((int)0, (int)0));
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2415 = object = new JPanel(new GridBagLayout());
        var8_9 = $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420;
        boolean bl3 = false;
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.setPreferredSize(new Dimension(0, 0));
        LibraryDescriptionPanel libraryDescriptionPanel2 = libraryDescriptionPanel = this$0.getLibraryDescriptionPanel();
        void var12_13 = $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
        boolean bl4 = false;
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2416.setPreferredSize(new Dimension(0, 0));
        var12_13.add((Component)libraryDescriptionPanel, FormUiUtilKt.gridConstraint((int)0, (int)0));
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2416 = libraryDescriptionPanel = new BorderLayoutPanel();
        var12_13 = $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
        boolean bl5 = false;
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.setPreferredSize(new Dimension(0, 0));
        Object object2 = $messages;
        if (object2 == null || (object2 = object2.getSelectedDependenciesLabel()) == null) {
            String string = JavaStartersBundle.message((String)"title.project.dependencies.selected.label", (Object[])new Object[0]);
            object2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        JBLabel jBLabel2 = jBLabel = new JBLabel((String)object2);
        void var16_17 = $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418;
        boolean bl6 = false;
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        var16_17.addToTop((Component)jBLabel);
        $this$createComponent_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.addToCenter((Component)this$0.getSelectedLibrariesPanel());
        var12_13.add((Component)libraryDescriptionPanel, FormUiUtilKt.gridConstraint((int)0, (int)1));
        var8_9.add((Component)object, FormUiUtilKt.gridConstraint((int)1, (int)0));
        row.cell((JComponent)jPanel).resizableColumn().align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$22(WebStarterLibrariesStep this$0, CustomizedMessages $messages, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        List<WebStarterFrameworkVersion> frameworkVersions = this$0.getAvailableFrameworkVersions();
        if (!((Collection)frameworkVersions).isEmpty()) {
            Object object = $messages;
            if (object == null || (object = object.getFrameworkVersionLabel()) == null) {
                String string = JavaStartersBundle.message((String)"title.project.version.label", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            $this$panel.row((String)object, arg_0 -> WebStarterLibrariesStep.createComponent$lambda$22$lambda$13(frameworkVersions, this$0, arg_0)).bottomGap(BottomGap.SMALL);
        }
        this$0.addFieldsAfter($this$panel);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> WebStarterLibrariesStep.createComponent$lambda$22$lambda$14($messages, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> WebStarterLibrariesStep.createComponent$lambda$22$lambda$21(this$0, $messages, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final void createLibrariesList$lambda$24(WebStarterLibrariesStep this$0, TreeSelectionEvent e) {
        TreePath path = e.getPath();
        if (path != null && e.isAddedPath()) {
            Object item;
            Object object = path.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
            Object object2 = item = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
            if (item instanceof WebStarterDependency) {
                this$0.updateSelectedLibraryInfo((WebStarterDependency)item);
            } else if (item instanceof WebStarterDependencyCategory) {
                this$0.getLibraryDescriptionPanel().update(((WebStarterDependencyCategory)item).getTitle(), null);
            }
        } else {
            this$0.getLibraryDescriptionPanel().reset();
        }
    }

    private static final boolean getDisposed$lambda$25(WebStarterLibrariesStep this$0, Object it) {
        return Disposer.isDisposed((Disposable)this$0.parentDisposable);
    }

    private static final Unit createSelectedLibrariesPanel$lambda$27$lambda$26(LibraryInfo $libraryInfo, WebStarterLibrariesStep this$0, CheckedTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it.getUserObject(), (Object)$libraryInfo)) {
            this$0.getLibrariesList().setNodeState(it, false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createSelectedLibrariesPanel$lambda$27(WebStarterLibrariesStep this$0, LibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        TypeIntrinsics.asMutableCollection((Object)this$0.selectedDependencies).remove(libraryInfo);
        FormUiUtilKt.walkCheckedTree((CheckedTreeNode)this$0.getLibrariesRoot(), arg_0 -> WebStarterLibrariesStep.createSelectedLibrariesPanel$lambda$27$lambda$26(libraryInfo, this$0, arg_0));
        this$0.getSelectedLibrariesPanel().update((Collection)this$0.selectedDependencies);
        return Unit.INSTANCE;
    }

    private static final DependencyState createSelectedLibrariesPanel$lambda$28(WebStarterLibrariesStep this$0, LibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        return this$0.getDependencyState(libraryInfo);
    }

    private static final Unit updateAvailableDependencies$lambda$29(WebStarterLibrariesStep this$0, CheckedTreeNode it) {
        WebStarterDependency dependency;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getUserObject();
        WebStarterDependency webStarterDependency = dependency = object instanceof WebStarterDependency ? (WebStarterDependency)object : null;
        if (dependency != null) {
            DependencyState state = this$0.getDependencyState(dependency);
            it.setEnabled(!dependency.isDefault() && state instanceof DependencyAvailable);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Set access$getSelectedDependencies$p(WebStarterLibrariesStep $this) {
        return $this.selectedDependencies;
    }

    public static final /* synthetic */ CheckboxTreeBase access$getLibrariesList(WebStarterLibrariesStep $this) {
        return $this.getLibrariesList();
    }

    public static final /* synthetic */ SelectedLibrariesPanel access$getSelectedLibrariesPanel(WebStarterLibrariesStep $this) {
        return $this.getSelectedLibrariesPanel();
    }

    public static final /* synthetic */ MergingUpdateQueue access$getSearchMergingUpdateQueue(WebStarterLibrariesStep $this) {
        return $this.getSearchMergingUpdateQueue();
    }

    public static final /* synthetic */ void access$setCurrentSearchString$p(WebStarterLibrariesStep $this, String string) {
        $this.currentSearchString = string;
    }

    public static final /* synthetic */ void access$loadLibrariesList(WebStarterLibrariesStep $this) {
        $this.loadLibrariesList();
    }

    public static final /* synthetic */ void access$updateAvailableDependencies(WebStarterLibrariesStep $this) {
        $this.updateAvailableDependencies();
    }
}

