/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.javaee.web;

import com.intellij.facet.FacetType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.appServers.facet.AppServerWebFacetSettingsService;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.javaee.web.workspaceModel.WebSettingsEntity;
import com.intellij.javaee.web.workspaceModel.WebSettingsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.io.Decompressor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.MavenExtBundle;
import org.jetbrains.idea.maven.ext.javaee.JavaeeFacetConfiguratorBase;
import org.jetbrains.idea.maven.ext.javaee.JavaeeFacetImpostor;
import org.jetbrains.idea.maven.ext.javaee.JavaeeFacetLibraryWrapper;
import org.jetbrains.idea.maven.ext.javaee.JavaeeImporterArtifact;
import org.jetbrains.idea.maven.ext.javaee.JavaeeImporterArtifacts;
import org.jetbrains.idea.maven.ext.javaee.JavaeePostTask;
import org.jetbrains.idea.maven.ext.javaee.OutputFileNameMappingResolver;
import org.jetbrains.idea.maven.ext.javaee.web.WebFacetConfigurator;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.maven.compiler.MavenPatternFileFilter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0006defghiB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016Jm\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00120\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001aH\u0014J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001aH\u0014J}\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00120\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0014\u00a2\u0006\u0002\u0010(J4\u0010)\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\u0018\u00100\u001a\u00020\f2\u0006\u0010%\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00102\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00103\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J*\u00104\u001a\u00020\f2\u0006\u0010%\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u00122\b\b\u0002\u00106\u001a\u00020\u0012H\u0002J\u0016\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J(\u0010:\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010;\u001a\u0002092\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020/H\u0014J \u0010>\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010?\u001a\u0002092\u0006\u0010=\u001a\u00020/H\u0014JH\u0010@\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010;\u001a\u0002092\u0006\u0010D\u001a\u00020\u0012H\u0014J@\u0010E\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010;\u001a\u0002092\u0006\u0010D\u001a\u00020\u0012H\u0014J@\u0010F\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010;\u001a\u0002092\u0006\u0010D\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u0012H\u0014JK\u0010H\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020B2\u0006\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010G\u001a\u00020\u00122\u0006\u0010D\u001a\u00020\u0012H\u0014\u00a2\u0006\u0002\u0010LJ\u0018\u0010M\u001a\u00020/2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020\u0012H\u0002J \u0010M\u001a\u00020/2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020\u00122\u0006\u0010D\u001a\u00020\u0012H\u0002J6\u0010O\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010;\u001a\u0002092\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0014J\u0010\u0010P\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u001aH\u0014J\u0012\u0010Q\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u001aH\u0016J \u0010R\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010A\u001a\u0002092\u0006\u0010S\u001a\u00020TH\u0002J\u0018\u0010U\u001a\u00020V2\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010A\u001a\u000209H\u0002J&\u0010W\u001a\b\u0012\u0004\u0012\u00020X082\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010Y\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u0012H\u0002J\u0010\u0010[\u001a\u00020/2\u0006\u0010;\u001a\u000209H\u0002J.\u0010\\\u001a\b\u0012\u0004\u0012\u00020X082\b\u0010]\u001a\u0004\u0018\u00010^2\u0006\u0010_\u001a\u00020\u00122\f\u0010`\u001a\b\u0012\u0004\u0012\u00020X08H\u0002J\u0010\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020bH\u0002\u00a8\u0006j"}, d2={"Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator;", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeeFacetConfiguratorBase;", "Lcom/intellij/javaee/web/facet/WebFacet;", "Lcom/intellij/javaee/web/facet/WebFacetConfiguration;", "Lcom/intellij/javaee/web/facet/WebFacetType;", "<init>", "()V", "createWorkspaceEntity", "Lcom/intellij/javaee/web/workspaceModel/WebSettingsEntity$Builder;", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity$Builder;", "reimportFacet", "", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "sourceRoots", "", "artifactModel", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeeImporterArtifacts;", "mavenTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "mavenProjectToModuleName", "", "postTasks", "", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeePostTask;", "(Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/idea/maven/ext/javaee/JavaeeImporterArtifacts;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/util/Map;Ljava/util/List;)V", "getTargetName", "p", "getExplodedPath", "reimportJavaeeFacet", "facet", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeeFacetImpostor;", "facetName", "(Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/idea/maven/ext/javaee/JavaeeImporterArtifacts;Lorg/jetbrains/idea/maven/ext/javaee/JavaeeFacetImpostor;Ljava/lang/String;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/util/Map;Ljava/util/List;)V", "prepareRootElement", "rootElement", "Lcom/intellij/packaging/elements/CompositePackagingElement;", "getArtifactType", "Lcom/intellij/packaging/artifacts/ArtifactType;", "exploded", "", "reimportWebRoots", "Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$WebFacetImpostor;", "getWebRootPath", "getDescriptorsDirectoryPath", "addWebRoot", "rootDir", "targetPath", "getOrderedDependenciesToPackage", "", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "getJarFileNameForModule", "depArtifact", "depProject", "withConflict", "getJarFileNameForLibrary", "mavenArtifact", "addFacetDependency", "artifact", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeeImporterArtifact;", "depModuleName", "jarFileName", "addModuleDependency", "doAddModuleDependency", "relativeOutputPath", "doAddLibraryDependency", "library", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeeFacetLibraryWrapper;", "libraryUrls", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/ext/javaee/JavaeeImporterArtifact;Lorg/jetbrains/idea/maven/ext/javaee/JavaeeFacetLibraryWrapper;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "isPackagingExcluded", "relativePath", "reimportCustomDependencyPackaging", "isLinkViaManifest", "getManifestClasspathPrefix", "addOverlay", "task", "Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$AddOverlayTask;", "collectSettings", "Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$OverlaySettings;", "collectGlobalPatterns", "Ljava/util/regex/Pattern;", "path", "defaultValue", "isOverlay", "collectPatterns", "configElement", "Lorg/jdom/Element;", "elementName", "defaultPatterns", "makeOverlayInfoFile", "Ljava/io/File;", "overlayDir", "WebFacetImpostor", "SetupAdditionalSettingsPostTask", "RemoveOldOverlaysPostTask", "OverlayExtractingTask", "OverlaySettings", "AddOverlayTask", "intellij.maven.ext"})
@SourceDebugExtension(value={"SMAP\nWebFacetConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebFacetConfigurator.kt\norg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,626:1\n127#2,2:627\n2632#3,3:629\n*S KotlinDebug\n*F\n+ 1 WebFacetConfigurator.kt\norg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator\n*L\n118#1:627,2\n268#1:629,3\n*E\n"})
final class WebFacetConfigurator
extends JavaeeFacetConfiguratorBase<WebFacet, WebFacetConfiguration, WebFacetType> {
    public WebFacetConfigurator() {
        WebFacetType webFacetType = WebFacetType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)webFacetType, (String)"getInstance(...)");
        super("org.apache.maven.plugins", "maven-war-plugin", "war", (JavaeeFacetType)webFacetType);
    }

    @NotNull
    public WebSettingsEntity.Builder createWorkspaceEntity(@NotNull ModuleEntity.Builder module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return WebSettingsEntity.Companion.create(this.getMyDefaultFacetName(), new ModuleId(module.getName()), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), module.getEntitySource(), arg_0 -> WebFacetConfigurator.createWorkspaceEntity$lambda$0(module, arg_0));
    }

    @Override
    public void reimportFacet(@NotNull MutableEntityStorage storage, @NotNull Project project, @NotNull String moduleName, @NotNull String[] sourceRoots, @NotNull JavaeeImporterArtifacts artifactModel, @NotNull MavenProjectsTree mavenTree, @NotNull MavenProject mavenProject, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<JavaeePostTask> postTasks) {
        Object element$iv2;
        WebFacetImpostor facet;
        block1: {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)sourceRoots, (String)"sourceRoots");
            Intrinsics.checkNotNullParameter((Object)artifactModel, (String)"artifactModel");
            Intrinsics.checkNotNullParameter((Object)mavenTree, (String)"mavenTree");
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
            Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
            facet = new WebFacetImpostor();
            this.reimportJavaeeFacet(storage, project, moduleName, sourceRoots, artifactModel, facet, this.getMyDefaultFacetName(), mavenTree, mavenProject, mavenProjectToModuleName, postTasks);
            Sequence $this$first$iv = storage.entities(WebSettingsEntity.class);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                WebSettingsEntity it = (WebSettingsEntity)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModule().getName(), (Object)moduleName)) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        WebSettingsEntity webSettingsEntity = (WebSettingsEntity)element$iv2;
        WebSettingsKt.modifyWebSettingsEntity((MutableEntityStorage)storage, (WebSettingsEntity)webSettingsEntity, arg_0 -> WebFacetConfigurator.reimportFacet$lambda$2(facet, arg_0));
    }

    @Override
    @NotNull
    protected String getTargetName(@NotNull MavenProject p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String warName = this.findConfigValue(p, "warName", super.getTargetName(p));
        String classifier = this.findConfigValue(p, "classifier");
        return StringUtil.isEmpty((String)classifier) ? warName : warName + "-" + classifier;
    }

    @Override
    @NotNull
    protected String getExplodedPath(@NotNull MavenProject p) {
        String string;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String result = this.findConfigValue(p, "webappDirectory");
        if (result == null) {
            String[] stringArray = new String[]{p.getBuildDirectory(), p.getFinalName()};
            string = this.makePath(p, stringArray);
        } else {
            String[] stringArray = new String[]{result};
            string = this.makePath(p, stringArray);
        }
        return string;
    }

    @Override
    protected void reimportJavaeeFacet(@NotNull MutableEntityStorage storage, @NotNull Project project, @NotNull String moduleName, @NotNull String[] sourceRoots, @NotNull JavaeeImporterArtifacts artifactModel, @NotNull JavaeeFacetImpostor facet, @NotNull String facetName, @NotNull MavenProjectsTree mavenTree, @NotNull MavenProject mavenProject, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<JavaeePostTask> postTasks) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)sourceRoots, (String)"sourceRoots");
        Intrinsics.checkNotNullParameter((Object)artifactModel, (String)"artifactModel");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        Intrinsics.checkNotNullParameter((Object)mavenTree, (String)"mavenTree");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        WebFacetImpostor webFacet = (WebFacetImpostor)facet;
        this.reimportWebRoots(webFacet, mavenProject);
        super.reimportJavaeeFacet(storage, project, moduleName, sourceRoots, artifactModel, facet, facetName, mavenTree, mavenProject, mavenProjectToModuleName, postTasks);
        postTasks.add(0, new SetupAdditionalSettingsPostTask());
        postTasks.add(0, new RemoveOldOverlaysPostTask(mavenProject, webFacet));
    }

    @Override
    protected void prepareRootElement(@NotNull Project project, @NotNull String moduleName, @NotNull String facetName, @NotNull MavenProject mavenProject, @NotNull CompositePackagingElement<?> rootElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter(rootElement, (String)"rootElement");
        ArtifactUtil.removeChildrenRecursively(rootElement, arg_0 -> WebFacetConfigurator.prepareRootElement$lambda$4(arg_0 -> WebFacetConfigurator.prepareRootElement$lambda$3(moduleName, arg_0), arg_0));
        boolean addModule = rootElement.getChildren().isEmpty();
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        PackagingElement packagingElement = addModule ? factory.getOrCreateDirectory(rootElement, ((WebFacetType)this.getMyFacetType()).getDefaultUriForDirectory()).addOrFindChild(factory.createModuleOutput(moduleName, project)) : rootElement.moveChild(1, -1);
        this.prepareArtifactManifest(rootElement, mavenProject);
        rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement(project, moduleName, (FacetType)this.getMyFacetType(), facetName));
    }

    @Override
    @NotNull
    protected ArtifactType getArtifactType(boolean exploded) {
        ArtifactType artifactType;
        if (exploded) {
            ArtifactType artifactType2 = WebArtifactUtil.getInstance().getExplodedWarArtifactType();
            artifactType = artifactType2;
            Intrinsics.checkNotNullExpressionValue((Object)artifactType2, (String)"getExplodedWarArtifactType(...)");
        } else {
            ArtifactType artifactType3 = WebArtifactUtil.getInstance().getWarArtifactType();
            artifactType = artifactType3;
            Intrinsics.checkNotNullExpressionValue((Object)artifactType3, (String)"getWarArtifactType(...)");
        }
        return artifactType;
    }

    private final void reimportWebRoots(WebFacetImpostor facet, MavenProject mavenProject) {
        String string;
        facet.removeAllWebRoots();
        String webSourceDir = this.getWebRootPath(mavenProject);
        String xmlFile = this.findConfigValue(mavenProject, "webXml");
        if (xmlFile != null) {
            var5_5 = new String[]{xmlFile};
            string = this.makePath(mavenProject, (String[])var5_5);
        } else {
            var5_5 = new String[]{webSourceDir, "WEB-INF/web.xml"};
            string = this.makePath(mavenProject, (String[])var5_5);
        }
        xmlFile = string;
        JavaeeFacetImpostor javaeeFacetImpostor = facet;
        ConfigFileMetaData configFileMetaData = DeploymentDescriptorsConstants.WEB_XML_META_DATA;
        Intrinsics.checkNotNullExpressionValue((Object)configFileMetaData, (String)"WEB_XML_META_DATA");
        this.setDescriptor(javaeeFacetImpostor, configFileMetaData, xmlFile);
        for (Element each : MavenJDOMUtil.findChildrenByPath((Element)this.getConfig(mavenProject), (String)"webResources", (String)"resource")) {
            String targetPath;
            String dir = MavenJDOMUtil.findChildValueByPath$default((Element)each, (String)"directory", null, (int)4, null);
            Intrinsics.checkNotNull((Object)MavenJDOMUtil.findChildValueByPath((Element)each, (String)"targetPath", (String)"/"));
            if (dir == null) continue;
            this.addWebRoot(facet, mavenProject, dir, targetPath);
        }
        WebFacetConfigurator.addWebRoot$default(this, facet, mavenProject, webSourceDir, null, 8, null);
    }

    private final String getWebRootPath(MavenProject mavenProject) {
        return this.findConfigValue(mavenProject, "warSourceDirectory", "src/main/webapp");
    }

    @Override
    @NotNull
    protected String getDescriptorsDirectoryPath(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return this.getWebRootPath(mavenProject);
    }

    private final void addWebRoot(WebFacetImpostor facet, MavenProject mavenProject, String rootDir, String targetPath) {
        boolean bl;
        String url;
        block4: {
            String[] stringArray = new String[]{rootDir};
            String string = VfsUtilCore.pathToUrl((String)this.makePath(mavenProject, stringArray));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
            url = string;
            Iterable $this$none$iv = facet.getWebRoots();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    WebRootData it = (WebRootData)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            facet.addWebRootNoFire(url, targetPath);
        }
    }

    static /* synthetic */ void addWebRoot$default(WebFacetConfigurator webFacetConfigurator, WebFacetImpostor webFacetImpostor, MavenProject mavenProject, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "/";
        }
        webFacetConfigurator.addWebRoot(webFacetImpostor, mavenProject, string, string2);
    }

    @Override
    @NotNull
    protected List<MavenArtifact> getOrderedDependenciesToPackage(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        List<MavenArtifact> deps = super.getOrderedDependenciesToPackage(mavenProject);
        List<JavaeeFacetConfiguratorBase.ArtifactConfig> configs = this.getArtifactConfigs(mavenProject, "overlays", "overlay");
        return CollectionsKt.sortedWith((Iterable)deps, (arg_0, arg_1) -> WebFacetConfigurator.getOrderedDependenciesToPackage$lambda$6(this, configs, deps, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected String getJarFileNameForModule(@NotNull MavenProject mavenProject, @NotNull MavenArtifact depArtifact, @NotNull MavenProject depProject, boolean withConflict) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)depArtifact, (String)"depArtifact");
        Intrinsics.checkNotNullParameter((Object)depProject, (String)"depProject");
        Object mapping = this.findConfigValue(mavenProject, "outputFileNameMapping");
        if (mapping == null) {
            CharSequence charSequence = depArtifact.getClassifier();
            Object object = mapping = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "@{artifactId}@-@{version}@.@{extension}@" : "@{artifactId}@-@{version}@-@{classifier}@.@{extension}@";
        }
        if (withConflict && !StringsKt.contains$default((CharSequence)((CharSequence)mapping), (CharSequence)"@{groupId}@", (boolean)false, (int)2, null)) {
            mapping = "@{groupId}@-" + (String)mapping;
        }
        String string = OutputFileNameMappingResolver.resolveOutputFileNameMapping((String)mapping, depArtifact);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolveOutputFileNameMapping(...)");
        return string;
    }

    @Override
    @NotNull
    protected String getJarFileNameForLibrary(@NotNull MavenProject mavenProject, @NotNull MavenArtifact mavenArtifact, boolean withConflict) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)mavenArtifact, (String)"mavenArtifact");
        Object mapping = this.findConfigValue(mavenProject, "outputFileNameMapping");
        if (mapping == null) {
            return super.getJarFileNameForLibrary(mavenProject, mavenArtifact, withConflict);
        }
        if (withConflict && !StringsKt.contains$default((CharSequence)((CharSequence)mapping), (CharSequence)"@{groupId}@", (boolean)false, (int)2, null)) {
            mapping = "@{groupId}@-" + (String)mapping;
        }
        String string = OutputFileNameMappingResolver.resolveOutputFileNameMapping((String)mapping, mavenArtifact);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolveOutputFileNameMapping(...)");
        return string;
    }

    @Override
    protected boolean addFacetDependency(@NotNull MutableEntityStorage storage, @NotNull Project project, @NotNull JavaeeImporterArtifacts artifactModel, @NotNull MavenProject mavenProject, @NotNull JavaeeImporterArtifact artifact, @NotNull String depModuleName, @NotNull MavenArtifact depArtifact, @NotNull String jarFileName) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)artifactModel, (String)"artifactModel");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)depModuleName, (String)"depModuleName");
        Intrinsics.checkNotNullParameter((Object)depArtifact, (String)"depArtifact");
        Intrinsics.checkNotNullParameter((Object)jarFileName, (String)"jarFileName");
        if (!this.isOverlay(depArtifact)) {
            return false;
        }
        this.addOverlay(mavenProject, depArtifact, new AddOverlayTask(project, this, depModuleName, artifact){
            final /* synthetic */ Project $project;
            final /* synthetic */ WebFacetConfigurator this$0;
            final /* synthetic */ String $depModuleName;
            final /* synthetic */ JavaeeImporterArtifact $artifact;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$depModuleName = $depModuleName;
                this.$artifact = $artifact;
            }

            public void add(MavenProject mavenProject, MavenArtifact depArtifact, OverlaySettings settings) {
                Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
                Intrinsics.checkNotNullParameter((Object)depArtifact, (String)"depArtifact");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.$project).createPointer(MavenUtil.getArtifactName((String)WebFacetConfigurator.access$getMyPackaging(this.this$0), (String)this.$depModuleName, (boolean)true));
                PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
                CompositePackagingElement<?> compositePackagingElement = this.$artifact.getRootElement();
                String string = settings.getTargetPath();
                Intrinsics.checkNotNull((Object)string);
                packagingElementFactory.getOrCreateDirectory(compositePackagingElement, string).addOrFindChild((PackagingElement)new ArtifactPackagingElement(this.$project, pointer));
            }
        });
        return true;
    }

    @Override
    protected void addModuleDependency(@NotNull Project project, @NotNull JavaeeImporterArtifacts artifactModel, @NotNull MavenProject mavenProject, @NotNull JavaeeImporterArtifact artifact, @NotNull String depModuleName, @NotNull MavenArtifact depArtifact, @NotNull String jarFileName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)artifactModel, (String)"artifactModel");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)depModuleName, (String)"depModuleName");
        Intrinsics.checkNotNullParameter((Object)depArtifact, (String)"depArtifact");
        Intrinsics.checkNotNullParameter((Object)jarFileName, (String)"jarFileName");
        if (Intrinsics.areEqual((Object)"client", (Object)depArtifact.getClassifier())) {
            JavaeeImporterArtifact artifactDep = this.findEjbClientArtifactDependency(artifactModel, depModuleName);
            if (artifactDep != null) {
                PackagingElementFactory factory = PackagingElementFactory.getInstance();
                CompositePackagingElement parent = null;
                String relativePath = this.getDependencyPackagingUrl() + "/" + jarFileName;
                if (this.isPackagingExcluded(mavenProject, relativePath)) {
                    return;
                }
                parent = factory.getOrCreateArchive(artifact.getRootElement(), relativePath);
                parent.addOrFindChild(factory.createArtifactElement(artifactDep.getName(), project));
            }
        } else {
            super.addModuleDependency(project, artifactModel, mavenProject, artifact, depModuleName, depArtifact, jarFileName);
        }
    }

    @Override
    protected void doAddModuleDependency(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull JavaeeImporterArtifact artifact, @NotNull String depModuleName, @NotNull MavenArtifact depArtifact, @NotNull String jarFileName, @NotNull String relativeOutputPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)depModuleName, (String)"depModuleName");
        Intrinsics.checkNotNullParameter((Object)depArtifact, (String)"depArtifact");
        Intrinsics.checkNotNullParameter((Object)jarFileName, (String)"jarFileName");
        Intrinsics.checkNotNullParameter((Object)relativeOutputPath, (String)"relativeOutputPath");
        if (!this.isPackagingExcluded(mavenProject, relativeOutputPath, jarFileName)) {
            super.doAddModuleDependency(project, mavenProject, artifact, depModuleName, depArtifact, jarFileName, relativeOutputPath);
        }
    }

    @Override
    protected void doAddLibraryDependency(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull JavaeeImporterArtifact artifact, @NotNull JavaeeFacetLibraryWrapper library, @NotNull String[] libraryUrls, @NotNull String relativeOutputPath, @NotNull String jarFileName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)libraryUrls, (String)"libraryUrls");
        Intrinsics.checkNotNullParameter((Object)relativeOutputPath, (String)"relativeOutputPath");
        Intrinsics.checkNotNullParameter((Object)jarFileName, (String)"jarFileName");
        if (!this.isPackagingExcluded(mavenProject, relativeOutputPath, jarFileName)) {
            super.doAddLibraryDependency(project, mavenProject, artifact, library, libraryUrls, relativeOutputPath, jarFileName);
        }
    }

    private final boolean isPackagingExcluded(MavenProject mavenProject, String relativePath) {
        Element configElement = this.getConfig(mavenProject);
        if (configElement != null) {
            String packagingIncludes = MavenJDOMUtil.findChildValueByPath$default((Element)configElement, (String)"packagingIncludes", null, (int)4, null);
            String packagingExcludes = MavenJDOMUtil.findChildValueByPath$default((Element)configElement, (String)"packagingExcludes", null, (int)4, null);
            String string = FileUtil.toSystemDependentName((String)StringsKt.removePrefix((String)relativePath, (CharSequence)"/"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            String path = string;
            return !new MavenPatternFileFilter(packagingIncludes, packagingExcludes).accept(path);
        }
        return false;
    }

    private final boolean isPackagingExcluded(MavenProject mavenProject, String relativeOutputPath, String jarFileName) {
        String string = FileUtil.toSystemIndependentName((String)new File(relativeOutputPath, jarFileName).getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String relativePath = string;
        return this.isPackagingExcluded(mavenProject, relativePath);
    }

    @Override
    protected boolean reimportCustomDependencyPackaging(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull JavaeeFacetImpostor facet, @NotNull MavenArtifact depArtifact, @NotNull List<JavaeePostTask> postTasks) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)depArtifact, (String)"depArtifact");
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        if (!this.isOverlay(depArtifact)) {
            return false;
        }
        this.addOverlay(mavenProject, depArtifact, new AddOverlayTask(this, project, facet, postTasks){
            final /* synthetic */ WebFacetConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ JavaeeFacetImpostor $facet;
            final /* synthetic */ List<JavaeePostTask> $postTasks;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$facet = $facet;
                this.$postTasks = $postTasks;
            }

            public void add(MavenProject mavenProject, MavenArtifact depArtifact, OverlaySettings settings) {
                Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
                Intrinsics.checkNotNullParameter((Object)depArtifact, (String)"depArtifact");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                OverlayExtractingTask overlayExtractingTask = this.this$0.new OverlayExtractingTask();
                JavaeeFacetImpostor javaeeFacetImpostor = this.$facet;
                Intrinsics.checkNotNull((Object)javaeeFacetImpostor, (String)"null cannot be cast to non-null type org.jetbrains.idea.maven.ext.javaee.web.WebFacetConfigurator.WebFacetImpostor");
                overlayExtractingTask.addIfNecessary(this.$project, mavenProject, (WebFacetImpostor)javaeeFacetImpostor, depArtifact, settings, this.$postTasks);
            }
        });
        return true;
    }

    @Override
    protected boolean isLinkViaManifest(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getManifestClasspathPrefix(project) != null;
    }

    @Override
    @Nullable
    public String getManifestClasspathPrefix(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String addClasspath = this.findConfigValue(project, "archive.manifest.addClasspath");
        return Intrinsics.areEqual((Object)"true", (Object)addClasspath) ? this.findConfigValue(project, "archive.manifest.classpathPrefix", "/") : null;
    }

    private final void addOverlay(MavenProject project, MavenArtifact artifact, AddOverlayTask task) {
        OverlaySettings settings = this.collectSettings(project, artifact);
        if (settings.isSkipped()) {
            return;
        }
        task.add(project, artifact, settings);
    }

    private final OverlaySettings collectSettings(MavenProject project, MavenArtifact artifact) {
        Element configElement = this.findConfigElementForArtifact(artifact, project, "overlays", "overlay");
        OverlaySettings result = new OverlaySettings();
        result.setTargetPath(MavenJDOMUtil.findChildValueByPath((Element)configElement, (String)"targetPath", (String)"/"));
        result.setSkipped(Intrinsics.areEqual((Object)"true", (Object)MavenJDOMUtil.findChildValueByPath((Element)configElement, (String)"skip", (String)"false")));
        List<Pattern> defaultIncludes = this.collectGlobalPatterns(project, "dependentWarIncludes", "**/*");
        List<Pattern> defaultExcludes = this.collectGlobalPatterns(project, "dependentWarExcludes", "META-INF/**");
        result.setIncludes(this.collectPatterns(configElement, "includes", defaultIncludes));
        result.setExcludes(this.collectPatterns(configElement, "excludes", defaultExcludes));
        return result;
    }

    private final List<Pattern> collectGlobalPatterns(MavenProject project, String path, String defaultValue) {
        List result = new ArrayList();
        String value = this.findConfigValue(project, path, defaultValue);
        for (String each : StringUtil.split((String)value, (String)",")) {
            MavenUtil.collectPattern((String)each, (Collection)result);
        }
        return result;
    }

    private final boolean isOverlay(MavenArtifact depArtifact) {
        return Intrinsics.areEqual((Object)"war", (Object)depArtifact.getType());
    }

    private final List<Pattern> collectPatterns(Element configElement, String elementName, List<Pattern> defaultPatterns) {
        Element element;
        Element element2 = configElement;
        Object object = element = element2 != null ? element2.getChild(elementName) : null;
        if (element == null) {
            return defaultPatterns;
        }
        List result = new ArrayList();
        for (Element eachElement : element.getChildren(StringUtil.unpluralize((String)elementName))) {
            String value = eachElement.getValue();
            if (value == null) continue;
            MavenUtil.collectPattern((String)value, (Collection)result);
        }
        return result;
    }

    private final File makeOverlayInfoFile(File overlayDir) {
        return new File(overlayDir.getParentFile(), overlayDir.getName() + ".info");
    }

    private static final Unit createWorkspaceEntity$lambda$0(ModuleEntity.Builder $module, WebSettingsEntity.Builder $this$WebSettingsEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$WebSettingsEntity, (String)"$this$WebSettingsEntity");
        $this$WebSettingsEntity.setModule($module);
        return Unit.INSTANCE;
    }

    private static final Unit reimportFacet$lambda$2(WebFacetImpostor $facet, WebSettingsEntity.Builder $this$modifyWebSettingsEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyWebSettingsEntity, (String)"$this$modifyWebSettingsEntity");
        $this$modifyWebSettingsEntity.setSourceRoots($facet.getSourceRoots());
        $this$modifyWebSettingsEntity.setWebRoots(CollectionsKt.toMutableList((Collection)$facet.getWebRoots()));
        $this$modifyWebSettingsEntity.setConfigFileItems($facet.getConfigFileItems());
        return Unit.INSTANCE;
    }

    private static final boolean prepareRootElement$lambda$3(String $moduleName, PackagingElement packagingElement) {
        return !(packagingElement instanceof ProductionModuleOutputPackagingElement) || !Intrinsics.areEqual((Object)$moduleName, (Object)((ProductionModuleOutputPackagingElement)packagingElement).getModuleName());
    }

    private static final boolean prepareRootElement$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int getOrderedDependenciesToPackage$lambda$6(WebFacetConfigurator this$0, List $configs, List $deps, MavenArtifact o1, MavenArtifact o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        JavaeeFacetConfiguratorBase.ArtifactConfig c1 = this$0.findConfigElementForArtifact(o1, $configs);
        JavaeeFacetConfiguratorBase.ArtifactConfig c2 = this$0.findConfigElementForArtifact(o2, $configs);
        int i1 = CollectionsKt.indexOf((List)$configs, (Object)c1);
        int i2 = CollectionsKt.indexOf((List)$configs, (Object)c2);
        if (i1 == -1 && i2 == -1) {
            return $deps.indexOf(o1) - $deps.indexOf(o2);
        }
        if (i1 == -1) {
            return 1;
        }
        if (i2 == -1) {
            return -1;
        }
        return i1 - i2;
    }

    public static final /* synthetic */ String access$getMyPackaging(WebFacetConfigurator $this) {
        return $this.getMyPackaging();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$AddOverlayTask;", "", "add", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "depArtifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "settings", "Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$OverlaySettings;", "intellij.maven.ext"})
    private static interface AddOverlayTask {
        public void add(@NotNull MavenProject var1, @NotNull MavenArtifact var2, @NotNull OverlaySettings var3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010 \u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bJ(\u0010\"\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001cJ\u0013\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016J\u0016\u0010+\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\b\u0010/\u001a\u00020\u000fH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$OverlayExtractingTask;", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeePostTask;", "<init>", "(Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator;)V", "myMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "myArtifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "myRelativePath", "", "mySettings", "Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$OverlaySettings;", "myOutputDir", "Ljava/io/File;", "addIfNecessary", "", "project", "Lcom/intellij/openapi/project/Project;", "mavenProject", "facet", "Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$WebFacetImpostor;", "artifact", "settings", "postTasks", "", "disableFacetsDetection", "perform", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "shouldUpdateOverlay", "", "overlayDir", "saveOverlaySettings", "makeInfoFileContent", "extractWarContent", "outputDir", "Ljava/nio/file/Path;", "process", "equals", "other", "", "hashCode", "", "makePatternsString", "patterns", "", "Ljava/util/regex/Pattern;", "scheduleFileRefresh", "intellij.maven.ext"})
    @SourceDebugExtension(value={"SMAP\nWebFacetConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebFacetConfigurator.kt\norg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$OverlayExtractingTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,626:1\n1557#2:627\n1628#2,3:628\n*S KotlinDebug\n*F\n+ 1 WebFacetConfigurator.kt\norg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$OverlayExtractingTask\n*L\n590#1:627\n590#1:628,3\n*E\n"})
    private final class OverlayExtractingTask
    implements JavaeePostTask {
        @Nullable
        private MavenProject myMavenProject;
        @Nullable
        private MavenArtifact myArtifact;
        @Nullable
        private String myRelativePath;
        @Nullable
        private OverlaySettings mySettings;
        @Nullable
        private File myOutputDir;

        public final void addIfNecessary(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull WebFacetImpostor facet, @NotNull MavenArtifact artifact, @Nullable OverlaySettings settings, @NotNull List<JavaeePostTask> postTasks) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
            if (!artifact.getFile().exists()) {
                return;
            }
            this.myMavenProject = mavenProject;
            this.myArtifact = artifact;
            this.mySettings = settings;
            this.disableFacetsDetection(project);
            MavenArtifact mavenArtifact = this.myArtifact;
            Intrinsics.checkNotNull((Object)mavenArtifact);
            String string = mavenArtifact.getGroupId();
            MavenArtifact mavenArtifact2 = this.myArtifact;
            Intrinsics.checkNotNull((Object)mavenArtifact2);
            String string2 = mavenArtifact2.getArtifactId();
            MavenArtifact mavenArtifact3 = this.myArtifact;
            Intrinsics.checkNotNull((Object)mavenArtifact3);
            String overlayName = string + "." + string2 + "-" + mavenArtifact3.getVersion();
            this.myRelativePath = "overlays/" + overlayName;
            MavenProject mavenProject2 = this.myMavenProject;
            Intrinsics.checkNotNull((Object)mavenProject2);
            String[] stringArray = new String[1];
            Intrinsics.checkNotNull((Object)this.myRelativePath);
            this.myOutputDir = new File(WebFacetConfigurator.this.makePath(mavenProject2, stringArray));
            MavenProject mavenProject3 = this.myMavenProject;
            Intrinsics.checkNotNull((Object)mavenProject3);
            String string3 = this.myRelativePath;
            Intrinsics.checkNotNull((Object)string3);
            OverlaySettings overlaySettings = this.mySettings;
            Intrinsics.checkNotNull((Object)overlaySettings);
            String string4 = overlaySettings.getTargetPath();
            Intrinsics.checkNotNull((Object)string4);
            WebFacetConfigurator.this.addWebRoot(facet, mavenProject3, string3, string4);
            File file = this.myOutputDir;
            Intrinsics.checkNotNull((Object)file);
            OverlaySettings overlaySettings2 = this.mySettings;
            Intrinsics.checkNotNull((Object)overlaySettings2);
            if (this.shouldUpdateOverlay(file, overlaySettings2)) {
                postTasks.add(this);
            }
        }

        public final void disableFacetsDetection(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)project);
            MavenProject mavenProject = this.myMavenProject;
            Intrinsics.checkNotNull((Object)mavenProject);
            String[] stringArray = new String[]{"overlays"};
            excludesConfiguration.addExcludedUrl(VfsUtilCore.pathToUrl((String)WebFacetConfigurator.this.makePath(mavenProject, stringArray)), null);
        }

        @Override
        public void perform(@NotNull Project project, @NotNull ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Object[] objectArray = new Object[]{this.myArtifact};
            progressIndicator.setText(MavenExtBundle.message("progress.text.clearing.war.overlay.content.for", objectArray));
            File file = this.myOutputDir;
            Intrinsics.checkNotNull((Object)file);
            FileUtil.delete((File)file);
            File file2 = this.myOutputDir;
            Intrinsics.checkNotNull((Object)file2);
            OverlaySettings overlaySettings = this.mySettings;
            Intrinsics.checkNotNull((Object)overlaySettings);
            this.saveOverlaySettings(file2, overlaySettings);
            File file3 = this.myOutputDir;
            Intrinsics.checkNotNull((Object)file3);
            Path path = file3.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            OverlaySettings overlaySettings2 = this.mySettings;
            Intrinsics.checkNotNull((Object)overlaySettings2);
            this.extractWarContent(project, path, overlaySettings2, progressIndicator);
            this.scheduleFileRefresh();
        }

        public final boolean shouldUpdateOverlay(@NotNull File overlayDir, @NotNull OverlaySettings settings) {
            Intrinsics.checkNotNullParameter((Object)overlayDir, (String)"overlayDir");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            if (!overlayDir.exists()) {
                return true;
            }
            File infoFile = WebFacetConfigurator.this.makeOverlayInfoFile(overlayDir);
            if (!infoFile.exists()) {
                return true;
            }
            try {
                String expectedContent = this.makeInfoFileContent(settings);
                String string = FileUtil.loadFile((File)infoFile);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
                String actualContent = string;
                return !Intrinsics.areEqual((Object)expectedContent, (Object)actualContent);
            }
            catch (IOException iOException) {
                return true;
            }
        }

        public final void saveOverlaySettings(@NotNull File overlayDir, @NotNull OverlaySettings settings) {
            Intrinsics.checkNotNullParameter((Object)overlayDir, (String)"overlayDir");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            File file = WebFacetConfigurator.this.makeOverlayInfoFile(overlayDir);
            String content = this.makeInfoFileContent(settings);
            try {
                FileUtil.delete((File)file);
                String string = content;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                FileUtil.writeToFile((File)file, (byte[])byArray);
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }

        @NotNull
        public final String makeInfoFileContent(@NotNull OverlaySettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            MavenArtifact mavenArtifact = this.myArtifact;
            Intrinsics.checkNotNull((Object)mavenArtifact);
            String timestamp = String.valueOf(mavenArtifact.getFile().lastModified());
            List<Pattern> list = settings.getIncludes();
            Intrinsics.checkNotNull(list);
            String includesString = this.makePatternsString(list);
            List<Pattern> list2 = settings.getExcludes();
            Intrinsics.checkNotNull(list2);
            String excludesString = this.makePatternsString(list2);
            return StringsKt.trimIndent((String)("\n            " + timestamp + "\n            " + includesString + "\n            " + excludesString + "\n            "));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void extractWarContent(@Nullable Project project, @NotNull Path outputDir, @NotNull OverlaySettings settings, @NotNull ProgressIndicator process) {
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Object object = new Object[]{this.myArtifact};
            process.setText(MavenExtBundle.message("progress.text.extracting.war.overlay.content.for", object));
            try {
                MavenArtifact mavenArtifact = this.myArtifact;
                Intrinsics.checkNotNull((Object)mavenArtifact);
                object = new JarFile(mavenArtifact.getFile());
                Throwable throwable = null;
                try {
                    JarFile jar = (JarFile)object;
                    boolean bl = false;
                    Files.createDirectories(outputDir, new FileAttribute[0]);
                    int size = jar.size();
                    int[] nArray = new int[]{0};
                    int[] i = nArray;
                    MavenArtifact mavenArtifact2 = this.myArtifact;
                    Intrinsics.checkNotNull((Object)mavenArtifact2);
                    Decompressor.Zip zip = new Decompressor.Zip(mavenArtifact2.getFile());
                    Predicate<String> predicate = arg_0 -> OverlayExtractingTask.extractWarContent$lambda$1$lambda$0(process, i, size, settings, arg_0);
                    Intrinsics.checkNotNull(predicate, (String)"null cannot be cast to non-null type java.util.function.Predicate<in kotlin.String?>");
                    zip.filter(predicate).extract(outputDir);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{this.myArtifact};
                MavenUtil.showError((Project)project, (String)MavenExtBundle.message("notification.title.cannot.extract.content", objectArray), (Throwable)e);
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            return this.myMavenProject == ((OverlayExtractingTask)other).myMavenProject && Intrinsics.areEqual((Object)this.myArtifact, (Object)((OverlayExtractingTask)other).myArtifact);
        }

        public int hashCode() {
            MavenProject mavenProject = this.myMavenProject;
            MavenArtifact mavenArtifact = this.myArtifact;
            return 31 * (mavenProject != null ? mavenProject.hashCode() : 0) + (mavenArtifact != null ? mavenArtifact.hashCode() : 0);
        }

        /*
         * WARNING - void declaration
         */
        private final String makePatternsString(List<Pattern> patterns) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = patterns;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pattern pattern = (Pattern)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.pattern());
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }

        private final void scheduleFileRefresh() {
            ApplicationManager.getApplication().invokeLater(OverlayExtractingTask::scheduleFileRefresh$lambda$3);
        }

        private static final boolean extractWarContent$lambda$1$lambda$0(ProgressIndicator $process, int[] $i, int $size, OverlaySettings $settings, String entryName) {
            if ($process.isCanceled()) {
                throw new ProcessCanceledException();
            }
            String string = entryName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = UriUtil.trimTrailingSlashes((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimTrailingSlashes(...)");
            String name = string2;
            $process.setText2(name);
            int n = $i[0];
            $i[0] = n + 1;
            $process.setFraction((double)n / (double)$size);
            return MavenUtil.isIncluded((String)name, $settings.getIncludes(), $settings.getExcludes());
        }

        private static final void scheduleFileRefresh$lambda$3() {
            VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$OverlaySettings;", "", "<init>", "()V", "targetPath", "", "getTargetPath", "()Ljava/lang/String;", "setTargetPath", "(Ljava/lang/String;)V", "isSkipped", "", "()Z", "setSkipped", "(Z)V", "includes", "", "Ljava/util/regex/Pattern;", "getIncludes", "()Ljava/util/List;", "setIncludes", "(Ljava/util/List;)V", "excludes", "getExcludes", "setExcludes", "intellij.maven.ext"})
    private static final class OverlaySettings {
        @Nullable
        private String targetPath;
        private boolean isSkipped;
        @Nullable
        private List<Pattern> includes;
        @Nullable
        private List<Pattern> excludes;

        @Nullable
        public final String getTargetPath() {
            return this.targetPath;
        }

        public final void setTargetPath(@Nullable String string) {
            this.targetPath = string;
        }

        public final boolean isSkipped() {
            return this.isSkipped;
        }

        public final void setSkipped(boolean bl) {
            this.isSkipped = bl;
        }

        @Nullable
        public final List<Pattern> getIncludes() {
            return this.includes;
        }

        public final void setIncludes(@Nullable List<Pattern> list) {
            this.includes = list;
        }

        @Nullable
        public final List<Pattern> getExcludes() {
            return this.excludes;
        }

        public final void setExcludes(@Nullable List<Pattern> list) {
            this.excludes = list;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$RemoveOldOverlaysPostTask;", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeePostTask;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "facet", "Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$WebFacetImpostor;", "<init>", "(Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$WebFacetImpostor;)V", "currentRoots", "", "", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.maven.ext"})
    private final class RemoveOldOverlaysPostTask
    implements JavaeePostTask {
        @NotNull
        private final MavenProject mavenProject;
        @NotNull
        private final Set<String> currentRoots;

        public RemoveOldOverlaysPostTask(@NotNull MavenProject mavenProject, WebFacetImpostor facet) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            this.mavenProject = mavenProject;
            Set set = CollectionFactory.createFilePathSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createFilePathSet(...)");
            this.currentRoots = set;
            for (WebRootData each : facet.getWebRoots()) {
                VirtualFile file = each.findFile();
                if (file == null) continue;
                String string = FileUtil.toSystemIndependentName((String)file.getPath());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
                this.currentRoots.add(string);
            }
        }

        @Override
        public void perform(@NotNull Project project, @NotNull ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            String[] stringArray = new String[]{"overlays"};
            File overlaysDir = new File(WebFacetConfigurator.this.makePath(this.mavenProject, stringArray));
            Object[] existingSubdirs = overlaysDir.listFiles();
            if (existingSubdirs != null) {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])existingSubdirs);
                while (iterator.hasNext()) {
                    File eachSubdir = (File)iterator.next();
                    if (this.currentRoots.contains(FileUtil.toSystemIndependentName((String)eachSubdir.getPath()))) continue;
                    Intrinsics.checkNotNull((Object)eachSubdir);
                    File infoFile = WebFacetConfigurator.this.makeOverlayInfoFile(eachSubdir);
                    if (!infoFile.exists()) continue;
                    FileUtil.delete((File)eachSubdir);
                    FileUtil.delete((File)infoFile);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$SetupAdditionalSettingsPostTask;", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeePostTask;", "<init>", "(Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator;)V", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.maven.ext"})
    private final class SetupAdditionalSettingsPostTask
    implements JavaeePostTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(@NotNull Project project, @NotNull ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
            ModifiableArtifactModel artifactModel = artifactManager.createModifiableModel();
            try {
                AppServerWebFacetSettingsService appServerWebFacetSettingsService = AppServerWebFacetSettingsService.getInstance();
                if (appServerWebFacetSettingsService != null) {
                    appServerWebFacetSettingsService.setupAdditionalSettings(project, "Maven", artifactModel);
                }
                if (artifactModel.isModified()) {
                    CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(artifactModel, null){
                        int label;
                        final /* synthetic */ ModifiableArtifactModel $artifactModel;
                        {
                            this.$artifactModel = $artifactModel;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = com.intellij.openapi.application.CoroutinesKt.writeAction(() -> perform.1.invokeSuspend$lambda$0(this.$artifactModel), (Continuation)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final Unit invokeSuspend$lambda$0(ModifiableArtifactModel $artifactModel) {
                            $artifactModel.commit();
                            return Unit.INSTANCE;
                        }
                    }));
                }
            }
            finally {
                artifactModel.dispose();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rJ\u0006\u0010\u000e\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/ext/javaee/web/WebFacetConfigurator$WebFacetImpostor;", "Lorg/jetbrains/idea/maven/ext/javaee/JavaeeFacetImpostor;", "<init>", "()V", "webRoots", "", "Lcom/intellij/javaee/web/facet/WebRootData;", "addWebRootNoFire", "", "url", "", "path", "getWebRoots", "", "removeAllWebRoots", "intellij.maven.ext"})
    private static final class WebFacetImpostor
    extends JavaeeFacetImpostor {
        @NotNull
        private final List<WebRootData> webRoots = new ArrayList();

        public final void addWebRootNoFire(@NotNull String url, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.webRoots.add(new WebRootData(url, path));
        }

        @NotNull
        public final List<WebRootData> getWebRoots() {
            return this.webRoots;
        }

        public final void removeAllWebRoots() {
            this.webRoots.clear();
        }
    }
}

