/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.profiler;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.ext.profiler.ExecExec;
import org.jetbrains.idea.maven.ext.profiler.ExecJava;
import org.jetbrains.idea.maven.ext.profiler.MavenParametersPatcherKt;
import org.jetbrains.idea.maven.ext.profiler.MavenProfileableGoal;
import org.jetbrains.idea.maven.ext.profiler.NoProfileableGoalsException;
import org.jetbrains.idea.maven.ext.profiler.ParametersUpdateStrategy;
import org.jetbrains.idea.maven.ext.profiler.ProjectHasSubmodulesAndNotExecJavaGoalException;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J:\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00132\b\b\u0002\u0010\u001d\u001a\u00020\u00132\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001fH\u0002J.\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u00132\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001fH\u0002J(\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u00132\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001fH\u0002J\b\u0010(\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/MavenParametersPatcher;", "", "configuration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "<init>", "(Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;Lorg/jetbrains/idea/maven/project/MavenProject;)V", "getConfiguration", "()Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "doPatch", "", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "agentParametersProvider", "Lkotlin/Function0;", "", "", "determineUpdateStrategy", "Lorg/jetbrains/idea/maven/ext/profiler/ParametersUpdateStrategy;", "parametersList", "Lcom/intellij/execution/configurations/ParametersList;", "determineUpdateStrategyForTests", "goal", "Lorg/jetbrains/idea/maven/ext/profiler/MavenProfileableGoal;", "getEffectivePropertyValue", "propertyName", "configAttributeName", "runtimeProperties", "Lkotlin/Function1;", "getDynamicConfigurationProperties", "domModel", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "resolveRuntimeProperty", "property", "getImmediateReferencedValue", "possiblyIgnoredCommandLineBasedValues", "", "logPossiblyIgnoredCommandLineBasedValues", "Companion", "intellij.maven.ext"})
public final class MavenParametersPatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MavenRunConfiguration configuration;
    @NotNull
    private final MavenProject mavenProject;
    @NotNull
    private final Set<String> possiblyIgnoredCommandLineBasedValues;
    @NotNull
    private static final Regex PROPERTY_REGEX = new Regex("\\$\\{(.+?)}");

    public MavenParametersPatcher(@NotNull MavenRunConfiguration configuration, @NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        this.configuration = configuration;
        this.mavenProject = mavenProject;
        this.possiblyIgnoredCommandLineBasedValues = new LinkedHashSet();
    }

    @NotNull
    public final MavenRunConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doPatch(@NotNull JavaParameters params, @NotNull Function0<? extends List<String>> agentParametersProvider) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(agentParametersProvider, (String)"agentParametersProvider");
        ParametersList parametersList = params.getProgramParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"getProgramParametersList(...)");
        ParametersUpdateStrategy parametersUpdateStrategy = this.determineUpdateStrategy(parametersList);
        if (parametersUpdateStrategy == null) {
            throw new NoProfileableGoalsException();
        }
        ParametersUpdateStrategy updateStrategy = parametersUpdateStrategy;
        this.configuration.putUserData(MavenParametersPatcherKt.getForkingStrategyKey(), (Object)updateStrategy);
        try {
            updateStrategy.doUpdate(params, (List)agentParametersProvider.invoke());
        }
        finally {
            this.logPossiblyIgnoredCommandLineBasedValues();
        }
    }

    private final ParametersUpdateStrategy determineUpdateStrategy(ParametersList parametersList) {
        List list = this.configuration.getRunnerParameters().getGoals();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGoals(...)");
        MavenProfileableGoal mavenProfileableGoal = MavenProfileableGoal.Companion.fromList(list);
        if (mavenProfileableGoal == null) {
            return null;
        }
        MavenProfileableGoal goal = mavenProfileableGoal;
        if (!(goal instanceof ExecJava) && !((Collection)this.mavenProject.getModulePaths()).isEmpty()) {
            throw new ProjectHasSubmodulesAndNotExecJavaGoalException();
        }
        MavenProfileableGoal mavenProfileableGoal2 = goal;
        return Intrinsics.areEqual((Object)mavenProfileableGoal2, (Object)ExecJava.INSTANCE) ? (ParametersUpdateStrategy)ParametersUpdateStrategy.SameVm.INSTANCE : (Intrinsics.areEqual((Object)mavenProfileableGoal2, (Object)ExecExec.INSTANCE) ? (ParametersUpdateStrategy)new ParametersUpdateStrategy.SingleFork(goal.getPropertyName(), false, goal.getPluginAnalyzer(this.mavenProject)) : this.determineUpdateStrategyForTests(goal, parametersList));
    }

    private final ParametersUpdateStrategy determineUpdateStrategyForTests(MavenProfileableGoal goal, ParametersList parametersList) {
        String string;
        String forkCount;
        String string2;
        String forkMode;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel((Project)this.configuration.getProject(), (VirtualFile)this.mavenProject.getFile());
        Intrinsics.checkNotNull((Object)mavenDomProjectModel);
        MavenDomProjectModel projectModel = mavenDomProjectModel;
        Function1<String, String> runtimeProperties = this.getDynamicConfigurationProperties(this.mavenProject, projectModel, parametersList);
        String string3 = MavenParametersPatcher.determineUpdateStrategyForTests$getEffectiveValue(this, goal, runtimeProperties, "forkMode");
        if (string3 == null) {
            string3 = forkMode = "once";
        }
        if ((string2 = MavenParametersPatcher.determineUpdateStrategyForTests$getEffectiveValue(this, goal, runtimeProperties, "forkCount")) == null) {
            string2 = forkCount = "1";
        }
        if ((string = MavenParametersPatcher.determineUpdateStrategyForTests$getEffectiveValue(this, goal, runtimeProperties, "reuseForks")) == null) {
            string = "true";
        }
        String reuseForks = string;
        return switch (forkMode) {
            case "never" -> ParametersUpdateStrategy.SameVm.INSTANCE;
            case "always" -> ParametersUpdateStrategy.ManyForks.INSTANCE;
            case "perthread" -> {
                int threadCount;
                Object v5 = parametersList.getPropertyValue("threadCount");
                int v6 = v5 != null && (v5 = StringsKt.toIntOrNull((String)v5)) != null ? (Integer)v5 : (threadCount = 0);
                if (threadCount == 1) {
                    yield new ParametersUpdateStrategy.SingleFork(goal.getPropertyName(), true, goal.getPluginAnalyzer(this.mavenProject));
                }
                yield ParametersUpdateStrategy.ManyForks.INSTANCE;
            }
            default -> Intrinsics.areEqual((Object)forkCount, (Object)"0") ? (ParametersUpdateStrategy)ParametersUpdateStrategy.SameVm.INSTANCE : (Intrinsics.areEqual((Object)forkCount, (Object)"1") && Intrinsics.areEqual((Object)reuseForks, (Object)"true") ? (ParametersUpdateStrategy)new ParametersUpdateStrategy.SingleFork(goal.getPropertyName(), true, goal.getPluginAnalyzer(this.mavenProject)) : (ParametersUpdateStrategy)ParametersUpdateStrategy.ManyForks.INSTANCE);
        };
    }

    private final String getEffectivePropertyValue(MavenProfileableGoal goal, String propertyName, String configAttributeName, Function1<? super String, String> runtimeProperties) {
        Object text;
        String resolvedPropertyValue;
        MavenPlugin mavenPlugin = goal.getPlugin(this.mavenProject);
        Element config = mavenPlugin != null ? mavenPlugin.getConfigurationElement() : null;
        String propertyValuePlaceholder = "${" + propertyName + "}";
        Object object = config;
        if (object == null || (object = object.getChild(configAttributeName)) == null || (object = object.getTextTrim()) == null) {
            object = propertyValuePlaceholder;
        }
        if (!Intrinsics.areEqual((Object)(resolvedPropertyValue = this.resolveRuntimeProperty((String)(text = object), runtimeProperties)), (Object)propertyValuePlaceholder)) {
            return resolvedPropertyValue;
        }
        return null;
    }

    static /* synthetic */ String getEffectivePropertyValue$default(MavenParametersPatcher mavenParametersPatcher, MavenProfileableGoal mavenProfileableGoal, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = string;
        }
        return mavenParametersPatcher.getEffectivePropertyValue(mavenProfileableGoal, string, string2, (Function1<? super String, String>)function1);
    }

    private final Function1<String, String> getDynamicConfigurationProperties(MavenProject mavenProject, MavenDomProjectModel domModel, ParametersList parametersList) {
        Map staticProperties = MavenPropertyResolver.collectPropertyMapFromDOM((MavenProject)mavenProject, (MavenDomProjectModel)domModel);
        return arg_0 -> MavenParametersPatcher.getDynamicConfigurationProperties$lambda$0(parametersList, staticProperties, this, arg_0);
    }

    private final String resolveRuntimeProperty(String property, Function1<? super String, String> runtimeProperties) {
        String previousValue = null;
        String currentValue = this.getImmediateReferencedValue(property, runtimeProperties);
        while (!Intrinsics.areEqual(previousValue, (Object)currentValue)) {
            previousValue = currentValue;
            if (currentValue == null) continue;
            currentValue = this.getImmediateReferencedValue(currentValue, runtimeProperties);
        }
        return currentValue;
    }

    private final String getImmediateReferencedValue(String property, Function1<? super String, String> runtimeProperties) {
        Object object = Regex.find$default((Regex)PROPERTY_REGEX, (CharSequence)property, (int)0, (int)2, null);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
            return property;
        }
        Object referencedPropertyName = object;
        return (String)runtimeProperties.invoke(referencedPropertyName);
    }

    private final void logPossiblyIgnoredCommandLineBasedValues() {
        if (this.possiblyIgnoredCommandLineBasedValues.isEmpty()) {
            return;
        }
        MavenParametersPatcherKt.access$getLOG$p().warn("The following properties defined in command line may be ignored if they are referenced from plugin configuration: " + CollectionsKt.joinToString$default((Iterable)this.possiblyIgnoredCommandLineBasedValues, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    private static final String determineUpdateStrategyForTests$getEffectiveValue(MavenParametersPatcher this$0, MavenProfileableGoal $goal, Function1<? super String, String> runtimeProperties, String propertyName) {
        return this$0.getEffectivePropertyValue($goal, propertyName, propertyName, runtimeProperties);
    }

    private static final String getDynamicConfigurationProperties$lambda$0(ParametersList $parametersList, Map $staticProperties, MavenParametersPatcher this$0, String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String commandLineBasedValue = $parametersList.getPropertyValue(name);
        String staticPropertiesBasedValue = (String)$staticProperties.get(name);
        if (commandLineBasedValue != null && staticPropertiesBasedValue != null) {
            ((Collection)this$0.possiblyIgnoredCommandLineBasedValues).add(name);
        }
        if ((string = commandLineBasedValue) == null) {
            string = staticPropertiesBasedValue;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/MavenParametersPatcher$Companion;", "", "<init>", "()V", "PROPERTY_REGEX", "Lkotlin/text/Regex;", "intellij.maven.ext"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

