/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.profiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.NewProcessStartedExternallyCommunicator;
import com.intellij.profiler.ultimate.NewProcessStartedWithProfilerCommunicator;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.ext.MavenExtBundle;
import org.jetbrains.idea.maven.ext.profiler.MavenParametersPatcher;
import org.jetbrains.idea.maven.ext.profiler.MavenParametersPatcherKt;
import org.jetbrains.idea.maven.ext.profiler.ParametersUpdateStrategy;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007H\u0000\u001aN\u0010\n\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102 \u0010\u0011\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0012H\u0000\"\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"doUpdateJavaParameters", "", "configuration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "agentParametersProvider", "Lkotlin/Function0;", "", "", "doAttachToMavenProcess", "T", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "profilerProcessFactory", "Lkotlin/Function2;", "Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "", "Lcom/intellij/profiler/api/ProfilerProcess;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.maven.ext"})
@SourceDebugExtension(value={"SMAP\nMavenRunConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenRunConfigurationExtension.kt\norg/jetbrains/idea/maven/ext/profiler/MavenRunConfigurationExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n1#2:58\n14#3:59\n*S KotlinDebug\n*F\n+ 1 MavenRunConfigurationExtension.kt\norg/jetbrains/idea/maven/ext/profiler/MavenRunConfigurationExtensionKt\n*L\n57#1:59\n*E\n"})
public final class MavenRunConfigurationExtensionKt {
    @NotNull
    private static final Logger LOG;

    public static final void doUpdateJavaParameters(@NotNull MavenRunConfiguration configuration, @NotNull JavaParameters params, @NotNull Function0<? extends List<String>> agentParametersProvider) {
        VirtualFile virtualFile;
        Path workingDirPath;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Intrinsics.checkNotNullParameter(agentParametersProvider, (String)"agentParametersProvider");
                workingDirPath = configuration.getRunnerParameters().getWorkingDirFile().toPath();
                virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(workingDirPath);
                if (virtualFile == null) break block4;
                VirtualFile it = virtualFile;
                boolean bl = false;
                Module module = ModuleUtil.findModuleForFile((VirtualFile)it, (Project)configuration.getProject());
                virtualFile = module;
                if (module != null) break block5;
            }
            Object[] objectArray = new Object[]{workingDirPath};
            throw new ExecutionException(MavenExtBundle.message("maven.profiler.working.dir.not.found", objectArray));
        }
        VirtualFile module = virtualFile;
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)configuration.getProject()).findProject((Module)module);
        if (mavenProject == null) {
            Object[] objectArray = new Object[]{workingDirPath};
            throw new ExecutionException(MavenExtBundle.message("maven.profiler.project.not.found", objectArray));
        }
        MavenProject mavenProject2 = mavenProject;
        MavenParametersPatcher patcher = new MavenParametersPatcher(configuration, mavenProject2);
        patcher.doPatch(params, agentParametersProvider);
    }

    public static final <T> void doAttachToMavenProcess(@NotNull JavaProfilerConfigurationExtension<T> $this$doAttachToMavenProcess, @NotNull ProcessHandler handler, @NotNull RunConfigurationBase<?> runConfiguration, @NotNull Function2<? super ProfilerProcessCommunicator<?>, ? super Long, ? extends ProfilerProcess<?>> profilerProcessFactory) {
        ProfilerProcessCommunicator profilerProcessCommunicator;
        Intrinsics.checkNotNullParameter($this$doAttachToMavenProcess, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(profilerProcessFactory, (String)"profilerProcessFactory");
        if (handler instanceof ExternalSystemProcessHandler) {
            return;
        }
        if (handler instanceof OSProcessHandler) {
            if (runConfiguration.getUserData(MavenParametersPatcherKt.getForkingStrategyKey()) instanceof ParametersUpdateStrategy.SingleFork) {
                String string = runConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                profilerProcessCommunicator = (ProfilerProcessCommunicator)new NewProcessStartedExternallyCommunicator(string, (BaseOSProcessHandler)handler);
            } else {
                String string = runConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                profilerProcessCommunicator = (ProfilerProcessCommunicator)new NewProcessStartedWithProfilerCommunicator(string, (BaseOSProcessHandler)handler);
            }
        } else {
            LOG.error("unexpected process handler: '" + handler + "'");
            throw new ExecutionException(UltimateProfilerBundleKt.profilerMessage((String)"profiler.exception.cant.start", (Object[])new Object[0]));
        }
        ProfilerProcessCommunicator communicator = profilerProcessCommunicator;
        $this$doAttachToMavenProcess.openToolWindowAndReportStart((ProfilerProcess)profilerProcessFactory.invoke((Object)communicator, (Object)System.currentTimeMillis()), runConfiguration);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JavaProfilerConfigurationExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

