/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.profiler;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.ext.profiler.ConfigPropertySetProfilerException;
import org.jetbrains.idea.maven.ext.profiler.MavenParametersPatcherKt;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "plugin", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/model/MavenPlugin;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getPlugin", "()Lorg/jetbrains/idea/maven/model/MavenPlugin;", "dominatingPluginParameter", "", "getDominatingPluginParameter", "()Ljava/lang/String;", "checkProjectCanBeProfiled", "", "patchJavaParametersByPomValues", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "Exec", "Test", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Exec;", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Test;", "intellij.maven.ext"})
public abstract class PluginAnalyzer {
    @NotNull
    private final MavenProject mavenProject;
    @NotNull
    private final MavenPlugin plugin;

    private PluginAnalyzer(MavenProject mavenProject, MavenPlugin plugin) {
        this.mavenProject = mavenProject;
        this.plugin = plugin;
    }

    @NotNull
    public final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @NotNull
    public final MavenPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public abstract String getDominatingPluginParameter();

    public final void checkProjectCanBeProfiled() {
        Element element = this.plugin.getConfigurationElement();
        if ((element != null ? element.getChild(this.getDominatingPluginParameter()) : null) != null) {
            throw new ConfigPropertySetProfilerException(this.getDominatingPluginParameter());
        }
    }

    public void patchJavaParametersByPomValues(@NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    public /* synthetic */ PluginAnalyzer(MavenProject mavenProject, MavenPlugin plugin, DefaultConstructorMarker $constructor_marker) {
        this(mavenProject, plugin);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Exec;", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "execPlugin", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/model/MavenPlugin;)V", "dominatingPluginParameter", "", "getDominatingPluginParameter", "()Ljava/lang/String;", "patchJavaParametersByPomValues", "", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "Companion", "intellij.maven.ext"})
    public static final class Exec
    extends PluginAnalyzer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String dominatingPluginParameter;
        @NotNull
        private static final String EXEC_ARGS_PROPERTY_NAME = "exec.args";

        public Exec(@NotNull MavenProject mavenProject, @NotNull MavenPlugin execPlugin) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter((Object)execPlugin, (String)"execPlugin");
            super(mavenProject, execPlugin, null);
            this.dominatingPluginParameter = "commandlineArgs";
        }

        @Override
        @NotNull
        public String getDominatingPluginParameter() {
            return this.dominatingPluginParameter;
        }

        @Override
        public void patchJavaParametersByPomValues(@NotNull JavaParameters params) {
            Element arguments;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            if (params.getProgramParametersList().hasProperty(EXEC_ARGS_PROPERTY_NAME)) {
                return;
            }
            String staticProperty = this.getMavenProject().getProperties().getProperty(EXEC_ARGS_PROPERTY_NAME);
            if (staticProperty != null) {
                ParametersList parametersList = params.getProgramParametersList();
                Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"getProgramParametersList(...)");
                MavenParametersPatcherKt.doUpdatePropertyValues$default(parametersList, EXEC_ARGS_PROPERTY_NAME, CollectionsKt.listOf((Object)staticProperty), false, 4, null);
            }
            Element element = this.getPlugin().getConfigurationElement();
            Object object = arguments = element != null ? element.getChild("arguments") : null;
            if (arguments != null) {
                MavenParametersPatcherKt.access$getLOG$p().warn("Existing <arguments> configuration parameter from " + this.getPlugin().getArtifactId() + " will be ignored");
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Exec$Companion;", "", "<init>", "()V", "EXEC_ARGS_PROPERTY_NAME", "", "intellij.maven.ext"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Test;", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "testPlugin", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/model/MavenPlugin;)V", "dominatingPluginParameter", "", "getDominatingPluginParameter", "()Ljava/lang/String;", "intellij.maven.ext"})
    public static final class Test
    extends PluginAnalyzer {
        @NotNull
        private final String dominatingPluginParameter;

        public Test(@NotNull MavenProject mavenProject, @NotNull MavenPlugin testPlugin) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter((Object)testPlugin, (String)"testPlugin");
            super(mavenProject, testPlugin, null);
            this.dominatingPluginParameter = "debugForkedProcess";
        }

        @Override
        @NotNull
        public String getDominatingPluginParameter() {
            return this.dominatingPluginParameter;
        }
    }
}

