/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.injection;

import com.intellij.freemarker.injection.FtlPatterns;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class FtlInjectionSupport
extends AbstractLanguageInjectionSupport {
    @NonNls
    static final String ID = "ftl";

    FtlInjectionSupport() {
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public Class @NotNull [] getPatternClasses() {
        Class[] classArray = new Class[]{FtlPatterns.class};
        if (classArray == null) {
            FtlInjectionSupport.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return host instanceof FtlMacro;
    }

    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost host) {
        BaseInjection injection = new BaseInjection(ID, language.getID(), "", "", new InjectionPlace[0]);
        String macroName = ((FtlMacro)host).getDirectiveName();
        @NlsSafe String displayName = "macro @" + macroName;
        ElementPattern pattern = injection.getCompiler().createElementPattern("ftlMacroCall(\"" + macroName + "\")", displayName);
        injection.setInjectionPlaces(new InjectionPlace[]{new InjectionPlace(pattern, true)});
        injection.setDisplayName(displayName);
        Project project = host.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        BaseInjection originalInjection = configuration.findExistingInjection(injection);
        BaseInjection newInjection = originalInjection != null ? originalInjection.copy() : injection;
        configuration.replaceInjectionsWithUndo(project, host.getContainingFile(), List.of(newInjection), ContainerUtil.createMaybeSingletonList((Object)originalInjection), List.of());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/injection/FtlInjectionSupport", "getPatternClasses"));
    }
}

