/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.freemarker.inspections.CreateFromUsageIntentionBase;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DefineInCommentIntentionBase
extends CreateFromUsageIntentionBase
implements IntentionAction {
    @Nls
    private final String myText;
    @NonNls
    public static final String FREEMARKER_IMPLICIT = "freemarker_implicit";

    public DefineInCommentIntentionBase(@Nls String text) {
        this.myText = text;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            DefineInCommentIntentionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void addDeclaration(PsiFile sourceFile, Editor sourceEditor, PsiFile targetFile, Editor editor) throws IncorrectOperationException {
        TemplateManager manager = TemplateManager.getInstance((Project)sourceFile.getProject());
        Template template = manager.createTemplate("", "");
        FtlDirectiveStyle style = FtlLexer.guessDirectiveStyle(editor.getDocument().getCharsSequence());
        this.fillTemplate(template, targetFile, sourceFile, style, sourceEditor);
        editor.getCaretModel().moveToOffset(this.calcInsertionIndex(targetFile, editor, style));
        manager.startTemplate(editor, template);
    }

    protected int calcInsertionIndex(PsiFile psiFile, Editor editor, FtlDirectiveStyle style) {
        Document document = editor.getDocument();
        String text = document.getText();
        int insertionIndex = 0;
        if (text.startsWith("[#ftl]\n[#-- @implicitly included --]\n")) {
            insertionIndex = "[#ftl]\n[#-- @implicitly included --]\n".length();
        } else if (text.startsWith("<#ftl>\n<#-- @implicitly included -->\n")) {
            insertionIndex = "<#ftl>\n<#-- @implicitly included -->\n".length();
        } else {
            int firstLineEnd = document.getLineEndOffset(0);
            assert (firstLineEnd >= 0);
            if (text.substring(0, firstLineEnd).contains(style.getDirectiveStartChar() + "#ftl") && (insertionIndex = firstLineEnd) < document.getTextLength() - 1) {
                ++insertionIndex;
            }
        }
        return insertionIndex;
    }

    protected abstract void fillTemplate(Template var1, PsiFile var2, PsiFile var3, FtlDirectiveStyle var4, Editor var5) throws IncorrectOperationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/DefineInCommentIntentionBase", "getText"));
    }
}

