/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlEnumReference;
import com.intellij.freemarker.psi.FtlExistsExpression;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlResolveResult;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlReferencesInspection
extends FtlSuppressableInspection {
    public static final String SHORT_NAME = "FtlReferencesInspection";
    public boolean fieldsExposed = false;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlReferencesInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                FtlEnumReference enumReference;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof FtlReferenceExpression) {
                    if (!Holder.IN_MACRO_END.accepts((Object)element)) {
                        FtlReferencesInspection.checkReference(((FtlReferenceExpression)element).getReference(), holder);
                    }
                } else if (element instanceof FtlIndexExpression) {
                    if (!Holder.IN_MACRO_END.accepts((Object)element)) {
                        FtlReferencesInspection.checkReference(((FtlIndexExpression)element).getQualifiedReference(), holder);
                    }
                } else if (element instanceof FtlStringLiteral && (enumReference = (FtlEnumReference)((Object)ContainerUtil.findInstance((Object[])element.getReferences(), FtlEnumReference.class))) != null) {
                    FtlReferencesInspection.checkEnumReference(enumReference, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlReferencesInspection$1", "visitElement"));
            }
        };
    }

    private static void checkEnumReference(FtlEnumReference reference, ProblemsHolder holder) {
        PsiClass enumClass = reference.getEnumClass();
        if (enumClass == null) {
            return;
        }
        if (reference.resolve() == null) {
            holder.registerProblem((PsiReference)reference, FreeMarkerBundle.message("reference.inspection.unknown.enum.constant.ref", enumClass.getName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static void checkReference(@Nullable FtlQualifiedReference reference, ProblemsHolder holder) {
        boolean hasResolveError;
        if (reference == null || reference.getAssignDeclaration() != null || FtlReferencesInspection.isDynamicReference(reference)) {
            return;
        }
        ResolveResult[] results = reference.multiResolve(false);
        JavaMethodResolveHelper.ErrorType resolveError = results.length > 0 && results[0] instanceof FtlResolveResult ? ((FtlResolveResult)results[0]).getResolveError() : JavaMethodResolveHelper.ErrorType.NONE;
        boolean bl = hasResolveError = resolveError != JavaMethodResolveHelper.ErrorType.NONE;
        if (!hasResolveError && FtlReferencesInspection.resolvesCorrectly(reference, results)) {
            FtlReferencesInspection.checkQualifierAccessibility(reference, holder);
            return;
        }
        holder.registerProblem((PsiReference)reference, reference.getUnresolvedMessage(resolveError), hasResolveError ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    private static void checkQualifierAccessibility(FtlQualifiedReference reference, ProblemsHolder holder) {
        if (reference.getElement().getParent() instanceof FtlInterpolation) {
            return;
        }
        FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(reference.getType(), FtlPsiType.class);
        if (ftlPsiType == null) {
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)ftlPsiType.getPsiType());
        if (psiClass == null) {
            return;
        }
        if (!psiClass.hasModifierProperty("public")) {
            holder.registerProblem((PsiReference)reference, FreeMarkerBundle.message("reference.inspection.accessing.non.public.class", psiClass.getQualifiedName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static boolean resolvesCorrectly(FtlQualifiedReference reference, ResolveResult[] results) {
        if (results.length == 0) {
            return false;
        }
        if (reference.resolve() != null) {
            return true;
        }
        long implicits = ((StreamEx)StreamEx.of((Object[])results).filter(FtlReferencesInspection::isImplicit)).count();
        return (long)results.length - implicits <= 1L;
    }

    private static boolean isImplicit(ResolveResult result) {
        PsiElement element = result.getElement();
        return element instanceof ImplicitVariable || element instanceof FtlImplicitVariable;
    }

    private static boolean isDynamicReference(@NotNull FtlQualifiedReference reference) {
        FtlReferenceQualifier qualifier;
        if (reference == null) {
            FtlReferencesInspection.$$$reportNull$$$0(1);
        }
        if ((qualifier = reference.getReferenceQualifier()) != null) {
            FtlType qualifierType = qualifier.getType();
            if (qualifierType == null || FtlBuiltInDescriptor.HashBuiltIn.isHash(qualifierType)) {
                return true;
            }
            if (FtlReferencesInspection.isCustomNumberFormat(reference)) {
                return true;
            }
        }
        if (reference.isNodeChildrenAccessor()) {
            return true;
        }
        return reference.getElement().getParent() instanceof FtlExistsExpression;
    }

    private static boolean isCustomNumberFormat(@NotNull FtlQualifiedReference reference) {
        String name;
        if (reference == null) {
            FtlReferencesInspection.$$$reportNull$$$0(2);
        }
        return (name = reference.getReferenceName()) != null && name.startsWith("@");
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlReferencesInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"fieldsExposed", (String)FreeMarkerBundle.message("reference.inspection.cb.public.fields.are.exposed", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            FtlReferencesInspection.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlReferencesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlReferencesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCustomNumberFormat";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        static final ElementPattern<PsiElement> IN_MACRO_END = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement((IElementType)FtlElementTypes.END_MACRO_START));

        private Holder() {
        }
    }
}

