/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.FtlBuiltIns;
import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlBuiltIn
extends FtlCompositeElement
implements FtlReferenceQualifier {
    public FtlBuiltIn(ASTNode node) {
        super(node);
    }

    @Override
    public FtlType getType() {
        FtlBuiltInDescriptor descriptor = this.getBuiltInDescriptor();
        return descriptor == null ? null : descriptor.getType(this);
    }

    @Nullable
    public FtlType getQualifierType() {
        return this.getQualifier().getType();
    }

    public FtlExpression getQualifier() {
        return (FtlExpression)this.findNotNullChildByClass(FtlExpression.class);
    }

    @Override
    public Object getConstantValue() {
        return null;
    }

    public boolean isEval() {
        return "eval".equals(this.getBuiltInName());
    }

    @Nullable
    public String getBuiltInName() {
        PsiElement element = this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
        return element == null ? null : element.getText();
    }

    @NotNull
    public PsiElement getQuestionToken() {
        PsiElement psiElement = this.findChildByType((IElementType)FtlElementTypes.QUESTION);
        if (psiElement == null) {
            FtlBuiltIn.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Override
    public FtlCallableType[] getCallableCandidates() {
        String builtInName = this.getBuiltInName();
        if (builtInName == null) {
            return FtlCallableType.EMPTY_ARRAY;
        }
        List<FtlBuiltInDescriptor> descriptors = FtlBuiltIns.getBuiltIns(this.getQualifier(), builtInName);
        if (descriptors.size() == 0) {
            return FtlCallableType.EMPTY_ARRAY;
        }
        SmartList callableTypes = new SmartList();
        for (FtlBuiltInDescriptor descriptor : descriptors) {
            callableTypes.addAll(FtlPsiUtil.getAllTypeComponents(descriptor.getType(this), FtlCallableType.class));
        }
        return callableTypes.toArray(FtlCallableType.EMPTY_ARRAY);
    }

    public boolean isCallableOnly() {
        List<FtlType> typeComponents = FtlPsiUtil.getAllTypeComponents(this.getType(), FtlType.class);
        return !this.isEval() && !typeComponents.isEmpty() && this.getCallableCandidates().length == typeComponents.size();
    }

    @Nullable
    public FtlBuiltInDescriptor getBuiltInDescriptor() {
        String builtInName = this.getBuiltInName();
        if (builtInName == null) {
            return null;
        }
        List<FtlBuiltInDescriptor> descriptors = FtlBuiltIns.getBuiltIns(this.getQualifier(), builtInName);
        return descriptors.size() != 1 ? null : descriptors.get(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlBuiltIn", "getQuestionToken"));
    }
}

