/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.requests;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.intellij.grpc.requests.ProtocBinaryBuilder;
import com.intellij.grpc.requests.execution.GrpcPrepareExecutionEnvironmentTaskKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a \u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0012H\u0000\u001a \u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a \u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\b\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"createBinaryProtoDescriptor", "Lcom/google/protobuf/Descriptors$FileDescriptor;", "protoFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "parseProtoDescriptorFromBinarySource", "Lcom/google/protobuf/DescriptorProtos$FileDescriptorSet;", "binaryDescriptorPath", "Ljava/nio/file/Path;", "tryParseProtoDescriptorSetFromBinaryProto", "binaryDescriptorAsStream", "Ljava/io/InputStream;", "assembleSelfContainedBinaryForPrimaryProto", "mainProtoFileName", "", "allRelatedDescriptors", "", "Lcom/google/protobuf/DescriptorProtos$FileDescriptorProto;", "tryBuildDependencyFreeDescriptorModel", "mainProtoDescriptor", "tryBuildSelfContainedDescriptorModel", "originalDescriptorSet", "buildDescriptorWithDependenciesUnsafe", "rootDescriptor", "allKnownDescriptorsSet", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nProtobufDependenciesAwareDescriptors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufDependenciesAwareDescriptors.kt\ncom/intellij/grpc/requests/ProtobufDependenciesAwareDescriptorsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,99:1\n1#2:100\n295#3,2:101\n669#3,11:103\n1557#3:114\n1628#3,3:115\n37#4,2:118\n*S KotlinDebug\n*F\n+ 1 ProtobufDependenciesAwareDescriptors.kt\ncom/intellij/grpc/requests/ProtobufDependenciesAwareDescriptorsKt\n*L\n45#1:101,2\n76#1:103,11\n83#1:114\n83#1:115,3\n89#1:118,2\n*E\n"})
public final class ProtobufDependenciesAwareDescriptorsKt {
    @Nullable
    public static final Descriptors.FileDescriptor createBinaryProtoDescriptor(@NotNull VirtualFile protoFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection<String> substitutedImports = GrpcPrepareExecutionEnvironmentTaskKt.extractImportPathsToDisk(project);
        Path effectiveBinariesPath = ProtocBinaryBuilder.INSTANCE.buildAllRelatedBinaryProtoDescriptors(protoFile, substitutedImports);
        DescriptorProtos.FileDescriptorSet fileDescriptorSet = ProtobufDependenciesAwareDescriptorsKt.parseProtoDescriptorFromBinarySource(effectiveBinariesPath);
        if (fileDescriptorSet == null) {
            return null;
        }
        DescriptorProtos.FileDescriptorSet parsedBinaryDescriptorSet = fileDescriptorSet;
        String string = protoFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        List list = parsedBinaryDescriptorSet.getFileList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFileList(...)");
        return ProtobufDependenciesAwareDescriptorsKt.assembleSelfContainedBinaryForPrimaryProto(string, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final DescriptorProtos.FileDescriptorSet parseProtoDescriptorFromBinarySource(@NotNull Path binaryDescriptorPath) {
        DescriptorProtos.FileDescriptorSet fileDescriptorSet;
        Intrinsics.checkNotNullParameter((Object)binaryDescriptorPath, (String)"binaryDescriptorPath");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(binaryDescriptorPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream p0 = (InputStream)closeable;
            boolean $i$f$parseProtoDescriptorFromBinarySource$stub_for_inlining = false;
            boolean bl = false;
            fileDescriptorSet = ProtobufDependenciesAwareDescriptorsKt.tryParseProtoDescriptorSetFromBinaryProto(p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return fileDescriptorSet;
    }

    @Nullable
    public static final DescriptorProtos.FileDescriptorSet tryParseProtoDescriptorSetFromBinaryProto(@NotNull InputStream binaryDescriptorAsStream) {
        DescriptorProtos.FileDescriptorSet fileDescriptorSet;
        Intrinsics.checkNotNullParameter((Object)binaryDescriptorAsStream, (String)"binaryDescriptorAsStream");
        try {
            fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)binaryDescriptorAsStream);
        }
        catch (IOException exception) {
            ProtobufDependenciesAwareDescriptorsKt.logger().warn("Unable to parse FileDescriptorSet from binary generated by protoc compiler", (Throwable)exception);
            fileDescriptorSet = null;
        }
        return fileDescriptorSet;
    }

    @Nullable
    public static final Descriptors.FileDescriptor assembleSelfContainedBinaryForPrimaryProto(@NotNull String mainProtoFileName, @NotNull List<DescriptorProtos.FileDescriptorProto> allRelatedDescriptors) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)mainProtoFileName, (String)"mainProtoFileName");
            Intrinsics.checkNotNullParameter(allRelatedDescriptors, (String)"allRelatedDescriptors");
            Iterable $this$firstOrNull$iv = allRelatedDescriptors;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DescriptorProtos.FileDescriptorProto it = (DescriptorProtos.FileDescriptorProto)element$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)mainProtoFileName, (boolean)false, (int)2, null)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = v1;
        if (fileDescriptorProto == null) {
            boolean bl = false;
            ProtobufDependenciesAwareDescriptorsKt.logger().warn("Primary proto file is not found inside generated descriptor set");
            return null;
        }
        DescriptorProtos.FileDescriptorProto mainProtoDescriptor = fileDescriptorProto;
        return ProtobufDependenciesAwareDescriptorsKt.tryBuildSelfContainedDescriptorModel(mainProtoDescriptor, allRelatedDescriptors);
    }

    @Nullable
    public static final Descriptors.FileDescriptor tryBuildDependencyFreeDescriptorModel(@NotNull DescriptorProtos.FileDescriptorProto mainProtoDescriptor) {
        Intrinsics.checkNotNullParameter((Object)mainProtoDescriptor, (String)"mainProtoDescriptor");
        return ProtobufDependenciesAwareDescriptorsKt.tryBuildSelfContainedDescriptorModel(mainProtoDescriptor, CollectionsKt.emptyList());
    }

    private static final Descriptors.FileDescriptor tryBuildSelfContainedDescriptorModel(DescriptorProtos.FileDescriptorProto mainProtoDescriptor, List<DescriptorProtos.FileDescriptorProto> originalDescriptorSet) {
        Descriptors.FileDescriptor fileDescriptor;
        try {
            fileDescriptor = ProtobufDependenciesAwareDescriptorsKt.buildDescriptorWithDependenciesUnsafe(mainProtoDescriptor, originalDescriptorSet);
        }
        catch (Descriptors.DescriptorValidationException exception) {
            ProtobufDependenciesAwareDescriptorsKt.logger().warn("Unable to build self-contained descriptor for given root descriptor with generated FileDescriptorSet", (Throwable)exception);
            fileDescriptor = null;
        }
        return fileDescriptor;
    }

    private static final Descriptors.FileDescriptor buildDescriptorWithDependenciesUnsafe(DescriptorProtos.FileDescriptorProto rootDescriptor, List<DescriptorProtos.FileDescriptorProto> allKnownDescriptorsSet) {
        return ProtobufDependenciesAwareDescriptorsKt.buildDescriptorWithDependenciesUnsafe$buildDescriptorForCurrentRoot(allKnownDescriptorsSet, rootDescriptor);
    }

    private static final Logger logger() {
        Logger logger = Logger.getInstance((String)"ProtobufLocalDependenciesAwareDescriptors");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    private static final Descriptors.FileDescriptor buildDescriptorWithDependenciesUnsafe$buildDescriptorForCurrentRoot(List<DescriptorProtos.FileDescriptorProto> $allKnownDescriptorsSet, DescriptorProtos.FileDescriptorProto currentRoot) {
        SmartList dependencies = new SmartList();
        for (String dependencyName : currentRoot.getDependencyList()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object v0;
            Object single$iv;
            Iterable $this$singleOrNull$iv;
            block5: {
                $this$singleOrNull$iv = $allKnownDescriptorsSet;
                boolean $i$f$singleOrNull = false;
                single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    DescriptorProtos.FileDescriptorProto it = (DescriptorProtos.FileDescriptorProto)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)dependencyName)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            DescriptorProtos.FileDescriptorProto dependencyProto = v0;
            if (dependencyProto != null) {
                dependencies.add((Object)ProtobufDependenciesAwareDescriptorsKt.buildDescriptorWithDependenciesUnsafe$buildDescriptorForCurrentRoot($allKnownDescriptorsSet, dependencyProto));
                continue;
            }
            $this$singleOrNull$iv = $allKnownDescriptorsSet;
            String string = dependencyName;
            Logger logger = ProtobufDependenciesAwareDescriptorsKt.logger();
            boolean $i$f$map = false;
            single$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DescriptorProtos.FileDescriptorProto bl = (DescriptorProtos.FileDescriptorProto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                boolean $i$f$buildDescriptorWithDependenciesUnsafe$buildDescriptorForCurrentRoot$stub_for_inlining$3 = false;
                collection.add(p0.getName());
            }
            collection = (List)destination$iv$iv;
            logger.warn("Either the dependency '" + string + "' can not be resolved among prepared descriptors, or the resolve result is ambiguous. Available dependencies: '" + (List)collection + "'");
            return null;
        }
        Collection $this$toTypedArray$iv = (Collection)dependencies;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)currentRoot, (Descriptors.FileDescriptor[])thisCollection$iv.toArray(new Descriptors.FileDescriptor[0]));
    }
}

