/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.sceneBuilder.EditorCallback;
import org.jetbrains.plugins.javaFX.sceneBuilder.JavaFXPlatformHelper;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilder;

public class SceneBuilderImpl
implements SceneBuilder {
    private static final Logger LOG = Logger.getInstance(SceneBuilderImpl.class);
    private static final PropertyName ourChildrenPropertyName = new PropertyName("children");
    private final URL myFileURL;
    private final Project myProject;
    private final EditorCallback myEditorCallback;
    private final JComponent myPanel;
    protected EditorController myEditorController;
    private URLClassLoader myClassLoader;
    private volatile Collection<JavaFXPlatformHelper.CustomComponent> myCustomComponents;
    private volatile boolean mySkipChanges;
    private Object myListener;
    private Object mySelectionListener;
    private List<List<SelectionNode>> mySelectionState;
    @NotNull
    protected final ClassLoader myParentClassLoader;

    public SceneBuilderImpl(URL url, Project project, EditorCallback editorCallback, @NotNull ClassLoader loader) {
        if (loader == null) {
            SceneBuilderImpl.$$$reportNull$$$0(0);
        }
        this.myPanel = JavaFXPlatformHelper.createJFXPanel();
        this.myFileURL = url;
        this.myProject = project;
        this.myEditorCallback = editorCallback;
        this.myParentClassLoader = loader;
        JavaFXPlatformHelper.disableImplicitExit();
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        if (dumbService.isDumb()) {
            dumbService.smartInvokeLater(() -> JavaFXPlatformHelper.javafxInvokeLater(this::create));
        } else {
            JavaFXPlatformHelper.javafxInvokeLater(this::create);
        }
    }

    private void create() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Thread.currentThread().setUncaughtExceptionHandler(SceneBuilderImpl::logUncaughtException);
        this.myEditorController = new EditorController();
        this.updateCustomLibrary();
        JavaFXPlatformHelper.setupJFXPanel((JComponent)this.myPanel, (EditorController)this.myEditorController);
        this.loadFile();
        this.myListener = JavaFXPlatformHelper.createChangeListener(() -> {
            if (!this.mySkipChanges) {
                this.myEditorCallback.saveChanges(this.myEditorController.getFxmlText());
            }
        });
        this.mySelectionListener = JavaFXPlatformHelper.createChangeListener(() -> {
            if (!this.mySkipChanges) {
                this.mySelectionState = this.getSelectionState();
            }
        });
        JavaFXPlatformHelper.addListeners((EditorController)this.myEditorController, (Object)this.myListener, (Object)this.mySelectionListener);
    }

    private void updateCustomLibrary() {
        URLClassLoader oldClassLoader = this.myClassLoader;
        this.myClassLoader = SceneBuilderImpl.createProjectContentClassLoader(this.myProject, this.myParentClassLoader);
        JavaFXPlatformHelper.setDefaultClassLoader((ClassLoader)this.myClassLoader);
        if (oldClassLoader != null) {
            try {
                oldClassLoader.close();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        List customComponents = (List)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(this::collectCustomComponents);
        try {
            JavaFXPlatformHelper.CustomLibrary customLibrary = new JavaFXPlatformHelper.CustomLibrary((ClassLoader)this.myClassLoader, customComponents);
            this.myEditorController.setLibrary((Library)customLibrary);
            this.myCustomComponents = customComponents;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    private List<JavaFXPlatformHelper.CustomComponent> collectCustomComponents() {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        PsiClass nodeClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("javafx.scene.Node", GlobalSearchScope.allScope((Project)this.myProject));
        if (nodeClass == null) {
            return Collections.emptyList();
        }
        Collection psiClasses = (Collection)CachedValuesManager.getCachedValue((PsiElement)nodeClass, () -> {
            GlobalSearchScope scope = ProjectScope.getLibrariesScope((Project)nodeClass.getProject());
            JavaSdkVersion ideJdkVersion = JavaSdkVersion.fromJavaVersion((JavaVersion)JavaVersion.current());
            LanguageLevel ideLanguageLevel = ideJdkVersion != null ? ideJdkVersion.getMaxLanguageLevel() : null;
            Query query = ClassInheritorsSearch.search((PsiClass)nodeClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            HashSet result = new HashSet();
            query.forEach(psiClass -> {
                if (psiClass.hasModifierProperty("public") && !psiClass.hasModifierProperty("abstract") && !SceneBuilderImpl.isBuiltInComponent(psiClass) && SceneBuilderImpl.isCompatibleLanguageLevel(psiClass, ideLanguageLevel)) {
                    result.add(psiClass);
                }
            });
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (psiClasses.isEmpty()) {
            return Collections.emptyList();
        }
        return this.prepareCustomComponents(psiClasses);
    }

    @NotNull
    private List<JavaFXPlatformHelper.CustomComponent> prepareCustomComponents(Collection<PsiClass> psiClasses) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        Map<String, BuiltinComponent> builtinComponents = SceneBuilderImpl.loadBuiltinComponents(className -> psiFacade.findClass(className, scope) != null);
        ArrayList<JavaFXPlatformHelper.CustomComponent> customComponents = new ArrayList<JavaFXPlatformHelper.CustomComponent>();
        for (PsiClass psiClass : psiClasses) {
            String qualifiedName = psiClass.getQualifiedName();
            String name = psiClass.getName();
            if (qualifiedName == null || name == null) continue;
            BuiltinComponent parentComponent = null;
            for (PsiClass aClass = psiClass; aClass != null; aClass = aClass.getSuperClass()) {
                BuiltinComponent component = builtinComponents.get(aClass.getQualifiedName());
                if (component == null) continue;
                parentComponent = component;
                break;
            }
            String moduleName = this.getComponentModuleName(psiClass);
            Map<Object, Object> attributes = parentComponent != null ? parentComponent.getAttributes() : Collections.emptyMap();
            customComponents.add(new JavaFXPlatformHelper.CustomComponent(name, qualifiedName, moduleName, attributes));
        }
        ArrayList<JavaFXPlatformHelper.CustomComponent> arrayList = customComponents;
        if (arrayList == null) {
            SceneBuilderImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private String getComponentModuleName(@NotNull PsiClass psiClass) {
        String libraryName;
        VirtualFile vFile;
        if (psiClass == null) {
            SceneBuilderImpl.$$$reportNull$$$0(2);
        }
        if ((vFile = PsiUtilCore.getVirtualFile((PsiElement)psiClass)) == null) {
            return null;
        }
        Module module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(vFile);
        if (module != null) {
            return module.getName();
        }
        OrderEntry entry = LibraryUtil.findLibraryEntry((VirtualFile)vFile, (Project)this.myProject);
        if (entry instanceof LibraryOrderEntry && (libraryName = ((LibraryOrderEntry)entry).getLibraryName()) != null) {
            return libraryName;
        }
        return null;
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public boolean reload() {
        if (this.myCustomComponents == null) {
            return false;
        }
        Collection customComponents = (Collection)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(this::collectCustomComponents);
        if (!new HashSet<JavaFXPlatformHelper.CustomComponent>(this.myCustomComponents).equals(new HashSet(customComponents))) {
            return false;
        }
        JavaFXPlatformHelper.javafxInvokeLater(() -> {
            if (this.myEditorController != null) {
                this.loadFile();
            }
        });
        return true;
    }

    public void close() {
        JavaFXPlatformHelper.javafxInvokeLater(this::closeImpl);
    }

    private void closeImpl() {
        JavaFXPlatformHelper.removeListeners((EditorController)this.myEditorController, (Object)this.myListener, (Object)this.mySelectionListener);
        this.myEditorController = null;
        try {
            if (this.myClassLoader != null) {
                JavaFXPlatformHelper.setDefaultClassLoader((ClassLoader)this.myParentClassLoader);
                this.myClassLoader.close();
                this.myClassLoader = null;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        this.myCustomComponents = null;
        Thread.currentThread().setUncaughtExceptionHandler(null);
    }

    private void loadFile() {
        this.mySkipChanges = true;
        try {
            String fxmlText = FXOMDocument.readContentFromURL((URL)this.myFileURL);
            String editorFxmlText = this.myEditorController.getFxmlText();
            if (Objects.equals(fxmlText, editorFxmlText)) {
                return;
            }
            this.myEditorController.setFxmlTextAndLocation(fxmlText, this.myFileURL);
            this.restoreSelection(this.mySelectionState);
        }
        catch (Throwable e) {
            this.myEditorCallback.handleError(e);
        }
        finally {
            this.mySkipChanges = false;
        }
    }

    private List<List<SelectionNode>> getSelectionState() {
        AbstractSelectionGroup group = this.myEditorController.getSelection().getGroup();
        if (group instanceof ObjectSelectionGroup) {
            Set items = ((ObjectSelectionGroup)group).getItems();
            ArrayList<List<SelectionNode>> state = new ArrayList<List<SelectionNode>>();
            for (FXOMObject item : items) {
                ArrayList<SelectionNode> path = new ArrayList<SelectionNode>();
                for (FXOMObject component = item; component != null; component = component.getParentObject()) {
                    path.add(new SelectionNode(component));
                }
                Collections.reverse(path);
                state.add(path);
            }
            return state;
        }
        return null;
    }

    private void restoreSelection(List<List<SelectionNode>> state) {
        if (state == null) {
            return;
        }
        ArrayList<FXOMObject> newSelection = new ArrayList<FXOMObject>();
        FXOMObject rootComponent = this.myEditorController.getFxomDocument().getFxomRoot();
        for (List<SelectionNode> path : state) {
            FXOMObject component = SceneBuilderImpl.getSelectedComponent(rootComponent, path, 0);
            if (component == null) continue;
            newSelection.add(component);
        }
        this.myEditorController.getSelection().select(newSelection);
    }

    private static void logUncaughtException(Thread t, Throwable e) {
        if (!(e instanceof ControlFlowException)) {
            LOG.info("Uncaught exception in JavaFX " + t, e);
        }
    }

    private static boolean isBuiltInComponent(PsiClass psiClass) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiClass);
        if (file == null) {
            return false;
        }
        List entries = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex().getOrderEntriesForFile(file);
        return entries.stream().anyMatch(entry -> entry instanceof JdkOrderEntry);
    }

    private static boolean isCompatibleLanguageLevel(@NotNull PsiClass aClass, @Nullable LanguageLevel targetLevel) {
        Sdk jdk;
        OrderEntry entry;
        if (aClass == null) {
            SceneBuilderImpl.$$$reportNull$$$0(3);
        }
        if (targetLevel == null) {
            return true;
        }
        Project project = aClass.getProject();
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
        if (vFile == null) {
            return true;
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(vFile);
        if (module == null && (entry = LibraryUtil.findLibraryEntry((VirtualFile)vFile, (Project)project)) != null) {
            module = entry.getOwnerModule();
        }
        Sdk sdk = jdk = module != null ? ModuleRootManager.getInstance((Module)module).getSdk() : null;
        if (jdk == null) {
            jdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        }
        if (jdk == null) {
            return true;
        }
        JavaSdkVersion jdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jdk);
        if (jdkVersion != null) {
            return targetLevel.isAtLeast(jdkVersion.getMaxLanguageLevel());
        }
        return true;
    }

    @NotNull
    private static URLClassLoader createProjectContentClassLoader(Project project, @NotNull ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            SceneBuilderImpl.$$$reportNull$$$0(4);
        }
        List pathList = (List)ReadAction.compute(() -> OrderEnumerator.orderEntries((Project)project).productionOnly().withoutSdk().recursively().getPathsList().getPathList());
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        for (String path : pathList) {
            try {
                URL url = new File(path).toURI().toURL();
                classpathUrls.add(url);
            }
            catch (MalformedURLException e) {
                LOG.info((Throwable)e);
            }
        }
        return new URLClassLoader(classpathUrls.toArray(new URL[0]), parentClassLoader);
    }

    private static FXOMObject getSelectedComponent(FXOMObject component, List<SelectionNode> path, int step) {
        if (step >= path.size()) {
            return null;
        }
        SelectionNode node = new SelectionNode(component);
        if (node.equals(path.get(step))) {
            if (step == path.size() - 1) {
                return component;
            }
            List<FXOMObject> children = SceneBuilderImpl.getChildComponents(component);
            if (children.isEmpty()) {
                return null;
            }
            int indexInParent = path.get((int)(step + 1)).indexInParent;
            if (indexInParent >= 0 && indexInParent < children.size()) {
                return SceneBuilderImpl.getSelectedComponent(children.get(indexInParent), path, step + 1);
            }
        }
        return null;
    }

    private static List<FXOMObject> getChildComponents(FXOMObject component) {
        Map properties;
        FXOMProperty value;
        if (component instanceof FXOMInstance && (value = (FXOMProperty)(properties = ((FXOMInstance)component).getProperties()).get(ourChildrenPropertyName)) instanceof FXOMPropertyC) {
            return ((FXOMPropertyC)value).getValues();
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Map<String, BuiltinComponent> loadBuiltinComponents(final Predicate<? super String> psiClassExists) {
        HashMap<String, BuiltinComponent> components = new HashMap<String, BuiltinComponent>();
        for (LibraryItem item : JavaFXPlatformHelper.getBuiltinLibraryItems()) {
            BuiltinComponent previous;
            final Ref refQualifiedName = new Ref();
            final ArrayList imports = new ArrayList();
            final HashMap<String, String> attributes = new HashMap<String, String>();
            final Ref rootTagProcessed = new Ref((Object)false);
            NanoXmlUtil.parse((Reader)new StringReader(item.getFxmlText()), (IXMLBuilder)new NanoXmlBuilder(){

                public void newProcessingInstruction(String target, Reader reader) throws Exception {
                    if ("import".equals(target)) {
                        String imported = StreamUtil.readText((Reader)reader);
                        imports.add(imported);
                    }
                }

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
                    if (((Boolean)rootTagProcessed.get()).booleanValue()) {
                        return;
                    }
                    if (key != null && value != null && StringUtil.isEmpty((String)nsPrefix)) {
                        attributes.put(key, value);
                    }
                }

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
                    rootTagProcessed.set((Object)true);
                }

                public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
                    if (((Boolean)rootTagProcessed.get()).booleanValue()) {
                        return;
                    }
                    for (String imported : imports) {
                        String className;
                        if (imported.equals(name) || imported.endsWith("." + name)) {
                            refQualifiedName.set((Object)imported);
                            break;
                        }
                        if (!imported.endsWith(".*") || !psiClassExists.test(className = imported.substring(0, imported.length() - 1) + name)) continue;
                        refQualifiedName.set((Object)className);
                        break;
                    }
                }
            });
            String qualifiedName = (String)refQualifiedName.get();
            if (StringUtil.isEmpty((String)qualifiedName) || (previous = (BuiltinComponent)components.get(qualifiedName)) != null && previous.getAttributes().size() >= attributes.size()) continue;
            components.put(qualifiedName, new BuiltinComponent(attributes));
        }
        HashMap<String, BuiltinComponent> hashMap = components;
        if (hashMap == null) {
            SceneBuilderImpl.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCustomComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBuiltinComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentModuleName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleLanguageLevel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProjectContentClassLoader";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    public static class BuiltinComponent {
        private final Map<String, String> myAttributes;

        BuiltinComponent(Map<String, String> attributes) {
            this.myAttributes = attributes;
        }

        public Map<String, String> getAttributes() {
            return this.myAttributes;
        }
    }

    static class SelectionNode {
        final String qualifiedName;
        final int indexInParent;

        SelectionNode(FXOMObject component) {
            Object graphObject = component.getSceneGraphObject();
            this.qualifiedName = graphObject.getClass().getName();
            FXOMPropertyC parentProperty = component.getParentProperty();
            this.indexInParent = parentProperty != null ? parentProperty.getValues().indexOf(component) : -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectionNode)) {
                return false;
            }
            SelectionNode node = (SelectionNode)o;
            return this.indexInParent == node.indexInParent && Objects.equals(this.qualifiedName, node.qualifiedName);
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedName, this.indexInParent);
        }

        public String toString() {
            return this.indexInParent + ":" + this.qualifiedName;
        }
    }
}

