/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.BaseConversionGraph;
import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DbDataConverters;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbConversionGraph
extends BaseConversionGraph {
    public DbConversionGraph(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator, @NotNull Supplier<ObjectFormatter> objectFormatter) {
        if (formatsCache == null) {
            DbConversionGraph.$$$reportNull$$$0(0);
        }
        if (formatterCreator == null) {
            DbConversionGraph.$$$reportNull$$$0(1);
        }
        if (objectFormatter == null) {
            DbConversionGraph.$$$reportNull$$$0(2);
        }
        super(formatsCache, formatterCreator, objectFormatter);
        this.register(new DbDataConverters.TimeZonedTimeToTemporal());
        this.register(new DbDataConverters.TimeZonedTimestampToTemporal());
        this.register(new DbDataConverters.NumberRangeToText(formatterCreator));
        this.register(new DbDataConverters.DateRangeToText(formatsCache, formatterCreator));
        this.register(new DbDataConverters.TimestampRangeToText(formatterCreator));
    }

    @Nullable
    public static Function<Object, Object> getConverter(@NotNull ConversionGraph graph, @Nullable Object o, @NotNull Domain from, @NotNull Domain to) {
        if (graph == null) {
            DbConversionGraph.$$$reportNull$$$0(3);
        }
        if (from == null) {
            DbConversionGraph.$$$reportNull$$$0(4);
        }
        if (to == null) {
            DbConversionGraph.$$$reportNull$$$0(5);
        }
        ConversionPoint startPoint = o == null ? from.getPoint() : from.getPoint().withClass(o.getClass());
        ConversionPoint endPoint = to.getPoint();
        Function resultFunction = graph.getConverter(startPoint, endPoint);
        return resultFunction == null ? null : Functions.compose((Function)resultFunction, obj2 -> obj2 == null ? null : to.trim(obj2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectFormatter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/data/types/DbConversionGraph";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getConverter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

