/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.Effect;
import com.intellij.database.dialects.base.generator.EffectCommon;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.RequiredEffect;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0003\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\b\u0012\u0004\u0012\u00020\u00050\u0003\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00070\u0003\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\b\u0012\u0004\u0012\u00020\t0\u0003\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0019*\u00020\u0019\u001a\u001a\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d*\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u000f\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"sortedE", "", "Lcom/intellij/database/dialects/base/generator/Effect;", "", "sortedRE", "Lcom/intellij/database/dialects/base/generator/RequiredEffect;", "sortedO", "Lcom/intellij/database/dialects/base/generator/Operation;", "sortedB", "Lcom/intellij/database/model/basic/BasicElement;", "OP_COMPARATOR", "Ljava/util/Comparator;", "EFFECT_COMPARATOR", "REQUIRED_EFFECT_COMPARATOR", "compareCommon", "", "e1", "Lcom/intellij/database/dialects/base/generator/EffectCommon;", "e2", "OBJ_COMPARATOR", "comparePath", "p1", "Lcom/intellij/database/util/ObjectPath;", "p2", "quote", "", "xmlEsc", "indent", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "d", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nScriptingGraphUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingGraphUtils.kt\ncom/intellij/database/dialects/base/generator/ScriptingGraphUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
public final class ScriptingGraphUtilsKt {
    @NotNull
    private static final Comparator<Operation> OP_COMPARATOR = ScriptingGraphUtilsKt::OP_COMPARATOR$lambda$0;
    @NotNull
    private static final Comparator<Effect> EFFECT_COMPARATOR = ScriptingGraphUtilsKt::EFFECT_COMPARATOR$lambda$1;
    @NotNull
    private static final Comparator<RequiredEffect> REQUIRED_EFFECT_COMPARATOR = ScriptingGraphUtilsKt::REQUIRED_EFFECT_COMPARATOR$lambda$3;
    @NotNull
    private static final Comparator<BasicElement> OBJ_COMPARATOR = ScriptingGraphUtilsKt::OBJ_COMPARATOR$lambda$4;

    @NotNull
    public static final List<Effect> sortedE(@NotNull Iterable<Effect> $this$sortedE) {
        Intrinsics.checkNotNullParameter($this$sortedE, (String)"<this>");
        return CollectionsKt.sortedWith($this$sortedE, EFFECT_COMPARATOR);
    }

    @NotNull
    public static final List<RequiredEffect> sortedRE(@NotNull Iterable<RequiredEffect> $this$sortedRE) {
        Intrinsics.checkNotNullParameter($this$sortedRE, (String)"<this>");
        return CollectionsKt.sortedWith($this$sortedRE, REQUIRED_EFFECT_COMPARATOR);
    }

    @NotNull
    public static final List<Operation> sortedO(@NotNull Iterable<Operation> $this$sortedO) {
        Intrinsics.checkNotNullParameter($this$sortedO, (String)"<this>");
        return CollectionsKt.sortedWith($this$sortedO, OP_COMPARATOR);
    }

    @NotNull
    public static final List<BasicElement> sortedB(@NotNull Iterable<? extends BasicElement> $this$sortedB) {
        Intrinsics.checkNotNullParameter($this$sortedB, (String)"<this>");
        return CollectionsKt.sortedWith($this$sortedB, OBJ_COMPARATOR);
    }

    private static final int compareCommon(EffectCommon e1, EffectCommon e2) {
        return e1.getType() != e2.getType() ? e1.getType().compareTo((Enum)e2.getType()) : ScriptingGraphUtilsKt.comparePath(e1.getTarget(), e2.getTarget());
    }

    private static final int comparePath(ObjectPath p1, ObjectPath p2) {
        int n;
        if (p1 == p2) {
            return 0;
        }
        if (p1 == null || p2 == null) {
            return p1 == null ? -1 : 1;
        }
        int p3 = ScriptingGraphUtilsKt.comparePath(p1.parent, p2.parent);
        if (p3 != 0) {
            return p3;
        }
        p3 = p1.kind.compareTo(p2.kind);
        if (p3 != 0) {
            n = p3;
        } else {
            String string = p1.name;
            String string2 = p2.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            n = string.compareTo(string2);
        }
        return n;
    }

    @NotNull
    public static final String quote(@NotNull String $this$quote) {
        Intrinsics.checkNotNullParameter((Object)$this$quote, (String)"<this>");
        return "\"" + StringUtil.escapeStringCharacters((String)$this$quote) + "\"";
    }

    @NotNull
    public static final String xmlEsc(@NotNull String $this$xmlEsc) {
        Intrinsics.checkNotNullParameter((Object)$this$xmlEsc, (String)"<this>");
        String string = StringUtil.escapeXmlEntities((String)$this$xmlEsc);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        return string;
    }

    @NotNull
    public static final StringBuilder indent(@NotNull StringBuilder $this$indent, int d) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"<this>");
        StringUtil.repeatSymbol((Appendable)$this$indent, (char)'\t', (int)d);
        return $this$indent;
    }

    private static final int OP_COMPARATOR$lambda$0(Operation o1, Operation o2) {
        return Comparing.compare((Comparable)((Comparable)((Object)o1.getProducer().getType().getDebugName())), (Comparable)((Comparable)((Object)o2.getProducer().getType().getDebugName())));
    }

    private static final int EFFECT_COMPARATOR$lambda$1(Effect e1, Effect e2) {
        Intrinsics.checkNotNull((Object)e1);
        EffectCommon effectCommon = e1;
        Intrinsics.checkNotNull((Object)e2);
        return ScriptingGraphUtilsKt.compareCommon(effectCommon, e2);
    }

    /*
     * WARNING - void declaration
     */
    private static final int REQUIRED_EFFECT_COMPARATOR$lambda$3(RequiredEffect e1, RequiredEffect e2) {
        void var2_2;
        Intrinsics.checkNotNull((Object)e1);
        EffectCommon effectCommon = e1;
        Intrinsics.checkNotNull((Object)e2);
        int it = ScriptingGraphUtilsKt.compareCommon(effectCommon, e2);
        boolean bl = false;
        return it == 0 ? e1.getMatch().compareTo((Enum)e2.getMatch()) : var2_2;
    }

    private static final int OBJ_COMPARATOR$lambda$4(BasicElement o1, BasicElement o2) {
        return ScriptingGraphUtilsKt.comparePath(BasicPaths.of(o1), BasicPaths.of(o2));
    }
}

