/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.h2.model.H2Constant;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J4\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/h2/model/H2ModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "exportApplyColumn", "", "helper", "Lcom/intellij/database/schemaEditor/SchemaApplyHelper;", "from", "Lcom/intellij/database/schemaEditor/model/DeColumn;", "to", "Lcom/intellij/database/model/basic/BasicModTableColumn;", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "fillPropertiesWithExamples", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "vars", "", "", "modifyParent", "", "applyH2Column", "col", "Lcom/intellij/database/dialects/h2/model/H2TableColumn;", "Companion", "intellij.database.dialects.h2"})
@SourceDebugExtension(value={"SMAP\nH2ModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2ModelHelper.kt\ncom/intellij/database/dialects/h2/model/H2ModelHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class H2ModelHelper
extends ModelHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ModelHelper.ObjectKindVariant ALIAS = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.alias", new Object[0]));

    @Override
    public void exportApplyColumn(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (to instanceof H2TableColumn) {
            this.applyH2Column(from, (H2TableColumn)to);
        } else {
            super.exportApplyColumn(helper, from, to);
        }
    }

    @Override
    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable<ModelHelper.ObjectKindVariant> jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        if (meta.kind == ObjectKind.ROUTINE) {
            JBIterable<ModelHelper.ObjectKindVariant> jBIterable2 = JBIterable.of((Object)ALIAS);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"of(...)");
        } else {
            JBIterable<ModelHelper.ObjectKindVariant> jBIterable3 = super.generationVariants(meta);
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue(jBIterable3, (String)"generationVariants(...)");
        }
        return jBIterable;
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        if (e instanceof H2Constant) {
            ((H2Constant)e).setValue("'val'");
            vars.put("value", "'val'");
        }
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
    }

    private final void applyH2Column(DeColumn from, H2TableColumn col) {
        Object object = from.unwrap();
        H2TableColumn prev2 = object instanceof H2TableColumn ? (H2TableColumn)object : null;
        Object object2 = object = SequenceIdentity.UNKNOWN;
        H2TableColumn h2TableColumn = col;
        boolean $i$a$-takeIf-H2ModelHelper$applyH2Column$22 = false;
        boolean bl = from.flags.contains((Object)DeColumn.Flag.AUTO_INC);
        h2TableColumn.setSequenceIdentity((SequenceIdentity)(bl ? object : null));
        boolean notChangedSeq = prev2 != null && prev2.isAutoInc() && !col.isAutoInc() && Intrinsics.areEqual((Object)from.defaultValue, (Object)prev2.getDefaultExpression());
        Object $i$a$-takeIf-H2ModelHelper$applyH2Column$22 = object2 = from.defaultValue;
        h2TableColumn = col;
        boolean bl2 = false;
        bl = notChangedSeq;
        h2TableColumn.setDefaultExpression((String)(!bl ? object2 : null));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/h2/model/H2ModelHelper$Companion;", "", "<init>", "()V", "ALIAS", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "intellij.database.dialects.h2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

