/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class DbPsiFacadeImpl
extends DbPsiFacade
implements Disposable {
    private final Project myProject;
    private final Map<DasDataSource, DbDataSource> myDataSourceMap;
    private volatile State myState;
    private final Alarm myAlarm;
    private final Set<DbDataSource> modifiedDataSources;

    public DbPsiFacadeImpl(@NotNull Project project) {
        if (project == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myDataSourceMap = new WeakHashMap<DasDataSource, DbDataSource>();
        this.modifiedDataSources = new LinkedHashSet<DbDataSource>();
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DataSourceManager.TOPIC, (Object)new DataSourceManager.Listener(){

            @Override
            public <T extends RawDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
                if (manager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.clearCaches(manager, null);
            }

            @Override
            public <T extends RawDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
                if (manager == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (dataSource == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.clearCaches(manager, null);
            }

            @Override
            public <T extends RawDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource) {
                this.clearCaches(manager, dataSource == null ? null : dataSource.getUniqueId());
            }

            private <T extends RawDataSource> void clearCaches(@Nullable DataSourceManager<T> dataSourceManager, @Nullable String dataSourceId) {
                Application app = ApplicationManager.getApplication();
                DbDataSource dataSource = dataSourceId != null ? DbPsiFacadeImpl.this.findDataSource(dataSourceId) : null;
                app.invokeLater(() -> DbPsiFacadeImpl.this.clearCachesImpl(dataSourceManager, dataSource), ModalityState.defaultModalityState(), app.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "manager";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/psi/DbPsiFacadeImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DataSourceManager.EP_NAME.getExtensions((AreaInstance)project);
        DataSourceManager.EP_NAME.addExtensionPointListener((AreaInstance)project, new ExtensionPointListener<DataSourceManager<?>>(){

            public void extensionAdded(DataSourceManager<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                DbPsiFacadeImpl.this.clearCachesImpl(extension, null);
            }

            public void extensionRemoved(DataSourceManager<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                DbPsiFacadeImpl.this.clearCachesImpl(extension, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/database/psi/DbPsiFacadeImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public DataSourceManager<RawDataSource> getDataSourceManager(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        DataSourceManager<RawDataSource> dataSourceManager = ((DbDataSourceImpl)dataSource).getDbManager();
        if (dataSourceManager == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        return dataSourceManager;
    }

    @Override
    public void clearCaches() {
        this.clearCachesImpl(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCachesImpl(@Nullable DataSourceManager<?> manager, @Nullable DbDataSource dataSource) {
        ThreadingAssertions.assertEventDispatchThread();
        this.incModificationCount();
        ArrayList<DbDataSource> languageChanged = new ArrayList<DbDataSource>();
        if (dataSource == null) {
            State state = this.myState;
            this.myState = null;
            if (state != null) {
                for (DbDataSource source : state.dataSources) {
                    if (manager != null && this.getDataSourceManager(source) != manager) continue;
                    DbPsiFacadeImpl.clearDataSourceCaches(source, languageChanged);
                }
            }
        } else {
            DbPsiFacadeImpl.clearDataSourceCaches(dataSource, languageChanged);
        }
        if (!languageChanged.isEmpty()) {
            this.onLanguagesChanged(languageChanged);
        }
        PsiManager.getInstance((Project)this.myProject).dropResolveCaches();
        Set<DbDataSource> set = this.modifiedDataSources;
        synchronized (set) {
            this.modifiedDataSources.add(dataSource);
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.notifyAboutModifiedDataSources();
            PsiManager.getInstance((Project)this.myProject).dropPsiCaches();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
            String id = dataSource == null ? null : dataSource.getUniqueId();
            for (VirtualFile file : fileEditorManager.getOpenFiles()) {
                DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)((Object)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementVirtualFileImpl.class)));
                if (dbFile == null || id != null && !Objects.equals(dbFile.getDataSourceId(), id) || !dbFile.isValid()) continue;
                fileEditorManager.updateFilePresentation(file);
            }
        }, ApplicationManager.getApplication().isUnitTestMode() ? 0 : 300, ModalityState.nonModal());
    }

    private void onLanguagesChanged(@NotNull List<DbDataSource> languageChanged) {
        if (languageChanged == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        if (!languageChanged.isEmpty()) {
            DatabaseUiService.getInstance().rescanDbSrcIndex(this.myProject, "DbSrc:// data sources changed dialects");
        }
        this.reparseDependentFiles(languageChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAboutModifiedDataSources() {
        ArrayList<DbDataSource> modified;
        Set<DbDataSource> set = this.modifiedDataSources;
        synchronized (set) {
            modified = new ArrayList<DbDataSource>(this.modifiedDataSources);
            this.modifiedDataSources.clear();
        }
        if (modified.contains(null)) {
            this.sendTopic(null);
        } else {
            modified.forEach(this::sendTopic);
        }
    }

    private void sendTopic(DbDataSource dataSource) {
        ((DbPsiFacade.Listener)this.myProject.getMessageBus().syncPublisher(TOPIC)).onChanged(dataSource);
    }

    private void reparseDependentFiles(List<DbDataSource> changed) {
        if (!changed.isEmpty()) {
            FileContentUtil.reparseFiles((Project)this.myProject, Collections.emptyList(), (boolean)true);
        }
    }

    private static void clearDataSourceCaches(DbDataSource dataSource, List<DbDataSource> languageChanged) {
        DbDataSourceImpl impl = (DbDataSourceImpl)dataSource;
        Language language = impl.getCachedQueryLanguage();
        if (language == null) {
            language = impl.getPushedQueryLanguage();
        }
        impl.clearCaches();
        if (impl.isValid() && language != impl.getQueryLanguage()) {
            languageChanged.add(dataSource);
        }
    }

    public Promise<?> whenReady() {
        AsyncPromise res2 = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myAlarm.isEmpty()) {
                res2.setResult(null);
            } else {
                DataSourceUtil.promiseFacadeUpdate(this, null).processed((Promise)res2);
            }
        });
        return res2;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    @NotNull
    public List<DbDataSource> getDataSources() {
        List<DbDataSource> list = this.getState().dataSources;
        if (list == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public DbDataSource findDataSource(@Nullable String id) {
        return this.getState().dataSourcesMap.get(id);
    }

    @Override
    @Nullable
    public DbElement findElement(@Nullable DasObject o) {
        return DatabaseCoreUiService.getInstance().findElement(this.myProject, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DbDataSource createDataSourceWrapperElement(@NotNull RawDataSource info2, @NotNull DataSourceManager<?> manager) {
        if (info2 == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(7);
        }
        Map<DasDataSource, DbDataSource> map2 = this.myDataSourceMap;
        // MONITORENTER : map2
        DbDataSource dataSource = this.myDataSourceMap.get(info2);
        if (dataSource == null) {
            dataSource = new DbDataSourceImpl(this.getProject(), info2, manager);
            this.myDataSourceMap.put(info2, dataSource);
        }
        DbDataSource dbDataSource = dataSource;
        // MONITOREXIT : map2
        if (dbDataSource != null) return dbDataSource;
        DbPsiFacadeImpl.$$$reportNull$$$0(8);
        return dbDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private State getState() {
        State state;
        State curState = this.myState;
        if (curState != null) {
            State state2 = curState;
            if (state2 == null) {
                DbPsiFacadeImpl.$$$reportNull$$$0(9);
            }
            return state2;
        }
        if (this.myProject.isDefault()) {
            state = new State(Collections.emptyList());
        } else {
            ArrayList<DbDataSource> result2 = new ArrayList<DbDataSource>();
            for (DataSourceManager<?> manager : DataSourceManager.getManagers(this.myProject)) {
                for (RawDataSource system : manager.getDataSources()) {
                    result2.add(this.createDataSourceWrapperElement(system, manager));
                }
            }
            state = new State(List.copyOf(result2));
        }
        this.myState = state;
        Map<DasDataSource, DbDataSource> map2 = this.myDataSourceMap;
        synchronized (map2) {
            this.myDataSourceMap.values().retainAll(state.dataSources);
        }
        State state3 = state;
        if (state3 == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(10);
        }
        return state3;
    }

    @TestOnly
    public void flushUpdates() {
        if (EDT.isCurrentThreadEdt()) {
            UIUtil.dispatchAllInvocationEvents();
            this.myAlarm.drainRequestsInTest();
        } else {
            Application app = ApplicationManager.getApplication();
            app.invokeAndWait(() -> ((Alarm)this.myAlarm).drainRequestsInTest());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbPsiFacadeImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageChanged";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbPsiFacadeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceWrapperElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceManager";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onLanguagesChanged";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceWrapperElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    private static class State {
        final List<DbDataSource> dataSources;
        final Map<String, DbDataSource> dataSourcesMap;

        State(@NotNull List<DbDataSource> dataSources) {
            if (dataSources == null) {
                State.$$$reportNull$$$0(0);
            }
            this.dataSources = dataSources;
            this.dataSourcesMap = dataSources.isEmpty() ? Collections.emptyMap() : new HashMap();
            for (DbDataSource dataSource : dataSources) {
                this.dataSourcesMap.put(dataSource.getUniqueId(), dataSource);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/psi/DbPsiFacadeImpl$State", "<init>"));
        }
    }
}

