/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.database.SqlNotebookManager;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlNotebookModel {
    private SqlNotebookModel() {
    }

    @Nullable
    public static CellsAccessor getCellAccessor(@NotNull PsiFile file, @NotNull ScriptModel<?> scriptModel, @NotNull Condition<? super TextRange> filter) {
        if (file == null) {
            SqlNotebookModel.$$$reportNull$$$0(0);
        }
        if (scriptModel == null) {
            SqlNotebookModel.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            SqlNotebookModel.$$$reportNull$$$0(2);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file.getVirtualFile())) {
            return null;
        }
        return SqlNotebookModel.getPreparedAccessor(file, scriptModel, filter);
    }

    @Nullable
    public static SqlNotebookManager.Cell getCell(@NotNull PsiFile file, @NotNull ScriptModel<?> scriptModel, @NotNull EditorLayoutProvider layoutProvider, @NotNull Condition<? super TextRange> filter, int offset) {
        if (file == null) {
            SqlNotebookModel.$$$reportNull$$$0(3);
        }
        if (scriptModel == null) {
            SqlNotebookModel.$$$reportNull$$$0(4);
        }
        if (layoutProvider == null) {
            SqlNotebookModel.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            SqlNotebookModel.$$$reportNull$$$0(6);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file.getVirtualFile())) {
            return null;
        }
        return SqlNotebookModel.getPreparedAccessor(file, scriptModel, filter).getCell(layoutProvider, offset);
    }

    @NotNull
    public static Collection<SqlNotebookManager.Cell> getCells(@NotNull PsiFile file, @NotNull ScriptModel<?> scriptModel, @NotNull EditorLayoutProvider layoutProvider, @NotNull Condition<? super TextRange> filter) {
        if (file == null) {
            SqlNotebookModel.$$$reportNull$$$0(7);
        }
        if (scriptModel == null) {
            SqlNotebookModel.$$$reportNull$$$0(8);
        }
        if (layoutProvider == null) {
            SqlNotebookModel.$$$reportNull$$$0(9);
        }
        if (filter == null) {
            SqlNotebookModel.$$$reportNull$$$0(10);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file.getVirtualFile())) {
            List<SqlNotebookManager.Cell> list = Collections.emptyList();
            if (list == null) {
                SqlNotebookModel.$$$reportNull$$$0(11);
            }
            return list;
        }
        Collection<SqlNotebookManager.Cell> collection = SqlNotebookModel.getPreparedAccessor(file, scriptModel, filter).getCells(layoutProvider);
        if (collection == null) {
            SqlNotebookModel.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    @TestOnly
    public static Collection<SqlNotebookManager.Cell> getCachedCells(@NotNull PsiFile file) {
        if (file == null) {
            SqlNotebookModel.$$$reportNull$$$0(13);
        }
        Collection<SqlNotebookManager.Cell> collection = SqlNotebookModel.getCachedAccessor(file).getCells(EditorLayoutProvider.DUMMY);
        if (collection == null) {
            SqlNotebookModel.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    private static CellsAccessor getPreparedAccessor(@NotNull PsiFile file, @NotNull ScriptModel<?> scriptModel, @NotNull Condition<? super TextRange> filter) {
        if (file == null) {
            SqlNotebookModel.$$$reportNull$$$0(15);
        }
        if (scriptModel == null) {
            SqlNotebookModel.$$$reportNull$$$0(16);
        }
        if (filter == null) {
            SqlNotebookModel.$$$reportNull$$$0(17);
        }
        CellsAccessor accessor = SqlNotebookModel.getCachedAccessor(file);
        accessor.compute(file.getProject(), scriptModel, file, filter);
        CellsAccessor cellsAccessor = accessor;
        if (cellsAccessor == null) {
            SqlNotebookModel.$$$reportNull$$$0(18);
        }
        return cellsAccessor;
    }

    @NotNull
    private static CellsAccessor getCachedAccessor(@NotNull PsiFile file) {
        if (file == null) {
            SqlNotebookModel.$$$reportNull$$$0(19);
        }
        CellsAccessor cellsAccessor = (CellsAccessor)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)new CellsAccessor(), (Object[])new Object[]{file}));
        if (cellsAccessor == null) {
            SqlNotebookModel.$$$reportNull$$$0(20);
        }
        return cellsAccessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 14, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutProvider";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/SqlNotebookModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/SqlNotebookModel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCells";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedCells";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedAccessor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCellAccessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCell";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCells";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCells";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedAccessor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCachedAccessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 14, 18, 20 -> new IllegalStateException(string);
        };
    }

    public static class CellsAccessor {
        private final Object myLock = new Object();
        private final List<SqlNotebookManager.Cell> myCells = ContainerUtil.createConcurrentList();
        private boolean myComputed = false;

        @Nullable
        public SqlNotebookManager.Cell getCell(@NotNull EditorLayoutProvider provider, int offset) {
            if (provider == null) {
                CellsAccessor.$$$reportNull$$$0(0);
            }
            if (this.myCells.isEmpty()) {
                return null;
            }
            int result2 = ObjectUtils.binarySearch((int)0, (int)this.myCells.size(), idx -> {
                TextRange range = this.myCells.get((int)idx).range;
                return range.contains(offset) ? 0 : (range.getStartOffset() > offset ? 1 : -1);
            });
            SqlNotebookManager.Cell resultCell = result2 < 0 ? null : this.myCells.get(result2);
            Collection<SqlNotebookManager.Cell> cells = CellsAccessor.splitCell(resultCell, provider);
            for (SqlNotebookManager.Cell cell : cells) {
                if (!cell.range.contains(offset)) continue;
                return cell;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void compute(@NotNull Project project, @NotNull ScriptModel<?> scriptModel, @NotNull PsiFile file, @NotNull Condition<? super TextRange> filter) {
            if (project == null) {
                CellsAccessor.$$$reportNull$$$0(1);
            }
            if (scriptModel == null) {
                CellsAccessor.$$$reportNull$$$0(2);
            }
            if (file == null) {
                CellsAccessor.$$$reportNull$$$0(3);
            }
            if (filter == null) {
                CellsAccessor.$$$reportNull$$$0(4);
            }
            Object object = this.myLock;
            synchronized (object) {
                if (this.myComputed) {
                    return;
                }
                this.myCells.addAll(SqlPsiFacade.getInstance((Project)project).getNotebookManager().getCells(file, scriptModel, filter, 0, file.getTextLength()));
                this.myComputed = true;
            }
        }

        @NotNull
        Collection<SqlNotebookManager.Cell> getCells(@NotNull EditorLayoutProvider provider) {
            if (provider == null) {
                CellsAccessor.$$$reportNull$$$0(5);
            }
            ArrayList<SqlNotebookManager.Cell> result2 = new ArrayList<SqlNotebookManager.Cell>();
            for (SqlNotebookManager.Cell cell : this.myCells) {
                result2.addAll(CellsAccessor.splitCell(cell, provider));
            }
            ArrayList<SqlNotebookManager.Cell> arrayList = result2;
            if (arrayList == null) {
                CellsAccessor.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @NotNull
        private static Collection<SqlNotebookManager.Cell> splitCell(@Nullable SqlNotebookManager.Cell cell, @NotNull EditorLayoutProvider provider) {
            if (provider == null) {
                CellsAccessor.$$$reportNull$$$0(7);
            }
            if (cell == null) {
                List<SqlNotebookManager.Cell> list = Collections.emptyList();
                if (list == null) {
                    CellsAccessor.$$$reportNull$$$0(8);
                }
                return list;
            }
            int[] inlayOffsets = provider.getInlayOffsets(cell.range);
            if (inlayOffsets.length == 0 || inlayOffsets.length == 1 && cell.lastStatementEnd <= inlayOffsets[0]) {
                Set<SqlNotebookManager.Cell> set = Collections.singleton(cell);
                if (set == null) {
                    CellsAccessor.$$$reportNull$$$0(9);
                }
                return set;
            }
            ArrayList<TextRange> ranges = new ArrayList<TextRange>(cell.ranges);
            Collection<CellItem> items = CellsAccessor.merge(ranges, inlayOffsets, provider.getInlayLength());
            ArrayList<SqlNotebookManager.Cell> result2 = new ArrayList<SqlNotebookManager.Cell>();
            ArrayList<TextRange> curRanges = new ArrayList<TextRange>();
            int start2 = -1;
            int cellStart = -1;
            for (CellItem item : items) {
                if (start2 == -1) {
                    start2 = item.range.getStartOffset();
                }
                if (cellStart != -1) {
                    CellsAccessor.flushCell(curRanges, result2, cellStart, item.range.getStartOffset());
                    cellStart = -1;
                    start2 = item.range.getStartOffset();
                }
                if (!item.statement) {
                    cellStart = start2;
                    continue;
                }
                curRanges.add(item.range);
            }
            CellsAccessor.flushCell(curRanges, result2, start2, cell.range.getEndOffset());
            ArrayList<SqlNotebookManager.Cell> arrayList = result2;
            if (arrayList == null) {
                CellsAccessor.$$$reportNull$$$0(10);
            }
            return arrayList;
        }

        private static void flushCell(@NotNull List<TextRange> ranges, @NotNull List<SqlNotebookManager.Cell> result2, int start2, int end) {
            TextRange lastRange;
            if (ranges == null) {
                CellsAccessor.$$$reportNull$$$0(11);
            }
            if (result2 == null) {
                CellsAccessor.$$$reportNull$$$0(12);
            }
            int lastStatementEnd = (lastRange = (TextRange)ContainerUtil.getLastItem(ranges)) == null ? start2 : lastRange.getEndOffset();
            result2.add(new SqlNotebookManager.Cell(TextRange.create((int)start2, (int)end), new ArrayList<TextRange>(ranges), lastStatementEnd));
            ranges.clear();
        }

        @NotNull
        private static Collection<CellItem> merge(@NotNull List<TextRange> ranges, int[] offsets, int inlayLength) {
            if (ranges == null) {
                CellsAccessor.$$$reportNull$$$0(13);
            }
            ArrayList<CellItem> items = new ArrayList<CellItem>();
            int inlayOffset = 0;
            int rangeOffset = 0;
            CellItem firstInlay = null;
            while (inlayOffset < offsets.length || rangeOffset < ranges.size()) {
                int inlay;
                TextRange range = rangeOffset < ranges.size() ? ranges.get(rangeOffset) : null;
                int n = inlay = inlayOffset < offsets.length ? offsets[inlayOffset] : -1;
                if (range == null || inlay != -1 && range.getEndOffset() > inlay) {
                    CellItem item = new CellItem(TextRange.create((int)inlay, (int)(inlay + inlayLength)), false);
                    items.add(item);
                    if (firstInlay == null) {
                        firstInlay = item;
                    }
                    ++inlayOffset;
                    continue;
                }
                items.add(new CellItem(firstInlay == null || !range.intersectsStrict(firstInlay.range) ? range : TextRange.create((int)range.getStartOffset(), (int)firstInlay.range.getStartOffset()), true));
                firstInlay = null;
                ++rangeOffset;
            }
            List list = ContainerUtil.sorted(items, Comparator.comparingInt(i2 -> i2.range.getStartOffset()));
            if (list == null) {
                CellsAccessor.$$$reportNull$$$0(14);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 8, 9, 10, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/SqlNotebookModel$CellsAccessor";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/SqlNotebookModel$CellsAccessor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCells";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitCell";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCell";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCells";
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 14: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "splitCell";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "flushCell";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 8, 9, 10, 14 -> new IllegalStateException(string);
            };
        }

        private static class CellItem {
            final TextRange range;
            final boolean statement;

            CellItem(@NotNull TextRange range, boolean statement2) {
                if (range == null) {
                    CellItem.$$$reportNull$$$0(0);
                }
                this.range = range;
                this.statement = statement2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/run/SqlNotebookModel$CellsAccessor$CellItem", "<init>"));
            }
        }
    }

    public static interface EditorLayoutProvider {
        public static final EditorLayoutProvider DUMMY = new EditorLayoutProvider(){

            @Override
            public int[] getInlayOffsets(@NotNull TextRange range) {
                if (range == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ArrayUtil.EMPTY_INT_ARRAY;
            }

            @Override
            public int getInlayLength() {
                return 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/run/SqlNotebookModel$EditorLayoutProvider$1", "getInlayOffsets"));
            }
        };

        public int[] getInlayOffsets(@NotNull TextRange var1);

        public int getInlayLength();
    }
}

