/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteBlob;
import com.intellij.database.remote.jdbc.RemoteClob;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SaveLobAsAction
extends DeleteAction
implements DumbAware,
GridAction {
    private static final Logger LOG = Logger.getInstance(SaveLobAsAction.class);

    public void update(@NotNull AnActionEvent e) {
        List whereClauseColumns;
        DataGrid dataGrid;
        if (e == null) {
            SaveLobAsAction.$$$reportNull$$$0(0);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(e.isFromActionToolbar());
            return;
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        ModelIndex lobColumnIdx = dataGrid.getSelectionModel().getSelectedColumn();
        GridColumn lobColumn = (GridColumn)model.getColumn(lobColumnIdx);
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        if (dbms.isMongo()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)dataGrid);
        Object cellObject = model.getValueAt(dataGrid.getSelectionModel().getSelectedRow(), lobColumnIdx);
        List<Object> list = whereClauseColumns = lobColumn == null ? Collections.emptyList() : SaveLobAsAction.getWhereClauseColumns(lobColumn, dbms, table, model.getColumns());
        boolean enabled = dataGrid.isReady() && (whereClauseColumns.size() > 0 || model.getRowCount() == 1) && (cellObject instanceof LobInfo && ((LobInfo)cellObject).length >= 0L || cellObject instanceof byte[] && ((byte[])cellObject).length > 0 || cellObject instanceof ImageInfo && ((ImageInfo)cellObject).bytes != null || cellObject instanceof TextInfo || cellObject instanceof String && ((String)cellObject).length() > 64 || StringUtil.equalsIgnoreCase((CharSequence)"oid", (CharSequence)(lobColumn == null ? null : lobColumn.getTypeName())));
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List columns;
        if (e == null) {
            SaveLobAsAction.$$$reportNull$$$0(1);
        }
        final Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (project == null || dataGrid == null) {
            return;
        }
        ModelIndex rowIndex = dataGrid.getSelectionModel().getSelectedRow();
        ModelIndex colIndex = dataGrid.getSelectionModel().getSelectedColumn();
        if (!rowIndex.isValid((CoreGrid)dataGrid) || !colIndex.isValid((CoreGrid)dataGrid)) {
            return;
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        Object cellObject = model.getValueAt(rowIndex, colIndex);
        if (cellObject == null) {
            return;
        }
        GridRow originalRow = (GridRow)model.getRow(rowIndex);
        final GridColumn column2 = (GridColumn)model.getColumn(colIndex);
        if (originalRow == null || column2 == null) {
            return;
        }
        final VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(DatabaseBundle.message("dialog.title.save.data.as", new Object[0]), DatabaseBundle.message("label.save.data.in.local.file", new Object[0]), new String[0]), project).save((Path)null, FileUtil.sanitizeFileName((String)column2.getName()) + "_" + (rowIndex.toView((CoreGrid)dataGrid).asInteger() + 1));
        if (wrapper == null) {
            return;
        }
        final DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)dataGrid);
        if (hookup == null) {
            return;
        }
        final String name2 = DataGridUtil.getResultSetName(e);
        String queryText = hookup.getUnlimitedQueryText(true);
        final DbDataSource dbDataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)dataGrid);
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        if (name2 == null || queryText == null) {
            return;
        }
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)dataGrid);
        List<GridColumn> filtered = SaveLobAsAction.getWhereClauseColumns(column2, dbms, table, columns = model.getColumns());
        if (filtered.size() == 0 && model.getRowCount() == 1) {
            DataRequest.Constraints constraints = DataRequest.newConstraints(originalRow.getRowNum() - 1, 1, 0, hookup.getSubQueryIndex(), hookup.getResultSetIndex());
            hookup.getMessageBus().getDataProducer().processRequest((GridDataRequest)new DataRequest.RawQueryRequest(hookup, hookup.getQueryText(), constraints){
                boolean hadRows;

                public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (columns == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    hookup.setCurrentTx(((DataRequest.Context)context).txMarker);
                }

                public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
                    if (context == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (rows == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.hadRows = true;
                    if (rows.isEmpty()) {
                        SaveLobAsAction.errorNotification(dbDataSource, project, 0);
                    }
                    GridRow item = (GridRow)ContainerUtil.getFirstItem(rows);
                    SaveLobAsAction.saveObject(Objects.requireNonNull(item), name2, column2, dbDataSource, wrapper, project);
                }

                public void afterLastRowAdded(// Could not load outer class - annotation placement on inner may be incorrect
                @NotNull GridDataRequest.Context context, int total) {
                    if (context == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (!this.hadRows) {
                        SaveLobAsAction.errorNotification(dbDataSource, project, 0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "columns";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "rows";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setColumns";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "addRows";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "afterLastRowAdded";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return;
        }
        List data = ContainerUtil.map(filtered, col -> new ColumnQueryData(col, col.getValue(originalRow)));
        RowQueryData rowQueryData = new RowQueryData(data, ArrayUtilRt.EMPTY_INT_ARRAY, queryText);
        DataProducer producer = hookup.getMessageBus().getDataProducer();
        producer.processRequest((GridDataRequest)new MyTestRowCountRequest(hookup, rowQueryData, dbDataSource, name2, column2, wrapper, project, table));
    }

    @NotNull
    private static List<GridColumn> getWhereClauseColumns(@NotNull GridColumn lobColumn, @NotNull Dbms dbms, @Nullable DasObject table, @NotNull List<GridColumn> columns) {
        if (lobColumn == null) {
            SaveLobAsAction.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            SaveLobAsAction.$$$reportNull$$$0(3);
        }
        if (columns == null) {
            SaveLobAsAction.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.filter(DbImplUtil.getWhereClauseColumns(table, columns, dbms), col -> col != lobColumn && (table != null || !GridUtilCore.isRowId((GridColumn)lobColumn)));
        if (list == null) {
            SaveLobAsAction.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void saveObject(final @NotNull GridRow row, @NotNull String resultSetName, final @NotNull GridColumn column2, final @NotNull DasDataSource system, final @NotNull VirtualFileWrapper wrapper, final @NotNull Project project) {
        if (row == null) {
            SaveLobAsAction.$$$reportNull$$$0(6);
        }
        if (resultSetName == null) {
            SaveLobAsAction.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            SaveLobAsAction.$$$reportNull$$$0(8);
        }
        if (system == null) {
            SaveLobAsAction.$$$reportNull$$$0(9);
        }
        if (wrapper == null) {
            SaveLobAsAction.$$$reportNull$$$0(10);
        }
        if (project == null) {
            SaveLobAsAction.$$$reportNull$$$0(11);
        }
        if (row.getSize() < column2.getColumnNumber()) {
            DbUIUtil.createNotification(system, DatabaseBundle.message("notification.content.cannot.save.lob.data.table.structure.has.been.changed", new Object[0]), NotificationType.ERROR, "SaveLobAsAction.structure.changed").notify(project);
            return;
        }
        final AsyncFutureResult result2 = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        final AtomicBoolean error = new AtomicBoolean(false);
        final AtomicReference unitsRef = new AtomicReference();
        ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, DatabaseBundle.message("progress.title.saving.lob.data", new Object[0]), true, PerformInBackgroundOption.DEAF){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean exists = wrapper.exists();
                try {
                    indicator.setText(DatabaseBundle.message("progress.text.saving", wrapper.getFile().getPath()));
                    unitsRef.set(SaveLobAsAction.saveObjectInner(system, column2.getValue(row), wrapper, indicator, project));
                }
                catch (ProcessCanceledException ex) {
                    error.set(true);
                    if (!exists) {
                        wrapper.getFile().delete();
                    }
                    throw ex;
                }
                catch (Exception e) {
                    error.set(true);
                }
                finally {
                    result2.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/run/actions/SaveLobAsAction$2", "run"));
            }
        }));
        try {
            result2.get();
            Units units = (Units)unitsRef.get();
            if (error.get() || units == null) {
                return;
            }
            SaveLobAsAction.endNotification(resultSetName, system, wrapper, project, units);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void endNotification(@NotNull String resultSetName, @NotNull DasDataSource system, @NotNull VirtualFileWrapper wrapper, @NotNull Project project, @NotNull Units units) {
        if (resultSetName == null) {
            SaveLobAsAction.$$$reportNull$$$0(12);
        }
        if (system == null) {
            SaveLobAsAction.$$$reportNull$$$0(13);
        }
        if (wrapper == null) {
            SaveLobAsAction.$$$reportNull$$$0(14);
        }
        if (project == null) {
            SaveLobAsAction.$$$reportNull$$$0(15);
        }
        if (units == null) {
            SaveLobAsAction.$$$reportNull$$$0(16);
        }
        DbUIUtil.createFileLinkNotification(project, system, DatabaseBundle.message("export.saved.from.to.message", ExtractorsUtil.getPresentableSize(units.count), units.getName(), resultSetName), NotificationType.INFORMATION, wrapper.getFile().getPath(), "SaveLobAsAction.finished").notify(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Units saveObjectInner(@NotNull DasDataSource system, @Nullable Object value, @NotNull VirtualFileWrapper wrapper, @NotNull ProgressIndicator indicator, @NotNull Project project) throws Exception {
        block43: {
            if (system == null) {
                SaveLobAsAction.$$$reportNull$$$0(17);
            }
            if (wrapper == null) {
                SaveLobAsAction.$$$reportNull$$$0(18);
            }
            if (indicator == null) {
                SaveLobAsAction.$$$reportNull$$$0(19);
            }
            if (project == null) {
                SaveLobAsAction.$$$reportNull$$$0(20);
            }
            indicator.setIndeterminate(true);
            file = wrapper.getFile();
            FileUtil.createParentDirs((File)file);
            try {
                stream = new BufferedOutputStream(new FileOutputStream(file));
                if (value instanceof byte[]) {
                    bytes = (byte[])value;
                    stream.write(bytes);
                    indicator.setText2(DatabaseBundle.message("progress.details.bytes.written", new Object[]{ExtractorsUtil.getPresentableSize(bytes.length)}));
                    var11_11 = Units.bytes(bytes.length);
                    return var11_11;
                }
                if (value instanceof String) {
                    string = (String)value;
                    writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
                    try {
                        writer.write(string);
                    }
                    finally {
                        writer.close();
                    }
                    indicator.setText2(DatabaseBundle.message("progress.details.chars.written", new Object[]{ExtractorsUtil.getPresentableSize(string.length())}));
                    writer = Units.chars(string.length());
                    return writer;
                }
                if (value instanceof RemoteClob) {
                    lob = (RemoteClob)value;
                    try {
                        out = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
                        try {
                            length = lob.length();
                            if (length > 0L) {
                                indicator.setIndeterminate(false);
                            }
                            total = 0L;
                            while (true) {
                                indicator.checkCanceled();
                                if (length > 0L) {
                                    fraction = (double)total / (double)length;
                                    indicator.setFraction(fraction);
                                    indicator.setText2(DatabaseBundle.message("progress.details.chars.size.written", new Object[]{ExtractorsUtil.getPresentableSize(total), ExtractorsUtil.getPresentableSize(length), (int)(100.0 * fraction)}));
                                } else {
                                    indicator.setText2(DatabaseBundle.message("progress.details.chars.size.written.text", new Object[]{ExtractorsUtil.getPresentableSize(total)}));
                                }
                                string = lob.getSubString(total + 1L, length < 0L ? 20480 : (int)Math.min(length - total, 20480L));
                                if (string.length() == 0) break;
                                out.write((String)string);
                                total += (long)string.length();
                            }
                            out.close();
                            string = Units.chars(total);
                        }
                        catch (Throwable var12_19) {
                            try {
                                out.close();
                            }
                            catch (Throwable var13_21) {
                                var12_19.addSuppressed(var13_21);
                            }
                            throw var12_19;
                        }
                        out.close();
                        return string;
                    }
                    finally {
                        JdbcNativeUtil.performSafe((ThrowableRunnable)(ThrowableRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, free(), ()V)((RemoteClob)lob));
                    }
                }
                ** if (!(value instanceof RemoteBlob)) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    lob = (RemoteBlob)value;
                    try {
                        length = lob.length();
                        if (length > 0L) {
                            indicator.setIndeterminate(false);
                            indicator.setText(DatabaseBundle.message("progress.text.saving", new Object[]{file.getPath()}));
                        }
                        total = 0L;
                        while (true) {
                            indicator.checkCanceled();
                            if (length > 0L) {
                                fraction = (double)total / (double)length;
                                indicator.setFraction(fraction);
                                indicator.setText2(DatabaseBundle.message("progress.details.bytes.written.message", new Object[]{ExtractorsUtil.getPresentableSize(total), ExtractorsUtil.getPresentableSize(length), (int)(100.0 * fraction)}));
                            } else {
                                indicator.setText2(DatabaseBundle.message("progress.details.bytes.size.written.message", new Object[]{ExtractorsUtil.getPresentableSize(total)}));
                            }
                            v0 = nextLength = length < 0L ? 20480 : (int)Math.min(length - total, 20480L);
                            if (nextLength == 0 || (bytes = lob.getBytes(total + 1L, nextLength)).length == 0) break;
                            stream.write(bytes);
                            total += (long)bytes.length;
                        }
                        var15_32 = Units.bytes(total);
                    }
                    catch (Throwable var19_33) {
                        JdbcNativeUtil.performSafe((ThrowableRunnable)(ThrowableRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, free(), ()V)((RemoteBlob)lob));
                        throw var19_33;
                    }
                    JdbcNativeUtil.performSafe((ThrowableRunnable)(ThrowableRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, free(), ()V)((RemoteBlob)lob));
                    return var15_32;
                }
lbl-1000:
                // 1 sources

                {
                    break block43;
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception ex) {
                trace = ExceptionUtil.getUserStackTrace((Throwable)ex, (Logger)SaveLobAsAction.LOG).replace("\n", "<br>\n");
                DbUIUtil.createNotification(system, DatabaseBundle.message("notification.content.cannot.save.lob.data", new Object[]{trace}), NotificationType.ERROR, "SaveLobAsAction.failed").notify(project);
                throw ex;
            }
        }
        return null;
    }

    private static void errorNotification(@NotNull DasDataSource system, @NotNull Project project, int size) {
        if (system == null) {
            SaveLobAsAction.$$$reportNull$$$0(21);
        }
        if (project == null) {
            SaveLobAsAction.$$$reportNull$$$0(22);
        }
        String text2 = SaveLobAsAction.getErrorText(size);
        DbUIUtil.createNotification(system, text2, NotificationType.ERROR, "SaveLobAsAction.error").notify(project);
    }

    @NotNull
    private static String getErrorText(int size) {
        String string = String.format("Cannot save LOB data: %s", size == 0 ? "table has been changed" : "ambiguous query result (" + size + " rows received)");
        if (string == null) {
            SaveLobAsAction.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lobColumn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/SaveLobAsAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSetName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 11: 
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "units";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhereClauseColumns";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWhereClauseColumns";
                break;
            }
            case 5: 
            case 23: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveObject";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "endNotification";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveObjectInner";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "errorNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 23 -> new IllegalStateException(string);
        };
    }

    private static class MyTestRowCountRequest
    extends MyAbstractRequest {
        private final List<GridRow> myRows;
        private final String myResultSetName;
        private final GridColumn myColumn;
        private final VirtualFileWrapper myWrapper;

        protected MyTestRowCountRequest(@NotNull DataBusGridDataHookUp hookUp, @NotNull RowQueryData rowQueryData, @NotNull DasDataSource system, @NotNull String resultSetName, @NotNull GridColumn column2, @NotNull VirtualFileWrapper wrapper, @NotNull Project project, @Nullable DasObject table) {
            if (hookUp == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(0);
            }
            if (rowQueryData == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(1);
            }
            if (system == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(2);
            }
            if (resultSetName == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(3);
            }
            if (column2 == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(4);
            }
            if (wrapper == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(5);
            }
            if (project == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(6);
            }
            super(hookUp, rowQueryData, system, project, table, 2);
            this.myResultSetName = resultSetName;
            this.myColumn = column2;
            this.myWrapper = wrapper;
            this.myRows = new ArrayList<GridRow>();
        }

        public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
            if (context == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(7);
            }
            if (rows == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(8);
            }
            this.myRows.addAll(rows);
        }

        public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
            if (context == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(9);
            }
            this.checkRowCount(this.myRows);
            if (this.myRows.size() != 1) {
                return;
            }
            MyRequest request2 = new MyRequest(this.myHookUp, this.mySystem, this.myResultSetName, this.rowQueryData, this.myColumn, this.myWrapper, this.myProject, this.table);
            this.myHookUp.getMessageBus().getDataProducer().processRequest((GridDataRequest)request2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hookUp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowQueryData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultSetName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction$MyTestRowCountRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Units {
        private final long count;

        private Units(long count) {
            this.count = count;
        }

        @NotNull
        abstract String getName();

        @NotNull
        static Units bytes(final long count) {
            return new Units(count){

                @Override
                @NotNull
                String getName() {
                    String string = DatabaseBundle.message("export.unit.byte", count);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/SaveLobAsAction$Units$1", "getName"));
                }
            };
        }

        @NotNull
        static Units chars(final long count) {
            return new Units(count){

                @Override
                @NotNull
                String getName() {
                    String string = DatabaseBundle.message("export.unit.char", count);
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/SaveLobAsAction$Units$2", "getName"));
                }
            };
        }
    }

    private static abstract class MyAbstractRequest
    extends DataRequest.ConditionQueryRequest {
        protected final DasDataSource mySystem;
        protected final Project myProject;
        protected final DataBusGridDataHookUp myHookUp;

        protected MyAbstractRequest(@NotNull DataBusGridDataHookUp hookUp, @NotNull RowQueryData rowQueryData, @NotNull DasDataSource system, @NotNull Project project, @Nullable DasObject table, int limit) {
            if (hookUp == null) {
                MyAbstractRequest.$$$reportNull$$$0(0);
            }
            if (rowQueryData == null) {
                MyAbstractRequest.$$$reportNull$$$0(1);
            }
            if (system == null) {
                MyAbstractRequest.$$$reportNull$$$0(2);
            }
            if (project == null) {
                MyAbstractRequest.$$$reportNull$$$0(3);
            }
            super(hookUp, rowQueryData, DataRequest.newConstraints(0, limit, 0, hookUp.getSubQueryIndex(), hookUp.getResultSetIndex()), table);
            this.myHookUp = hookUp;
            this.mySystem = system;
            this.myProject = project;
        }

        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
            DataRequest.Context c2;
            if (context == null) {
                MyAbstractRequest.$$$reportNull$$$0(4);
            }
            if (columns == null) {
                MyAbstractRequest.$$$reportNull$$$0(5);
            }
            if ((c2 = (DataRequest.Context)((Object)ObjectUtils.tryCast((Object)context, DataRequest.Context.class))) != null) {
                this.myHookUp.setCurrentTx(c2.txMarker);
            }
        }

        void checkRowCount(List<? extends GridRow> rows) {
            if (rows.size() != 1) {
                SaveLobAsAction.errorNotification(this.mySystem, this.myProject, rows.size());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hookUp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowQueryData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction$MyAbstractRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRequest
    extends MyAbstractRequest {
        private final String myResultSetName;
        private final GridColumn myColumn;
        private final VirtualFileWrapper myWrapper;

        protected MyRequest(@NotNull DataBusGridDataHookUp hookUp, @NotNull DasDataSource system, @NotNull String resultSetName, @NotNull RowQueryData rowQueryData, @NotNull GridColumn column2, @NotNull VirtualFileWrapper wrapper, @NotNull Project project, @Nullable DasObject table) {
            if (hookUp == null) {
                MyRequest.$$$reportNull$$$0(0);
            }
            if (system == null) {
                MyRequest.$$$reportNull$$$0(1);
            }
            if (resultSetName == null) {
                MyRequest.$$$reportNull$$$0(2);
            }
            if (rowQueryData == null) {
                MyRequest.$$$reportNull$$$0(3);
            }
            if (column2 == null) {
                MyRequest.$$$reportNull$$$0(4);
            }
            if (wrapper == null) {
                MyRequest.$$$reportNull$$$0(5);
            }
            if (project == null) {
                MyRequest.$$$reportNull$$$0(6);
            }
            super(hookUp, rowQueryData, system, project, table, 1);
            this.myResultSetName = resultSetName;
            this.myColumn = column2;
            this.myWrapper = wrapper;
        }

        public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
            if (context == null) {
                MyRequest.$$$reportNull$$$0(7);
            }
            if (rows == null) {
                MyRequest.$$$reportNull$$$0(8);
            }
            this.checkRowCount(rows);
            GridRow row = (GridRow)ContainerUtil.getFirstItem(rows);
            if (row == null || rows.size() != 1) {
                return;
            }
            SaveLobAsAction.saveObject(row, this.myResultSetName, this.myColumn, this.mySystem, this.myWrapper, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hookUp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultSetName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowQueryData";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction$MyRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

